/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;

public class ControlShape3D
extends ControlElement3D {
    private static final int SHAPE_PROPERTIES_ADDED = 3;
    private ElementShape shape;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementShape";
    }

    @Override
    protected Element createElement() {
        this.shape = new ElementShape();
        return this.shape;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 3;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("style")) {
            return "MarkerShape|int";
        }
        if (_property.equals("pixelSize")) {
            return "boolean";
        }
        if (_property.equals("rotationAngle")) {
            return "int|double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.shape.setShapeType(_value.getInteger());
                break;
            }
            case 1: {
                this.shape.setPixelSize(_value.getBoolean());
                break;
            }
            case 2: {
                if (_value instanceof IntegerValue) {
                    this.shape.setRotationAngle((double)_value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.shape.setRotationAngle(_value.getDouble());
                break;
            }
            default: {
                super.setValue(_index - 3, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.shape.setShapeType(1);
                break;
            }
            case 1: {
                this.shape.setPixelSize(false);
                break;
            }
            case 2: {
                this.shape.setRotationAngle(0.0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 3);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "0.0";
            }
        }
        return super.getDefaultValueString(_index - 3);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

