/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.drawing3d.ControlGroup3D;
import org.colos.ejs.library.control.drawing3d.ControlParentOfElement3D;
import org.colos.ejs.library.control.drawing3d.utils.Control3DChild;
import org.colos.ejs.library.control.drawing3d.utils.ControlTransformation3D;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.Resolution;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;

public abstract class ControlElement3D
extends ControlElement
implements InteractionListener,
Control3DChild {
    public static final int EL3D_NAME = 0;
    public static final int PARENT = 1;
    protected static final int POSITION_X = 2;
    protected static final int POSITION_Y = 3;
    protected static final int POSITION_Z = 4;
    protected static final int SIZE_X = 5;
    protected static final int SIZE_Y = 6;
    protected static final int SIZE_Z = 7;
    protected static final int TRANSFORMATION = 8;
    protected static final int VISIBLE = 9;
    protected static final int LINE_COLOR = 10;
    protected static final int LINE_WIDTH = 11;
    protected static final int FILL_COLOR = 12;
    protected static final int RESOLUTION = 13;
    protected static final int DRAWING_FILL = 14;
    protected static final int DRAWING_LINES = 15;
    protected static final int ENABLED_POSITION = 16;
    protected static final int MOVES_GROUP = 17;
    protected static final int ENABLED_SIZE = 18;
    protected static final int RESIZES_GROUP = 19;
    protected static final int SENSITIVITY = 20;
    protected static final int PRESS_ACTION = 21;
    protected static final int DRAG_ACTION = 22;
    protected static final int RELEASE_ACTION = 23;
    protected static final int ENTERED_ACTION = 24;
    protected static final int EXITED_ACTION = 25;
    protected static final int POSITION = 26;
    protected static final int SIZE = 27;
    protected static final int MENU_NAME = 28;
    protected static final int OFFSET = 29;
    protected static final int DEPTH_FACTOR = 30;
    protected static final int MEASURED = 31;
    protected static final int EXTRA_COLOR = 32;
    protected static final int TEXTURE = 33;
    protected static final int SECOND_TEXTURE = 34;
    protected static final int TEXTURE_TRANSPARENCY = 35;
    protected static final int TEXTURE_COMBINE = 36;
    protected static final int COLOR_ORIGIN = 37;
    protected static final int COLOR_DIRECTION = 38;
    protected static final int COLOR_LEVELS = 39;
    protected static final int COLOR_FILLS = 40;
    protected static final int COLOR_BELOW = 41;
    public static final Color NULL_COLOR = ConstantParserUtil.NULL_COLOR;
    public static final double TO_RADIANS = Math.PI / 180;
    protected String menuNameEntry = null;
    protected DoubleValue[] posValues;
    protected DoubleValue[] sizeValues;
    protected double defaultX;
    protected double defaultY;
    protected double defaultZ;
    protected double defaultSizeX;
    protected double defaultSizeY;
    protected double defaultSizeZ;
    protected Color defLines;
    protected Color defExtraColor;
    protected Paint defFill;
    protected Resolution defaultRes;
    protected int defaultOffset;
    protected double[] thePos;
    protected double[] theSize;
    protected ControlParentOfElement3D myParent;
    private Element myElement = this.createElement();
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private static List<String> infoList = null;

    public ControlElement3D() {
        Style myStyle = this.myElement.getStyle();
        DoubleValue[] doubleValueArray = new DoubleValue[3];
        this.defaultX = this.myElement.getX();
        doubleValueArray[0] = new DoubleValue(this.defaultX);
        this.defaultY = this.myElement.getY();
        doubleValueArray[1] = new DoubleValue(this.defaultY);
        this.defaultZ = this.myElement.getZ();
        doubleValueArray[2] = new DoubleValue(this.defaultZ);
        this.posValues = doubleValueArray;
        DoubleValue[] doubleValueArray2 = new DoubleValue[3];
        this.defaultSizeX = this.myElement.getSizeX();
        doubleValueArray2[0] = new DoubleValue(this.defaultSizeX);
        this.defaultSizeY = this.myElement.getSizeY();
        doubleValueArray2[1] = new DoubleValue(this.defaultSizeY);
        this.defaultSizeZ = this.myElement.getSizeZ();
        doubleValueArray2[2] = new DoubleValue(this.defaultSizeZ);
        this.sizeValues = doubleValueArray2;
        this.defLines = myStyle.getLineColor();
        this.defFill = myStyle.getFillColor();
        this.defExtraColor = myStyle.getExtraColor();
        this.defaultRes = myStyle.getResolution();
        this.defaultOffset = myStyle.getRelativePosition();
        int disp = this.getPropertiesDisplacement();
        this.posSpot = new int[]{2 + disp, 3 + disp, 4 + disp};
        this.sizeSpot = new int[]{5 + disp, 6 + disp, 7 + disp};
        this.fullPosition = 26 + disp;
        this.fullSize = 27 + disp;
        this.myElement.addInteractionListener(this);
        this.myElement.setDataObject(this);
    }

    protected abstract int getPropertiesDisplacement();

    protected abstract Element createElement();

    @Override
    public Object getObject() {
        return this.myElement;
    }

    @Override
    public abstract String getObjectClassname();

    public Element getElement() {
        return this.myElement;
    }

    /*
     * Unable to fully structure code
     */
    protected Window getTopWindow() {
        if (this.myParent == null) {
            return null;
        }
        ejsControl = this.getEjsControl();
        parent = ejsControl.getElement(this.getProperty("parent"));
        if (parent != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            parent = ejsControl.getElement(parent.getProperty("parent"));
lbl8:
            // 2 sources

            ** while (!(parent instanceof ControlSwingElement))
        }
lbl9:
        // 1 sources

        return ((ControlSwingElement)parent).getTopWindow();
    }

    public final int[] getPosSpot() {
        return this.posSpot;
    }

    public final int[] getSizeSpot() {
        return this.sizeSpot;
    }

    public final int getFullPositionSpot() {
        return this.fullPosition;
    }

    public final int getFullSizeSpot() {
        return this.fullSize;
    }

    protected void setName(String _name) {
        this.myElement.setName(_name);
    }

    public final void setParent(ControlParentOfElement3D _dp) {
        Element el = this.myElement;
        if (this.myParent != null) {
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent.removeElement(el);
        }
        if (_dp != null) {
            if (this instanceof NeedsPreUpdate) {
                _dp.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            _dp.addElement(el);
            if (_dp instanceof NeedsUpdate) {
                ((NeedsUpdate)((Object)_dp)).update();
            }
            if (_dp instanceof NeedsFinalUpdate) {
                ((NeedsFinalUpdate)((Object)_dp)).finalUpdate();
            }
            this.myParent = _dp;
        }
    }

    public final ControlParentOfElement3D getParent() {
        return this.myParent;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.myParent instanceof NeedsUpdate) {
            ((NeedsUpdate)((Object)this.myParent)).update();
        }
        if (this.myParent instanceof NeedsFinalUpdate) {
            ((NeedsFinalUpdate)((Object)this.myParent)).finalUpdate();
        }
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        if (_child instanceof ControlTransformation3D) {
            return true;
        }
        return super.acceptsChild(_child);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("sizeZ");
            infoList.add("transformation");
            infoList.add("visible");
            infoList.add("lineColor");
            infoList.add("lineWidth");
            infoList.add("fillColor");
            infoList.add("resolution");
            infoList.add("drawingFill");
            infoList.add("drawingLines");
            infoList.add("enabledPosition");
            infoList.add("movesGroup");
            infoList.add("enabledSize");
            infoList.add("resizesGroup");
            infoList.add("sensitivity");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("position");
            infoList.add("size");
            infoList.add("menuName");
            infoList.add("elementposition");
            infoList.add("depthFactor");
            infoList.add("measured");
            infoList.add("extraColor");
            infoList.add("texture");
            infoList.add("textureSecond");
            infoList.add("textureTransparency");
            infoList.add("textureCombine");
            infoList.add("colorOrigin");
            infoList.add("colorDirection");
            infoList.add("colorLevels");
            infoList.add("colorFills");
            infoList.add("belowWhenEqual");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String CONSTANT";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("z")) {
            return "int|double";
        }
        if (_property.equals("sizeX")) {
            return "int|double";
        }
        if (_property.equals("sizeY")) {
            return "int|double";
        }
        if (_property.equals("sizeZ")) {
            return "int|double";
        }
        if (_property.equals("transformation")) {
            return "3DTransformation|double[]|String|Object";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("lineColor")) {
            return "int|Color|Object";
        }
        if (_property.equals("lineWidth")) {
            return "int|double";
        }
        if (_property.equals("fillColor")) {
            return "int|Color|Object";
        }
        if (_property.equals("resolution")) {
            return "3DResolution|String|Object|double";
        }
        if (_property.equals("drawingFill")) {
            return "boolean";
        }
        if (_property.equals("drawingLines")) {
            return "boolean";
        }
        if (_property.equals("enabledPosition")) {
            return "Interaction3D|int|boolean";
        }
        if (_property.equals("movesGroup")) {
            return "boolean";
        }
        if (_property.equals("enabledSize")) {
            return "Interaction3D|int|boolean";
        }
        if (_property.equals("resizesGroup")) {
            return "boolean";
        }
        if (_property.equals("sensitivity")) {
            return "int";
        }
        if (_property.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("position")) {
            return "double[]";
        }
        if (_property.equals("size")) {
            return "double[]";
        }
        if (_property.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("elementposition")) {
            return "ElementPosition|int";
        }
        if (_property.equals("depthFactor")) {
            return "double";
        }
        if (_property.equals("measured")) {
            return "boolean";
        }
        if (_property.equals("extraColor")) {
            return "int|Color|Object";
        }
        if (_property.equals("texture")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("textureSecond")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("textureTransparency")) {
            return "double";
        }
        if (_property.equals("textureCombine")) {
            return "boolean";
        }
        if (_property.equals("colorOrigin")) {
            return "double[]";
        }
        if (_property.equals("colorDirection")) {
            return "double[]";
        }
        if (_property.equals("colorLevels")) {
            return "double[]";
        }
        if (_property.equals("colorFills")) {
            return "Object[]|Color[]|int[]";
        }
        if (_property.equals("belowWhenEqual")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(_property);
    }

    public void updatePanel() {
        DrawingPanel3D panel = this.myElement.getPanel();
        if (panel != null) {
            panel.update();
        }
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setName(_value.getString());
                super.setValue(0, _value);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null) {
                    this.setParent(null);
                }
                if ((parent = this.myGroup.getElement(_value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> not found for " + this.toString());
                    break;
                }
                if (parent instanceof ControlParentOfElement3D) {
                    this.setParent((ControlParentOfElement3D)((Object)parent));
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> is not a ControlElements3DParent");
                break;
            }
            case 2: {
                this.thePos = null;
                this.posValues[0].value = _value.getDouble();
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 3: {
                this.thePos = null;
                this.posValues[1].value = _value.getDouble();
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 4: {
                this.thePos = null;
                this.posValues[2].value = _value.getDouble();
                this.myElement.setZ(this.posValues[2].value);
                break;
            }
            case 26: {
                if (!(_value.getObject() instanceof double[])) break;
                this.thePos = (double[])_value.getObject();
                this.posValues[0].value = this.thePos[0];
                this.posValues[1].value = this.thePos[1];
                this.posValues[2].value = this.thePos[2];
                this.myElement.setXYZ(this.posValues[0].value, this.posValues[1].value, this.posValues[2].value);
                break;
            }
            case 5: {
                this.theSize = null;
                this.sizeValues[0].value = _value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 6: {
                this.theSize = null;
                this.sizeValues[1].value = _value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 7: {
                this.theSize = null;
                this.sizeValues[2].value = _value.getDouble();
                this.myElement.setSizeZ(this.sizeValues[2].value);
                break;
            }
            case 27: {
                if (!(_value.getObject() instanceof double[])) break;
                this.theSize = (double[])_value.getObject();
                this.sizeValues[0].value = this.theSize[0];
                this.sizeValues[1].value = this.theSize[1];
                this.sizeValues[2].value = this.theSize[2];
                this.myElement.setSizeXYZ(this.sizeValues[0].value, this.sizeValues[1].value, this.sizeValues[2].value);
                break;
            }
            case 8: {
                if (_value == null) {
                    System.err.println("Trans is null");
                    return;
                }
                if (_value.getObject() instanceof Transformation) {
                    this.myElement.setTransformation((Transformation)_value.getObject());
                    break;
                }
                if (_value.getObject() instanceof double[]) {
                    double[] array = (double[])_value.getObject();
                    if (array.length == 6) {
                        double[] v1 = new double[]{array[0], array[1], array[2]};
                        double[] v2 = new double[]{array[3], array[4], array[5]};
                        this.myElement.setTransformation(Matrix3DTransformation.createAlignmentTransformation(v1, v2));
                        break;
                    }
                    if (array.length != 4) break;
                    double[] v = new double[]{array[1], array[2], array[3]};
                    this.myElement.setTransformation(Matrix3DTransformation.rotation(array[0], v));
                    break;
                }
                this.myElement.setTransformation(ControlElement3D.createTransformation(this, _value.getString()));
                break;
            }
            case 9: {
                this.myElement.setVisible(_value.getBoolean());
                break;
            }
            case 10: {
                if (_value.getObject() instanceof Color) {
                    this.myElement.getStyle().setLineColor((Color)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setLineColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth((float)_value.getDouble());
                break;
            }
            case 12: {
                if (_value.getObject() instanceof Paint) {
                    this.myElement.getStyle().setFillColor((Paint)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setFillColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 13: {
                if (_value.getObject() instanceof Resolution) {
                    this.myElement.getStyle().setResolution((Resolution)_value.getObject());
                    break;
                }
                Resolution res = ControlElement3D.decodeResolution(_value.toString());
                if (res == null) break;
                this.myElement.getStyle().setResolution(res);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingFill(_value.getBoolean());
                break;
            }
            case 15: {
                this.myElement.getStyle().setDrawingLines(_value.getBoolean());
                break;
            }
            case 16: {
                if (_value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(0).setEnabled(_value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(0).setEnabled(_value.getInteger());
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(_value.getBoolean());
                break;
            }
            case 18: {
                if (_value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(1).setEnabled(_value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(1).setEnabled(_value.getInteger());
                break;
            }
            case 19: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(_value.getBoolean());
                break;
            }
            case 20: {
                this.myElement.getStyle().setSensitivity(_value.getInteger());
                break;
            }
            case 21: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 22: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 23: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, _value.getString());
                break;
            }
            case 24: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 25: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 28: {
                this.menuNameEntry = _value.getString();
                this.setName(this.menuNameEntry);
                break;
            }
            case 29: {
                if (_value.getInteger() == this.myElement.getStyle().getRelativePosition()) break;
                this.myElement.getStyle().setRelativePosition(_value.getInteger());
                break;
            }
            case 30: {
                if (_value.getDouble() == this.myElement.getStyle().getDepthFactor()) break;
                this.myElement.getStyle().setDepthFactor(_value.getDouble());
                break;
            }
            case 31: {
                this.myElement.setCanBeMeasured(_value.getBoolean());
                break;
            }
            case 32: {
                if (_value.getObject() instanceof Color) {
                    this.myElement.getStyle().setExtraColor((Color)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setExtraColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 33: {
                this.myElement.getStyle().setTexture(_value.getString(), this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 34: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], _value.getString(), this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 35: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], _value.getDouble(), this.myElement.getStyle().getCombine());
                break;
            }
            case 36: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), _value.getBoolean());
                break;
            }
            case 37: {
                this.myElement.setColorOrigin((double[])_value.getObject());
                break;
            }
            case 38: {
                this.myElement.setColorDirection((double[])_value.getObject());
                break;
            }
            case 39: {
                this.myElement.setColorRegions((double[])_value.getObject());
                break;
            }
            case 40: {
                if (_value.getObject() instanceof Color[]) {
                    this.myElement.setColorPalette((Color[])_value.getObject());
                    break;
                }
                if (!(_value.getObject() instanceof int[])) break;
                this.myElement.setColorPalette((int[])_value.getObject());
                break;
            }
            case 41: {
                this.myElement.setColorBelowWhenEqual(_value.getBoolean());
                break;
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                this.setName("");
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.posValues[0].value = this.defaultX;
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 3: {
                this.posValues[1].value = this.defaultY;
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 4: {
                this.posValues[2].value = this.defaultZ;
                this.myElement.setZ(this.posValues[2].value);
                break;
            }
            case 26: {
                this.thePos = null;
                break;
            }
            case 5: {
                this.sizeValues[0].value = this.defaultSizeX;
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 6: {
                this.sizeValues[1].value = this.defaultSizeY;
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 7: {
                this.sizeValues[2].value = this.defaultSizeZ;
                this.myElement.setSizeZ(this.sizeValues[2].value);
                break;
            }
            case 27: {
                this.theSize = null;
                break;
            }
            case 8: {
                this.myElement.setTransformation(new Matrix3DTransformation(null));
                break;
            }
            case 9: {
                this.myElement.setVisible(true);
                break;
            }
            case 10: {
                this.myElement.getStyle().setLineColor(this.defLines);
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth(1.0f);
                break;
            }
            case 12: {
                this.myElement.getStyle().setFillColor(this.defFill);
                break;
            }
            case 13: {
                this.myElement.getStyle().setResolution(this.defaultRes);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingFill(true);
                break;
            }
            case 15: {
                this.myElement.getStyle().setDrawingLines(true);
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setEnabled(false);
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(false);
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setEnabled(false);
                break;
            }
            case 19: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(false);
                break;
            }
            case 20: {
                this.myElement.getStyle().setSensitivity(5);
                break;
            }
            case 21: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 22: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 23: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 24: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 25: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 28: {
                this.menuNameEntry = null;
                break;
            }
            case 29: {
                this.myElement.getStyle().setRelativePosition(5);
                break;
            }
            case 30: {
                this.myElement.getStyle().setDepthFactor(1.0);
                break;
            }
            case 31: {
                this.myElement.setCanBeMeasured(true);
                break;
            }
            case 32: {
                this.myElement.getStyle().setExtraColor(this.defExtraColor);
                break;
            }
            case 33: {
                this.myElement.getStyle().setTexture(null, this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 34: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], null, this.myElement.getStyle().getTransparency(), this.myElement.getStyle().getCombine());
                break;
            }
            case 35: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], Double.NaN, this.myElement.getStyle().getCombine());
                break;
            }
            case 36: {
                this.myElement.getStyle().setTexture(this.myElement.getStyle().getTextures()[0], this.myElement.getStyle().getTextures()[1], this.myElement.getStyle().getTransparency(), false);
                break;
            }
            case 37: {
                this.myElement.setColorOrigin(new double[]{0.0, 0.0, 0.0});
                break;
            }
            case 38: {
                this.myElement.setColorDirection(new double[]{1.0, 0.0, 0.0});
                break;
            }
            case 39: {
                this.myElement.setColorRegions(null);
                break;
            }
            case 40: {
                this.myElement.setColorRegions(null);
                break;
            }
            case 41: {
                this.myElement.setColorBelowWhenEqual(true);
                break;
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 26: 
            case 27: {
                return "<none>";
            }
            case 2: {
                return "" + this.defaultX;
            }
            case 3: {
                return "" + this.defaultY;
            }
            case 4: {
                return "" + this.defaultZ;
            }
            case 5: {
                return "" + this.defaultSizeX;
            }
            case 6: {
                return "" + this.defaultSizeY;
            }
            case 7: {
                return "" + this.defaultSizeZ;
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return "<none>";
            }
            case 11: {
                return "1";
            }
            case 12: {
                return "<none>";
            }
            case 13: {
                return "<none>";
            }
            case 14: 
            case 15: {
                return "true";
            }
            case 16: {
                return "ENABLED_NONE";
            }
            case 17: {
                return "false";
            }
            case 18: {
                return "ENABLED_NONE";
            }
            case 19: {
                return "false";
            }
            case 20: {
                return Integer.toString(5);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return "<no_action>";
            }
            case 28: {
                return "<none>";
            }
            case 29: {
                return "" + this.defaultOffset;
            }
            case 30: {
                return "1.0";
            }
            case 31: {
                return "true";
            }
            case 32: {
                return this.defExtraColor.toString();
            }
            case 33: 
            case 34: 
            case 35: {
                return "<none>";
            }
            case 36: {
                return "false";
            }
            case 37: {
                return "{0.0,0.0,0.0}";
            }
            case 38: {
                return "{1.0,0.0,0.0}";
            }
            case 39: 
            case 40: {
                return "<none>";
            }
            case 41: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 26: {
                return new ObjectValue(this.thePos);
            }
            case 2: {
                return this.posValues[0];
            }
            case 3: {
                return this.posValues[1];
            }
            case 4: {
                return this.posValues[2];
            }
            case 27: {
                return new ObjectValue(this.theSize);
            }
            case 5: {
                return this.sizeValues[0];
            }
            case 6: {
                return this.sizeValues[1];
            }
            case 7: {
                return this.sizeValues[2];
            }
        }
        return null;
    }

    final ControlGroup3D getControlGroup() {
        if (this.myParent instanceof ControlGroup3D) {
            return (ControlGroup3D)this.myParent;
        }
        return null;
    }

    protected void propagatePosition(ControlElement3D origin) {
        this.posValues[0].value = this.myElement.getX();
        this.posValues[1].value = this.myElement.getY();
        this.posValues[2].value = this.myElement.getZ();
        if (this.thePos != null) {
            this.thePos[0] = this.posValues[0].value;
            this.thePos[1] = this.posValues[1].value;
            this.thePos[2] = this.posValues[2].value;
            ObjectValue objVal = new ObjectValue(this.thePos);
            this.variableChanged(this.getFullPositionSpot(), objVal);
            if (origin != this) {
                origin.variableChanged(origin.getFullPositionSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.posValues);
            if (origin != this) {
                origin.variablesChanged(origin.getPosSpot(), this.posValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.posValues);
            }
        }
    }

    protected void propagateSize(ControlElement3D origin) {
        this.sizeValues[0].value = this.myElement.getSizeX();
        this.sizeValues[1].value = this.myElement.getSizeY();
        this.sizeValues[2].value = this.myElement.getSizeZ();
        if (this.theSize != null) {
            this.theSize[0] = this.sizeValues[0].value;
            this.theSize[1] = this.sizeValues[1].value;
            this.theSize[2] = this.sizeValues[2].value;
            ObjectValue objVal = new ObjectValue(this.theSize);
            this.variableChanged(this.getFullSizeSpot(), objVal);
            if (origin != this) {
                origin.variableChanged(origin.getFullSizeSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.sizeValues);
            if (origin != this) {
                origin.variablesChanged(origin.getSizeSpot(), this.sizeValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.sizeValues);
            }
        }
    }

    private void reportMouseMotion(Object _info) {
        InteractionTarget target = (InteractionTarget)_info;
        ControlGroup3D gr = this.getControlGroup();
        if (target == this.myElement.getInteractionTarget(0)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagatePosition(this);
            } else {
                this.propagatePosition(this);
            }
        } else if (target == this.myElement.getInteractionTarget(1)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagateSize(this);
            } else {
                this.propagateSize(this);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2000: {
                this.reportMouseMotion(_event.getInfo());
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(_event.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("3DResolution") >= 0) {
            Resolution res = ControlElement3D.decodeResolution(_value);
            if (res != null) {
                return new ObjectValue(res);
            }
        } else if (_propertyType.indexOf("ElementPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north")) {
                return new IntegerValue(1);
            }
            if (_value.equals("south")) {
                return new IntegerValue(2);
            }
            if (_value.equals("east")) {
                return new IntegerValue(3);
            }
            if (_value.equals("west")) {
                return new IntegerValue(4);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (_value.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (_propertyType.indexOf("ArrowPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (_propertyType.indexOf("3DTransformation") >= 0) {
            Transformation transf = ControlElement3D.decodeTransformation(this, _value);
            if (transf != null) {
                return new ObjectValue(transf);
            }
        } else if (_propertyType.indexOf("ArrowPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (_propertyType.indexOf("MarkerShape") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (_value.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (_value.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (_value.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (_value.equals("none")) {
                return new IntegerValue(0);
            }
        } else if (_propertyType.indexOf("Interaction3D") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("enabled_none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("enabled_any")) {
                return new IntegerValue(1);
            }
            if (_value.equals("enabled_x")) {
                return new IntegerValue(2);
            }
            if (_value.equals("enabled_y")) {
                return new IntegerValue(3);
            }
            if (_value.equals("enabled_z")) {
                return new IntegerValue(4);
            }
            if (_value.equals("enabled_xy")) {
                return new IntegerValue(5);
            }
            if (_value.equals("enabled_xz")) {
                return new IntegerValue(6);
            }
            if (_value.equals("enabled_yz")) {
                return new IntegerValue(7);
            }
            if (_value.equals("enabled_no_move")) {
                return new IntegerValue(8);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public static Resolution decodeResolution(String _value) {
        if ((_value = _value.trim().toLowerCase()).indexOf(46) >= 0) {
            try {
                return new Resolution(Double.parseDouble(_value));
            }
            catch (Exception exc) {
                System.out.println("Incorrect double value for resolution");
                exc.printStackTrace();
                return null;
            }
        }
        if (_value.indexOf(44) < 0) {
            try {
                return new Resolution(Integer.parseInt(_value), 1, 1);
            }
            catch (Exception exc) {
                return null;
            }
        }
        try {
            StringTokenizer t = new StringTokenizer(_value, "\",");
            int n1 = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return new Resolution(n1, 1, 1);
            }
            int n2 = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return new Resolution(n1, n2, 1);
            }
            return new Resolution(n1, n2, Integer.parseInt(t.nextToken()));
        }
        catch (Exception exc) {
            System.out.println("Incorrect integer values for resolution");
            exc.printStackTrace();
            return null;
        }
    }

    private static Transformation createTransformation(ControlElement _element, String _value) {
        Matrix3DTransformation transformation = new Matrix3DTransformation(null);
        if (_value == null || _value.equals("null")) {
            return transformation;
        }
        if (_value.indexOf(58) < 0 && _value.indexOf(44) < 0) {
            return transformation;
        }
        if (_element.editorIsReading() && _value.indexOf("void") >= 0) {
            return transformation;
        }
        StringTokenizer tokenizer = new StringTokenizer(_value, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            String keyword = token.toLowerCase();
            try {
                Matrix3DTransformation newTransf;
                String angleStr;
                if (keyword.startsWith("x:") || keyword.startsWith("y:") || keyword.startsWith("z:")) {
                    angleStr = token.substring(2).trim();
                    boolean degrees = false;
                    if (angleStr.endsWith("\ufffd") || angleStr.endsWith("d")) {
                        angleStr = angleStr.substring(0, angleStr.length() - 1).trim();
                        degrees = true;
                    }
                    double angle = Double.parseDouble(angleStr);
                    if (degrees) {
                        angle *= Math.PI / 180;
                    }
                    newTransf = keyword.startsWith("x") ? Matrix3DTransformation.rotationX(angle) : (keyword.startsWith("y") ? Matrix3DTransformation.rotationY(angle) : Matrix3DTransformation.rotationZ(angle));
                } else if (keyword.startsWith("q:")) {
                    angleStr = token.substring(2).trim();
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    double q1 = Double.parseDouble(t.nextToken());
                    double q2 = Double.parseDouble(t.nextToken());
                    double q3 = Double.parseDouble(t.nextToken());
                    double q4 = Double.parseDouble(t.nextToken());
                    newTransf = Matrix3DTransformation.Quaternion(q1, q2, q3, q4);
                } else {
                    angleStr = token;
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    String firstToken = t.nextToken();
                    double x2 = Double.parseDouble(t.nextToken());
                    double x3 = Double.parseDouble(t.nextToken());
                    double x4 = Double.parseDouble(t.nextToken());
                    if (!t.hasMoreTokens()) {
                        boolean degrees = false;
                        if (firstToken.endsWith("\ufffd") || firstToken.endsWith("d")) {
                            firstToken = firstToken.substring(0, firstToken.length() - 1);
                            degrees = true;
                        }
                        double angle = Double.parseDouble(firstToken);
                        if (degrees) {
                            angle *= Math.PI / 180;
                        }
                        newTransf = Matrix3DTransformation.rotation(angle, new double[]{x2, x3, x4});
                    } else {
                        double x1 = Double.parseDouble(firstToken);
                        double x5 = Double.parseDouble(t.nextToken());
                        double x6 = Double.parseDouble(t.nextToken());
                        newTransf = Matrix3DTransformation.createAlignmentTransformation(new double[]{x1, x2, x3}, new double[]{x4, x5, x6});
                    }
                }
                newTransf.multiply(transformation);
                transformation = newTransf;
            }
            catch (Exception exc) {
                System.out.println("Incorrect value for transformation: " + token);
                exc.printStackTrace();
            }
        }
        return transformation;
    }

    private static Transformation decodeTransformation(ControlElement _element, String _value) {
        if (_value.indexOf(34) >= 0) {
            return null;
        }
        if (_value.indexOf(37) >= 0) {
            return null;
        }
        if (_value.indexOf(123) >= 0 || _value.indexOf(125) >= 0) {
            return null;
        }
        if (_value.indexOf(58) < 0 && _value.indexOf(44) < 0) {
            return null;
        }
        return ControlElement3D.createTransformation(_element, _value.trim());
    }
}

