/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.BootstrapIntervalData;

public class Bootstrap2IntervalData
extends BootstrapIntervalData {
    private static final double BETA1 = 0.7;
    private static final double BETA2 = 0.85;
    private static final double bt2_den = 0.009639000000000005;
    private static final double bt2_cf11 = -0.06999999999999974;
    private static final double bt2_cf01 = 0.33000000000000007;
    private static final double bt2_cys1 = -1.26;
    private static final double bt2_cf12 = -0.46749999999999986;
    private static final double bt2_cf02 = 0.23250000000000015;
    private static final double bt2_cys2 = -0.765;
    private static final double bt2_m44 = -0.16799999999999982;
    private static final double bt2_m54 = -0.17849999999999996;
    private static final double bt2_m45 = -0.4095;
    private static final double bt2_m55 = -0.4924687499999998;
    private double[] state_bt2 = null;
    private double[] rate_bt21;
    private double[] rate_bt22;
    private double[] bt2_c2;
    private double[] bt2_c3;
    private double[] bt2_c4;
    private double[] bt2_c5;

    public Bootstrap2IntervalData(double[] aState, double[] aRate, double[] bState, double[] bRate, ODE ode) {
        super(aState, aRate, bState, bRate, ode);
        this.prepareSecondBootstrap();
    }

    @Override
    public double interpolate(double time, int index) {
        double step = (time - this.getLeft()) / this.mDeltaTime;
        return this.mLeftState[index] + step * (this.mDeltaTime * this.mLeftRate[index] + step * (this.bt2_c2[index] + step * (this.bt2_c3[index] + step * (this.bt2_c4[index] + step * this.bt2_c5[index]))));
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        this.bootstrap2((time - this.getLeft()) / this.mDeltaTime, state, beginIndex, length);
        return state;
    }

    protected void bootstrap2(double step, double[] state, int beginIndex, int length) {
        int index = beginIndex;
        int i = 0;
        while (i < length) {
            state[i] = this.mLeftState[index] + step * (this.mDeltaTime * this.mLeftRate[index] + step * (this.bt2_c2[index] + step * (this.bt2_c3[index] + step * (this.bt2_c4[index] + step * this.bt2_c5[index]))));
            ++index;
            ++i;
        }
    }

    private void prepareSecondBootstrap() {
        int dimension = this.mTimeIndex + 1;
        if (this.state_bt2 == null) {
            this.state_bt2 = new double[dimension];
            this.rate_bt21 = new double[dimension];
            this.rate_bt22 = new double[dimension];
            this.bt2_c2 = new double[dimension];
            this.bt2_c3 = new double[dimension];
            this.bt2_c4 = new double[dimension];
            this.bt2_c5 = new double[dimension];
        }
        super.bootstrap1(0.7, this.state_bt2, 0, this.mTimeIndex);
        this.state_bt2[this.mTimeIndex] = this.getLeft() + 0.7 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt2, this.rate_bt21);
        super.bootstrap1(0.85, this.state_bt2, 0, this.mTimeIndex);
        this.state_bt2[this.mTimeIndex] = this.getLeft() + 0.85 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt2, this.rate_bt22);
        int i = 0;
        while (i < dimension) {
            double dif = this.mRightState[i] - this.mLeftState[i];
            double f0 = this.mDeltaTime * this.mLeftRate[i];
            double f1 = this.mDeltaTime * this.mRightRate[i];
            double e1 = this.mDeltaTime * this.rate_bt21[i] + -0.06999999999999974 * f1 + 0.33000000000000007 * f0 + -1.26 * dif;
            double e2 = this.mDeltaTime * this.rate_bt22[i] + -0.46749999999999986 * f1 + 0.23250000000000015 * f0 + -0.765 * dif;
            double c4 = (-0.4924687499999998 * e1 - -0.4095 * e2) / 0.009639000000000005;
            double c5 = (-0.16799999999999982 * e2 - -0.17849999999999996 * e1) / 0.009639000000000005;
            double c3 = f1 + f0 - 2.0 * dif - 2.0 * c4 - 3.0 * c5;
            this.bt2_c5[i] = c5;
            this.bt2_c4[i] = c4;
            this.bt2_c3[i] = c3;
            this.bt2_c2[i] = dif - f0 - c3 - c4 - c5;
            ++i;
        }
    }
}

