/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class Style {
    public static final int DEFAULT_SENSITIVITY = 5;
    public static final int CHANGED_LINE_COLOR = 0;
    public static final int CHANGED_LINE_WIDTH = 1;
    public static final int CHANGED_FILL_COLOR = 2;
    public static final int CHANGED_DRAWING_FILL = 3;
    public static final int CHANGED_DRAWING_LINES = 4;
    public static final int CHANGED_RELATIVE_POSITION = 5;
    public static final int CHANGED_SENSITIVITY = 6;
    public static final int CHANGED_EXTRA_COLOR = 7;
    public static final int CHANGED_DEPTH_FACTOR = 8;
    public static final int CHANGED_RESOLUTION = 9;
    public static final int CHANGED_TEXTURES = 10;
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.BLACK;
    private float lineWidth = 1.0f;
    private Paint fillColor = Color.BLUE;
    private Color extraColor = Color.black;
    private int sensitivity = 5;
    private Resolution resolution = null;
    private double depthFactor = 1.0;
    private int position = 0;
    private Object texture1 = null;
    private Object texture2 = null;
    private double transpTexture = Double.NaN;
    private boolean combineTexture = false;
    private double ambientFactor = 0.4;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    public Style(Element _element) {
        this.element = _element;
    }

    public Element getElement() {
        return this.element;
    }

    public Style clone() {
        Style newStyle = new Style(this.element);
        this.copyTo(newStyle);
        return newStyle;
    }

    public void copyTo(Style target) {
        target.setDrawingFill(this.drawsFill);
        target.setDrawingLines(this.drawsLines);
        target.setLineColor(this.lineColor);
        target.setLineWidth(this.lineWidth);
        target.setFillColor(this.fillColor);
        target.setExtraColor(this.extraColor);
        target.setSensitivity(this.sensitivity);
        target.setResolution(this.resolution);
        target.setDepthFactor(this.depthFactor);
        target.setRelativePosition(this.position);
        target.setTexture(this.texture1, this.texture2, this.transpTexture, this.combineTexture);
    }

    private void notifyChange(int change) {
        if (this.element == null) {
            return;
        }
        this.element.styleChanged(change);
    }

    void setElement(Element _element) {
        this.element = _element;
    }

    public void setLineColor(Color _color) {
        if (_color == null || _color.equals(this.lineColor)) {
            return;
        }
        this.lineColor = _color;
        this.notifyChange(0);
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(float _width) {
        if (this.lineWidth == _width) {
            return;
        }
        this.lineWidth = _width;
        this.lineStroke = new BasicStroke(this.lineWidth);
        this.notifyChange(1);
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Paint _color) {
        if (_color == null || _color.equals(this.fillColor)) {
            return;
        }
        this.fillColor = _color;
        this.notifyChange(2);
    }

    public final Paint getFillColor() {
        return this.fillColor;
    }

    public final void setExtraColor(Color _color) {
        if (_color == null || _color.equals(this.extraColor)) {
            return;
        }
        this.extraColor = _color;
        this.notifyChange(7);
    }

    public final Color getExtraColor() {
        return this.extraColor;
    }

    public void setResolution(Resolution _resolution) {
        if (this.resolution != null && this.resolution.equals(_resolution)) {
            return;
        }
        this.resolution = _resolution;
        this.notifyChange(9);
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public boolean isDrawingFill() {
        return this.drawsFill;
    }

    public void setDrawingFill(boolean _drawsFill) {
        if (this.drawsFill == _drawsFill) {
            return;
        }
        this.drawsFill = _drawsFill;
        this.notifyChange(3);
    }

    public boolean isDrawingLines() {
        return this.drawsLines;
    }

    public void setDrawingLines(boolean _drawsLines) {
        if (this.drawsLines == _drawsLines) {
            return;
        }
        this.drawsLines = _drawsLines;
        this.notifyChange(4);
    }

    public void setDepthFactor(double factor) {
        if (this.depthFactor == factor) {
            return;
        }
        this.depthFactor = factor;
        this.notifyChange(8);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setTexture(Object texture1, Object texture2, double transparency, boolean combine) {
        this.texture1 = texture1;
        this.texture2 = texture2;
        this.transpTexture = transparency;
        this.combineTexture = combine;
        this.notifyChange(10);
    }

    public Object[] getTextures() {
        return new Object[]{this.texture1, this.texture2};
    }

    public double getTransparency() {
        return this.transpTexture;
    }

    public boolean getCombine() {
        return this.combineTexture;
    }

    public void setAmbientFactor(double _factor) {
        if (this.ambientFactor == _factor) {
            return;
        }
        this.ambientFactor = _factor;
        this.notifyChange(2);
    }

    public double getAmbientFactor() {
        return this.ambientFactor;
    }

    public final void setRelativePosition(int _position) {
        if (this.position == _position) {
            return;
        }
        this.position = _position;
        this.notifyChange(5);
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public final void setSensitivity(int _s) {
        if (this.sensitivity == _s) {
            return;
        }
        this.sensitivity = _s;
        this.notifyChange(6);
    }

    public final int getSensitivity() {
        return this.sensitivity;
    }
}

