/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public abstract class SimpleAbstractTile
extends SimpleElement {
    protected static final int RECOMPUTE_VERTEX = 24;
    protected int[][] a = null;
    protected int[][] b = null;
    private int numberOfTiles = -1;
    private double[][][] standardTile = null;
    private double[][][] vertex = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;

    public SimpleAbstractTile(Element _element) {
        super(_element);
    }

    protected abstract double[][][] computeTile();

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x18) != 0) {
            this.computeVertex();
            this.computeCoordinates();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x136) != 0) {
            this.computeCoordinates();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        if (this.element.getColorLevels() != null && this.element.getColorPalette() != null) {
            this.drawColorCoded(_g2, _index);
            return;
        }
        DrawingPanel3D panel = this.element.getPanel();
        int sides = this.vertex[_index].length;
        if (this.style.isDrawingFill()) {
            _g2.setPaint(panel.projectPaint(this.style.getFillColor(), this.objects[_index].getDistance()));
            _g2.fillPolygon(this.a[_index], this.b[_index], sides);
        }
        if (this.style.isDrawingLines()) {
            _g2.setStroke(this.style.getLineStroke());
            _g2.setColor(panel.projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
            _g2.drawPolygon(this.a[_index], this.b[_index], sides);
        }
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        if (this.style.isDrawingFill() || this.drawQuickInterior) {
            Color color;
            Paint fill = this.style.getFillColor();
            if (this.drawQuickInterior && fill instanceof Color && (color = (Color)fill).getAlpha() > this.interiorTransparency) {
                fill = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            _g2.setPaint(fill);
            int i = 0;
            while (i < this.numberOfTiles) {
                _g2.fillPolygon(this.a[i], this.b[i], this.vertex[i].length);
                ++i;
            }
        }
        if (this.style.isDrawingLines()) {
            _g2.setStroke(this.style.getLineStroke());
            _g2.setColor(this.style.getLineColor());
            int i = 0;
            while (i < this.numberOfTiles) {
                _g2.drawPolygon(this.a[i], this.b[i], this.vertex[i].length);
                ++i;
            }
        }
    }

    protected final void computeVertex() {
        this.standardTile = this.computeTile();
        if (this.standardTile == null) {
            this.numberOfTiles = 0;
            return;
        }
        if (this.standardTile.length != this.numberOfTiles) {
            this.numberOfTiles = this.standardTile.length;
            this.vertex = new double[this.numberOfTiles][][];
            this.a = new int[this.numberOfTiles][];
            this.b = new int[this.numberOfTiles][];
            this.objects = new Object3D[this.numberOfTiles];
        }
        int i = 0;
        while (i < this.numberOfTiles) {
            int sides = this.standardTile[i].length;
            if (this.a[i] == null || sides != this.a[i].length) {
                this.vertex[i] = new double[sides][3];
                this.a[i] = new int[sides];
                this.b[i] = new int[sides];
            }
            this.objects[i] = new Object3D(this, i);
            ++i;
        }
    }

    protected final void computeCoordinates() {
        int i = 0;
        while (i < this.numberOfTiles) {
            int j = 0;
            int sides = this.vertex[i].length;
            while (j < sides) {
                System.arraycopy(this.standardTile[i][j], 0, this.vertex[i][j], 0, 3);
                this.element.sizeAndToSpaceFrame(this.vertex[i][j]);
                ++j;
            }
            ++i;
        }
    }

    protected final void projectPoints() {
        DrawingPanel3D panel = this.element.getPanel();
        double depthFactor = this.style.getDepthFactor();
        int i = 0;
        while (i < this.numberOfTiles) {
            int sides = this.vertex[i].length;
            int k = 0;
            while (k < 3) {
                this.center[k] = 0.0;
                ++k;
            }
            int j = 0;
            while (j < sides) {
                System.arraycopy(this.vertex[i][j], 0, this.pixel, 0, 3);
                panel.projectPosition(this.pixel);
                this.a[i][j] = (int)this.pixel[0];
                this.b[i][j] = (int)this.pixel[1];
                int k2 = 0;
                while (k2 < 3) {
                    int n = k2;
                    this.center[n] = this.center[n] + this.vertex[i][j][k2];
                    ++k2;
                }
                ++j;
            }
            k = 0;
            while (k < 3) {
                int n = k++;
                this.center[n] = this.center[n] / (double)sides;
            }
            panel.projectPosition(this.center);
            this.objects[i].setDistance(this.center[2] * depthFactor);
            ++i;
        }
    }

    public void setDrawQuickInterior(boolean draw, int transparency) {
        this.drawQuickInterior = draw;
        this.interiorTransparency = Math.max(0, Math.min(transparency, 255));
    }

    private void drawColorCoded(Graphics2D _g2, int _index) {
        int l;
        int k;
        double level;
        int j;
        int sides = this.vertex[_index].length;
        int[] region = new int[sides];
        double[] levelZ = this.element.getColorLevels();
        if (this.element.getColorBelowWhenEqual()) {
            j = 0;
            while (j < sides) {
                region[j] = 0;
                level = this.element.levelScalarProduct(this.vertex[_index][j]);
                k = levelZ.length - 1;
                while (k >= 0) {
                    if (level > levelZ[k]) {
                        region[j] = k + 1;
                        break;
                    }
                    --k;
                }
                ++j;
            }
        } else {
            j = 0;
            while (j < sides) {
                region[j] = levelZ.length;
                level = this.element.levelScalarProduct(this.vertex[_index][j]);
                k = 0;
                l = levelZ.length;
                while (k < l) {
                    if (level < levelZ[k]) {
                        region[j] = k;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
        }
        int[] newCornersA = new int[sides * 2];
        int[] newCornersB = new int[sides * 2];
        Color[] levelColors = this.element.getColorPalette();
        k = 0;
        l = levelZ.length;
        while (k <= l) {
            int newCornersCounter = 0;
            int j2 = 0;
            while (j2 < sides) {
                double t;
                int next = (j2 + 1) % sides;
                if (region[j2] <= k && region[next] >= k) {
                    if (region[j2] == k) {
                        newCornersA[newCornersCounter] = this.a[_index][j2];
                        newCornersB[newCornersCounter] = this.b[_index][j2];
                        ++newCornersCounter;
                    } else {
                        t = this.element.levelScalarProduct(this.vertex[_index][j2]);
                        t = (levelZ[k - 1] - t) / (this.element.levelScalarProduct(this.vertex[_index][next]) - t);
                        newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                        newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                        ++newCornersCounter;
                    }
                    if (region[next] > k) {
                        t = this.element.levelScalarProduct(this.vertex[_index][j2]);
                        t = (levelZ[k] - t) / (this.element.levelScalarProduct(this.vertex[_index][next]) - t);
                        newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                        newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                        ++newCornersCounter;
                    }
                } else if (region[j2] >= k && region[next] <= k) {
                    if (region[j2] == k) {
                        newCornersA[newCornersCounter] = this.a[_index][j2];
                        newCornersB[newCornersCounter] = this.b[_index][j2];
                        ++newCornersCounter;
                    } else {
                        t = this.element.levelScalarProduct(this.vertex[_index][j2]);
                        t = (levelZ[k] - t) / (this.element.levelScalarProduct(this.vertex[_index][next]) - t);
                        newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                        newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                        ++newCornersCounter;
                    }
                    if (region[next] < k) {
                        t = this.element.levelScalarProduct(this.vertex[_index][j2]);
                        t = (levelZ[k - 1] - t) / (this.element.levelScalarProduct(this.vertex[_index][next]) - t);
                        newCornersA[newCornersCounter] = (int)Math.round((double)this.a[_index][j2] + t * (double)(this.a[_index][next] - this.a[_index][j2]));
                        newCornersB[newCornersCounter] = (int)Math.round((double)this.b[_index][j2] + t * (double)(this.b[_index][next] - this.b[_index][j2]));
                        ++newCornersCounter;
                    }
                }
                ++j2;
            }
            if (newCornersCounter > 0) {
                Color theFillColor = k >= levelColors.length ? levelColors[levelColors.length - 1] : levelColors[k];
                _g2.setPaint(theFillColor);
                _g2.fillPolygon(newCornersA, newCornersB, newCornersCounter);
            }
            ++k;
        }
        _g2.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
        _g2.setStroke(this.style.getLineStroke());
        _g2.drawPolygon(this.a[_index], this.b[_index], sides);
    }
}

