/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementBox;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementBox;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementBox
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private double sizeZreduction = 1.0;

    public ElementBox() {
        this.getStyle().setResolution(new Resolution(3, 3, 3));
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementBox(this);
            }
            case 1: 
        }
        return new Java3dElementBox(this);
    }

    public void setSizeZReduction(double reduction) {
        if (this.sizeZreduction == reduction) {
            return;
        }
        this.sizeZreduction = reduction;
        this.addChange(8);
    }

    public double getSizeZReduction() {
        return this.sizeZreduction;
    }

    public void setClosedBottom(boolean close) {
        if (this.closedBottom == close) {
            return;
        }
        this.closedBottom = close;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        if (this.closedTop == close) {
            return;
        }
        this.closedTop = close;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public static double[][][] createStandardBox(int nx, int ny, int nz, boolean top, boolean bottom, double rz) {
        double topZdx;
        double topZ;
        double theX;
        int nTotal = 2 * nx * nz + 2 * ny * nz;
        if (bottom) {
            nTotal += nx * ny;
        }
        if (top) {
            nTotal += nx * ny;
        }
        if (rz == 0.0) {
            nTotal -= ny * nz;
        }
        double[][][] data = new double[nTotal][4][3];
        int tile = 0;
        double dx = 1.0 / (double)nx;
        double dy = 1.0 / (double)ny;
        int i = 0;
        while (i < nx) {
            theX = (double)i * dx;
            topZ = 1.0 - theX * (1.0 - rz) - 0.5;
            topZdx = topZ - dx * (1.0 - rz);
            theX -= 0.5;
            int j = 0;
            while (j < ny) {
                double theY = (double)j * dy - 0.5;
                if (bottom) {
                    data[tile][0][0] = theX;
                    data[tile][0][1] = theY;
                    data[tile][0][2] = -0.5;
                    data[tile][1][0] = theX + dx;
                    data[tile][1][1] = theY;
                    data[tile][1][2] = -0.5;
                    data[tile][2][0] = theX + dx;
                    data[tile][2][1] = theY + dy;
                    data[tile][2][2] = -0.5;
                    data[tile][3][0] = theX;
                    data[tile][3][1] = theY + dy;
                    data[tile][3][2] = -0.5;
                    ++tile;
                }
                if (top) {
                    data[tile][0][0] = theX;
                    data[tile][0][1] = theY;
                    data[tile][0][2] = topZ;
                    data[tile][1][0] = theX + dx;
                    data[tile][1][1] = theY;
                    data[tile][1][2] = topZdx;
                    data[tile][2][0] = theX + dx;
                    data[tile][2][1] = theY + dy;
                    data[tile][2][2] = topZdx;
                    data[tile][3][0] = theX;
                    data[tile][3][1] = theY + dy;
                    data[tile][3][2] = topZ;
                    ++tile;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nx) {
            theX = (double)i * dx;
            topZ = 1.0 - theX * (1.0 - rz);
            topZdx = topZ - dx * (1.0 - rz);
            double dz = topZ / (double)nz;
            double dzdx = topZdx / (double)nz;
            theX -= 0.5;
            int k = 0;
            while (k < nz) {
                double theZ = (double)k * dz - 0.5;
                double theZdx = (double)k * dzdx - 0.5;
                data[tile][0][0] = theX;
                data[tile][0][2] = theZ;
                data[tile][0][1] = -0.5;
                data[tile][1][0] = theX + dx;
                data[tile][1][2] = theZdx;
                data[tile][1][1] = -0.5;
                data[tile][2][0] = theX + dx;
                data[tile][2][2] = theZdx + dzdx;
                data[tile][2][1] = -0.5;
                data[tile][3][0] = theX;
                data[tile][3][2] = theZ + dz;
                data[tile][3][1] = -0.5;
                data[++tile][0][0] = theX;
                data[tile][0][2] = theZ;
                data[tile][0][1] = 0.5;
                data[tile][1][0] = theX + dx;
                data[tile][1][2] = theZdx;
                data[tile][1][1] = 0.5;
                data[tile][2][0] = theX + dx;
                data[tile][2][2] = theZdx + dzdx;
                data[tile][2][1] = 0.5;
                data[tile][3][0] = theX;
                data[tile][3][2] = theZ + dz;
                data[tile][3][1] = 0.5;
                ++tile;
                ++k;
            }
            ++i;
        }
        double dz = 1.0 / (double)nz;
        double dzend = rz / (double)nz;
        int k = 0;
        while (k < nz) {
            double theZ = (double)k * dz - 0.5;
            double theZend = (double)k * dzend - 0.5;
            int j = 0;
            while (j < ny) {
                double theY = (double)j * dy - 0.5;
                data[tile][0][2] = theZ;
                data[tile][0][1] = theY;
                data[tile][0][0] = -0.5;
                data[tile][1][2] = theZ + dz;
                data[tile][1][1] = theY;
                data[tile][1][0] = -0.5;
                data[tile][2][2] = theZ + dz;
                data[tile][2][1] = theY + dy;
                data[tile][2][0] = -0.5;
                data[tile][3][2] = theZ;
                data[tile][3][1] = theY + dy;
                data[tile][3][0] = -0.5;
                ++tile;
                if (rz != 0.0) {
                    data[tile][0][2] = theZend;
                    data[tile][0][1] = theY;
                    data[tile][0][0] = 0.5;
                    data[tile][1][2] = theZend + dzend;
                    data[tile][1][1] = theY;
                    data[tile][1][0] = 0.5;
                    data[tile][2][2] = theZend + dzend;
                    data[tile][2][1] = theY + dy;
                    data[tile][2][0] = 0.5;
                    data[tile][3][2] = theZend;
                    data[tile][3][1] = theY + dy;
                    data[tile][3][0] = 0.5;
                    ++tile;
                }
                ++j;
            }
            ++k;
        }
        return data;
    }
}

