/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.drawing2d.ControlGroup2D;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionListener;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.numerics.Matrix2DTransformation;

public abstract class ControlElement2D
extends ControlDrawable
implements InteractionListener {
    public static final int E2D_ADDED = 27;
    protected static final int POSITION_X = 0;
    protected static final int POSITION_Y = 1;
    protected static final int POSITION = 2;
    protected static final int SIZE_X = 3;
    protected static final int SIZE_Y = 4;
    protected static final int SIZE = 5;
    protected static final int SCALE_X = 6;
    protected static final int SCALE_Y = 7;
    protected static final int TRANSFORMATION = 8;
    protected static final int VISIBLE = 9;
    protected static final int LINE_COLOR = 10;
    protected static final int LINE_WIDTH = 11;
    protected static final int FILL_COLOR = 12;
    protected static final int DRAWING_FILL = 13;
    protected static final int DRAWING_LINES = 14;
    protected static final int ENABLED_POSITION = 15;
    protected static final int MOVES_GROUP = 16;
    protected static final int ENABLED_SIZE = 17;
    protected static final int RESIZES_GROUP = 18;
    protected static final int SENSITIVITY = 19;
    protected static final int PRESS_ACTION = 20;
    protected static final int DRAG_ACTION = 21;
    protected static final int RELEASE_ACTION = 22;
    protected static final int ENTERED_ACTION = 23;
    protected static final int EXITED_ACTION = 24;
    protected static final int MEASURED = 25;
    protected static final int EXTRA_COLOR = 26;
    public static final Color NULL_COLOR = ConstantParserUtil.NULL_COLOR;
    public static final double TO_RADIANS = Math.PI / 180;
    protected DoubleValue[] posValues;
    protected DoubleValue[] sizeValues;
    protected double defaultX;
    protected double defaultY;
    protected double defaultSizeX;
    protected double defaultSizeY;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double lineWidth = 1.0;
    protected Color defLines;
    protected Color defExtraColor;
    protected Paint defFill;
    protected double[] thePos;
    protected double[] theSize;
    private Element myElement = (Element)this.getDrawable();
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private static List<String> infoList = null;

    public ControlElement2D() {
        DoubleValue[] doubleValueArray = new DoubleValue[2];
        this.defaultX = this.myElement.getX();
        doubleValueArray[0] = new DoubleValue(this.defaultX);
        this.defaultY = this.myElement.getY();
        doubleValueArray[1] = new DoubleValue(this.defaultY);
        this.posValues = doubleValueArray;
        DoubleValue[] doubleValueArray2 = new DoubleValue[2];
        this.defaultSizeX = this.myElement.getSizeX();
        doubleValueArray2[0] = new DoubleValue(this.defaultSizeX);
        this.defaultSizeY = this.myElement.getSizeY();
        doubleValueArray2[1] = new DoubleValue(this.defaultSizeY);
        this.sizeValues = doubleValueArray2;
        this.defLines = this.myElement.getStyle().getLineColor();
        this.defFill = this.myElement.getStyle().getFillColor();
        this.defExtraColor = this.myElement.getStyle().getExtraColor();
        int disp = this.getPropertiesDisplacement();
        this.posSpot = new int[]{0 + disp, 1 + disp};
        this.sizeSpot = new int[]{3 + disp, 4 + disp};
        this.fullPosition = 2 + disp;
        this.fullSize = 5 + disp;
        this.myElement.addInteractionListener(this);
        this.myElement.setDataObject(this);
    }

    protected abstract int getPropertiesDisplacement();

    @Override
    public Object getObject() {
        return this.myElement;
    }

    @Override
    public abstract String getObjectClassname();

    public final Element getElement() {
        return this.myElement;
    }

    public final int[] getPosSpot() {
        return this.posSpot;
    }

    public final int[] getSizeSpot() {
        return this.sizeSpot;
    }

    public final int getFullPositionSpot() {
        return this.fullPosition;
    }

    public final int getFullSizeSpot() {
        return this.fullSize;
    }

    @Override
    protected void setName(String _name) {
        this.myElement.setName(_name);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("x");
            infoList.add("y");
            infoList.add("position");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("size");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("transformation");
            infoList.add("visible");
            infoList.add("lineColor");
            infoList.add("lineWidth");
            infoList.add("fillColor");
            infoList.add("drawingFill");
            infoList.add("drawingLines");
            infoList.add("enabledPosition");
            infoList.add("movesGroup");
            infoList.add("enabledSize");
            infoList.add("resizesGroup");
            infoList.add("sensitivity");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("measured");
            infoList.add("extraColor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("position")) {
            return "double[]";
        }
        if (_property.equals("sizeX")) {
            return "int|double";
        }
        if (_property.equals("sizeY")) {
            return "int|double";
        }
        if (_property.equals("size")) {
            return "double[]";
        }
        if (_property.equals("scalex")) {
            return "int|double";
        }
        if (_property.equals("scaley")) {
            return "int|double";
        }
        if (_property.equals("transformation")) {
            return "AffineTransform|int|double|double[]|double[][]|Object";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("lineColor")) {
            return "int|Color|Object";
        }
        if (_property.equals("lineWidth")) {
            return "int|double";
        }
        if (_property.equals("fillColor")) {
            return "int|Color|Object";
        }
        if (_property.equals("drawingFill")) {
            return "boolean";
        }
        if (_property.equals("drawingLines")) {
            return "boolean";
        }
        if (_property.equals("enabledPosition")) {
            return "Interaction2D|int|boolean";
        }
        if (_property.equals("movesGroup")) {
            return "boolean";
        }
        if (_property.equals("enabledSize")) {
            return "Interaction2D|int|boolean";
        }
        if (_property.equals("resizesGroup")) {
            return "boolean";
        }
        if (_property.equals("sensitivity")) {
            return "int";
        }
        if (_property.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("measured")) {
            return "boolean";
        }
        if (_property.equals("extraColor")) {
            return "int|Color|Object";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.thePos = null;
                this.posValues[0].value = _value.getDouble();
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 1: {
                this.thePos = null;
                this.posValues[1].value = _value.getDouble();
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 2: {
                if (!(_value.getObject() instanceof double[])) break;
                this.thePos = (double[])_value.getObject();
                this.posValues[0].value = this.thePos[0];
                this.posValues[1].value = this.thePos[1];
                this.myElement.setXY(this.posValues[0].value, this.posValues[1].value);
                break;
            }
            case 3: {
                this.theSize = null;
                this.sizeValues[0].value = _value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.theSize = null;
                this.sizeValues[1].value = _value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                if (!(_value.getObject() instanceof double[])) break;
                this.theSize = (double[])_value.getObject();
                this.sizeValues[0].value = this.theSize[0];
                this.sizeValues[1].value = this.theSize[1];
                this.myElement.setSizeXY(this.sizeValues[0].value * this.scalex, this.sizeValues[1].value * this.scaley);
                break;
            }
            case 6: {
                this.scalex = _value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 7: {
                this.scaley = _value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 8: {
                Object transform = _value.getObject();
                if (transform instanceof AffineTransform || transform instanceof Matrix2DTransformation || transform instanceof double[] || transform instanceof double[][]) {
                    this.myElement.setTransformation(_value.getObject());
                    break;
                }
                if (_value instanceof IntegerValue) {
                    this.myElement.setTransformation(AffineTransform.getRotateInstance((double)_value.getInteger() * (Math.PI / 180)));
                    break;
                }
                if (_value instanceof DoubleValue || _value instanceof InterpretedValue) {
                    this.myElement.setTransformation(AffineTransform.getRotateInstance(_value.getDouble()));
                    break;
                }
                this.myElement.setTransformation(ControlElement2D.decodeAffineTransform(_value.getString()));
                break;
            }
            case 9: {
                this.myElement.setVisible(_value.getBoolean());
                break;
            }
            case 10: {
                if (_value.getObject() instanceof Color) {
                    this.myElement.getStyle().setLineColor((Color)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setLineColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth((float)_value.getDouble());
                break;
            }
            case 12: {
                if (_value.getObject() instanceof Paint) {
                    this.myElement.getStyle().setFillColor((Paint)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setFillColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            case 13: {
                this.myElement.getStyle().setDrawingFill(_value.getBoolean());
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingLines(_value.getBoolean());
                break;
            }
            case 15: {
                if (_value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(0).setEnabled(_value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(0).setEnabled(_value.getInteger());
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(_value.getBoolean());
                break;
            }
            case 17: {
                if (_value instanceof BooleanValue) {
                    this.myElement.getInteractionTarget(1).setEnabled(_value.getBoolean());
                    break;
                }
                this.myElement.getInteractionTarget(1).setEnabled(_value.getInteger());
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(_value.getBoolean());
                break;
            }
            case 19: {
                this.myElement.getStyle().setSensitivity(_value.getInteger());
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, _value.getString());
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 25: {
                this.myElement.setCanBeMeasured(_value.getBoolean());
                break;
            }
            case 26: {
                if (_value.getObject() instanceof Color) {
                    this.myElement.getStyle().setExtraColor((Color)_value.getObject());
                    break;
                }
                this.myElement.getStyle().setExtraColor(DisplayColors.getLineColor(_value.getInteger()));
                break;
            }
            default: {
                super.setValue(_index - 27, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.posValues[0].value = this.defaultX;
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 1: {
                this.posValues[1].value = this.defaultY;
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 2: {
                this.thePos = null;
                break;
            }
            case 3: {
                this.sizeValues[0].value = this.defaultSizeX;
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.sizeValues[1].value = this.defaultSizeY;
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                this.theSize = null;
                break;
            }
            case 6: {
                this.scalex = 1.0;
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 7: {
                this.scaley = 1.0;
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 8: {
                this.myElement.setTransformation(null);
                break;
            }
            case 9: {
                this.myElement.setVisible(true);
                break;
            }
            case 10: {
                this.myElement.getStyle().setLineColor(this.defLines);
                break;
            }
            case 11: {
                this.myElement.getStyle().setLineWidth(1.0f);
                break;
            }
            case 12: {
                this.myElement.getStyle().setFillColor(this.defFill);
                break;
            }
            case 13: {
                this.myElement.getStyle().setDrawingFill(true);
                break;
            }
            case 14: {
                this.myElement.getStyle().setDrawingLines(true);
                break;
            }
            case 15: {
                this.myElement.getInteractionTarget(0).setEnabled(false);
                break;
            }
            case 16: {
                this.myElement.getInteractionTarget(0).setAffectsGroup(false);
                break;
            }
            case 17: {
                this.myElement.getInteractionTarget(1).setEnabled(false);
                break;
            }
            case 18: {
                this.myElement.getInteractionTarget(1).setAffectsGroup(false);
                break;
            }
            case 19: {
                this.myElement.getStyle().setSensitivity(5);
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 25: {
                this.myElement.setCanBeMeasured(true);
                break;
            }
            case 26: {
                this.myElement.getStyle().setExtraColor(this.defExtraColor);
                break;
            }
            default: {
                super.setDefaultValue(_index - 27);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return Double.toString(this.defaultX);
            }
            case 1: {
                return Double.toString(this.defaultY);
            }
            case 2: {
                return "<none>";
            }
            case 3: {
                return Double.toString(this.defaultSizeX);
            }
            case 4: {
                return Double.toString(this.defaultSizeY);
            }
            case 5: {
                return "<none>";
            }
            case 6: {
                return "1";
            }
            case 7: {
                return "1";
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "true";
            }
            case 10: {
                return this.defLines.toString();
            }
            case 11: {
                return "1";
            }
            case 12: {
                return this.defFill.toString();
            }
            case 13: 
            case 14: {
                return "true";
            }
            case 15: {
                return "ENABLED_NONE";
            }
            case 16: {
                return "false";
            }
            case 17: {
                return "ENABLED_NONE";
            }
            case 18: {
                return "false";
            }
            case 19: {
                return Integer.toString(5);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return "<no_action>";
            }
            case 25: {
                return "true";
            }
            case 26: {
                return this.defExtraColor.toString();
            }
        }
        return super.getDefaultValueString(_index - 27);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 2: {
                return new ObjectValue(this.thePos);
            }
            case 0: {
                return this.posValues[0];
            }
            case 1: {
                return this.posValues[1];
            }
            case 5: {
                return new ObjectValue(this.theSize);
            }
            case 3: {
                return this.sizeValues[0];
            }
            case 4: {
                return this.sizeValues[1];
            }
        }
        return super.getValue(_index - 27);
    }

    final ControlGroup2D getControlGroup() {
        if (this.myParent instanceof ControlGroup2D) {
            return (ControlGroup2D)this.myParent;
        }
        return null;
    }

    protected void propagatePosition(ControlElement2D origin) {
        this.posValues[0].value = this.myElement.getX();
        this.posValues[1].value = this.myElement.getY();
        if (this.thePos != null) {
            this.thePos[0] = this.posValues[0].value;
            this.thePos[1] = this.posValues[1].value;
            ObjectValue objVal = new ObjectValue(this.thePos);
            this.variableChanged(this.getFullPositionSpot(), objVal);
            if (this != origin) {
                origin.variableChanged(origin.getFullPositionSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.posValues);
            if (this != origin) {
                origin.variablesChanged(origin.getPosSpot(), this.posValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.posValues);
            }
        }
    }

    protected void propagateSize(ControlElement2D origin) {
        this.sizeValues[0].value = this.scalex != 0.0 ? this.myElement.getSizeX() / this.scalex : this.myElement.getSizeX();
        this.sizeValues[1].value = this.scaley != 0.0 ? this.myElement.getSizeY() / this.scaley : this.myElement.getSizeY();
        if (this.theSize != null) {
            this.theSize[0] = this.sizeValues[0].value;
            this.theSize[1] = this.sizeValues[1].value;
            ObjectValue objVal = new ObjectValue(this.theSize);
            this.variableChanged(this.getFullSizeSpot(), objVal);
            if (this != origin) {
                origin.variableChanged(origin.getFullSizeSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.sizeValues);
            if (this != origin) {
                origin.variablesChanged(origin.getSizeSpot(), this.sizeValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.sizeValues);
            }
        }
    }

    protected final void reportMouseMotion(Object _info) {
        InteractionTarget target = (InteractionTarget)_info;
        ControlGroup2D gr = this.getControlGroup();
        if (target == this.myElement.getInteractionTarget(0)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagatePosition(this);
            } else {
                this.propagatePosition(this);
            }
        } else if (target == this.myElement.getInteractionTarget(1)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagateSize(this);
            } else {
                this.propagateSize(this);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2003: {
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                break;
            }
            case 2000: {
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(_event.getInfo());
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("AffineTransform") >= 0) {
            AffineTransform transf = ControlElement2D.decodeAffineTransform(_value);
            if (transf != null) {
                return new ObjectValue(transf);
            }
        } else if (_propertyType.indexOf("ElementPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north")) {
                return new IntegerValue(1);
            }
            if (_value.equals("south")) {
                return new IntegerValue(2);
            }
            if (_value.equals("east")) {
                return new IntegerValue(3);
            }
            if (_value.equals("west")) {
                return new IntegerValue(4);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (_value.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (_propertyType.indexOf("ArrowPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
        } else if (_propertyType.indexOf("ArrowStyle") >= 0 || _propertyType.indexOf("NewArrowStyle") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("arrow")) {
                return new IntegerValue(0);
            }
            if (_value.equals("segment")) {
                return new IntegerValue(1);
            }
            if (_value.equals("box")) {
                return new IntegerValue(2);
            }
            if (_value.equals("triangle")) {
                return new IntegerValue(3);
            }
            if (_value.equals("rhombus")) {
                return new IntegerValue(4);
            }
        } else if (_propertyType.indexOf("MarkerShape") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (_value.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (_value.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (_value.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (_value.equals("none")) {
                return new IntegerValue(0);
            }
        } else if (_propertyType.indexOf("Interaction2D") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("enabled_none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("enabled_any")) {
                return new IntegerValue(1);
            }
            if (_value.equals("enabled_x")) {
                return new IntegerValue(2);
            }
            if (_value.equals("enabled_y")) {
                return new IntegerValue(3);
            }
            if (_value.equals("enabled_no_move")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public static AffineTransform createAffineTransform(String _value) {
        AffineTransform transformation = new AffineTransform();
        if (_value == null || _value.equals("null")) {
            return transformation;
        }
        if (_value.indexOf(58) < 0 && _value.indexOf(44) < 0) {
            return transformation;
        }
        StringTokenizer tokenizer = new StringTokenizer(_value, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            String keyword = token.toLowerCase();
            try {
                double sy;
                double sx;
                AffineTransform newTransf;
                String angleStr;
                if (keyword.startsWith("ro:")) {
                    angleStr = token.substring(3).trim();
                    boolean degrees = false;
                    if (angleStr.endsWith("\ufffd") || angleStr.endsWith("d")) {
                        angleStr = angleStr.substring(0, angleStr.length() - 1).trim();
                        degrees = true;
                    }
                    double angle = Double.parseDouble(angleStr);
                    if (degrees) {
                        angle *= Math.PI / 180;
                    }
                    newTransf = AffineTransform.getRotateInstance(angle);
                } else if (keyword.startsWith("sc:")) {
                    angleStr = token.substring(3).trim();
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    sx = Double.parseDouble(t.nextToken());
                    sy = Double.parseDouble(t.nextToken());
                    newTransf = AffineTransform.getScaleInstance(sx, sy);
                } else if (keyword.startsWith("sh:")) {
                    angleStr = token.substring(3).trim();
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    sx = Double.parseDouble(t.nextToken());
                    sy = Double.parseDouble(t.nextToken());
                    newTransf = AffineTransform.getShearInstance(sx, sy);
                } else if (keyword.startsWith("tr:")) {
                    angleStr = token.substring(3).trim();
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    sx = Double.parseDouble(t.nextToken());
                    sy = Double.parseDouble(t.nextToken());
                    newTransf = AffineTransform.getTranslateInstance(sx, sy);
                } else {
                    angleStr = token;
                    StringTokenizer t = new StringTokenizer(angleStr, ",");
                    double m00 = Double.parseDouble(t.nextToken());
                    double m10 = Double.parseDouble(t.nextToken());
                    double m01 = Double.parseDouble(t.nextToken());
                    double m11 = Double.parseDouble(t.nextToken());
                    double m02 = Double.parseDouble(t.nextToken());
                    double m12 = Double.parseDouble(t.nextToken());
                    newTransf = new AffineTransform(m00, m10, m01, m11, m02, m12);
                }
                newTransf.concatenate(transformation);
                transformation = newTransf;
            }
            catch (Exception exc) {
                System.out.println("Incorrect value for transformation: " + token);
                exc.printStackTrace();
            }
        }
        return transformation;
    }

    public static AffineTransform decodeAffineTransform(String _value) {
        if (_value.indexOf(34) >= 0) {
            return null;
        }
        if (_value.indexOf(37) >= 0) {
            return null;
        }
        if (_value.indexOf(123) >= 0 || _value.indexOf(125) >= 0) {
            return null;
        }
        if (_value.indexOf(58) < 0 && _value.indexOf(44) < 0) {
            return null;
        }
        return ControlElement2D.createAffineTransform(_value.trim());
    }
}

