/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FourierPanel;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class DataToolTab
extends JPanel
implements Tool,
PropertyChangeListener {
    protected static String helpName = "data_tool_help.html";
    protected static NumberFormat correlationFormat = NumberFormat.getInstance();
    protected DataTool dataTool;
    protected int originatorID = 0;
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane dataScroller;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JScrollPane tableScroller;
    protected JToolBar toolbar;
    protected JCheckBoxMenuItem statsCheckbox;
    protected JCheckBoxMenuItem fitterCheckbox;
    protected JCheckBoxMenuItem propsCheckbox;
    protected JCheckBoxMenuItem fourierCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected FourierPanel fourierPanel;
    protected JDialog fourierDialog;
    protected JButton measureButton;
    protected JButton analyzeButton;
    protected JButton dataBuilderButton;
    protected JButton newColumnButton;
    protected JButton refreshDataButton;
    protected JCheckBoxMenuItem valueCheckbox;
    protected JCheckBoxMenuItem slopeCheckbox;
    protected JCheckBoxMenuItem areaCheckbox;
    protected Action fitterAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected String ownerName;
    protected Map<String, String[]> ownedColumns = new TreeMap<String, String[]>();
    protected JButton helpButton;
    protected int colorIndex = 0;
    protected boolean tabChanged;
    protected boolean userEditable = false;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected FunctionTool dataBuilder;
    protected int fontLevel = FontSizer.getLevel();
    protected JobManager jobManager = new JobManager(this);
    protected JLabel statusLabel;
    protected JLabel editableLabel;
    protected CartesianInteractive plotAxes;
    protected boolean positionVisible = false;
    protected boolean slopeVisible = false;
    protected boolean areaVisible = false;
    protected JPopupMenu varPopup;
    protected boolean isHorzVarPopup;
    protected Action setVarAction;
    protected boolean isInitialized = false;
    protected Object[][] constantsLoadedFromXML;
    protected boolean replaceColumnsWithMatchingNames = true;

    static {
        if (correlationFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)correlationFormat;
            decimalFormat.applyPattern("0.000");
        }
    }

    public DataToolTab(Data data, DataTool dataTool) {
        String string;
        this.dataTool = dataTool;
        this.dataTable = new DataToolTable(this);
        this.createGUI();
        String string2 = ToolsRes.getString("DataToolTab.DefaultName");
        if (data != null && (string = data.getName()) != null && !string.equals("")) {
            string2 = string;
        }
        this.setName(string2);
        this.loadData(data, false);
        this.tabChanged(false);
    }

    public ArrayList<DataColumn> loadData(Data data, boolean bl) {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        if (data == null) {
            return arrayList;
        }
        ArrayList<DataColumn> arrayList2 = DataTool.getAllDataColumns(data);
        if (arrayList2 == null) {
            return arrayList;
        }
        boolean bl2 = false;
        if (this.dataManager.getDatasets().isEmpty()) {
            this.originatorID = data.getID();
            for (DataColumn dataColumn : arrayList2) {
                this.addColumn(dataColumn);
                arrayList.add(dataColumn);
            }
        } else {
            for (Dataset dataset : this.dataManager.getDatasets()) {
                Object object;
                DataColumn dataColumn = this.getIDMatch(dataset, arrayList2);
                if (dataColumn != null) {
                    object = dataset.getYColumnName();
                    String string = dataColumn.getYColumnName();
                    dataset.setXYColumnNames("row", "");
                    string = this.getUniqueYColumnName(dataColumn, string, false);
                    dataset.setXYColumnNames("row", (String)object);
                    if (!Arrays.equals(dataset.getYPoints(), dataColumn.getYPoints()) || !string.equals(object)) {
                        dataset.clear();
                        double[] dArray = DataTool.getRowArray(dataColumn.getIndex());
                        dataset.append(dArray, dataColumn.getYPoints());
                        dataset.setXYColumnNames("row", string);
                        bl2 = true;
                    }
                    arrayList2.remove(dataColumn);
                    continue;
                }
                if (!bl || (dataColumn = this.getNameMatch(dataset, arrayList2)) == null) continue;
                if (!Arrays.equals(dataset.getYPoints(), dataColumn.getYPoints())) {
                    dataset.clear();
                    object = DataTool.getRowArray(dataColumn.getIndex());
                    dataset.append((double[])object, dataColumn.getYPoints());
                    bl2 = true;
                }
                arrayList2.remove(dataColumn);
            }
            for (DataColumn dataColumn : arrayList2) {
                this.addColumn(dataColumn);
                arrayList.add(dataColumn);
            }
        }
        if (bl2 || !arrayList.isEmpty()) {
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            this.refreshPlot();
            this.refreshGUI();
            this.tabChanged(true);
            this.varPopup = null;
        }
        return arrayList;
    }

    public void addColumns(Data data, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        Dataset dataset = arrayList.isEmpty() ? null : arrayList.get(0);
        double[] dArray = object2 = dataset == null ? null : dataset.getYPoints();
        if (object2 != null) {
            while (((double[])object2).length > 0 && Double.isNaN(object2[((double[])object2).length - 1])) {
                object = new double[((double[])object2).length - 1];
                System.arraycopy(object2, 0, object, 0, ((Object)object).length);
                object2 = object;
            }
        }
        dataset = object2 == null || DataTool.containsDuplicateValues(object2) ? null : dataset;
        object = DataTool.getDataColumns(data);
        DataColumn dataColumn = null;
        if (dataset != null) {
            String string = dataset.getYColumnName();
            Iterator<DataColumn> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                int n;
                DataColumn dataColumn2 = iterator.next();
                if (dataColumn != null || !dataColumn2.getYColumnName().equals(string)) continue;
                double[] dArray2 = dataColumn2.getYPoints();
                while (dArray2.length > 0 && Double.isNaN(dArray2[dArray2.length - 1])) {
                    double[] dArray3 = new double[dArray2.length - 1];
                    System.arraycopy(dArray2, 0, dArray3, 0, dArray3.length);
                    dArray2 = dArray3;
                }
                if (DataTool.containsDuplicateValues(dArray2)) continue;
                boolean bl4 = false;
                double[] dArray4 = dArray2;
                int n2 = dArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    double d = dArray4[n3];
                    if (DataTool.getIndex(d, object2, -1) > -1) {
                        bl4 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl4) continue;
                dataColumn = dataColumn2;
                int n4 = 1;
                double d = -1.7976931348623157E308;
                Object object3 = object2;
                int n5 = ((double[])object2).length;
                int n6 = 0;
                while (n6 < n5) {
                    double d2 = object3[n6];
                    if (!(d2 > d)) {
                        n4 = -1;
                        break;
                    }
                    d = d2;
                    ++n6;
                }
                if (n4 == -1) {
                    d = Double.MAX_VALUE;
                    object3 = object2;
                    n5 = ((double[])object2).length;
                    n6 = 0;
                    while (n6 < n5) {
                        double d3 = object3[n6];
                        if (!(d3 < d)) {
                            n4 = 0;
                            break;
                        }
                        d = d3;
                        ++n6;
                    }
                }
                double[] dArray5 = new double[((double[])object2).length];
                System.arraycopy(object2, 0, dArray5, 0, ((double[])object2).length);
                dArray4 = new double[dArray2.length];
                n6 = 0;
                n5 = 0;
                while (n5 < dArray2.length) {
                    int n7 = DataTool.getIndex(dArray2[n5], object2, -1);
                    if (n7 == -1) {
                        dArray4[n6] = dArray2[n5];
                        ++n6;
                        dArray5 = DataTool.insert(dArray2[n5], dArray5, n4);
                    }
                    ++n5;
                }
                if (n6 <= 0) continue;
                double[] dArray6 = new double[n6];
                int[] nArray = new int[n6];
                int n8 = 0;
                while (n8 < n6) {
                    double d4 = dArray4[n8];
                    n = DataTool.getIndex(d4, dArray5, -1);
                    dArray6[n8] = n;
                    nArray[n8] = n;
                    ++n8;
                }
                Arrays.sort(nArray);
                double[] dArray7 = new double[n6];
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = nArray[n9];
                    n = DataTool.getIndex(n10, dArray6, -1);
                    dArray7[n9] = dArray4[n];
                    ++n9;
                }
                this.dataTable.pasteValues.clear();
                this.dataTable.pasteValues.put(string, dArray7);
                HashMap<String, double[]> hashMap = this.dataTable.insertRows(nArray, this.dataTable.pasteValues);
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(6, null, nArray, hashMap);
                this.undoSupport.postEdit(tableEdit);
                Iterator iterator2 = ((ArrayList)object).iterator();
                while (iterator2.hasNext()) {
                    DataColumn dataColumn3 = (DataColumn)iterator2.next();
                    if (dataColumn3 == dataColumn) continue;
                    double[] dArray8 = dataColumn3.getYPoints();
                    double[] dArray9 = DataTool.getRowArray(dArray5.length);
                    double[] dArray10 = new double[dArray9.length];
                    Arrays.fill(dArray10, Double.NaN);
                    int n11 = Math.min(dArray2.length, dArray8.length);
                    int n12 = 0;
                    while (n12 < n11) {
                        int n13 = DataTool.getIndex(dArray2[n12], dArray5, -1);
                        dArray10[n13] = dArray8[n12];
                        ++n12;
                    }
                    dataColumn3.clear();
                    dataColumn3.append(dArray9, dArray10);
                }
            }
        }
        ((ArrayList)object).remove(dataColumn);
        this.addColumns((ArrayList<DataColumn>)object, bl, bl2, bl3);
    }

    protected void addColumns(ArrayList<DataColumn> arrayList, boolean bl, boolean bl2, boolean bl3) {
        for (DataColumn dataColumn : arrayList) {
            int n = dataColumn.getID();
            if (bl2) {
                dataColumn.setID(-n);
            }
            ArrayList<DataColumn> arrayList2 = this.loadData(dataColumn, false);
            dataColumn.setID(n);
            if (arrayList2.isEmpty()) continue;
            for (DataColumn dataColumn2 : arrayList2) {
                dataColumn2.deletable = bl;
            }
            if (bl3) {
                int n2 = this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(1, dataColumn.getYColumnName(), new Integer(n2), dataColumn);
                this.undoSupport.postEdit(tableEdit);
            }
            this.refreshDataBuilder();
        }
        this.dataTable.refreshUndoItems();
        this.refreshGUI();
    }

    protected void addColumn(DataColumn dataColumn) {
        String string;
        String string2 = dataColumn.getYColumnName();
        if (!string2.equals(string = this.getUniqueYColumnName(dataColumn, string2, false))) {
            String string3 = dataColumn.getXColumnName();
            dataColumn.setXYColumnNames(string3, string);
        }
        if (this.dataManager.getDatasets().isEmpty()) {
            dataColumn.setMarkerColor(Color.BLACK);
            dataColumn.setLineColor(Color.BLACK);
        }
        this.dataManager.addDataset(dataColumn);
        this.dataTable.getWorkingData(string);
    }

    public void setWorkingColumns(String string, String string2) {
        this.dataTable.setWorkingColumns(string, string2);
    }

    @Override
    public void setName(String string) {
        string = this.replaceSpacesWithUnderscores(string);
        super.setName(string);
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
    }

    public void setUserEditable(boolean bl) {
        if (this.userEditable == bl) {
            return;
        }
        this.userEditable = bl;
        this.refreshGUI();
    }

    protected boolean isDeletable(Dataset dataset) {
        return dataset != null;
    }

    public FunctionTool getDataBuilder() {
        if (this.dataTool != null) {
            return this.dataTool.getDataBuilder();
        }
        if (this.dataBuilder == null) {
            this.dataBuilder = new FunctionTool(this){

                @Override
                protected void refreshGUI() {
                    super.refreshGUI();
                    this.dropdown.setToolTipText(ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip"));
                    this.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
                }
            };
            this.dataBuilder.setFontLevel(this.fontLevel);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("function", this);
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function")) {
            String string2;
            this.tabChanged(true);
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                this.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                this.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String) {
                string2 = propertyChangeEvent.getNewValue().toString();
                if (propertyChangeEvent.getOldValue() instanceof String) {
                    String string3 = propertyChangeEvent.getOldValue().toString();
                    this.columnNameChanged(string3, string2);
                } else {
                    this.dataTable.getWorkingData(string2);
                }
            }
            this.refreshPlot();
            this.varPopup = null;
        }
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            this.loadData(data, this.replaceColumnsWithMatchingNames);
            this.jobManager.associate(job, this.dataManager);
            this.refreshGUI();
        } else if (DataToolTab.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            xMLControlElement.loadObject(this);
            this.refreshGUI();
        }
    }

    public void addFitFunction(KnownFunction knownFunction, boolean bl) {
        this.curveFitter.addFitFunction(knownFunction, bl);
    }

    public void clearData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            arrayList.add(dataset.getYColumnName());
        }
        this.dataTable.setSelectedColumnNames(arrayList);
        this.dataTable.deleteSelectedColumns();
    }

    public void setReplaceColumnsWithMatchingNames(boolean bl) {
        this.replaceColumnsWithMatchingNames = bl;
    }

    protected String replaceSpacesWithUnderscores(String string) {
        string.trim();
        int n = string.indexOf(" ");
        while (n > -1) {
            string = String.valueOf(string.substring(0, n)) + "_" + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        return string;
    }

    protected void refreshDataBuilder() {
        if (this.dataTool != null) {
            this.dataTool.refreshDataBuilder();
            return;
        }
        if (this.dataBuilder == null) {
            return;
        }
        if (this.dataBuilder.getPanel(this.getName()) == null) {
            DataFunctionPanel object = new DataFunctionPanel(this.dataManager);
            this.dataBuilder.addPanel(this.getName(), object);
        }
        for (String string : this.dataBuilder.panels.keySet()) {
            if (string.equals(this.getName())) continue;
            this.dataBuilder.removePanel(string);
        }
    }

    protected void setFontLevel(int n) {
        if (this.fontLevel == n) {
            return;
        }
        this.fontLevel = n;
        this.plot.setFontLevel(n);
        FontSizer.setFonts(this.statsTable, n);
        FontSizer.setFonts(this.propsTable, n);
        this.curveFitter.setFontLevel(n);
        double d = FontSizer.getFactor(n);
        this.plot.getAxes().resizeFonts(d, this.plot);
        FontSizer.setFonts(this.plot.getPopupMenu(), n);
        if (this.propsTable.styleDialog != null) {
            FontSizer.setFonts(this.propsTable.styleDialog, n);
            this.propsTable.styleDialog.pack();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(this.fontLevel);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DataToolTab.this.fitterAction.actionPerformed(null);
                DataToolTab.this.propsAndStatsAction.actionPerformed(null);
                DataToolTab.this.propsTable.refreshTable();
                DataToolTab.this.refreshStatusBar();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void tabChanged(boolean bl) {
        this.tabChanged = bl;
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        this.dataTable.getSelectedData();
        return this.dataTable.workingData;
    }

    protected String getUniqueYColumnName(Dataset dataset, String string, boolean bl) {
        Object object;
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        string = string.replaceAll(" ", "");
        boolean bl2 = this.containsOperators(string);
        if (bl || bl2) {
            n2 = 0;
            n = 3;
            while (n2 < n) {
                ++n2;
                if (this.isDuplicateName(dataset, string)) {
                    object = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2, null, null, string);
                    String string2 = string = object == null ? null : object.toString();
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                if (this.isReservedName(string)) {
                    object = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2, null, null, string);
                    String string3 = string = object == null ? null : object.toString();
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                bl2 = this.containsOperators(string);
                if (bl2) {
                    object = JOptionPane.showInputDialog(this, ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Message"), ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Title"), 2, null, null, string);
                    String string4 = string = object == null ? null : object.toString();
                }
                if (string != null && !string.equals("")) continue;
                return null;
            }
        }
        if (bl2) {
            return null;
        }
        n2 = 0;
        try {
            Double.parseDouble(string);
            string = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        catch (NumberFormatException numberFormatException) {}
        n = 0;
        if (this.isDuplicateName(dataset, string)) {
            object = TeXParser.getSubscript(string);
            try {
                n2 = Integer.parseInt((String)object);
                string = TeXParser.removeSubscript(string);
                n = 1;
            }
            catch (Exception exception) {}
        }
        object = string;
        while (n != 0 || this.isDuplicateName(dataset, (String)object) || this.isReservedName((String)object)) {
            object = TeXParser.addSubscript(string, String.valueOf(++n2));
            n = 0;
        }
        return object;
    }

    protected boolean isDuplicateName(Dataset dataset, String string) {
        if (this.dataManager.getDatasets().isEmpty()) {
            return false;
        }
        if (this.dataManager.getDataset(0).getXColumnName().equals(string)) {
            return true;
        }
        string = TeXParser.removeSubscripting(string);
        for (Dataset dataset2 : this.dataManager.getDatasets()) {
            String string2;
            if (dataset2 == dataset || !(string2 = TeXParser.removeSubscripting(dataset2.getYColumnName())).equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isReservedName(String string) {
        String[] stringArray = FunctionTool.parserNames;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        if (DataTable.rowName.equals(string)) {
            return true;
        }
        stringArray = UserFunction.dummyVars;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected boolean containsOperators(String string) {
        String[] stringArray = FunctionTool.parserOperators;
        int n = FunctionTool.parserOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.indexOf(string2) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void columnNameChanged(String string, String string2) {
        Object object;
        this.tabChanged(true);
        this.varPopup = null;
        String string3 = this.dataTable.getFormatPattern(string);
        this.dataTable.removeWorkingData(string);
        this.dataTable.getWorkingData(string2);
        this.dataTable.setFormatPattern(string2, string3);
        if (this.propsTable.styleDialog != null && this.propsTable.styleDialog.isVisible() && this.propsTable.styleDialog.getName().equals(string)) {
            this.propsTable.styleDialog.setName(string2);
            object = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            String string4 = TeXParser.removeSubscripting(string2);
            this.propsTable.styleDialog.setTitle(String.valueOf(object) + " \"" + string4 + "\"");
        }
        this.statsTable.refreshStatistics();
        object = this.getWorkingData();
        if (object == null) {
            return;
        }
        this.refreshPlot();
    }

    protected DataColumn createDataColumn() {
        Color color = DisplayColors.getMarkerColor(this.colorIndex);
        Color color2 = DisplayColors.getLineColor(this.colorIndex);
        if (!this.dataManager.getDatasets().isEmpty()) {
            ++this.colorIndex;
        }
        DataColumn dataColumn = new DataColumn();
        dataColumn.setMarkerColor(color);
        dataColumn.setLineColor(color2);
        dataColumn.setConnected(false);
        int n = Math.max(1, this.dataTable.getRowCount());
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.NaN);
        dataColumn.setPoints(dArray);
        dataColumn.setXColumnVisible(false);
        return dataColumn;
    }

    protected String saveTableDataToFile() {
        String string = this.getName();
        OSPLog.finest("saving tabe data from " + string);
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        jFileChooser.setSelectedFile(new File(String.valueOf(string) + ".txt"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            string2 = XML.getRelativePath(string2);
            String string3 = this.getSelectedTableData();
            return DataTool.write(string3, string2);
        }
        return null;
    }

    protected void copyTableDataToClipboard() {
        OSPLog.finest("copying table data from " + this.getName());
        DataTool.copy(this.getSelectedTableData());
    }

    protected String getSelectedTableData() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName() != null) {
            stringBuffer.append(String.valueOf(this.getName()) + "\n");
        }
        if (this.dataTable.getColumnCount() == 1 || this.dataTable.getRowCount() == 0) {
            return stringBuffer.toString();
        }
        this.dataTable.clearSelectionIfEmptyEndRow();
        int[] nArray = this.dataTable.getSelectedRows();
        if (nArray.length == 0) {
            this.dataTable.selectAll();
            nArray = this.dataTable.getSelectedRows();
        }
        int[] nArray2 = this.dataTable.getSelectedColumns();
        int n3 = 0;
        while (n3 < nArray2.length) {
            n2 = nArray2[n3];
            n = this.dataTable.convertColumnIndexToModel(n2);
            if (!this.dataTable.isRowNumberVisible() || n != 0) {
                stringBuffer.append(this.dataTable.getColumnName(n2));
                stringBuffer.append("\t");
            }
            ++n3;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append("\n");
        DateFormat dateFormat = DateFormat.getInstance();
        n2 = 0;
        while (n2 < nArray.length) {
            n = 0;
            while (n < nArray2.length) {
                int n4 = nArray2[n];
                int n5 = this.dataTable.convertColumnIndexToModel(n4);
                if (!this.dataTable.isRowNumberVisible() || n5 != 0) {
                    Object object = this.dataTable.getValueAt(nArray[n2], n4);
                    if (object != null) {
                        if (object instanceof Date) {
                            object = dateFormat.format(object);
                        }
                        stringBuffer.append(object);
                    }
                    stringBuffer.append("\t");
                }
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataToolTab.this.refreshGUI();
            }
        });
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = DataToolTab.this.dataTable.getMinimumTableWidth() + 6;
                JScrollBar jScrollBar = DataToolTab.this.dataScroller.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    dimension.width += jScrollBar.getWidth();
                }
                dimension.height = 10;
                return dimension;
            }
        };
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                OSPLog.getOSPLog();
                if (DataToolTab.this.getSize().width > 0) {
                    DataToolTab.this.init();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab.this.fitterAction.actionPerformed(null);
            }
        });
        this.dataTool.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                DataToolTab.this.fitterAction.actionPerformed(null);
            }
        });
        this.dataTable.setRowNumberVisible(true);
        this.dataScroller = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataScroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DataToolTab.this.dataTable.clearSelection();
            }
        });
        this.dataScroller.setToolTipText(ToolsRes.getString("DataToolTab.Scroller.Tooltip"));
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                DataToolTable.WorkingDataset workingDataset2 = DataToolTab.this.getWorkingData();
                if (workingDataset2 != workingDataset && DataToolTab.this.dataTool.fitBuilder != null) {
                    DataToolTab.this.tabChanged(true);
                }
                if (workingDataset2 == null || workingDataset2 == workingDataset) {
                    return;
                }
                DataToolTab.this.plot.selectionBox.setSize(0, 0);
                DataToolTab.this.refreshPlot();
            }
        });
        this.fitterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.fitterCheckbox == null) {
                    return;
                }
                DataToolTab.this.splitPanes[1].remove(DataToolTab.this.curveFitter);
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean bl = DataToolTab.this.fitterCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(bl);
                DataToolTab.this.curveFitter.setActive(bl);
                if (bl) {
                    DataToolTab.this.splitPanes[1].setBottomComponent(DataToolTab.this.curveFitter);
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(-1);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                if (actionEvent != null) {
                    DataToolTab.this.refreshPlot();
                }
            }
        };
        this.fitterCheckbox = new JCheckBoxMenuItem();
        this.fitterCheckbox.setSelected(false);
        this.fitterCheckbox.addActionListener(this.fitterAction);
        this.fourierCheckbox = new JCheckBoxMenuItem();
        this.fourierCheckbox.setSelected(false);
        this.fourierCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.fourierPanel == null && DataToolTab.this.dataTool != null) {
                    DataToolTab.this.fourierPanel = new FourierPanel();
                    DataToolTab.this.fourierDialog = new JDialog(DataToolTab.this.dataTool, false){

                        @Override
                        public void setVisible(boolean bl) {
                            super.setVisible(bl);
                            (this).DataToolTab.this.fourierCheckbox.setSelected(bl);
                        }
                    };
                    DataToolTab.this.fourierDialog.setContentPane(DataToolTab.this.fourierPanel);
                    Dimension dimension = new Dimension(640, 400);
                    DataToolTab.this.fourierDialog.setSize(dimension);
                    DataToolTab.this.fourierPanel.splitPane.setDividerLocation(dimension.width / 2);
                    DataToolTab.this.fourierPanel.refreshFourierData(DataToolTab.this.dataTable.getSelectedData(), DataToolTab.this.getName());
                    DataToolTab.this.fourierDialog.setLocationRelativeTo(DataToolTab.this.dataTool);
                }
                DataToolTab.this.fourierDialog.setVisible(DataToolTab.this.fourierCheckbox.isSelected());
            }
        });
        this.newColumnButton = DataTool.createButton("");
        this.newColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                Object object;
                Object object2;
                DataColumn dataColumn = DataToolTab.this.createDataColumn();
                String string = ToolsRes.getString("DataToolTab.NewColumn.Name");
                string = DataToolTab.this.getUniqueYColumnName(dataColumn, string, false);
                Object object3 = JOptionPane.showInputDialog(DataToolTab.this, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, null, null, string);
                if (object3 == null) {
                    return;
                }
                String string2 = DataToolTab.this.getUniqueYColumnName(dataColumn, object3.toString(), true);
                if (string2 == null) {
                    return;
                }
                if (string2.equals("")) {
                    object2 = ToolsRes.getString("DataToolTab.NewColumn.Name");
                    string2 = DataToolTab.this.getUniqueYColumnName(dataColumn, (String)object2, false);
                }
                OSPLog.finer("adding new column \"" + string2 + "\"");
                dataColumn.setXYColumnNames("row", string2);
                object2 = DataToolTab.this.loadData(dataColumn, false);
                if (!((ArrayList)object2).isEmpty()) {
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        DataColumn dataColumn2 = (DataColumn)object.next();
                        dataColumn2.deletable = true;
                    }
                }
                int n = DataToolTab.this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = DataToolTab.this.dataTable;
                dataToolTable.getClass();
                object = dataToolTable.new DataToolTable.TableEdit(1, string2, new Integer(n), dataColumn);
                DataToolTab.this.undoSupport.postEdit((UndoableEdit)object);
                DataToolTab.this.dataTable.refreshUndoItems();
                Runnable runnable = new Runnable(){

                    @Override
                    public synchronized void run() {
                        int n = (this).DataToolTab.this.dataTable.getColumnCount() - 1;
                        (this).DataToolTab.this.dataTable.changeSelection(0, n, false, false);
                        (this).DataToolTab.this.dataTable.editCellAt(0, n, actionEvent);
                        (this).DataToolTab.this.dataTable.editor.field.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.getDataBuilder().setSelectedPanel(DataToolTab.this.getName());
                DataToolTab.this.getDataBuilder().setVisible(true);
            }
        });
        this.refreshDataButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.refreshDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.refreshData();
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataTool.showHelp(DataTool.helpName);
                } else {
                    DataTool.showHelp(helpName);
                }
            }
        });
        this.valueCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Position"));
        this.valueCheckbox.setSelected(false);
        this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
        this.valueCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.positionVisible = DataToolTab.this.valueCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.slopeCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
        this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
        this.slopeCheckbox.setSelected(false);
        this.slopeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.slopeVisible = DataToolTab.this.slopeCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.areaCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Area"));
        this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
        this.areaCheckbox.setSelected(false);
        this.areaCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.plot.setAreaVisible(DataToolTab.this.areaCheckbox.isSelected());
            }
        });
        this.measureButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Measure.Label"));
        this.measureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(DataToolTab.this.valueCheckbox);
                jPopupMenu.add(DataToolTab.this.slopeCheckbox);
                jPopupMenu.add(DataToolTab.this.areaCheckbox);
                jPopupMenu.show(DataToolTab.this.measureButton, 0, DataToolTab.this.measureButton.getHeight());
            }
        });
        this.analyzeButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Analyze.Label"));
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(DataToolTab.this.statsCheckbox);
                jPopupMenu.add(DataToolTab.this.fitterCheckbox);
                jPopupMenu.add(DataToolTab.this.fourierCheckbox);
                jPopupMenu.show(DataToolTab.this.analyzeButton, 0, DataToolTab.this.analyzeButton.getHeight());
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = DataToolTab.this.statsCheckbox.isSelected();
                boolean bl2 = DataToolTab.this.propsCheckbox.isSelected();
                if (bl) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                DataToolTab.this.refreshStatusBar();
                int n2 = DataToolTab.this.statsTable.getPreferredSize().height;
                int n3 = DataToolTab.this.propsTable.getPreferredSize().height;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                int n4 = n = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1 ? 8 : 4;
                if (bl && bl2) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n3 + 2 * n);
                } else if (bl) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n);
                } else if (bl2) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n3 + n);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBoxMenuItem(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        this.plot = new DataToolPlotter(this.getWorkingData());
        this.plotAxes = new DataToolAxes(this.plot);
        this.plot.setAxes(this.plotAxes);
        if (this.getWorkingData() != null) {
            this.plot.addDrawable(this.getWorkingData());
            this.plot.setTitle(this.getWorkingData().getName());
        }
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Set<Integer> rowsInside = new HashSet<Integer>();
            Set<Integer> recent = new HashSet<Integer>();
            boolean boxActive;
            Interactive ia;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.ia = DataToolTab.this.plot.getInteractive();
                if (this.ia instanceof HighlightableDataset) {
                    HighlightableDataset highlightableDataset = (HighlightableDataset)this.ia;
                    int n = highlightableDataset.getHitIndex();
                    ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                    int n2 = DataToolTab.this.dataTable.getXColumn();
                    listSelectionModel.setSelectionInterval(n2, n2);
                    n2 = DataToolTab.this.dataTable.getYColumn();
                    listSelectionModel.addSelectionInterval(n2, n2);
                    TableModel tableModel = DataToolTab.this.dataTable.getModel();
                    int n3 = 1;
                    while (n3 < tableModel.getColumnCount()) {
                        if (highlightableDataset.getYColumnName().equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                            listSelectionModel.addSelectionInterval(n3, n3);
                            if (n2 != n3) {
                                highlightableDataset.setHighlightColor(highlightableDataset.getFillColor());
                            }
                            highlightableDataset.setHighlighted(n, true);
                            break;
                        }
                        ++n3;
                    }
                    if (!mouseEvent.isControlDown()) {
                        DataToolTab.this.dataTable.setSelectedModelRows(new int[]{n});
                    } else {
                        int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                        boolean bl = true;
                        int[] nArray2 = nArray;
                        int n4 = nArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = nArray2[n5];
                            if (n6 == n) {
                                bl = false;
                            }
                            ++n5;
                        }
                        int[] nArray3 = new int[bl ? nArray.length + 1 : nArray.length - 1];
                        if (bl) {
                            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                            nArray3[nArray.length] = n;
                        } else {
                            n5 = 0;
                            int[] nArray4 = nArray;
                            int n7 = nArray.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                n4 = nArray4[n8];
                                if (n4 != n) {
                                    nArray3[n5] = n4;
                                    ++n5;
                                }
                                ++n8;
                            }
                        }
                        DataToolTab.this.dataTable.setSelectedModelRows(nArray3);
                    }
                    DataToolTab.this.dataTable.getSelectedData();
                    DataToolTab.this.plot.repaint();
                    this.boxActive = false;
                    return;
                }
                if (this.ia != null) {
                    this.boxActive = false;
                    return;
                }
                boolean bl = this.boxActive = !OSPRuntime.isPopupTrigger(mouseEvent);
                if (this.boxActive) {
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        DataToolTab.this.dataTable.clearSelection();
                    }
                    this.rowsInside.clear();
                    int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                    int n = nArray.length;
                    int n9 = 0;
                    while (n9 < n) {
                        int n10 = nArray[n9];
                        this.rowsInside.add(new Integer(n10));
                        ++n9;
                    }
                    this.recent.clear();
                    Point point = mouseEvent.getPoint();
                    DataToolTab.this.plot.selectionBox.xstart = point.x;
                    DataToolTab.this.plot.selectionBox.ystart = point.y;
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.boxActive) {
                    return;
                }
                HighlightableDataset highlightableDataset = DataToolTab.this.getWorkingData();
                if (highlightableDataset == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                DataToolTab.this.plot.selectionBox.visible = true;
                DataToolTab.this.plot.selectionBox.setSize(point.x - DataToolTab.this.plot.selectionBox.xstart, point.y - DataToolTab.this.plot.selectionBox.ystart);
                double[] dArray = highlightableDataset.getXPoints();
                double[] dArray2 = highlightableDataset.getYPoints();
                int n = 0;
                while (n < dArray.length) {
                    double d = DataToolTab.this.plot.xToPix(dArray[n]);
                    double d2 = DataToolTab.this.plot.yToPix(dArray2[n]);
                    Integer n2 = DataToolTab.this.dataTable.workingRows.get(new Integer(n));
                    int n3 = n2;
                    if (DataToolTab.this.plot.selectionBox.contains(d, d2)) {
                        if (!this.rowsInside.contains(n2) && !this.recent.contains(n2)) {
                            if (this.rowsInside.isEmpty()) {
                                ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                                int n4 = DataToolTab.this.dataTable.getXColumn();
                                listSelectionModel.setSelectionInterval(n4, n4);
                                n4 = DataToolTab.this.dataTable.getYColumn();
                                listSelectionModel.addSelectionInterval(n4, n4);
                            }
                            this.rowsInside.add(n2);
                            this.recent.add(n2);
                            DataToolTab.this.dataTable.getSelectionModel().addSelectionInterval(n3, n3);
                        }
                    } else if (this.rowsInside.contains(n2) && this.recent.contains(n2)) {
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        this.rowsInside.remove(n2);
                        this.recent.remove(n2);
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        if (this.rowsInside.isEmpty()) {
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().removeSelectionInterval(0, DataToolTab.this.dataTable.getColumnCount() - 1);
                        }
                    }
                    ++n;
                }
                highlightableDataset = DataToolTab.this.dataTable.getSelectedData();
                DataToolTab.this.plot.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataToolTab.this.plot.selectionBox.visible = false;
                if (this.ia != null) {
                    if (this.ia instanceof Selectable) {
                        DataToolTab.this.plot.setMouseCursor(((Selectable)this.ia).getPreferredCursor());
                    } else {
                        DataToolTab.this.plot.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                    if (this.ia instanceof HighlightableDataset) {
                        HighlightableDataset highlightableDataset = (HighlightableDataset)this.ia;
                        TableModel tableModel = DataToolTab.this.dataTable.getModel();
                        int n = DataToolTab.this.dataTable.getYColumn();
                        int n2 = 1;
                        while (n2 < tableModel.getColumnCount()) {
                            if (highlightableDataset.getYColumnName().equals(DataToolTab.this.dataTable.getColumnName(n2)) && n != n2) {
                                highlightableDataset.clearHighlights();
                                highlightableDataset.setHighlightColor(Color.YELLOW);
                                ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                                listSelectionModel.removeSelectionInterval(n2, n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                DataToolTab.this.plot.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                HighlightableDataset highlightableDataset = DataToolTab.this.dataTable.workingData;
                this.ia = DataToolTab.this.plot.getInteractive();
                if (this.ia instanceof HighlightableDataset) {
                    highlightableDataset = (HighlightableDataset)this.ia;
                }
                if (highlightableDataset != null) {
                    DataToolTab.this.plot.setCoordinateLabels(highlightableDataset.getXColumnName(), highlightableDataset.getYColumnName());
                }
                DataToolTab.this.plot.value = Double.NaN;
                DataToolTab.this.plot.slope = Double.NaN;
                double[] dArray = null;
                double[] dArray2 = null;
                int n = -1;
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    if (highlightableDataset == null) {
                        return;
                    }
                    if (highlightableDataset.getIndex() > 0) {
                        double d = DataToolTab.this.plot.pixToX(mouseEvent.getX());
                        n = DataToolTab.this.plot.findIndexNearestX(d, highlightableDataset);
                    }
                    dArray = highlightableDataset.getXPoints();
                    dArray2 = highlightableDataset.getYPoints();
                }
                if (DataToolTab.this.positionVisible && n > -1) {
                    DataToolTab.this.plot.value = dArray2[n];
                    DataToolTab.this.plot.crossbars.x = dArray[n];
                    DataToolTab.this.plot.crossbars.y = dArray2[n];
                    DataToolTab.this.plot.xVar = highlightableDataset.getXColumnName();
                    DataToolTab.this.plot.yVar = highlightableDataset.getYColumnName();
                }
                if (DataToolTab.this.slopeVisible && n > 0 && n < highlightableDataset.getIndex() - 1) {
                    DataToolTab.this.plot.slopeLine.x = dArray[n];
                    DataToolTab.this.plot.slopeLine.y = dArray2[n];
                    DataToolTab.this.plot.slope = (dArray2[n + 1] - dArray2[n - 1]) / (dArray[n + 1] - dArray[n - 1]);
                }
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                }
                DataToolTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.measureButton);
        this.toolbar.add(this.analyzeButton);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.newColumnButton);
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.refreshDataButton);
        this.toolbar.add(this.helpButton);
        FitBuilder fitBuilder = this.dataTool.getFitBuilder();
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData(), fitBuilder);
        this.curveFitter.setDataToolTab(this);
        fitBuilder.curveFitters.add(this.curveFitter);
        fitBuilder.removePropertyChangeListener(this.curveFitter.fitListener);
        fitBuilder.addPropertyChangeListener(this.curveFitter.fitListener);
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("changed")) {
                    DataToolTab.this.tabChanged(true);
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("drawer") && DataToolTab.this.fitterCheckbox != null && DataToolTab.this.fitterCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    DataToolTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.statsTable.getPreferredSize();
                return dimension;
            }
        };
        this.statsScroller.setVerticalScrollBarPolicy(21);
        this.statsScroller.setHorizontalScrollBarPolicy(31);
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("display")) {
                    DataToolTab.this.refreshPlot();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.propsTable.getPreferredSize();
                return dimension;
            }
        };
        this.propsScroller.setVerticalScrollBarPolicy(21);
        this.propsScroller.setHorizontalScrollBarPolicy(31);
        this.statusLabel = new JLabel(" ", 10);
        this.statusLabel.setFont(new JTextField().getFont());
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.editableLabel = new JLabel(" ", 11);
        this.editableLabel.setFont(this.statusLabel.getFont());
        this.editableLabel.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 2));
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.statusLabel, "West");
        jPanel.add((Component)this.editableLabel, "East");
        this.add((Component)jPanel, "South");
        this.tableScroller = new JScrollPane(this.splitPanes[2]);
        this.tableScroller.setVerticalScrollBarPolicy(21);
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.tableScroller);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(this.dataScroller);
        this.splitPanes[0].setDividerLocation(0);
        this.curveFitter.splitPane.setDividerLocation(0);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
    }

    protected void refreshGUI() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = DataToolTab.this.tabChanged;
                DataToolTab.this.newColumnButton.setText(ToolsRes.getString("DataToolTab.Button.NewColumn.Text"));
                DataToolTab.this.newColumnButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.NewColumn.Tooltip"));
                DataToolTab.this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
                DataToolTab.this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
                DataToolTab.this.dataBuilderButton.setEnabled(DataToolTab.this.originatorID != 0);
                DataToolTab.this.refreshDataButton.setText(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
                DataToolTab.this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
                DataToolTab.this.measureButton.setText(ToolsRes.getString("DataToolTab.Button.Measure.Label"));
                DataToolTab.this.measureButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Measure.Tooltip"));
                DataToolTab.this.analyzeButton.setText(ToolsRes.getString("DataToolTab.Button.Analyze.Label"));
                DataToolTab.this.analyzeButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Analyze.Tooltip"));
                DataToolTab.this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
                DataToolTab.this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
                DataToolTab.this.fitterCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
                DataToolTab.this.fitterCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
                DataToolTab.this.fourierCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Fourier.Label"));
                DataToolTab.this.fourierCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Fourier.ToolTip"));
                DataToolTab.this.propsCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"));
                DataToolTab.this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
                DataToolTab.this.valueCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Position"));
                DataToolTab.this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
                DataToolTab.this.slopeCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
                DataToolTab.this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
                DataToolTab.this.areaCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Area"));
                DataToolTab.this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
                DataToolTab.this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
                DataToolTab.this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
                DataToolTab.this.toolbar.remove(DataToolTab.this.newColumnButton);
                if (DataToolTab.this.userEditable) {
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.newColumnButton, n);
                    DataToolTab.this.toolbar.validate();
                }
                DataToolTab.this.toolbar.remove(DataToolTab.this.refreshDataButton);
                Collection<Tool> collection = DataToolTab.this.jobManager.getTools(DataToolTab.this.dataManager);
                for (Tool tool : collection) {
                    if (!(tool instanceof DataRefreshTool)) continue;
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.refreshDataButton, n);
                    DataToolTab.this.toolbar.validate();
                    break;
                }
                DataToolTab.this.curveFitter.refreshGUI();
                DataToolTab.this.statsTable.refreshGUI();
                DataToolTab.this.propsTable.refreshGUI();
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshStatusBar();
                DataToolTab.this.tabChanged = bl;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        if (this.splitPanes[0].getDividerLocation() < 10) {
            this.splitPanes[0].setDividerLocation(0.7);
            this.curveFitter.splitPane.setDividerLocation(1.0);
        }
        this.splitPanes[1].setDividerLocation(1.0);
        this.propsAndStatsAction.actionPerformed(null);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            String string = this.dataTable.getColumnName(n);
            this.dataTable.getWorkingData(string);
            ++n;
        }
        this.refreshPlot();
        this.refreshGUI();
        this.isInitialized = true;
    }

    private void buildVarPopup() {
        if (this.setVarAction == null) {
            this.setVarAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getActionCommand();
                    String string2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.plot.yVar : DataToolTab.this.plot.xVar;
                    int n = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    int n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getXColumn() : DataToolTab.this.dataTable.getYColumn();
                    TableModel tableModel = DataToolTab.this.dataTable.getModel();
                    int n3 = 0;
                    while (n3 < tableModel.getColumnCount()) {
                        if (string.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                            if (n3 == n2) {
                                return;
                            }
                            DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                            break;
                        }
                        ++n3;
                    }
                    if (!string.equals(string2)) {
                        n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getYColumn() : DataToolTab.this.dataTable.getXColumn();
                        n3 = 0;
                        while (n3 < tableModel.getColumnCount()) {
                            if (string2.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                                DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                                break;
                            }
                            ++n3;
                        }
                    }
                    n2 = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    DataToolTab.this.dataTable.getColumnModel().moveColumn(n2, n);
                }
            };
        }
        this.varPopup = new JPopupMenu();
        Font font = new JTextField().getFont();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            String string = TeXParser.removeSubscripting(dataset.getYColumnName());
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(dataset.getYColumnName());
            jMenuItem.addActionListener(this.setVarAction);
            jMenuItem.setFont(font);
            this.varPopup.add(jMenuItem);
        }
    }

    private DataColumn getIDMatch(Dataset dataset, ArrayList<DataColumn> arrayList) {
        if (arrayList == null || dataset == null) {
            return null;
        }
        for (DataColumn dataColumn : arrayList) {
            if (dataset.getID() != dataColumn.getID() || dataset.getColumnID() != dataColumn.getColumnID()) continue;
            return dataColumn;
        }
        return null;
    }

    private DataColumn getNameMatch(Dataset dataset, ArrayList<DataColumn> arrayList) {
        if (arrayList == null || dataset == null) {
            return null;
        }
        for (DataColumn dataColumn : arrayList) {
            if (!dataset.getYColumnName().equals(dataColumn.getYColumnName())) continue;
            return dataColumn;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String string, double[] dArray) {
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray2 = dataset.getYPoints();
            if (!string.equals(dataset.getYColumnName()) || !this.isDuplicate(dArray, dataset.getYPoints())) continue;
            if (dArray.length > dArray2.length) {
                dataset.clear();
                dataset.append(dArray, dArray);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (!(Double.isNaN(dArray[n2]) && Double.isNaN(dArray2[n2]) || dArray[n2] == dArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isInterestedIn(Data data) {
        if (data == null) {
            return false;
        }
        if (this.isOwnedBy(data)) {
            return true;
        }
        Collection<Tool> collection = this.jobManager.getTools(this.dataManager);
        for (Tool tool : collection) {
            if (!(tool instanceof DataRefreshTool)) continue;
            DataRefreshTool dataRefreshTool = (DataRefreshTool)tool;
            if (!dataRefreshTool.moreData.contains(data)) continue;
            return true;
        }
        return false;
    }

    public boolean setOwnedColumnIDs(String string, Data data) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String object2 : this.ownedColumns.keySet()) {
            String[] stringArray = this.ownedColumns.get(object2);
            if (stringArray == null || !stringArray[0].equals(string)) continue;
            hashSet.add(object2);
        }
        Map<DataColumn, Dataset> map = this.getColumnMatchesByName(hashSet, data);
        for (Object object3 : map.keySet()) {
            Dataset dataset = map.get(object3);
            ((Dataset)object3).setID(dataset.getID());
        }
        return !map.isEmpty();
    }

    public void saveOwnedColumnNames(String string, Data data) {
        Map<DataColumn, Dataset> map = this.getColumnMatchesByID(data);
        for (DataColumn dataColumn : map.keySet()) {
            Dataset dataset = map.get(dataColumn);
            this.ownedColumns.put(dataColumn.getYColumnName(), new String[]{string, dataset.getYColumnName()});
        }
    }

    public String getColumnName(int n) {
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (dataset.getID() != n) continue;
            return dataset.getYColumnName();
        }
        return null;
    }

    public boolean isOwnedBy(Data data) {
        if (data == null) {
            return false;
        }
        String string = data.getName();
        if (string != null && this.replaceSpacesWithUnderscores(string).equals(this.getName())) {
            return true;
        }
        return data.getID() == this.originatorID;
    }

    public void setOwner(String string, Data data) {
        this.ownerName = string;
        this.originatorID = data.getID();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    protected Map<DataColumn, Dataset> getColumnMatchesByID(Data data) {
        HashMap<DataColumn, Dataset> hashMap = new HashMap<DataColumn, Dataset>();
        ArrayList<Dataset> arrayList = DataTool.getDatasets(data);
        for (Dataset dataset : this.dataManager.getDatasets()) {
            DataColumn dataColumn;
            Dataset dataset2;
            if (!(dataset instanceof DataColumn) || (dataset2 = this.getMatchByID(dataColumn = (DataColumn)dataset, arrayList)) == null) continue;
            hashMap.put(dataColumn, dataset2);
        }
        return hashMap;
    }

    protected Map<DataColumn, Dataset> getColumnMatchesByName(Set<String> set, Data data) {
        HashMap<DataColumn, Dataset> hashMap = new HashMap<DataColumn, Dataset>();
        ArrayList<Dataset> arrayList = DataTool.getDatasets(data);
        for (Dataset dataset : this.dataManager.getDatasets()) {
            Dataset dataset2;
            if (!(dataset instanceof DataColumn)) continue;
            DataColumn dataColumn = (DataColumn)dataset;
            if (set != null && !set.contains(dataColumn.getYColumnName()) || (dataset2 = this.getMatchByName(dataColumn, arrayList)) == null) continue;
            hashMap.put(dataColumn, dataset2);
        }
        return hashMap;
    }

    protected Dataset getMatchByName(DataColumn dataColumn, ArrayList<Dataset> arrayList) {
        String[] stringArray = this.ownedColumns.get(dataColumn.getYColumnName());
        if (stringArray == null) {
            return null;
        }
        String string = stringArray[1];
        int n = 0;
        while (n < arrayList.size()) {
            Dataset dataset = arrayList.get(n);
            if (dataset != null) {
                if (n == 0 && string.equals(dataset.getXColumnName())) {
                    return dataset;
                }
                if (string.equals(dataset.getYColumnName())) {
                    return dataset;
                }
            }
            ++n;
        }
        return null;
    }

    protected Dataset getMatchByID(DataColumn dataColumn, ArrayList<Dataset> arrayList) {
        for (Dataset dataset : arrayList) {
            if (dataset == null || dataColumn.getID() != dataset.getID()) continue;
            return dataset;
        }
        return null;
    }

    protected void setSelectedData(Dataset dataset) {
        this.curveFitter.setData(dataset);
        if (this.fourierPanel != null) {
            this.fourierPanel.refreshFourierData(dataset, this.getName());
        }
    }

    protected void refreshPlot() {
        this.setSelectedData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingDataset = this.getWorkingData();
        this.valueCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 0);
        if (!this.valueCheckbox.isEnabled()) {
            this.valueCheckbox.setSelected(false);
            this.positionVisible = false;
        }
        this.slopeCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 2);
        if (!this.slopeCheckbox.isEnabled()) {
            this.slopeCheckbox.setSelected(false);
            this.slopeVisible = false;
        }
        this.areaCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 1);
        if (!this.areaCheckbox.isEnabled()) {
            this.areaCheckbox.setSelected(false);
            this.areaVisible = false;
        }
        if (workingDataset != null) {
            String string;
            Object object2;
            int n = this.dataTable.convertColumnIndexToView(0);
            String string2 = this.dataTable.getColumnName(n == 0 ? 1 : 0);
            HashMap<String, DataToolTable.WorkingDataset> hashMap = this.dataTable.workingMap;
            for (Object object2 : hashMap.values()) {
                ((DataToolTable.WorkingDataset)object2).setXSource(workingDataset.getXSource());
                string = ((Dataset)object2).getYColumnName();
                if (object2 == workingDataset || string.equals(string2) || !((DataToolTable.WorkingDataset)object2).isMarkersVisible() && !((Dataset)object2).isConnected()) continue;
                ((HighlightableDataset)object2).clearHighlights();
                if (!((DataToolTable.WorkingDataset)object2).isMarkersVisible()) {
                    ((DataToolTable.WorkingDataset)object2).setMarkerShape(0);
                }
                this.plot.addDrawable((Drawable)object2);
            }
            this.plot.addDrawable(workingDataset);
            if (this.areaVisible) {
                this.plot.limits[0].x = Math.max(this.plot.limits[0].x, workingDataset.getXMin());
                this.plot.limits[0].x = Math.min(this.plot.limits[0].x, workingDataset.getXMax());
                this.plot.limits[1].x = Math.max(this.plot.limits[1].x, workingDataset.getXMin());
                this.plot.limits[1].x = Math.min(this.plot.limits[1].x, workingDataset.getXMax());
            }
            workingDataset.restoreHighlights();
            if (this.fitterCheckbox != null && this.fitterCheckbox.isSelected()) {
                this.plot.removeDrawable(this.curveFitter.getDrawer());
                this.plot.addDrawable(this.curveFitter.getDrawer());
            }
            String string3 = workingDataset.getColumnName(0);
            object2 = workingDataset.getColumnName(1);
            this.plot.setAxisLabels(string3, (String)object2);
            string = TeXParser.removeSubscripting(workingDataset.getColumnName(1));
            String string4 = TeXParser.removeSubscripting(workingDataset.getColumnName(0));
            if (this.curveFitter.fit instanceof UserFunction) {
                this.curveFitter.eqnField.setText(String.valueOf(string) + " = " + ((UserFunction)this.curveFitter.fit).getFullExpression(new String[]{string4}));
            } else {
                this.curveFitter.eqnField.setText(String.valueOf(string) + " = " + this.curveFitter.fit.getExpression(string4));
            }
        } else {
            this.plot.setXLabel("");
            this.plot.setYLabel("");
        }
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
        if (this.areaVisible) {
            this.plot.refreshArea(workingDataset);
        }
        this.repaint();
    }

    public void refreshData() {
        this.dataManager.setName(this.getName());
        this.jobManager.sendReplies(this.dataManager);
    }

    protected void refreshStatusBar() {
        if (this.statsCheckbox.isSelected()) {
            String string = ToolsRes.getString("DataToolTab.Status.Correlation");
            string = Double.isNaN(this.curveFitter.correlation) ? String.valueOf(string) + " " + ToolsRes.getString("DataToolTab.Status.Correlation.Undefined") : String.valueOf(string) + " = " + correlationFormat.format(this.curveFitter.correlation);
            this.statusLabel.setText(string);
            this.statusLabel.setFont(this.editableLabel.getFont().deriveFont(1));
        } else {
            this.statusLabel.setFont(this.editableLabel.getFont().deriveFont(0));
            if (this.dataManager.getDatasets().size() < 2) {
                this.statusLabel.setText(this.userEditable ? ToolsRes.getString("DataToolTab.StatusBar.Text.CreateColumns") : ToolsRes.getString("DataToolTab.StatusBar.Text.PasteColumns"));
            } else {
                this.statusLabel.setText(ToolsRes.getString("DataToolTab.StatusBar.Text.DragColumns"));
            }
        }
        this.editableLabel.setText(this.userEditable ? ToolsRes.getString("DataTool.MenuItem.Editable").toLowerCase() : ToolsRes.getString("DataTool.MenuItem.Noneditable").toLowerCase());
        this.editableLabel.setForeground(this.userEditable ? Color.GREEN.darker() : Color.RED.darker());
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataToolAxes
    extends CartesianInteractive {
        DataToolAxes(PlottingPanel plottingPanel) {
            super(plottingPanel);
        }

        @Override
        protected boolean hasHorzVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        @Override
        protected JPopupMenu getHorzVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = true;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.xLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }

        @Override
        protected boolean hasVertVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        @Override
        protected JPopupMenu getVertVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = false;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.yLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }
    }

    class DataToolPlotter
    extends PlottingPanel {
        SelectionBox selectionBox;
        Crossbars crossbars;
        SlopeLine slopeLine;
        Dataset areaDataset;
        LimitLine[] limits;
        double value;
        double slope;
        double area;
        DecimalFormat sciFormat;
        DecimalFormat fixedFormat;
        String xVar;
        String yVar;
        String message;

        DataToolPlotter(Dataset dataset) {
            super(dataset == null ? "x" : dataset.getColumnName(0), dataset == null ? "y" : dataset.getColumnName(1), "");
            this.limits = new LimitLine[2];
            this.value = Double.NaN;
            this.slope = Double.NaN;
            this.sciFormat = new DecimalFormat("0.00E0");
            this.fixedFormat = new DecimalFormat("0.00");
            this.setAntialiasShapeOn(true);
            this.selectionBox = new SelectionBox();
            this.crossbars = new Crossbars();
            this.slopeLine = new SlopeLine();
            this.limits[0] = new LimitLine();
            this.limits[1] = new LimitLine();
            this.addDrawable(this.limits[0]);
            this.addDrawable(this.limits[1]);
            this.addDrawable(this.selectionBox);
        }

        @Override
        protected void paintDrawableList(Graphics graphics, ArrayList<Drawable> arrayList) {
            super.paintDrawableList(graphics, arrayList);
            if (arrayList.contains(DataToolTab.this.curveFitter.getDrawer())) {
                double[] dArray = DataToolTab.this.curveFitter.getDrawer().getYRange();
                if (dArray[0] >= this.getYMax() || dArray[1] <= this.getYMin()) {
                    String string = ToolsRes.getString("DataToolTab.Plot.Message.FitNotVisible");
                    if (this.message != null && !"".equals(this.message)) {
                        string = String.valueOf(string) + "  " + this.message;
                    }
                    this.setMessage(string);
                } else {
                    this.setMessage(this.message);
                }
            } else {
                this.setMessage(this.message);
            }
            this.slopeLine.draw(graphics);
            this.crossbars.draw(graphics);
        }

        void setAreaVisible(boolean bl) {
            DataToolTab.this.areaVisible = bl;
            if (this.areaDataset == null) {
                this.areaDataset = new Dataset();
                this.areaDataset.setMarkerShape(5);
                this.areaDataset.setConnected(false);
                this.areaDataset.setMarkerColor(new Color(102, 102, 102, 51));
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    this.limits[0].x = workingDataset.getXMin();
                    this.limits[1].x = workingDataset.getXMax();
                }
            }
            DataToolTab.this.refreshPlot();
            this.setMessage(this.createMessage());
        }

        void refreshArea(Dataset dataset) {
            if (!DataToolTab.this.areaVisible) {
                return;
            }
            this.area = 0.0;
            if (dataset == null) {
                DataToolTab.this.areaVisible = false;
                this.setMessage(this.createMessage());
                return;
            }
            double[] dArray = dataset.getXPoints();
            double[] dArray2 = dataset.getYPoints();
            this.areaDataset.clear();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n = 0;
            while (n < dArray.length) {
                double d = Math.min(this.limits[0].x, this.limits[1].x);
                double d2 = Math.max(this.limits[0].x, this.limits[1].x);
                if (dArray[n] >= d && dArray[n] <= d2) {
                    arrayList.add(new Double(dArray[n]));
                    arrayList2.add(new Double(dArray2[n]));
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                dArray = new double[arrayList.size()];
                dArray2 = new double[arrayList.size()];
                n = 0;
                while (n < dArray.length) {
                    dArray[n] = (Double)arrayList.get(n);
                    dArray2[n] = (Double)arrayList2.get(n);
                    ++n;
                }
                this.areaDataset.append(dArray[0], 0.0);
                this.areaDataset.append(dArray, dArray2);
                this.areaDataset.append(dArray[dArray.length - 1], 0.0);
                n = dArray.length;
                if (n > 1) {
                    DataToolTab.this.plot.addDrawable(this.areaDataset);
                    this.area = dArray2[0] * (dArray[1] - dArray[0]);
                    this.area += dArray2[n - 1] * (dArray[n - 1] - dArray[n - 2]);
                    int n2 = 1;
                    while (n2 < n - 1) {
                        this.area += dArray2[n2] * (dArray[n2 + 1] - dArray[n2 - 1]);
                        ++n2;
                    }
                    this.area /= 2.0;
                }
            }
            this.setMessage(this.createMessage());
        }

        protected int findIndexNearestX(double d, Dataset dataset) {
            if (dataset == null) {
                return -1;
            }
            int n = dataset.getIndex() - 1;
            if (n == -1) {
                return -1;
            }
            d = Math.max(DataToolTab.this.plot.getXMin(), d);
            d = Math.min(DataToolTab.this.plot.getXMax(), d);
            double[] dArray = dataset.getXPoints();
            Arrays.sort(dArray);
            if (d < dArray[0]) {
                return 0;
            }
            if (d >= dArray[n]) {
                return n;
            }
            int n2 = 1;
            while (n2 < dArray.length) {
                if (d >= dArray[n2 - 1] && d < dArray[n2]) {
                    d = dArray[n2 - 1] < DataToolTab.this.plot.getXMin() ? dArray[n2] : (dArray[n2] > DataToolTab.this.plot.getXMax() ? dArray[n2 - 1] : (Math.abs(d - dArray[n2 - 1]) < Math.abs(d - dArray[n2]) ? dArray[n2 - 1] : dArray[n2]));
                    double[] dArray2 = dataset.getXPoints();
                    int n3 = 0;
                    while (n3 < dArray2.length) {
                        if (dArray2[n3] == d) {
                            return n3;
                        }
                        ++n3;
                    }
                    return -1;
                }
                ++n2;
            }
            return -1;
        }

        String createMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            if (DataToolTab.this.positionVisible && !Double.isNaN(this.value)) {
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.xVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.x, this.getXMax() - this.getXMin()));
                stringBuffer.append("  ");
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.yVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.y, this.getYMax() - this.getYMin()));
            }
            if (DataToolTab.this.slopeVisible && !Double.isNaN(this.slope)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Slope"));
                stringBuffer.append(this.format(DataToolTab.this.plot.slope, 0.0));
            }
            if (DataToolTab.this.areaVisible) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Area"));
                stringBuffer.append(this.format(DataToolTab.this.plot.area, 0.0));
            }
            this.message = stringBuffer.toString();
            return this.message;
        }

        String format(double d, double d2) {
            double d3 = Math.min(1.0, d2) / 1000.0;
            if (Math.abs(d) < d3) {
                d = 0.0;
            }
            if (d2 < 1.0 && d != 0.0) {
                return this.sciFormat.format(d);
            }
            return Math.abs(d) <= 10.0 ? this.fixedFormat.format(d) : this.sciFormat.format(d);
        }

        void setAxisLabels(String string, String string2) {
            this.setXLabel(string);
            this.setYLabel(string2);
            this.xVar = TeXParser.removeSubscripting(string);
            this.yVar = TeXParser.removeSubscripting(string2);
            String string3 = String.valueOf(this.xVar) + "=";
            String string4 = "  " + this.yVar + "=";
            this.coordinateStrBuilder.setCoordinateLabels(string3, string4);
        }

        void setCoordinateLabels(String string, String string2) {
            string = TeXParser.removeSubscripting(string);
            string2 = TeXParser.removeSubscripting(string2);
            String string3 = String.valueOf(string) + "=";
            String string4 = "  " + string2 + "=";
            this.coordinateStrBuilder.setCoordinateLabels(string3, string4);
        }

        @Override
        protected void setFontLevel(int n) {
            super.setFontLevel(n);
        }

        class Crossbars {
            double x;
            double y;
            Color color = new Color(0, 0, 0);

            Crossbars() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.positionVisible || Double.isNaN(DataToolPlotter.this.value)) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                graphics.drawLine(DataToolPlotter.this.getLeftGutter(), DataToolPlotter.this.yToPix(this.y), DataToolPlotter.this.getWidth() - DataToolPlotter.this.getRightGutter() - 1, DataToolPlotter.this.yToPix(this.y));
                graphics.drawLine(DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getTopGutter(), DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getHeight() - DataToolPlotter.this.getBottomGutter() - 1);
                graphics.setColor(color);
            }
        }

        class LimitLine
        extends Line2D.Double
        implements Selectable {
            double x;
            Stroke stroke = new BasicStroke(1.0f);
            Rectangle hitRect = new Rectangle();
            Color color = new Color(51, 51, 51);
            Cursor move;

            LimitLine() {
            }

            @Override
            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                int n = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter();
                int n2 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().height - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                int n3 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(this.x);
                this.setLine(n3 + 1, n, n3 + 1, n2);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
                this.hitRect.setBounds(n3 - 2, n, 6, n2 - n - 20);
            }

            @Override
            public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible && this.hitRect.contains(n, n2)) {
                    return this;
                }
                return null;
            }

            @Override
            public Cursor getPreferredCursor() {
                if (this.move == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/limitcursor.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Move Integration Limit");
                }
                return this.move;
            }

            @Override
            public void setXY(double d, double d2) {
                this.setX(d);
            }

            @Override
            public void setX(double d) {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                int n = DataToolPlotter.this.findIndexNearestX(d, workingDataset);
                this.x = n == -1 ? d : workingDataset.getXPoints()[n];
                DataToolPlotter.this.refreshArea(workingDataset);
                DataToolPlotter.this.createMessage();
                ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMessage(DataToolPlotter.this.message);
            }

            @Override
            public boolean isMeasured() {
                return ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible;
            }

            @Override
            public double getXMin() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.min(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.min(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 - 0.02 * d;
            }

            @Override
            public double getXMax() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.max(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.max(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 + 0.02 * d;
            }

            @Override
            public double getYMin() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            @Override
            public double getYMax() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            @Override
            public void setY(double d) {
            }

            @Override
            public double getX() {
                return this.x;
            }

            @Override
            public double getY() {
                return 0.0;
            }

            @Override
            public void setSelected(boolean bl) {
            }

            @Override
            public boolean isSelected() {
                return false;
            }

            @Override
            public void toggleSelected() {
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void setEnabled(boolean bl) {
            }
        }

        class SelectionBox
        extends Rectangle
        implements Drawable {
            boolean visible = true;
            int xstart;
            int ystart;
            Color color = new Color(0, 255, 0, 127);

            SelectionBox() {
            }

            @Override
            public void setSize(int n, int n2) {
                int n3 = Math.min(0, n);
                int n4 = Math.min(0, n2);
                n = Math.abs(n);
                n2 = Math.abs(n2);
                super.setLocation(this.xstart + n3, this.ystart + n4);
                super.setSize(n, n2);
            }

            @Override
            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (this.visible) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(this.color);
                    graphics2D.draw(this);
                }
            }
        }

        class SlopeLine
        extends Line2D.Double {
            double x;
            double y;
            Stroke stroke = new BasicStroke(1.5f);
            int length = 30;
            Color color = new Color(0, 0, 0);

            SlopeLine() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.slopeVisible || Double.isNaN(DataToolPlotter.this.slope)) {
                    return;
                }
                double d = 1.0 * DataToolPlotter.this.getXPixPerUnit();
                double d2 = DataToolPlotter.this.slope * DataToolPlotter.this.getYPixPerUnit();
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d2 / d3;
                double d5 = d / d3;
                int n = DataToolPlotter.this.xToPix(this.x);
                int n2 = DataToolPlotter.this.yToPix(this.y);
                this.setLine((double)n - (double)this.length * d5 + 1.0, (double)n2 + (double)this.length * d4 + 1.0, (double)n + (double)this.length * d5 + 1.0, (double)n2 - (double)this.length * d4 + 1.0);
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            Object[] objectArray;
            Object object3;
            DataToolTab dataToolTab = (DataToolTab)object;
            xMLControl.setValue("name", dataToolTab.getName());
            xMLControl.setValue("owner_name", dataToolTab.getOwnerName());
            if (!dataToolTab.ownedColumns.isEmpty()) {
                object3 = new String[dataToolTab.ownedColumns.size()][3];
                int n = 0;
                for (String string : dataToolTab.ownedColumns.keySet()) {
                    objectArray = dataToolTab.ownedColumns.get(string);
                    object3[n] = new String[]{string, objectArray[0], objectArray[1]};
                    ++n;
                }
                xMLControl.setValue("owned_columns", object3);
            }
            xMLControl.setValue("editable", dataToolTab.userEditable);
            object3 = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset dataset : dataToolTab.dataManager.getDatasets()) {
                if (dataset instanceof DataFunction) {
                    arrayList.add(dataset);
                    continue;
                }
                ((DatasetManager)object3).addDataset(dataset);
            }
            xMLControl.setValue("data", object3);
            String[] stringArray2 = dataToolTab.dataManager.getConstantNames();
            if (stringArray2.length > 0) {
                Object[][] objectArray2 = new Object[stringArray2.length][3];
                int n = 0;
                String[] stringArray3 = stringArray2;
                int n2 = stringArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray = stringArray3[n3];
                    objectArray2[n][0] = stringArray;
                    objectArray2[n][1] = dataToolTab.dataManager.getConstantValue((String)stringArray);
                    objectArray2[n][2] = dataToolTab.dataManager.getConstantExpression((String)stringArray);
                    ++n;
                    ++n3;
                }
                xMLControl.setValue("constants", objectArray2);
            }
            if (!arrayList.isEmpty()) {
                DataFunction[] dataFunctionArray = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", dataFunctionArray);
            }
            if (dataToolTab.dataTool.fitBuilder != null) {
                ArrayList arrayList2 = new ArrayList(dataToolTab.dataTool.fitBuilder.panels.values());
                xMLControl.setValue("fits", arrayList2);
            }
            xMLControl.setValue("selected_fit", dataToolTab.curveFitter.getSelectedFitName());
            xMLControl.setValue("autofit", dataToolTab.curveFitter.autofitCheckBox.isSelected());
            if (!dataToolTab.curveFitter.autofitCheckBox.isSelected()) {
                double[] dArray = new double[dataToolTab.curveFitter.paramModel.getRowCount()];
                int n = 0;
                while (n < dArray.length) {
                    stringArray = (Double)dataToolTab.curveFitter.paramModel.getValueAt(n, 1);
                    dArray[n] = stringArray.doubleValue();
                    ++n;
                }
                xMLControl.setValue("fit_parameters", dArray);
            }
            xMLControl.setValue("fit_color", dataToolTab.curveFitter.color);
            xMLControl.setValue("fit_visible", dataToolTab.fitterCheckbox.isSelected());
            xMLControl.setValue("props_visible", dataToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", dataToolTab.statsCheckbox.isSelected());
            int n = dataToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            int n4 = dataToolTab.curveFitter.splitPane.getDividerLocation();
            xMLControl.setValue("fit_split_pane", n4);
            objectArray = dataToolTab.dataTable.getModelColumnOrder();
            xMLControl.setValue("column_order", objectArray);
            stringArray = dataToolTab.dataTable.getHiddenMarkers();
            xMLControl.setValue("hidden_markers", stringArray);
            String[] stringArray4 = dataToolTab.dataTable.getFormattedColumnNames();
            if (stringArray4.length > 0) {
                ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
                int n5 = 0;
                while (n5 < stringArray4.length) {
                    String string = stringArray4[n5];
                    String string2 = dataToolTab.dataTable.getFormatPattern(string);
                    arrayList3.add(new String[]{string, string2});
                    ++n5;
                }
                xMLControl.setValue("format_patterns", arrayList3);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            DataTool dataTool = (DataTool)xMLControl.getObject("datatool");
            DatasetManager datasetManager = (DatasetManager)xMLControl.getObject("data");
            if (datasetManager == null) {
                return new DataToolTab(null, dataTool);
            }
            for (Dataset dataset : datasetManager.getDatasets()) {
                dataset.setXColumnVisible(false);
            }
            return new DataToolTab(datasetManager, dataTool);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Runnable runnable22;
            String[] stringArray;
            Object object2;
            Object object3;
            Object[][] objectArray;
            int n;
            Object object422;
            final DataToolTab dataToolTab = (DataToolTab)object;
            dataToolTab.setName(xMLControl.getString("name"));
            dataToolTab.ownerName = xMLControl.getString("owner_name");
            String[][] stringArray2 = (String[][])xMLControl.getObject("owned_columns");
            if (stringArray2 != null) {
                dataToolTab.ownedColumns.clear();
                object422 = stringArray2;
                int n2 = stringArray2.length;
                n = 0;
                while (n < n2) {
                    objectArray = object422[n];
                    object3 = new String[]{objectArray[1], objectArray[2]};
                    dataToolTab.ownedColumns.put((String)objectArray[0], (String[])object3);
                    ++n;
                }
            }
            if ((objectArray = (Object[][])xMLControl.getObject("constants")) != null) {
                n = 0;
                while (n < objectArray.length) {
                    String string = (String)objectArray[n][0];
                    double d = (Double)objectArray[n][1];
                    object2 = (String)objectArray[n][2];
                    dataToolTab.dataManager.setConstant(string, d, (String)object2);
                    ++n;
                }
            }
            for (XMLProperty xMLProperty : xMLControl.getPropertyContent()) {
                if (!xMLProperty.getPropertyName().equals("data_functions")) continue;
                object422 = xMLProperty.getChildControls();
                int n3 = 0;
                while (n3 < ((String[][])object422).length) {
                    object2 = new DataFunction(dataToolTab.dataManager);
                    object422[n3].loadObject(object2);
                    ((Dataset)object2).setXColumnVisible(false);
                    dataToolTab.dataManager.addDataset((Dataset)object2);
                    ++n3;
                }
                object3 = dataToolTab.dataManager.getDatasets();
                int n4 = 0;
                while (n4 < ((ArrayList)object3).size()) {
                    if (((ArrayList)object3).get(n4) instanceof DataFunction) {
                        ((DataFunction)((ArrayList)object3).get(n4)).refreshFunctionData();
                    }
                    ++n4;
                }
                dataToolTab.dataTable.refreshTable();
                break;
            }
            dataToolTab.userEditable = xMLControl.getBoolean("editable");
            ArrayList arrayList = (ArrayList)xMLControl.getObject("fits");
            if (arrayList != null) {
                for (Object object422 : arrayList) {
                    dataToolTab.dataTool.fitBuilder.addPanel(((Component)object422).getName(), (FunctionPanel)object422);
                }
            }
            object422 = xMLControl.getString("selected_fit");
            dataToolTab.curveFitter.fitDropDown.setSelectedItem(object422);
            boolean bl = xMLControl.getBoolean("autofit");
            dataToolTab.curveFitter.autofitCheckBox.setSelected(bl);
            double[] dArray = (double[])xMLControl.getObject("fit_parameters");
            if (dArray != null) {
                int n5 = 0;
                while (n5 < dArray.length) {
                    dataToolTab.curveFitter.setParameterValue(n5, dArray[n5]);
                    ++n5;
                }
            }
            Color color = (Color)xMLControl.getObject("fit_color");
            dataToolTab.curveFitter.setColor(color);
            boolean bl2 = xMLControl.getBoolean("fit_visible");
            dataToolTab.fitterCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("props_visible");
            dataToolTab.propsCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("stats_visible");
            dataToolTab.statsCheckbox.setSelected(bl2);
            final int n6 = xMLControl.getInt("split_pane");
            final int n7 = xMLControl.getInt("fit_split_pane");
            int[] nArray = (int[])xMLControl.getObject("column_order");
            dataToolTab.dataTable.setModelColumnOrder(nArray);
            if (nArray == null && (stringArray = (String[])xMLControl.getObject("working_columns")) != null) {
                dataToolTab.dataTable.setWorkingColumns(stringArray[0], stringArray[1]);
            }
            stringArray = (String[])xMLControl.getObject("hidden_markers");
            dataToolTab.dataTable.hideMarkers(stringArray);
            ArrayList arrayList2 = (ArrayList)xMLControl.getObject("format_patterns");
            if (arrayList2 != null) {
                for (Runnable runnable22 : arrayList2) {
                    dataToolTab.dataTable.setFormatPattern(runnable22[0], runnable22[1]);
                }
            }
            runnable22 = new Runnable(){

                @Override
                public synchronized void run() {
                    dataToolTab.fitterAction.actionPerformed(null);
                    dataToolTab.propsAndStatsAction.actionPerformed(null);
                    dataToolTab.splitPanes[0].setDividerLocation(n6);
                    dataToolTab.curveFitter.splitPane.setDividerLocation(n7);
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runnable22);
            return object;
        }
    }
}

