/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing2d.utils.VectorAlgebra;
import org.opensourcephysics.drawing3d.ElementSpring;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSegment;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementSpring
extends SimpleElementSegment {
    private int loops = -1;
    private int pointsPerLoop = -1;

    public SimpleElementSpring(ElementSpring _element) {
        super(_element);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x136) != 0 || (_cummulativeChange & 8) != 0) {
            this.computePoints();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
        _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index + 1], this.bCoord[_index + 1]);
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.style.getLineColor());
        _g2.drawPolyline(this.aCoord, this.bCoord, this.aCoord.length);
    }

    private void computePoints() {
        int segments;
        int theLoops = this.loops;
        int thePPL = this.pointsPerLoop;
        Resolution res = this.style.getResolution();
        if (res == null) {
            theLoops = 8;
            thePPL = 15;
        } else {
            switch (res.getType()) {
                case 0: {
                    theLoops = Math.max(res.getN1(), 0);
                    thePPL = Math.max(res.getN2(), 1);
                    break;
                }
                case 1: {
                    theLoops = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / res.getMaxLength()), 1);
                    thePPL = 15;
                }
            }
        }
        if (theLoops != this.loops || thePPL != this.pointsPerLoop) {
            int segments2;
            this.loops = theLoops;
            this.pointsPerLoop = thePPL;
            this.div = segments2 = this.loops * this.pointsPerLoop;
            this.points = new double[segments2 + 1][3];
            this.aCoord = new int[segments2 + 1];
            this.bCoord = new int[segments2 + 1];
            this.objects = new Object3D[segments2];
            int i = 0;
            while (i < segments2) {
                this.objects[i] = new Object3D(this, i);
                ++i;
            }
        }
        ElementSpring spring = (ElementSpring)this.element;
        this.div = segments = this.objects.length;
        double delta = Math.PI * 2 / (double)this.pointsPerLoop;
        double radius = spring.getRadius();
        double solenoid = spring.getSolenoid();
        if (radius < 0.0) {
            delta *= -1.0;
        }
        int pre = this.pointsPerLoop / 2;
        double[] size = this.element.getSize();
        double[] v = new double[]{1.0, 0.0, 0.0};
        v[0] = size[0];
        v[1] = size[1];
        v[2] = size[2];
        if (size[0] == 0.0) {
            size[0] = 1.0;
        }
        if (size[1] == 0.0) {
            size[1] = 1.0;
        }
        if (size[2] == 0.0) {
            size[2] = 1.0;
        }
        double[] u1 = VectorAlgebra.normalTo(v);
        double[] u2 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(v, u1));
        int i = 0;
        while (i <= segments) {
            int k = spring.isThinExtremes() ? (i < pre ? 0 : (i < this.pointsPerLoop ? i - pre : (i > segments - pre ? 0 : (i > segments - this.pointsPerLoop ? segments - i - pre : pre)))) : pre;
            double angle = (double)i * delta;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            if (solenoid != 0.0) {
                double cte = (double)k * Math.cos((double)(i * 2) * Math.PI / (double)this.pointsPerLoop) / (double)pre;
                int c = 0;
                while (c < 3) {
                    this.points[i][c] = solenoid * cte * v[c] + (double)i * v[c] / (double)segments + (double)k * radius * (cos * u1[c] + sin * u2[c]) / (double)pre;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < 3) {
                    this.points[i][c] = (double)i * v[c] / (double)segments + (double)k * radius * (cos * u1[c] + sin * u2[c]) / (double)pre;
                    ++c;
                }
            }
            this.element.toSpaceFrame(this.points[i]);
            ++i;
        }
    }
}

