/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementPolygon
extends SimpleElement {
    private ElementPolygon polygon;
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] transformedCoordinates = new double[0][0];
    private double[] center = new double[3];
    private double[] pixel = new double[3];
    private Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};

    public SimpleElementPolygon(ElementPolygon _element) {
        super(_element);
        this.polygon = _element;
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x136) != 0) {
            this.transformPoints();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    public Object3D[] getObjects3D() {
        if (this.polygon.isClosed() && this.style.isDrawingFill()) {
            return this.closedObject;
        }
        return this.objects;
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        DrawingPanel3D panel = this.element.getPanel();
        if (_index < 0) {
            if (this.style.isDrawingFill()) {
                _g2.setPaint(panel.projectPaint(this.style.getFillColor(), this.closedObject[0].getDistance()));
                _g2.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
            if (this.style.isDrawingLines()) {
                _g2.setStroke(this.style.getLineStroke());
                _g2.setColor(panel.projectColor(this.style.getLineColor(), this.closedObject[0].getDistance()));
                int n = this.aPoints.length - 1;
                int i = 0;
                while (i < n) {
                    _g2.drawLine(this.aPoints[i], this.bPoints[i], this.aPoints[i + 1], this.bPoints[i + 1]);
                    ++i;
                }
                _g2.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(panel.projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
        int sides = this.aPoints.length - 1;
        if (_index < sides) {
            _g2.drawLine(this.aPoints[_index], this.bPoints[_index], this.aPoints[_index + 1], this.bPoints[_index + 1]);
        } else {
            _g2.drawLine(this.aPoints[sides], this.bPoints[sides], this.aPoints[0], this.bPoints[0]);
        }
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.style.getLineColor());
        _g2.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        if (this.polygon.isClosed()) {
            int sides = this.aPoints.length - 1;
            _g2.drawLine(this.aPoints[sides], this.bPoints[sides], this.aPoints[0], this.bPoints[0]);
        }
    }

    private void transformPoints() {
        int i;
        double[][] coordinates = this.polygon.getDataArray();
        int n = coordinates.length;
        if (this.transformedCoordinates.length != n) {
            this.transformedCoordinates = new double[n][3];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
            this.objects = new Object3D[n];
            i = 0;
            while (i < n) {
                this.objects[i] = new Object3D(this, i);
                ++i;
            }
        }
        System.arraycopy(Element.STD_ORIGIN, 0, this.center, 0, 3);
        i = 0;
        while (i < n) {
            System.arraycopy(coordinates[i], 0, this.transformedCoordinates[i], 0, 3);
            this.element.sizeAndToSpaceFrame(this.transformedCoordinates[i]);
            int k = 0;
            while (k < 3) {
                int n2 = k;
                this.center[n2] = this.center[n2] + this.transformedCoordinates[i][k];
                ++k;
            }
            ++i;
        }
        int k = 0;
        while (k < 3) {
            int n3 = k++;
            this.center[n3] = this.center[n3] / (double)n;
        }
    }

    private void projectPoints() {
        DrawingPanel3D panel = this.element.getPanel();
        int n = this.transformedCoordinates.length;
        int i = 0;
        while (i < n) {
            System.arraycopy(this.transformedCoordinates[i], 0, this.pixel, 0, 3);
            panel.projectPosition(this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.objects[i].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++i;
        }
        if (this.polygon.isClosed()) {
            if (this.style.isDrawingFill()) {
                System.arraycopy(this.center, 0, this.pixel, 0, 3);
                panel.projectPosition(this.pixel);
                this.closedObject[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
            } else {
                this.closedObject[0].setDistance(Double.NaN);
            }
        } else {
            this.objects[n - 1].setDistance(Double.NaN);
        }
    }
}

