/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;
import org.opensourcephysics.drawing3d.ElementSpring;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class Java3dElementSpring
extends Java3dElement {
    private LineStripArray lines = null;
    private BranchGroup bg;
    private TexCoord2f[] texCoord = null;
    private int[] stripVertexCounts = null;
    private double[] points = new double[300];
    private int length = 0;
    private double[] nextPoint = new double[3];

    public Java3dElementSpring(ElementSpring _element) {
        super(_element);
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(true);
        this.getAppearance().getPointAttributes().setPointSize(0.1f);
        this.element.getStyle().setResolution(new Resolution(8, 15, 1));
        this.element.addChange(8);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 8) != 0 || (_change & 4) != 0) {
            this.computePoints();
        }
        if ((_change & 2) != 0 || (_change & 0x26) != 0) {
            this.setScaleSpring();
        }
    }

    @Override
    public void styleChanged(int _change) {
        super.styleChanged(_change);
        switch (_change) {
            case 0: {
                this.element.getStyle().setFillColor(this.element.getStyle().getLineColor());
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    private void init() {
        this.stripVertexCounts = new int[]{Math.max(2, this.length)};
        this.lines = new LineStripArray(this.points.length / 3, 39, this.stripVertexCounts);
        this.lines.setCapability(3);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCapability(7);
        this.lines.setCoordinates(0, this.points);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
        this.addNode((Node)this.bg);
    }

    private void computePoints() {
        this.clear();
        int theLoops = 0;
        int thePPL = 0;
        Resolution res = this.element.getStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    theLoops = Math.max(res.getN1(), 0);
                    thePPL = Math.max(res.getN2(), 1);
                    break;
                }
                case 1: {
                    theLoops = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / res.getMaxLength()), 1);
                    thePPL = 15;
                }
            }
        } else {
            theLoops = 8;
            thePPL = 15;
        }
        ElementSpring spring = (ElementSpring)this.element;
        int segments = theLoops * thePPL + 3;
        this.texCoord = new TexCoord2f[segments + 1];
        double delta = Math.PI * 2 / (double)thePPL;
        double radius = spring.getRadius();
        double solenoid = spring.getSolenoid();
        if (radius < 0.0) {
            delta *= -1.0;
        }
        int pre = thePPL / 2;
        double[] size = this.element.getSize();
        double[] v = new double[]{0.0, 0.0, 0.0};
        v[0] = size[0];
        v[1] = size[1];
        v[2] = size[2];
        if (size[0] == 0.0) {
            size[0] = 1.0;
        }
        if (size[1] == 0.0) {
            size[1] = 1.0;
        }
        if (size[2] == 0.0) {
            size[2] = 1.0;
        }
        this.setScaleSpring();
        double[] u1 = VectorAlgebra.normalTo(v);
        double[] u2 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(v, u1));
        int i = 0;
        while (i <= segments) {
            double z;
            double y;
            double x;
            int k = spring.isThinExtremes() ? (i < pre ? 0 : (i < thePPL ? i - pre : (i > segments - pre ? 0 : (i > segments - thePPL ? segments - i - pre : pre)))) : pre;
            double angle = (double)i * delta;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            if (solenoid != 0.0) {
                double cte = (double)k * Math.cos((double)(i * 2) * Math.PI / (double)thePPL) / (double)pre;
                x = solenoid * cte * v[0] + (double)i * v[0] / (double)segments + (double)k * radius * (cos * u1[0] + sin * u2[0]) / (double)pre;
                y = solenoid * cte * v[1] + (double)i * v[1] / (double)segments + (double)k * radius * (cos * u1[1] + sin * u2[1]) / (double)pre;
                z = solenoid * cte * v[2] + (double)i * v[2] / (double)segments + (double)k * radius * (cos * u1[2] + sin * u2[2]) / (double)pre;
                this.addPoint(x, y, z);
            } else {
                x = (double)i * v[0] / (double)segments + (double)k * radius * (cos * u1[0] + sin * u2[0]) / (double)pre;
                y = (double)i * v[1] / (double)segments + (double)k * radius * (cos * u1[1] + sin * u2[1]) / (double)pre;
                z = (double)i * v[2] / (double)segments + (double)k * radius * (cos * u1[2] + sin * u2[2]) / (double)pre;
                this.addPoint(x, y, z);
            }
            ++i;
        }
    }

    private void setScaleSpring() {
        Transform3D scale = new Transform3D();
        Vector3d vscale = new Vector3d();
        this.getTransformGroup().getTransform(scale);
        scale.getScale(vscale);
        vscale.x = 1.0;
        vscale.y = 1.0;
        vscale.z = 1.0;
        scale.setScale(vscale);
        this.getTransformGroup().setTransform(scale);
    }

    private void clear() {
        this.length = 0;
        this.init();
    }

    private void addPoint(double x, double y, double z) {
        this.nextPoint[0] = x;
        this.nextPoint[1] = y;
        this.nextPoint[2] = z;
        if (this.length * 3 == this.points.length) {
            double[] newArray = new double[this.length * 3 * 2];
            System.arraycopy(this.points, 0, newArray, 0, this.length * 3);
            this.points = newArray;
            this.init();
            this.styleChanged(10);
        } else {
            if (this.lines == null) {
                this.init();
            }
            this.updatePoints();
        }
    }

    private void updatePoints() {
        this.points[this.length * 3] = this.nextPoint[0];
        this.points[this.length * 3 + 1] = this.nextPoint[1];
        this.points[this.length * 3 + 2] = this.nextPoint[2];
        this.lines.setCoordinate(this.length, new double[]{this.points[this.length * 3], this.points[this.length * 3 + 1], this.points[this.length * 3 + 2]});
        this.texCoord[this.length] = new TexCoord2f();
        this.texCoord[this.length].x = (float)(this.nextPoint[0] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
        this.texCoord[this.length].y = (float)(this.nextPoint[1] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
        this.lines.setTextureCoordinate(0, this.length, this.texCoord[this.length]);
        ++this.length;
        if (this.length < 2) {
            this.points[this.length * 3] = this.nextPoint[0];
            this.points[this.length * 3 + 1] = this.nextPoint[1];
            this.points[this.length * 3 + 2] = this.nextPoint[2];
            this.lines.setCoordinate(this.length, new double[]{this.points[this.length * 3], this.points[this.length * 3 + 1], this.points[this.length * 3 + 2]});
            this.texCoord[this.length] = new TexCoord2f();
            this.texCoord[this.length].x = (float)(this.nextPoint[0] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
            this.texCoord[this.length].y = (float)(this.nextPoint[1] / Math.sqrt(this.nextPoint[0] * this.nextPoint[0] + this.nextPoint[1] * this.nextPoint[1] + this.nextPoint[2] * this.nextPoint[2]));
            this.lines.setTextureCoordinate(0, this.length, this.texCoord[this.length]);
        }
        this.stripVertexCounts[0] = Math.max(2, this.length);
        this.lines.setStripVertexCounts(this.stripVertexCounts);
    }
}

