/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.utils.Style;

public class MultiTrail
extends Group {
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    private ElementTrail currentSegment;
    private ElementTrail.TrailPoint flushPoint = new ElementTrail.TrailPoint(0.0, 0.0, 0.0, 1);
    private int counter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;

    public MultiTrail() {
        this.createNewTrail();
    }

    @Override
    public Style getStyle() {
        return this.currentSegment.getStyle();
    }

    public void setActive(boolean _active) {
        this.active = _active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean _noRepeat) {
        this.noRepeat = _noRepeat;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean _clear) {
        this.clearAtInput = _clear;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int _skip) {
        if (this.skip != _skip) {
            this.skip = _skip;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void setXLabel(String _label) {
        this.inputLabels[0] = _label;
        this.currentSegment.setXLabel(this.inputLabels[0]);
    }

    public void setYLabel(String _label) {
        this.inputLabels[1] = _label;
        this.currentSegment.setYLabel(this.inputLabels[1]);
    }

    public void setZLabel(String _label) {
        this.inputLabels[2] = _label;
        this.currentSegment.setZLabel(this.inputLabels[2]);
    }

    public void addPoint(double x, double y, double z) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(x, y, z, this.connectionType);
    }

    public void addPoint(double[] point) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(point[0], point[1], point[2], this.connectionType);
    }

    public void moveToPoint(double x, double y, double z) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(x, y, z, 0);
    }

    public void moveToPoint(double[] point) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(point[0], point[1], point[2], 0);
    }

    public void addPoints(double[][] input) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = input.length;
        while (i < n) {
            this.addPoint(input[i][0], input[i][1], input[i][2], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double xInput, double yInput, double[] zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = zInput.length;
        while (i < n) {
            this.addPoint(xInput, yInput, zInput[i], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double xInput, double[] yInput, double zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = yInput.length;
        while (i < n) {
            this.addPoint(xInput, yInput[i], zInput, this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] xInput, double yInput, double zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int i = 0;
        int n = xInput.length;
        while (i < n) {
            this.addPoint(xInput[i], yInput, zInput, this.connectionType);
            ++i;
        }
    }

    public void addPoints(double xInput, double[] yInput, double[] zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(yInput.length, zInput.length);
        int i = 0;
        while (i < n) {
            this.addPoint(xInput, yInput[i], zInput[i], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] xInput, double yInput, double[] zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(xInput.length, zInput.length);
        int i = 0;
        while (i < n) {
            this.addPoint(xInput[i], yInput, zInput[i], this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] xInput, double[] yInput, double zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(xInput.length, yInput.length);
        int i = 0;
        while (i < n) {
            this.addPoint(xInput[i], yInput[i], zInput, this.connectionType);
            ++i;
        }
    }

    public void addPoints(double[] xInput, double[] yInput, double[] zInput) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(xInput.length, Math.min(yInput.length, zInput.length));
        int i = 0;
        while (i < n) {
            this.addPoint(xInput[i], yInput[i], zInput[i], this.connectionType);
            ++i;
        }
    }

    public void setMaximumPoints(int maximum) {
        this.maximum = Math.max(maximum, 0);
        this.currentSegment.setMaximumPoints(maximum);
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int type) {
        this.connectionType = type;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    @Override
    public void clear() {
        for (Element el : this.getElements()) {
            ((ElementTrail)el).clear();
        }
        this.removeAllElements();
        this.addElement(this.currentSegment);
        this.initialize();
    }

    @Override
    public void initialize() {
        this.currentSegment.clear();
        this.currentSegment.setGhostPoint(null);
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    public void newSegment() {
        this.currentSegment.closeTrail(Double.isNaN(this.lastX) ? 0 : this.flushPoint.getType());
        this.createNewTrail();
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    private void createNewTrail() {
        ElementTrail oldTrail = this.currentSegment;
        this.currentSegment = new ElementTrail();
        this.currentSegment.setMaximumPoints(this.maximum);
        this.currentSegment.setLabels(this.inputLabels);
        if (oldTrail != null) {
            oldTrail.getStyle().copyTo(this.currentSegment.getStyle());
        }
        this.addElement(this.currentSegment);
    }

    private void addPoint(double _x, double _y, double _z, int _type) {
        if (Double.isNaN(_x) || Double.isNaN(_y) || Double.isNaN(_z)) {
            this.lastZ = Double.NaN;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            return;
        }
        if (this.noRepeat && this.lastX == _x && this.lastY == _y && this.lastZ == _z) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint.setCoordinates(_x, _y, _z, _type);
                this.currentSegment.setGhostPoint(this.flushPoint);
                this.lastX = _x;
                this.lastY = _y;
                this.lastZ = _z;
                return;
            }
            ++this.counter;
        }
        this.currentSegment.setGhostPoint(null);
        this.lastX = _x;
        this.lastY = _y;
        this.lastZ = _z;
        this.currentSegment.addPoint(_x, _y, _z, Double.isNaN(this.lastX) ? 0 : _type);
    }
}

