/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.MultiTrail;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.java3d.Java3dGroup;
import org.opensourcephysics.drawing3d.simple3d.SimpleGroup;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class Group
extends Element
implements Data {
    protected ArrayList<Element> elementList = new ArrayList();
    private int elementInteracted = -1;
    protected int datasetID;

    public Group() {
        this.setEnabled(true);
        this.datasetID = this.hashCode();
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleGroup(this);
            }
            case 1: 
        }
        return new Java3dGroup(this);
    }

    @Override
    protected void setImplementation(int _implementation) {
        super.setImplementation(_implementation);
        for (Element element : this.elementList) {
            element.setImplementation(_implementation);
        }
    }

    @Override
    public void setPanel(DrawingPanel3D _panel) {
        super.setPanel(_panel);
        for (Element element : this.elementList) {
            if (element.getPanel() == null) continue;
            element.setPanel(_panel);
        }
    }

    @Override
    public void removePanel() {
        super.removePanel();
        for (Element element : this.elementList) {
            element.removePanel();
        }
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        element.setGroup(this);
    }

    public void addElementAtIndex(int index, Element element) {
        if (!this.elementList.contains(element)) {
            index = Math.max(index, this.elementList.size() - 1);
            this.elementList.add(index, element);
        }
        element.setGroup(this);
    }

    public void addElements(Collection<Element> elements) {
        if (elements != null) {
            for (Element el : elements) {
                this.addElement(el);
            }
        }
    }

    public void removeElement(Element element) {
        element.setGroup(null);
        this.elementList.remove(element);
    }

    public void removeAllElements() {
        for (Element element : this.elementList) {
            element.setGroup(null);
        }
        this.elementList.clear();
    }

    public synchronized List<Element> getElements() {
        return new ArrayList<Element>(this.elementList);
    }

    public int getNumberOfElements() {
        return this.elementList.size();
    }

    public Element getElement(int index) {
        try {
            return this.elementList.get(index);
        }
        catch (IndexOutOfBoundsException exc) {
            return null;
        }
    }

    @Override
    public void processChanges(int _cummulativeChange) {
        _cummulativeChange |= this.changeType;
        ImplementingObject impl = this.getImplementingObject();
        if (impl != null) {
            impl.processChanges(this.changeType, _cummulativeChange);
        }
        for (Element el : this.elementList) {
            el.processChanges(_cummulativeChange);
        }
        this.changeType = 0;
    }

    @Override
    public boolean hasChanged() {
        if (this.changeType != 0) {
            return true;
        }
        for (Element el : this.elementList) {
            if (!el.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getDiagonalSize() {
        double max = 0.0;
        for (Element el : this.elementList) {
            if (!el.isVisible()) continue;
            max = Math.max(max, el.getDiagonalSize());
        }
        return max;
    }

    @Override
    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Element el : this.elementList) {
            if (!el.getCanBeMeasured() || !el.isVisible()) continue;
            el.getExtrema(min, max);
            minX = Math.min(Math.min(minX, min[0]), max[0]);
            maxX = Math.max(Math.max(maxX, min[0]), max[0]);
            minY = Math.min(Math.min(minY, min[1]), max[1]);
            maxY = Math.max(Math.max(maxY, min[1]), max[1]);
            minZ = Math.min(Math.min(minZ, min[2]), max[2]);
            maxZ = Math.max(Math.max(maxZ, min[2]), max[2]);
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    @Override
    public InteractionTarget getTargetHit(int x, int y) {
        if (!this.isEnabled()) {
            return null;
        }
        List<Element> elList = this.getElements();
        int i = elList.size() - 1;
        while (i >= 0) {
            InteractionTarget target;
            Element el = elList.get(i);
            if (el.isVisible() && (target = el.getTargetHit(x, y)) != null) {
                this.elementInteracted = i;
                return target;
            }
            --i;
        }
        this.elementInteracted = -1;
        return null;
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    @Override
    public boolean getCanBeMeasured() {
        if (!super.getCanBeMeasured()) {
            return false;
        }
        for (Element el : this.getElements()) {
            if (!el.getCanBeMeasured()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (Element el : this.getElements()) {
            if (!(el instanceof MultiTrail)) continue;
            ((MultiTrail)el).clear();
        }
    }

    public void initialize() {
        for (Element el : this.getElements()) {
            if (!(el instanceof MultiTrail)) continue;
            ((MultiTrail)el).initialize();
        }
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        for (Element el : this.elementList) {
            if (!(el instanceof Data)) continue;
            return ((Data)((Object)el)).getColumnNames();
        }
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), (Color)fill};
        }
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> list = new ArrayList<Data>();
        for (Element el : this.elementList) {
            if (!(el instanceof Data)) continue;
            list.add((Data)((Object)el));
        }
        return list;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

