/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSpring;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSpring;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementSpring
extends ElementSegment {
    public static final double DEF_RADIUS = 0.05;
    public static final int DEF_LOOPS = 8;
    public static final int DEF_PPL = 15;
    private double radius = 0.05;
    private double solenoid = 0.0;
    private boolean thinExtremes = true;
    private int loops;
    private int pointsPerLoop;

    public ElementSpring() {
        this.setSize(new double[]{0.1, 0.1, 0.1});
        this.setResolution(8, 15);
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementSpring(this);
            }
            case 1: 
        }
        return new Java3dElementSpring(this);
    }

    public void setRadius(double _radius) {
        if (this.radius == _radius) {
            return;
        }
        this.radius = _radius;
        this.addChange(8);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setSolenoid(double _sol) {
        if (this.solenoid == _sol) {
            return;
        }
        this.solenoid = _sol;
        this.addChange(8);
    }

    public double getSolenoid() {
        return this.solenoid;
    }

    public void setThinExtremes(boolean _thin) {
        if (this.thinExtremes == _thin) {
            return;
        }
        this.thinExtremes = _thin;
        this.addChange(8);
    }

    public boolean isThinExtremes() {
        return this.thinExtremes;
    }

    public void setResolution(int _loops, int _ppl) {
        if (_loops == this.loops && _ppl == this.pointsPerLoop) {
            return;
        }
        this.loops = _loops;
        this.pointsPerLoop = _ppl;
        this.getStyle().setResolution(new Resolution(this.loops, this.pointsPerLoop, 1));
        this.addChange(8);
    }

    public int getLoops() {
        return this.loops;
    }

    public int getPointsPerLoop() {
        return this.pointsPerLoop;
    }
}

