/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.util.Arrays;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementPlane;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementPlane;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementPlane
extends Element {
    private double[] vectorU = new double[]{1.0, 0.0, 0.0};
    private double[] vectorV = new double[]{0.0, 1.0, 0.0};
    private double sizeU = 1.0;
    private double sizeV = 1.0;
    private double vectorUSize = 1.0;
    private double vectorVSize = 1.0;

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementPlane(this);
            }
            case 1: 
        }
        return new Java3dElementPlane(this);
    }

    public void setFirstDirection(double[] vector) {
        if (vector == null) {
            return;
        }
        if (Arrays.equals(vector, this.vectorU)) {
            return;
        }
        System.arraycopy(vector, 0, this.vectorU, 0, 3);
        this.vectorUSize = Math.sqrt(this.vectorU[0] * this.vectorU[0] + this.vectorU[1] * this.vectorU[1] + this.vectorU[2] * this.vectorU[2]);
        this.addChange(8);
    }

    public void setSizeFirstDirection(double size) {
        if (size == this.sizeU) {
            return;
        }
        this.sizeU = size;
        this.addChange(8);
    }

    public double getSizeFirstDirection() {
        return this.sizeU;
    }

    public void setSizeSecondDirection(double size) {
        if (size == this.sizeV) {
            return;
        }
        this.sizeV = size;
        this.addChange(8);
    }

    public double getSizeSecondDirection() {
        return this.sizeV;
    }

    public double[] getFirstDirection() {
        return (double[])this.vectorU.clone();
    }

    public void setSecondDirection(double[] vector) {
        if (vector == null) {
            return;
        }
        if (Arrays.equals(vector, this.vectorV)) {
            return;
        }
        System.arraycopy(vector, 0, this.vectorV, 0, 3);
        this.vectorVSize = Math.sqrt(this.vectorV[0] * this.vectorV[0] + this.vectorV[1] * this.vectorV[1] + this.vectorV[2] * this.vectorV[2]);
        this.addChange(8);
    }

    public double[] getSecondDirection() {
        return (double[])this.vectorV.clone();
    }

    public double getFirstSize() {
        return this.getSizeX() * this.sizeU * this.vectorUSize;
    }

    public double getSecondSize() {
        return this.getSizeY() * this.sizeV * this.vectorVSize;
    }

    public static double[][][] createPlane(ElementPlane plane, int nu, int nv) {
        double[][][] data = new double[nu * nv][4][3];
        int tile = 0;
        double su = plane.sizeU / 2.0;
        double sv = plane.sizeV / 2.0;
        double du = plane.sizeU / (double)nu;
        double dv = plane.sizeV / (double)nv;
        int i = 0;
        while (i < nu) {
            double u = (double)i * du - su;
            int j = 0;
            while (j < nv) {
                double v = (double)j * dv - sv;
                int k = 0;
                while (k < 3) {
                    data[tile][0][k] = u * plane.vectorU[k] + v * plane.vectorV[k];
                    ++k;
                }
                k = 0;
                while (k < 3) {
                    data[tile][1][k] = (u + du) * plane.vectorU[k] + v * plane.vectorV[k];
                    ++k;
                }
                k = 0;
                while (k < 3) {
                    data[tile][2][k] = (u + du) * plane.vectorU[k] + (v + dv) * plane.vectorV[k];
                    ++k;
                }
                k = 0;
                while (k < 3) {
                    data[tile][3][k] = u * plane.vectorU[k] + (v + dv) * plane.vectorV[k];
                    ++k;
                }
                ++tile;
                ++j;
            }
            ++i;
        }
        return data;
    }
}

