/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display2d.GridData;

public class ArrayData
implements GridData {
    protected double[][][] data;
    protected double left;
    protected double right;
    protected double bottom;
    protected double top;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected boolean cellData = false;
    protected String[] names;

    public ArrayData(int n, int n2, int n3) {
        if (n2 < 1 || n < 1) {
            throw new IllegalArgumentException("Number of dataset rows and columns must be positive. Your row=" + n2 + "  col=" + n);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Number of 2d data components must be positive. Your ncomponents=" + n3);
        }
        this.data = new double[n3][n][n2];
        this.setScale(0.0, n, 0.0, n2);
        this.names = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.names[n4] = "Component_" + n4;
            ++n4;
        }
    }

    @Override
    public void setComponentName(int n, String string) {
        this.names[n] = string;
    }

    @Override
    public String getComponentName(int n) {
        return this.names[n];
    }

    @Override
    public int getComponentCount() {
        return this.data.length;
    }

    @Override
    public void setScale(double d, double d2, double d3, double d4) {
        this.cellData = false;
        this.left = d;
        this.right = d2;
        this.bottom = d3;
        this.top = d4;
        int n = this.data[0].length;
        int n2 = this.data[0][0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (this.right - this.left) / (double)(n - 1);
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (this.bottom - this.top) / (double)(n2 - 1);
        }
        if (this.dx == 0.0) {
            this.left -= 0.5;
            this.right += 0.5;
        }
        if (this.dy == 0.0) {
            this.bottom -= 0.5;
            this.top += 0.5;
        }
    }

    @Override
    public boolean isCellData() {
        return this.cellData;
    }

    @Override
    public double getValue(int n, int n2, int n3) {
        return this.data[n3][n][n2];
    }

    @Override
    public void setValue(int n, int n2, int n3, double d) {
        this.data[n3][n][n2] = d;
    }

    @Override
    public int getNx() {
        return this.data[0].length;
    }

    @Override
    public int getNy() {
        return this.data[0][0].length;
    }

    @Override
    public void setCellScale(double d, double d2, double d3, double d4) {
        this.cellData = true;
        int n = this.data[0].length;
        int n2 = this.data[0][0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (d2 - d) / (double)n;
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (d3 - d4) / (double)n2;
        }
        this.left = d + this.dx / 2.0;
        this.right = d2 - this.dx / 2.0;
        this.bottom = d3 - this.dy / 2.0;
        this.top = d4 + this.dy / 2.0;
    }

    @Override
    public void setCenteredCellScale(double d, double d2, double d3, double d4) {
        int n = this.data[0].length;
        int n2 = this.data[0][0].length;
        double d5 = n > 1 ? (d2 - d) / (double)(n - 1) / 2.0 : 0.0;
        d -= d5;
        d2 += d5;
        d5 = n2 > 1 ? (d4 - d3) / (double)(n2 - 1) / 2.0 : 0.0;
        this.setCellScale(d, d2, d3 -= d5, d4 += d5);
    }

    @Override
    public double interpolate(double d, double d2, int n) {
        int n2 = (int)((d - this.left) / this.dx);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data[0].length - 2, n2);
        int n3 = -((int)((this.top - d2) / this.dy));
        n3 = Math.max(0, n3);
        n3 = Math.min(this.data[0][0].length - 2, n3);
        double d3 = (d - this.left) / this.dx - (double)n2;
        double d4 = -(this.top - d2) / this.dy - (double)n3;
        if (n2 < 0) {
            return (1.0 - d4) * this.data[n][0][n3] + d4 * this.data[n][0][n3 + 1];
        }
        if (n3 < 0) {
            return (1.0 - d3) * this.data[n][n2][0] + d3 * this.data[n][n2 + 1][0];
        }
        return (1.0 - d3) * (1.0 - d4) * this.data[n][n2][n3] + d3 * (1.0 - d4) * this.data[n][n2 + 1][n3] + d3 * d4 * this.data[n][n2 + 1][n3 + 1] + (1.0 - d3) * d4 * this.data[n][n2][n3 + 1];
    }

    @Override
    public double[] interpolate(double d, double d2, int[] nArray, double[] dArray) {
        int n = (int)((d - this.left) / this.dx);
        n = Math.max(0, n);
        n = Math.min(this.data[0].length - 2, n);
        int n2 = -((int)((this.top - d2) / this.dy));
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data[0][0].length - 2, n2);
        if (n < 0 && n2 < 0) {
            int n3 = 0;
            int n4 = nArray.length;
            while (n3 < n4) {
                dArray[n3] = this.data[nArray[n3]][0][0];
                ++n3;
            }
            return dArray;
        }
        if (n < 0) {
            double d3 = -(this.top - d2) / this.dy - (double)n2;
            int n5 = 0;
            int n6 = nArray.length;
            while (n5 < n6) {
                dArray[n5] = (1.0 - d3) * this.data[nArray[n5]][0][n2] + d3 * this.data[nArray[n5]][0][n2 + 1];
                ++n5;
            }
            return dArray;
        }
        if (n2 < 0) {
            double d4 = (d - this.left) / this.dx - (double)n;
            int n7 = 0;
            int n8 = nArray.length;
            while (n7 < n8) {
                dArray[n7] = (1.0 - d4) * this.data[nArray[n7]][n][0] + d4 * this.data[nArray[n7]][n + 1][0];
                ++n7;
            }
            return dArray;
        }
        double d5 = (d - this.left) / this.dx - (double)n;
        double d6 = -(this.top - d2) / this.dy - (double)n2;
        int n9 = 0;
        int n10 = nArray.length;
        while (n9 < n10) {
            int n11 = nArray[n9];
            dArray[n9] = (1.0 - d5) * (1.0 - d6) * this.data[n11][n][n2] + d5 * (1.0 - d6) * this.data[n11][n + 1][n2] + d5 * d6 * this.data[n11][n + 1][n2 + 1] + (1.0 - d5) * d6 * this.data[n11][n][n2 + 1];
            ++n9;
        }
        return dArray;
    }

    @Override
    public double[][][] getData() {
        return this.data;
    }

    @Override
    public double[] getZRange(int n) {
        double d;
        double d2 = d = this.data[n][0][0];
        int n2 = 0;
        int n3 = this.data[0].length;
        while (n2 < n3) {
            int n4 = 0;
            int n5 = this.data[0][0].length;
            while (n4 < n5) {
                double d3 = this.data[n][n2][n4];
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
                ++n4;
            }
            ++n2;
        }
        return new double[]{d, d2};
    }

    @Override
    public final double getLeft() {
        return this.left;
    }

    @Override
    public final double getRight() {
        return this.right;
    }

    @Override
    public final double getTop() {
        return this.top;
    }

    @Override
    public final double getBottom() {
        return this.bottom;
    }

    @Override
    public final double getDx() {
        return this.dx;
    }

    @Override
    public final double getDy() {
        return this.dy;
    }

    @Override
    public double indexToX(int n) {
        return this.data == null ? Double.NaN : this.left + this.dx * (double)n;
    }

    @Override
    public double indexToY(int n) {
        return this.data == null ? Double.NaN : this.top + this.dy * (double)n;
    }

    @Override
    public int xToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNx();
        double d2 = (this.right - this.left) / (double)n;
        int n2 = (int)((d - this.left) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    @Override
    public int yToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNy();
        double d2 = (this.top - this.bottom) / (double)n;
        int n2 = (int)((this.top - d) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ArrayData arrayData = (ArrayData)object;
            xMLControl.setValue("left", arrayData.left);
            xMLControl.setValue("right", arrayData.right);
            xMLControl.setValue("bottom", arrayData.bottom);
            xMLControl.setValue("top", arrayData.top);
            xMLControl.setValue("dx", arrayData.dx);
            xMLControl.setValue("dy", arrayData.dy);
            xMLControl.setValue("is cell data", arrayData.cellData);
            xMLControl.setValue("data", arrayData.data);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new ArrayData(1, 1, 1);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            ArrayData arrayData = (ArrayData)object;
            double[][][] dArray = (double[][][])xMLControl.getObject("data");
            arrayData.data = dArray;
            arrayData.left = xMLControl.getDouble("left");
            arrayData.right = xMLControl.getDouble("right");
            arrayData.bottom = xMLControl.getDouble("bottom");
            arrayData.top = xMLControl.getDouble("top");
            arrayData.dx = xMLControl.getDouble("dx");
            arrayData.dy = xMLControl.getDouble("dy");
            arrayData.cellData = xMLControl.getBoolean("is cell data");
            return object;
        }
    }
}

