/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;

public class ControlText3D
extends ControlElement3D {
    private static final int TEXT_PROPERTIES_ADDED = 4;
    private ElementText text;
    private Font font;
    private Font defaultFont;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementText";
    }

    @Override
    protected Element createElement() {
        this.text = new ElementText();
        this.font = this.defaultFont = this.text.getFont();
        return this.text;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 4;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("font");
            infoList.add("pixelSize");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("text")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("font")) {
            return "Font|Object";
        }
        if (_property.equals("pixelSize")) {
            return "boolean";
        }
        if (_property.equals("rotationAngle")) {
            return "int|double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getString() == this.text.getText()) break;
                this.text.setText(_value.getString());
                break;
            }
            case 1: {
                Font newFont;
                if (!(_value.getObject() instanceof Font) || (newFont = (Font)_value.getObject()) == this.font) break;
                this.font = newFont;
                this.text.setFont(this.font);
                break;
            }
            case 2: {
                if (_value.getBoolean() == this.text.isTrueSize()) break;
                this.text.setTrueSize(_value.getBoolean());
                break;
            }
            case 3: {
                double angle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (angle == this.text.getRotationAngle()) break;
                this.text.setRotationAngle(angle);
                break;
            }
            default: {
                super.setValue(_index - 4, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.text.setText("");
                break;
            }
            case 1: {
                this.text.setFont(this.defaultFont);
                break;
            }
            case 2: {
                this.text.setTrueSize(false);
                break;
            }
            case 3: {
                this.text.setRotationAngle(0.0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 4);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "false";
            }
            case 3: {
                return "0.0";
            }
        }
        return super.getDefaultValueString(_index - 4);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(_index - 4);
    }
}

