/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementSpring;

public class ControlSpring3D
extends ControlElement3D {
    private static final int SPRING3D_PROPERTIES_ADDED = 5;
    private ElementSpring spring;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementSpring";
    }

    @Override
    protected Element createElement() {
        this.spring = new ElementSpring();
        return this.spring;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 5;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("radius");
            infoList.add("solenoid");
            infoList.add("thinExtremes");
            infoList.add("loops");
            infoList.add("pointsPerLoop");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("radius")) {
            return "int|double";
        }
        if (_property.equals("solenoid")) {
            return "int|double";
        }
        if (_property.equals("thinExtremes")) {
            return "boolean";
        }
        if (_property.equals("loops")) {
            return "int";
        }
        if (_property.equals("pointsPerLoop")) {
            return "int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.spring.setRadius(_value.getDouble());
                break;
            }
            case 1: {
                this.spring.setSolenoid(_value.getDouble());
                break;
            }
            case 2: {
                this.spring.setThinExtremes(_value.getBoolean());
                break;
            }
            case 3: {
                this.spring.setResolution(_value.getInteger(), this.spring.getPointsPerLoop());
                break;
            }
            case 4: {
                this.spring.setResolution(this.spring.getLoops(), _value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.spring.setRadius(0.05);
                break;
            }
            case 1: {
                this.spring.setSolenoid(0.0);
                break;
            }
            case 2: {
                this.spring.setThinExtremes(true);
                break;
            }
            case 3: {
                this.spring.setResolution(8, this.spring.getPointsPerLoop());
                break;
            }
            case 4: {
                this.spring.setResolution(this.spring.getLoops(), 15);
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return Double.toString(0.05);
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return Integer.toString(8);
            }
            case 4: {
                return Integer.toString(15);
            }
        }
        return super.getDefaultValueString(_index - 5);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }
}

