/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlSet3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;

public class ControlArrowSet3D
extends ControlSet3D {
    private static final int ARROWSET_PROPERTIES_ADDED = 1;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 1;
    }

    @Override
    protected Element createAnElement() {
        ElementArrow el = new ElementArrow();
        return el;
    }

    @Override
    protected void copyAnElement(Element oldElement, Element newElement) {
        super.copyAnElement(oldElement, newElement);
        ((ElementArrow)newElement).setArrowType(((ElementArrow)oldElement).getArrowType());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("style")) {
            return "ArrowStyle|int|int[]";
        }
        if (_property.equals("elementposition")) {
            return "ArrowPosition|int|int[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        ((ElementArrow)this.elements[i]).setArrowType(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementArrow)this.elements[i]).setArrowType(val);
                        ++i;
                    }
                }
                break;
            }
            default: {
                super.setValue(_index - 1, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                int i = 0;
                while (i < this.numElements) {
                    ((ElementArrow)this.elements[i]).setArrowType(0);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index - 1);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "ARROW";
            }
        }
        return super.getDefaultValueString(_index - 1);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
        }
        return super.getValue(_index - 1);
    }
}

