/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitBuilder
extends FunctionTool {
    static JFileChooser chooser;
    protected JButton newFitButton;
    protected JButton deleteFitButton;
    protected JButton cloneFitButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected Component parent;

    public FitBuilder(Component component) {
        super(component);
        this.parent = component;
        this.newFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
        this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
        this.newFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FitBuilder.this.getUniqueName(ToolsRes.getString("DatasetCurveFitter.NewFit.Name"));
                UserFunction userFunction = new UserFunction(string);
                Dataset dataset = null;
                DatasetCurveFitter datasetCurveFitter = FitBuilder.this.getSelectedCurveFitter();
                if (datasetCurveFitter != null) {
                    dataset = datasetCurveFitter.getData();
                }
                String string2 = dataset == null ? "x" : TeXParser.removeSubscripting(dataset.getColumnName(0));
                userFunction.setExpression("0", new String[]{string2});
                FitBuilder.this.addFitFunction(userFunction);
            }
        });
        this.deleteFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
        this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
        this.deleteFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FitBuilder.this.getSelectedName();
                FitBuilder.this.removePanel(string);
            }
        });
        this.cloneFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Text"));
        this.cloneFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Tooltip"));
        this.cloneFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object22;
                final HashMap<Object, KnownFunction> hashMap = new HashMap<Object, KnownFunction>();
                final ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object22 : FitBuilder.this.curveFitters) {
                    int n = 0;
                    while (n < ((DatasetCurveFitter)object22).fitDropDown.getItemCount()) {
                        String string = ((DatasetCurveFitter)object22).fitDropDown.getItemAt(n).toString();
                        if (!arrayList.contains(string)) {
                            arrayList.add(string);
                            hashMap.put(string, ((DatasetCurveFitter)object22).allFitsMap.get(string));
                        }
                        ++n;
                    }
                }
                object22 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        for (String string : arrayList) {
                            DatasetCurveFitter datasetCurveFitter;
                            if (!string.equals(actionEvent.getActionCommand()) || (datasetCurveFitter = FitBuilder.this.getSelectedCurveFitter()) == null) continue;
                            KnownFunction knownFunction = (KnownFunction)hashMap.get(string);
                            UserFunction userFunction = datasetCurveFitter.createClone(knownFunction, string);
                            UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
                            userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
                            FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
                            FitBuilder.this.addPanel(userFunction.getName(), fitFunctionPanel);
                        }
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (String string : arrayList) {
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener((ActionListener)object22);
                    jPopupMenu.add(jMenuItem);
                }
                jPopupMenu.show(FitBuilder.this.cloneFitButton, 0, FitBuilder.this.cloneFitButton.getHeight());
            }
        });
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        ImageIcon imageIcon = ResourceLoader.getIcon(string);
        this.loadButton = new JButton(imageIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FitBuilder.this.loadFits();
            }
        });
        string = "/org/opensourcephysics/resources/tools/images/save.gif";
        ImageIcon imageIcon2 = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(imageIcon2);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FitBuilder.this.saveFits();
            }
        });
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, new JToolBar.Separator(), this.newFitButton, this.cloneFitButton, this.deleteFitButton});
    }

    public DatasetCurveFitter getSelectedCurveFitter() {
        DataTool dataTool;
        DataToolTab dataToolTab;
        Window window = this.getOwner();
        if (window != null && window instanceof DataTool && (dataToolTab = (dataTool = (DataTool)window).getSelectedTab()) != null) {
            return dataToolTab.curveFitter;
        }
        return null;
    }

    @Override
    public void refreshDropdown(String string) {
        this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty());
        if (this.getPanelNames().isEmpty()) {
            String string2 = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(string2) + ":");
        }
        super.refreshDropdown(string);
    }

    public void addFitFunction(UserFunction userFunction) {
        UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
        userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
        FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
        this.addPanel(userFunction.getName(), fitFunctionPanel);
    }

    public String loadFits() {
        int n;
        if (chooser == null) {
            chooser = OSPRuntime.getChooser();
            FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n2 = fileFilterArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FileFilter fileFilter = fileFilterArray[n3];
                if (fileFilter.getDescription().toLowerCase().indexOf("xml") > -1) {
                    chooser.setFileFilter(fileFilter);
                    break;
                }
                ++n3;
            }
        }
        if ((n = chooser.showOpenDialog(this)) == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String string = chooser.getSelectedFile().getAbsolutePath();
            return this.loadFits(string, false);
        }
        return null;
    }

    public String loadFits(String string, boolean bl) {
        if (string == null) {
            return this.loadFits();
        }
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (xMLControlElement.failedToRead()) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
            return null;
        }
        Class<?> clazz = xMLControlElement.getObjectClass();
        if (FitBuilder.class.isAssignableFrom(clazz)) {
            if (bl || this.chooseFitFunctions(xMLControlElement, "Load")) {
                xMLControlElement.loadObject(this);
            }
        } else {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Title"), 0);
        }
        return string;
    }

    public String saveFits() {
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.chooseFitFunctions(xMLControlElement, "Save")) {
            int n;
            int n2;
            if (chooser == null) {
                chooser = OSPRuntime.getChooser();
                FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
                n2 = fileFilterArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    FileFilter fileFilter = fileFilterArray[n3];
                    if (fileFilter.getDescription().toLowerCase().indexOf("xml") > -1) {
                        chooser.setFileFilter(fileFilter);
                        break;
                    }
                    ++n3;
                }
            }
            if ((n = chooser.showSaveDialog(this)) == 0) {
                OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                File file = chooser.getSelectedFile();
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                    return null;
                }
                return this.saveFits(file.getAbsolutePath());
            }
        }
        return null;
    }

    public String saveFits(String string) {
        if (string == null) {
            return this.saveFits();
        }
        if (XML.getExtension(string) == null) {
            string = String.valueOf(string) + ".xml";
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        xMLControlElement.write(string);
        return string;
    }

    @Override
    protected void refreshGUI() {
        Object object;
        super.refreshGUI();
        this.setTitle(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Title"));
        if (this.getPanelNames().isEmpty()) {
            object = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(object) + ":");
        }
        if (this.saveButton != null) {
            this.saveButton.setEnabled(!this.getPanelNames().isEmpty());
            this.loadButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Save.Tooltip"));
            this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty());
            this.newFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.deleteFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
            object = this.getSelectedCurveFitter();
            this.cloneFitButton.setEnabled(object != null);
        }
    }

    protected boolean chooseFitFunctions(XMLControl xMLControl, String string) {
        Object object2;
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DatasetCurveFitter.FitBuilder." + string + ".Title"), ToolsRes.getString("DatasetCurveFitter.FitBuilder." + string + ".Message"), this);
        ArrayList<XMLControl> arrayList = new ArrayList<XMLControl>();
        ArrayList<XMLControl> arrayList2 = new ArrayList<XMLControl>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (Object object2 : xMLControl.getPropertyContent()) {
            if (!(object2 instanceof XMLProperty)) continue;
            XMLProperty xMLProperty = (XMLProperty)object2;
            for (Object object3 : xMLProperty.getPropertyContent()) {
                if (!(object3 instanceof XMLProperty)) continue;
                XMLProperty xMLProperty2 = (XMLProperty)object3;
                XMLControl xMLControl2 = xMLProperty2.getChildControls()[0];
                arrayList.add(xMLControl2);
                arrayList2.add(xMLControl2);
                arrayList3.add(xMLControl2.getString("name"));
                String string2 = xMLControl2.getString("description");
                arrayList4.add(string2);
            }
        }
        object2 = new boolean[arrayList2.size()];
        int n = 0;
        while (n < ((Object)object2).length) {
            object2[n] = true;
            ++n;
        }
        if (listChooser.choose(arrayList2, arrayList3, arrayList4, (boolean[])object2)) {
            for (XMLControl xMLControl3 : arrayList) {
                Object object3;
                if (arrayList2.contains(xMLControl3)) continue;
                object3 = xMLControl3.getParentProperty();
                XMLProperty xMLProperty = object3.getParentProperty();
                xMLProperty.getPropertyContent().remove(object3);
            }
            return true;
        }
        return false;
    }
}

