/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolTable
extends DataTable {
    protected static final int RENAME_COLUMN_EDIT = 0;
    protected static final int INSERT_COLUMN_EDIT = 1;
    protected static final int DELETE_COLUMN_EDIT = 2;
    protected static final int INSERT_CELLS_EDIT = 3;
    protected static final int DELETE_CELLS_EDIT = 4;
    protected static final int REPLACE_CELLS_EDIT = 5;
    protected static final int INSERT_ROWS_EDIT = 6;
    protected static final int DELETE_ROWS_EDIT = 7;
    protected static String[] editTypes = new String[]{"rename column", "insert column", "delete column", "insert cells", "delete cells", "replace cells", "insert rows", "delete rows"};
    protected static Color xAxisColor = new Color(255, 255, 153);
    protected static Color yAxisColor = new Color(204, 255, 204);
    DataToolTab dataToolTab;
    DatasetManager dataManager;
    WorkingDataset workingData;
    HashMap<String, WorkingDataset> workingMap = new HashMap();
    HighlightableDataset selectedData = new HighlightableDataset();
    HeaderRenderer headerRenderer;
    LabelRenderer labelRenderer = new LabelRenderer();
    DataCellRenderer dataRenderer = new DataCellRenderer();
    DataEditor editor = new DataEditor();
    TreeSet<Integer> selectedRows = new TreeSet();
    TreeSet<Integer> selectedColumns = new TreeSet();
    JPopupMenu popup = new JPopupMenu();
    JMenuItem renameColumnItem;
    JMenuItem copyColumnsItem;
    JMenuItem cutColumnsItem;
    JMenuItem pasteColumnsItem;
    JMenuItem cloneColumnsItem;
    JMenuItem numberFormatItem;
    JMenuItem insertRowItem;
    JMenuItem pasteRowsItem;
    JMenuItem copyRowsItem;
    JMenuItem cutRowsItem;
    JMenuItem insertCellsItem;
    JMenuItem deleteCellsItem;
    JMenuItem copyCellsItem;
    JMenuItem cutCellsItem;
    JMenuItem pasteInsertCellsItem;
    JMenuItem pasteCellsItem;
    JMenuItem addEndRowItem;
    JMenuItem trimRowsItem;
    Action clearCellsAction;
    Action pasteCellsAction;
    Action pasteInsertCellsAction;
    Action cantPasteCellsAction;
    Action cantPasteRowsAction;
    Action getPasteDataAction;
    MouseAdapter tableMouseListener;
    Color selectedBG;
    Color selectedFG;
    Color unselectedBG;
    Color selectedHeaderFG;
    Color selectedHeaderBG;
    Color rowBG;
    int focusRow;
    int focusCol;
    int mouseRow;
    int mouseCol;
    int leadCol = 0;
    int leadRow = 0;
    int pasteW;
    int pasteH;
    HashMap<String, double[]> pasteValues = new HashMap();
    DatasetManager pasteData = null;
    HashMap<Integer, Integer> workingRows = new HashMap();

    public DataToolTable(DataToolTab dataToolTab) {
        super(new DataToolTableModel(dataToolTab));
        this.dataToolTab = dataToolTab;
        this.dataManager = dataToolTab.dataManager;
        this.add(this.dataManager);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
        this.headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataToolTable.this.selectedRows.clear();
                int[] nArray = DataToolTable.this.getSelectedRows();
                int n = 0;
                while (n < nArray.length) {
                    int n2 = DataToolTable.this.getModelRow(nArray[n]);
                    DataToolTable.this.selectedRows.add(n2);
                    ++n;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    n = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.addColumnSelectionInterval(n, n);
                    DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData());
                }
            }
        });
        listSelectionModel = this.getColumnModel().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataToolTable.this.getTableHeader().repaint();
            }
        });
        this.clearCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
                int[] nArray = DataToolTable.this.getSelectedModelRows();
                Iterator<String> iterator = DataToolTable.this.getSelectedColumnNames().iterator();
                while (iterator.hasNext()) {
                    hashMap.put(iterator.next(), null);
                }
                HashMap<String, double[]> hashMap2 = DataToolTable.this.replaceCells(nArray, hashMap);
                TableEdit tableEdit = new TableEdit(5, null, nArray, new HashMap[]{hashMap2, hashMap});
                DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                DataToolTable.this.refreshUndoItems();
            }
        };
        this.pasteCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent var1_1) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                var2_2 = DataToolTable.this.getSelectedModelRows();
                                if (DataToolTable.this.pasteValues.isEmpty() || var2_2.length != 1 && DataToolTable.this.pasteH != var2_2.length) break block2;
                                var3_3 = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != var2_2.length) break block3;
                                var3_3 = var2_2;
                                break block4;
                            }
                            var3_3[0] = var2_2[0];
                            var4_4 = DataToolTable.this.getViewRow(var2_2[0]);
                            var5_6 = 1;
                            ** GOTO lbl19
                            {
                                var6_8 = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(var6_8, null);
                                do {
                                    if (var4_4 + var5_6 >= DataToolTable.this.getRowCount()) continue block0;
                                    var3_3[var5_6] = DataToolTable.this.getModelRow(var4_4 + var5_6);
                                    ++var5_6;
lbl19:
                                    // 2 sources

                                } while (var5_6 < DataToolTable.this.pasteH);
                            }
                        }
                        var4_5 = DataToolTable.this.replaceCells(var3_3, DataToolTable.this.pasteValues);
                        var5_7 = new TableEdit(5, null, var3_3, new HashMap[]{var4_5, DataToolTable.this.pasteValues});
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(var5_7);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(var1_1);
                }
            }
        };
        this.pasteInsertCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent var1_1) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                var2_2 = DataToolTable.this.getSelectedModelRows();
                                if (DataToolTable.this.pasteValues.isEmpty() || var2_2.length != 1 && DataToolTable.this.pasteH != var2_2.length) break block2;
                                var3_3 = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != var2_2.length) break block3;
                                var3_3 = var2_2;
                                break block4;
                            }
                            var3_3[0] = var2_2[0];
                            var4_4 = DataToolTable.this.getViewRow(var2_2[0]);
                            var5_6 = 1;
                            ** GOTO lbl19
                            {
                                var6_7 = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(var6_7, null);
                                do {
                                    if (var4_4 + var5_6 >= DataToolTable.this.getRowCount()) continue block0;
                                    var3_3[var5_6] = DataToolTable.this.getModelRow(var4_4 + var5_6);
                                    ++var5_6;
lbl19:
                                    // 2 sources

                                } while (var5_6 < DataToolTable.this.pasteH);
                            }
                        }
                        DataToolTable.this.insertCells(var3_3, DataToolTable.this.pasteValues);
                        var4_5 = new TableEdit(3, null, var3_3, DataToolTable.this.pasteValues);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(var4_5);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(var1_1);
                }
            }
        };
        this.cantPasteCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message1")) + " " + DataToolTable.this.pasteW + " x " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.cantPasteRowsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message1")) + " " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.getPasteDataAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTable.this.pasteValues.clear();
                DataToolTable.this.pasteData = null;
                String string = DataTool.paste();
                ArrayList<String> arrayList = DataToolTable.this.getSelectedColumnNames();
                if (string != null) {
                    DataToolTable.this.pasteData = DataTool.parseData(string, null);
                    if (DataToolTable.this.pasteData != null) {
                        DataToolTable.this.pasteW = DataToolTable.this.pasteData.getDatasets().size();
                        if (DataToolTable.this.pasteW > 0 && DataToolTable.this.pasteW == arrayList.size()) {
                            DataToolTable.this.pasteH = DataToolTable.this.pasteData.getDataset(0).getXPoints().length;
                            if (DataToolTable.this.pasteH > 0) {
                                int n = 0;
                                while (n < DataToolTable.this.pasteW) {
                                    double[] dArray = DataToolTable.this.pasteData.getDataset(n).getYPoints();
                                    DataToolTable.this.pasteValues.put(arrayList.get(n), dArray);
                                    ++n;
                                }
                            }
                        }
                    }
                }
            }
        };
        this.getTableHeader().addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = DataToolTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                if ((n = DataToolTable.this.convertColumnIndexToModel(n)) == 0) {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Deselect.Tooltip"));
                } else {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Tooltip"));
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                Object object;
                if (DataToolTable.this.getRowCount() == 0) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n2 = DataToolTable.this.columnAtPoint(point);
                if (n2 == -1) {
                    return;
                }
                int n3 = DataToolTable.this.convertColumnIndexToView(0);
                ArrayList<String> arrayList = DataToolTable.this.getSelectedColumnNames();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    String string;
                    if (n2 == n3) {
                        return;
                    }
                    object = DataToolTable.this.getColumnName(n2);
                    if (!arrayList.contains(object)) {
                        DataToolTable.this.setColumnSelectionInterval(n2, n2);
                        DataToolTable.this.leadCol = n2;
                    }
                    DataToolTable.this.setRowSelectionInterval(0, DataToolTable.this.getRowCount() - 1);
                    DataToolTable.this.popup.removeAll();
                    arrayList = DataToolTable.this.getSelectedColumnNames();
                    if (arrayList.size() == 1 && DataToolTable.this.dataToolTab.userEditable) {
                        n = DataToolTable.this.convertColumnIndexToModel(n2) - 1;
                        final Dataset object2 = DataToolTable.this.dataManager.getDataset(n);
                        string = ToolsRes.getString("DataToolTable.Popup.MenuItem.RenameColumn");
                        DataToolTable.this.renameColumnItem = new JMenuItem(string);
                        DataToolTable.this.renameColumnItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (object2 instanceof DataFunction) {
                                    DataToolTable.this.showDataBuilder();
                                    return;
                                }
                                String string = object2.getYColumnName();
                                Object object = JOptionPane.showInputDialog((this).DataToolTable.this.dataToolTab, ToolsRes.getString("DataToolTable.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTable.Dialog.NameColumn.Title"), 3, null, null, string);
                                if (object == null || object.equals("")) {
                                    return;
                                }
                                String string2 = (this).DataToolTable.this.dataToolTab.getUniqueYColumnName(object2, object.toString(), true);
                                if (string2 == null) {
                                    return;
                                }
                                int n = string2.indexOf("}");
                                if (n == 0) {
                                    return;
                                }
                                if (n > -1) {
                                    string2 = string2.substring(0, n + 1);
                                }
                                DataToolTable.this.renameColumn(string, string2);
                                TableEdit tableEdit = new TableEdit(0, string2, null, string);
                                (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.renameColumnItem);
                        DataToolTable.this.popup.addSeparator();
                    }
                    string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyColumns");
                    DataToolTable.this.copyColumnsItem = new JMenuItem(string);
                    DataToolTable.this.copyColumnsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            (this).DataToolTable.this.dataToolTab.copyTableDataToClipboard();
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.copyColumnsItem);
                    n = 1;
                    for (String string2 : arrayList) {
                        if (DataToolTable.this.dataToolTab.isDeletable(DataToolTable.this.getDataset(string2))) continue;
                        n = 0;
                    }
                    if (n != 0) {
                        string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutColumns");
                        DataToolTable.this.cutColumnsItem = new JMenuItem(string);
                        DataToolTable.this.cutColumnsItem.setActionCommand(String.valueOf(n2));
                        DataToolTable.this.cutColumnsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                (this).DataToolTable.this.copyColumnsItem.doClick();
                                DataToolTable.this.deleteSelectedColumns();
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.cutColumnsItem);
                    }
                    if (DataToolTable.this.dataToolTab != null && DataToolTable.this.dataToolTab.dataTool != null && DataToolTable.this.dataToolTab.dataTool.hasPastableData() && DataToolTable.this.dataToolTab.dataTool.hasPastableColumns(DataToolTable.this.dataToolTab)) {
                        string = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteColumns");
                        DataToolTable.this.pasteColumnsItem = new JMenuItem(string);
                        DataToolTable.this.pasteColumnsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                (this).DataToolTable.this.dataToolTab.dataTool.pasteColumnsItem.doClick(0);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.pasteColumnsItem);
                    }
                    DataToolTable.this.popup.addSeparator();
                    string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CloneColumns");
                    DataToolTable.this.cloneColumnsItem = new JMenuItem(string);
                    DataToolTable.this.cloneColumnsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ArrayList<String> arrayList = DataToolTable.this.getSelectedColumnNames();
                            int n = 0;
                            while (n < arrayList.size()) {
                                Dataset dataset = DataToolTable.this.getDataset(arrayList.get(n));
                                if (dataset != null) {
                                    Dataset dataset2 = DataTool.copyDataset(dataset, null, false);
                                    double[] dArray = dataset.getXPoints();
                                    double[] dArray2 = dataset.getYPoints();
                                    dataset2.append(dArray, dArray2);
                                    String string = dataset.getYColumnName();
                                    String string2 = "_" + ToolsRes.getString("DataTool.Clone.Subscript");
                                    int n2 = string.indexOf(string2);
                                    if (n2 > -1) {
                                        string = string.substring(0, n2);
                                    }
                                    string = String.valueOf(string) + string2;
                                    string = (this).DataToolTable.this.dataToolTab.getUniqueYColumnName(dataset2, string, false);
                                    dataset2.setXYColumnNames(dataset.getXColumnName(), string);
                                    ArrayList<DataColumn> arrayList2 = (this).DataToolTable.this.dataToolTab.loadData(dataset2, false);
                                    if (!arrayList2.isEmpty()) {
                                        for (DataColumn dataColumn : arrayList2) {
                                            dataColumn.deletable = true;
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.cloneColumnsItem);
                    DataToolTable.this.popup.addSeparator();
                    string = ToolsRes.getString("DataToolTable.Popup.MenuItem.NumberFormat");
                    DataToolTable.this.numberFormatItem = new JMenuItem(string);
                    DataToolTable.this.numberFormatItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String[] stringArray;
                            int n = DataToolTable.this.getColumnCount();
                            String[] stringArray2 = new String[n - 1];
                            int n2 = DataToolTable.this.convertColumnIndexToView(0);
                            int n3 = 0;
                            int n4 = 0;
                            while (n4 < n) {
                                if (n4 != n2) {
                                    stringArray2[n3] = stringArray = DataToolTable.this.getColumnName(n4);
                                    ++n3;
                                }
                                ++n4;
                            }
                            ArrayList<String> arrayList = DataToolTable.this.getSelectedColumnNames();
                            stringArray = new String[arrayList.size()];
                            int n5 = 0;
                            while (n5 < stringArray.length) {
                                stringArray[n5] = arrayList.get(n5);
                                ++n5;
                            }
                            DataTable.NumberFormatDialog numberFormatDialog = DataToolTable.this.getFormatDialog(stringArray2, stringArray);
                            numberFormatDialog.setVisible(true);
                            (this).DataToolTable.this.dataToolTab.refreshPlot();
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.numberFormatItem);
                    FontSizer.setFonts(DataToolTable.this.popup, DataToolTable.this.dataToolTab.fontLevel);
                    DataToolTable.this.popup.show(DataToolTable.this.getTableHeader(), mouseEvent.getX(), mouseEvent.getY() + 8);
                } else if (mouseEvent.getClickCount() == 2) {
                    if (n2 == n3) {
                        DataToolTable.this.selectAll();
                    } else {
                        DataToolTable.this.setRowSelectionInterval(0, DataToolTable.this.getRowCount() - 1);
                        DataToolTable.this.setColumnSelectionInterval(n2, n2);
                        DataToolTable.this.leadCol = n2;
                    }
                    DataToolTable.this.sort(0);
                } else if (n2 != n3 || DataToolTable.this.getSortedColumn() != n2) {
                    if (mouseEvent.isControlDown()) {
                        if (n2 != n3 && DataToolTable.this.isColumnSelected(n2)) {
                            DataToolTable.this.removeColumnSelectionInterval(n2, n2);
                        } else {
                            if (!DataToolTable.this.selectedRows.isEmpty()) {
                                DataToolTable.this.addColumnSelectionInterval(n2, n2);
                            }
                            if (DataToolTable.this.getSelectedColumns().length == 1) {
                                DataToolTable.this.leadCol = n2;
                            }
                        }
                    } else if (mouseEvent.isShiftDown() && !DataToolTable.this.selectedRows.isEmpty()) {
                        if (DataToolTable.this.leadCol < DataToolTable.this.getColumnCount()) {
                            DataToolTable.this.setColumnSelectionInterval(n2, DataToolTable.this.leadCol);
                        }
                    } else {
                        object = DataToolTable.this.getSelectedModelRows();
                        DataToolTable.this.setSelectedModelRows((int[])object);
                    }
                }
                DataToolTable.this.getSelectedData();
                DataToolTable.this.addColumnSelectionInterval(n3, n3);
                DataToolTable.this.selectedColumns.clear();
                object = DataToolTable.this.getSelectedColumns();
                int n4 = 0;
                while (n4 < ((Object)object).length) {
                    if (object[n4] != n3) {
                        n = DataToolTable.this.convertColumnIndexToModel((int)object[n4]);
                        DataToolTable.this.selectedColumns.add(n);
                    }
                    ++n4;
                }
                if (DataToolTable.this.selectedColumns.isEmpty()) {
                    DataToolTable.this.clearSelection();
                }
            }
        });
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!DataToolTable.this.popup.isVisible()) {
                    int n = DataToolTable.this.rowAtPoint(mouseEvent.getPoint());
                    int n2 = DataToolTable.this.columnAtPoint(mouseEvent.getPoint());
                    int n3 = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.mouseRow = n;
                    DataToolTable.this.mouseCol = n2;
                    DataToolTable.this.dataRenderer.showFocus = n2 == n3;
                    DataToolTable.this.repaint();
                    if (n2 == n3) {
                        DataToolTable.this.dataRenderer.showFocus = true;
                        DataToolTable.this.setToolTipText(ToolsRes.getString("DataToolTable.Deselect.Tooltip"));
                    } else {
                        Object object = DataToolTable.this.getValueAt(n, n2);
                        String string = DataToolTable.this.getColumnName(n2);
                        DataToolTable.this.setToolTipText(String.valueOf(string) + " = " + object);
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                int n2 = DataToolTable.this.columnAtPoint(mouseEvent.getPoint());
                DataToolTable.this.mouseRow = n = DataToolTable.this.rowAtPoint(mouseEvent.getPoint());
                DataToolTable.this.mouseCol = n2;
                int n3 = DataToolTable.this.convertColumnIndexToView(0);
                if (n2 == n3) {
                    if (DataToolTable.this.leadRow < DataToolTable.this.getRowCount()) {
                        DataToolTable.this.setRowSelectionInterval(DataToolTable.this.leadRow, n);
                    }
                    DataToolTable.this.setColumnSelectionInterval(DataToolTable.this.getColumnCount() - 1, 0);
                }
                DataToolTable.this.dataRenderer.showFocus = false;
                DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData());
                DataToolTable.this.dataToolTab.plot.repaint();
            }
        });
        this.tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!DataToolTable.this.popup.isVisible()) {
                    DataToolTable.this.mouseRow = -1;
                    DataToolTable.this.dataRenderer.showFocus = true;
                    DataToolTable.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2 = DataToolTable.this.columnAtPoint(mouseEvent.getPoint());
                int n3 = DataToolTable.this.rowAtPoint(mouseEvent.getPoint());
                int n4 = DataToolTable.this.convertColumnIndexToView(0);
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    DataToolTable.this.editor.stopCellEditing();
                    if (n2 == n4) {
                        if (!DataToolTable.this.isRowSelected(n3)) {
                            DataToolTable.this.setRowSelectionInterval(n3, n3);
                        }
                        DataToolTable.this.setColumnSelectionInterval(0, DataToolTable.this.getColumnCount() - 1);
                    } else if (!DataToolTable.this.isCellSelected(n3, n2)) {
                        DataToolTable.this.setRowSelectionInterval(n3, n3);
                        DataToolTable.this.setColumnSelectionInterval(n2, n2);
                        DataToolTable.this.leadCol = n2;
                        DataToolTable.this.leadRow = n3;
                    }
                    DataToolTable.this.repaint();
                    DataToolTable.this.getPasteDataAction.actionPerformed(null);
                    final int[] nArray = DataToolTable.this.getSelectedModelRows();
                    boolean bl = true;
                    int[] nArray2 = DataToolTable.this.getSelectedRows();
                    ArrayList<String> arrayList = DataToolTable.this.getSelectedColumnNames();
                    int n5 = 0;
                    while (n5 < nArray2.length) {
                        if (!DataToolTable.this.isEmptyCells(nArray2[n5], arrayList)) {
                            bl = false;
                            break;
                        }
                        ++n5;
                    }
                    DataToolTable.this.popup.removeAll();
                    if (n2 != n4) {
                        int n6 = DataToolTable.this.convertColumnIndexToModel(n2) - 1;
                        Dataset dataset = DataToolTable.this.dataManager.getDataset(n6);
                        DataToolTable.this.mouseRow = n3;
                        DataToolTable.this.mouseCol = n2;
                        DataToolTable.this.repaint();
                        if (DataToolTable.this.dataToolTab.userEditable && !(dataset instanceof DataFunction)) {
                            String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertCells");
                            DataToolTable.this.insertCellsItem = new JMenuItem(string);
                            DataToolTable.this.insertCellsItem.setActionCommand(String.valueOf(n2));
                            DataToolTable.this.insertCellsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
                                    Iterator<String> iterator = DataToolTable.this.getSelectedColumnNames().iterator();
                                    while (iterator.hasNext()) {
                                        hashMap.put(iterator.next(), null);
                                    }
                                    DataToolTable.this.insertCells(nArray, hashMap);
                                    TableEdit tableEdit = new TableEdit(3, null, nArray, hashMap);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.insertCellsItem);
                            if (DataToolTable.this.pasteData != null) {
                                string = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertCells");
                                DataToolTable.this.pasteInsertCellsItem = new JMenuItem(string);
                                DataToolTable.this.pasteInsertCellsItem.setActionCommand(String.valueOf(n2));
                                DataToolTable.this.pasteInsertCellsItem.addActionListener(DataToolTable.this.pasteInsertCellsAction);
                                DataToolTable.this.popup.add(DataToolTable.this.pasteInsertCellsItem);
                            }
                            string = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteCells");
                            DataToolTable.this.deleteCellsItem = new JMenuItem(string);
                            DataToolTable.this.deleteCellsItem.setActionCommand(String.valueOf(n2));
                            DataToolTable.this.deleteCellsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    Iterator<String> iterator = DataToolTable.this.getSelectedColumnNames().iterator();
                                    while (iterator.hasNext()) {
                                        (this).DataToolTable.this.pasteValues.put(iterator.next(), null);
                                    }
                                    HashMap<String, double[]> hashMap = DataToolTable.this.deleteCells(nArray, (this).DataToolTable.this.pasteValues);
                                    TableEdit tableEdit = new TableEdit(4, null, nArray, hashMap);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.deleteCellsItem);
                        }
                        if (!bl || DataToolTable.this.pasteData != null) {
                            if (DataToolTable.this.popup.getComponentCount() > 0) {
                                DataToolTable.this.popup.addSeparator();
                            }
                            if (!bl) {
                                String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyCells");
                                DataToolTable.this.copyCellsItem = new JMenuItem(string);
                                DataToolTable.this.copyCellsItem.setActionCommand(String.valueOf(n2));
                                DataToolTable.this.copyCellsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        (this).DataToolTable.this.dataToolTab.copyTableDataToClipboard();
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.copyCellsItem);
                                if (DataToolTable.this.dataToolTab.userEditable && !(dataset instanceof DataFunction)) {
                                    string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutCells");
                                    DataToolTable.this.cutCellsItem = new JMenuItem(string);
                                    DataToolTable.this.cutCellsItem.setActionCommand(String.valueOf(n2));
                                    DataToolTable.this.cutCellsItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            (this).DataToolTable.this.copyCellsItem.doClick();
                                            (this).DataToolTable.this.clearCellsAction.actionPerformed(actionEvent);
                                        }
                                    });
                                    DataToolTable.this.popup.add(DataToolTable.this.cutCellsItem);
                                }
                            }
                            if (DataToolTable.this.dataToolTab.userEditable && DataToolTable.this.pasteData != null) {
                                String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteCells");
                                DataToolTable.this.pasteCellsItem = new JMenuItem(string);
                                DataToolTable.this.pasteCellsItem.setActionCommand(String.valueOf(n2));
                                DataToolTable.this.pasteCellsItem.addActionListener(DataToolTable.this.pasteCellsAction);
                                DataToolTable.this.popup.add(DataToolTable.this.pasteCellsItem);
                            }
                        }
                    } else {
                        DataToolTable.this.leadRow = n3;
                        if (DataToolTable.this.dataToolTab.userEditable) {
                            boolean bl2;
                            String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertRows");
                            DataToolTable.this.insertRowItem = new JMenuItem(string);
                            DataToolTable.this.insertRowItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    HashMap<String, double[]> hashMap = DataToolTable.this.insertRows(nArray, null);
                                    TableEdit tableEdit = new TableEdit(6, null, nArray, hashMap);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.insertRowItem);
                            boolean bl3 = bl2 = !DataToolTable.this.pasteValues.isEmpty();
                            if (bl2) {
                                for (String string2 : DataToolTable.this.pasteValues.keySet()) {
                                    boolean bl4 = bl2 = bl2 && DataToolTable.this.pasteData.getDatasetIndex(string2) > -1;
                                }
                            }
                            if (bl2) {
                                string = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertRows");
                                DataToolTable.this.pasteRowsItem = new JMenuItem(string);
                                DataToolTable.this.pasteRowsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (nArray.length != 1 && (this).DataToolTable.this.pasteH != nArray.length) {
                                            (this).DataToolTable.this.cantPasteRowsAction.actionPerformed(actionEvent);
                                            return;
                                        }
                                        int[] nArray2 = new int[(this).DataToolTable.this.pasteH];
                                        if ((this).DataToolTable.this.pasteH == nArray.length) {
                                            nArray2 = nArray;
                                        } else if (nArray.length == 1) {
                                            nArray2[0] = nArray[0];
                                            int n = 1;
                                            while (n < (this).DataToolTable.this.pasteH) {
                                                nArray2[n] = nArray[0] + n;
                                                ++n;
                                            }
                                        }
                                        DataToolTable.this.insertRows(nArray2, (this).DataToolTable.this.pasteValues);
                                        TableEdit tableEdit = new TableEdit(6, null, nArray2, (this).DataToolTable.this.pasteValues);
                                        (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                                        DataToolTable.this.refreshUndoItems();
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.pasteRowsItem);
                            }
                            DataToolTable.this.popup.addSeparator();
                        }
                        String string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyRows");
                        DataToolTable.this.copyRowsItem = new JMenuItem(string);
                        DataToolTable.this.copyRowsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                OSPLog.finest("copying rows");
                                String string = (this).DataToolTable.this.dataToolTab.getSelectedTableData();
                                DataTool.copy(string);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.copyRowsItem);
                        if (DataToolTable.this.dataToolTab.userEditable) {
                            string = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutRows");
                            DataToolTable.this.cutRowsItem = new JMenuItem(string);
                            DataToolTable.this.cutRowsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    (this).DataToolTable.this.copyRowsItem.doClick();
                                    int[] nArray = DataToolTable.this.getSelectedModelRows();
                                    HashMap<String, double[]> hashMap = DataToolTable.this.deleteRows(nArray);
                                    TableEdit tableEdit = new TableEdit(7, null, nArray, hashMap);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(tableEdit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.cutRowsItem);
                            DataToolTable.this.popup.addSeparator();
                            string = ToolsRes.getString("DataToolTable.Popup.MenuItem.AddEndRow");
                            DataToolTable.this.addEndRowItem = new JMenuItem(string);
                            DataToolTable.this.addEndRowItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    DataToolTable.this.insertRows(new int[]{DataToolTable.this.getRowCount()}, null);
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.addEndRowItem);
                            if (DataToolTable.this.isEmptyRow(DataToolTable.this.getRowCount() - 1)) {
                                string = ToolsRes.getString("DataToolTable.Popup.MenuItem.TrimRows");
                                DataToolTable.this.trimRowsItem = new JMenuItem(string);
                                DataToolTable.this.trimRowsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        DataToolTable.this.trimEmptyRows(0);
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.trimRowsItem);
                            }
                        }
                    }
                    FontSizer.setFonts(DataToolTable.this.popup, DataToolTable.this.dataToolTab.fontLevel);
                    DataToolTable.this.popup.show(DataToolTable.this, mouseEvent.getX(), mouseEvent.getY() + 8);
                    return;
                }
                DataToolTable.this.dataRenderer.showFocus = true;
                if (n2 == n4) {
                    if (mouseEvent.getClickCount() == 2) {
                        DataToolTable.this.leadRow = n3;
                        DataToolTable.this.setRowSelectionInterval(n3, n3);
                        DataToolTable.this.setColumnSelectionInterval(0, DataToolTable.this.getColumnCount() - 1);
                    } else if (mouseEvent.isShiftDown() && DataToolTable.this.leadRow < DataToolTable.this.getRowCount()) {
                        DataToolTable.this.setRowSelectionInterval(DataToolTable.this.leadRow, n3);
                        for (int n7 : DataToolTable.this.selectedColumns) {
                            n = DataToolTable.this.convertColumnIndexToView(n7);
                            DataToolTable.this.addColumnSelectionInterval(n, n);
                        }
                    } else if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        DataToolTable.this.clearSelection();
                        DataToolTable.this.leadRow = 0;
                        DataToolTable.this.leadCol = 1;
                    }
                } else if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    DataToolTable.this.leadRow = n3;
                    DataToolTable.this.leadCol = n2;
                }
                DataToolTable.this.getSelectedData();
                DataToolTable.this.dataToolTab.plot.repaint();
                DataToolTable.this.addColumnSelectionInterval(n4, n4);
                DataToolTable.this.selectedColumns.clear();
                int[] nArray = DataToolTable.this.getSelectedColumns();
                int n8 = 0;
                while (n8 < nArray.length) {
                    if (nArray[n8] != n4) {
                        n = DataToolTable.this.convertColumnIndexToModel(nArray[n8]);
                        DataToolTable.this.selectedColumns.add(n);
                    }
                    ++n8;
                }
                if (DataToolTable.this.selectedColumns.isEmpty() || DataToolTable.this.selectedRows.isEmpty()) {
                    DataToolTable.this.clearSelection();
                }
            }
        };
        this.addMouseListener(this.tableMouseListener);
        InputMap inputMap = this.getInputMap(1);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTable.this.editCellAt(DataToolTable.this.focusRow, DataToolTable.this.focusCol, actionEvent);
                DataToolTable.this.editor.field.requestFocus();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTable.this.dataToolTab.copyTableDataToClipboard();
            }
        };
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, n);
        this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTable.this.getPasteDataAction.actionPerformed(actionEvent);
                DataToolTable.this.pasteCellsAction.actionPerformed(actionEvent);
            }
        };
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(86, n);
        this.getActionMap().put(inputMap.get(keyStroke3), abstractAction3);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(keyStroke4, this.clearCellsAction);
        this.getActionMap().put(inputMap.get(keyStroke4), this.clearCellsAction);
    }

    protected WorkingDataset getWorkingData(String string) {
        int n;
        String string2;
        Dataset dataset;
        if (string == null) {
            return null;
        }
        WorkingDataset workingDataset = this.workingMap.get(string);
        if (workingDataset == null) {
            Dataset dataset2 = this.getDataset(string);
            if (dataset2 == null) {
                return null;
            }
            workingDataset = new WorkingDataset(dataset2);
            if (dataset2.getMarkerShape() == 0) {
                dataset2.setMarkerShape(2);
                workingDataset.setMarkersVisible(false);
            }
            this.workingMap.put(string, workingDataset);
        }
        if ((dataset = this.getDataset(string2 = this.getColumnName((n = this.convertColumnIndexToView(0)) == 0 ? 1 : 0))) == null) {
            return null;
        }
        workingDataset.setXSource(dataset);
        Dataset dataset3 = workingDataset.getYSource();
        workingDataset.setMarkerColor(dataset3.getFillColor(), dataset3.getEdgeColor());
        workingDataset.setMarkerSize(dataset3.getMarkerSize());
        workingDataset.markerType = dataset3.getMarkerShape();
        workingDataset.setLineColor(dataset3.getLineColor());
        workingDataset.setConnected(dataset3.isConnected());
        return workingDataset;
    }

    protected WorkingDataset getWorkingData() {
        int n = this.dataManager.getDatasets().size();
        if (n < 2) {
            this.workingData = null;
        } else {
            int n2 = this.convertColumnIndexToView(0);
            int n3 = n2 < 2 ? 2 : 1;
            String string = this.getColumnName(n3);
            this.workingData = this.getWorkingData(string);
        }
        return this.workingData;
    }

    protected void removeWorkingData(String string) {
        if (string == null) {
            return;
        }
        this.workingMap.remove(string);
        this.setFormatPattern(string, null);
        this.refreshTable();
    }

    protected void deleteSelectedColumns() {
        ArrayList<String> arrayList = this.getSelectedColumnNames();
        int[] nArray = this.getSelectedColumns();
        int n = arrayList.size() - 1;
        while (n > -1) {
            Dataset dataset;
            String string = arrayList.get(n);
            Dataset dataset2 = this.getDataset(string);
            if (this.dataToolTab.isDeletable(dataset2) && (dataset = this.deleteColumn(string)) != null) {
                Integer n2 = new Integer(nArray[n]);
                TableEdit tableEdit = new TableEdit(2, string, n2, dataset);
                this.dataToolTab.undoSupport.postEdit(tableEdit);
            }
            --n;
        }
        this.refreshUndoItems();
    }

    protected void clearWorkingData() {
        Iterator<String> iterator = this.workingMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            this.setFormatPattern(string, null);
        }
        this.workingMap.clear();
        this.refreshTable();
    }

    protected Dataset getDataset(String string) {
        int n = this.dataManager.getDatasetIndex(string);
        if (n > -1) {
            return this.dataManager.getDataset(n);
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (!dataset.getYColumnName().equals(string)) continue;
            return dataset;
        }
        return null;
    }

    protected HighlightableDataset getSelectedData() {
        double[] dArray;
        double[] dArray2;
        if (this.getWorkingData() == null) {
            return null;
        }
        double[] dArray3 = this.workingData.getXSource().getYPoints();
        double[] dArray4 = this.workingData.getYSource().getYPoints();
        int n = 0;
        int n2 = 0;
        while (n2 < dArray3.length) {
            if (!Double.isNaN(dArray3[n2])) {
                this.workingRows.put(new Integer(n++), new Integer(n2));
            }
            ++n2;
        }
        this.workingData.clearHighlights();
        n2 = this.convertColumnIndexToView(0);
        int n3 = n2 == 0 ? 1 : 0;
        int n4 = n2 < 2 ? 2 : 1;
        int[] nArray = this.getSelectedColumns();
        boolean bl = false;
        int n5 = 0;
        while (n5 < nArray.length) {
            bl = bl || nArray[n5] == n3 || nArray[n5] == n4;
            ++n5;
        }
        if (!bl || this.getSelectedRowCount() == 0) {
            dArray2 = dArray3;
            dArray = new double[dArray3.length];
            n5 = 0;
            while (n5 < dArray.length) {
                dArray[n5] = n5 < dArray4.length ? dArray4[n5] : Double.NaN;
                ++n5;
            }
        } else {
            dArray2 = new double[this.selectedRows.size()];
            dArray = new double[this.selectedRows.size()];
            n5 = 0;
            int n6 = 0;
            n = -1;
            for (int n7 : this.selectedRows) {
                dArray2[n5] = n7 >= dArray3.length ? Double.NaN : dArray3[n7];
                dArray[n5] = n7 >= dArray4.length ? Double.NaN : dArray4[n7];
                ++n5;
                while (n6 <= n7) {
                    if (n6 < dArray3.length && !Double.isNaN(dArray3[n6])) {
                        ++n;
                    }
                    ++n6;
                }
                if (n <= -1 || n6 > dArray3.length || Double.isNaN(dArray3[n6 - 1])) continue;
                this.workingData.setHighlighted(n, true);
            }
        }
        DataTool.copyDataset(this.workingData, this.selectedData, false);
        this.selectedData.clear();
        this.selectedData.append(dArray2, dArray);
        return this.selectedData;
    }

    protected int getModelRow(int n) {
        int n2 = this.convertColumnIndexToView(0);
        return (Integer)this.getValueAt(n, n2);
    }

    protected int getViewRow(int n) {
        int n2 = this.convertColumnIndexToView(0);
        int n3 = 0;
        while (n3 < this.getRowCount()) {
            if (n == (Integer)this.getValueAt(n3, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected int[] getSelectedModelRows() {
        Integer[] integerArray = this.selectedRows.toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            nArray[n] = integerArray[n];
            ++n;
        }
        return nArray;
    }

    protected void setSelectedModelRows(int[] nArray) {
        if (this.getRowCount() < 1) {
            return;
        }
        this.removeRowSelectionInterval(0, this.getRowCount() - 1);
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.getViewRow(nArray[n]);
            if (n2 > -1) {
                this.addRowSelectionInterval(n2, n2);
            }
            ++n;
        }
    }

    protected ArrayList<String> getSelectedColumnNames() {
        int[] nArray = this.getSelectedColumns();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.convertColumnIndexToModel(nArray[n]) - 1;
            if (n2 >= 0) {
                String string = this.dataManager.getDataset(n2).getYColumnName();
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    protected void setSelectedColumnNames(Collection<String> collection) {
        if (this.getColumnCount() < 1) {
            return;
        }
        this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        for (String string : collection) {
            int n = this.dataManager.getDatasetIndex(string);
            if (n == -1) continue;
            int n2 = this.convertColumnIndexToView(n + 1);
            this.addColumnSelectionInterval(n2, n2);
        }
    }

    protected void insertColumn(Dataset dataset, int n) {
        dataset.setXColumnVisible(false);
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        int n2 = arrayList.size();
        if (n2 == 0) {
            this.dataToolTab.originatorID = dataset.getID();
        }
        int n3 = n2 + 1;
        int n4 = n2 + 1;
        int[] nArray = this.getSelectedModelRows();
        ArrayList<String> arrayList2 = this.getSelectedColumnNames();
        this.clearSelection();
        TableModel tableModel = this.getModel();
        int n5 = tableModel.getColumnCount();
        int[] nArray2 = new int[n5 + 1];
        nArray2[n] = n3;
        int n6 = 0;
        while (n6 < tableModel.getColumnCount()) {
            int n7 = this.convertColumnIndexToModel(n6);
            if (n7 != n3) {
                int n8 = n6;
                if (n6 < n4) {
                    if (n6 >= n) {
                        ++n8;
                    }
                } else if (n6 <= n) {
                    --n8;
                }
                nArray2[n8] = n7;
            }
            ++n6;
        }
        if (dataset instanceof DataFunction) {
            FunctionTool functionTool = this.dataToolTab.getDataBuilder();
            FunctionPanel functionPanel = functionTool.getPanel(this.dataToolTab.getName());
            String string = functionPanel.undoManager.getPresentationName();
            if (functionPanel.undoManager.canUndo() && string.equals("Deletion")) {
                functionPanel.undoManager.undo();
            }
        } else {
            this.dataManager.addDataset(dataset);
            this.getWorkingData(dataset.getYColumnName());
        }
        DataToolTable.super.refreshTable();
        int n9 = 0;
        while (n9 < nArray2.length) {
            int n10 = n9;
            while (n10 < nArray2.length) {
                if (this.convertColumnIndexToModel(n10) == nArray2[n9]) {
                    if (n10 == n9) break;
                    this.moveColumn(n10, n9);
                    break;
                }
                ++n10;
            }
            ++n9;
        }
        if (nArray.length == 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
        } else {
            this.setSelectedModelRows(nArray);
        }
        arrayList2.add(dataset.getYColumnName());
        this.setSelectedColumnNames(arrayList2);
        this.refreshTable();
        this.refreshDataFunctions();
        this.dataToolTab.statsTable.refreshStatistics();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
    }

    protected Dataset deleteColumn(String string) {
        boolean bl;
        int n = this.dataManager.getDatasetIndex(string);
        int n2 = this.convertColumnIndexToView(n + 1);
        Dataset dataset = this.dataManager.getDataset(n);
        boolean bl2 = bl = this.getSortedColumn() == n + 1;
        if (bl) {
            this.sort(0);
        }
        int[] nArray = this.getSelectedModelRows();
        ArrayList<String> arrayList = this.getSelectedColumnNames();
        this.clearSelection();
        TableModel tableModel = this.getModel();
        int[] nArray2 = new int[tableModel.getColumnCount() - 1];
        int n3 = -1;
        int n4 = 0;
        while (n4 < tableModel.getColumnCount()) {
            if (n4 != n2) {
                ++n3;
                int n5 = this.convertColumnIndexToModel(n4);
                if (n5 > n + 1) {
                    // empty if block
                }
                nArray2[n3] = --n5;
            }
            ++n4;
        }
        if (dataset instanceof DataFunction) {
            FunctionTool functionTool = this.dataToolTab.getDataBuilder();
            FunctionPanel functionPanel = functionTool.getPanel(this.dataToolTab.getName());
            functionPanel.functionEditor.removeObject(dataset, true);
        } else {
            this.dataManager.removeDataset(n);
            this.workingMap.remove(string);
        }
        if (this.dataManager.getDatasets().isEmpty()) {
            this.dataToolTab.originatorID = 0;
            this.tableChanged(new TableModelEvent(this.getModel(), -1));
            this.dataToolTab.refreshGUI();
        } else {
            DataToolTable.super.refreshTable();
            int n6 = 0;
            while (n6 < nArray2.length) {
                int n7 = n6;
                while (n7 < nArray2.length) {
                    if (this.convertColumnIndexToModel(n7) == nArray2[n6]) {
                        if (n7 == n6) break;
                        this.moveColumn(n7, n6);
                        break;
                    }
                    ++n7;
                }
                ++n6;
            }
            if (arrayList.size() != 1 || !arrayList.contains(string)) {
                this.setSelectedModelRows(nArray);
                this.setSelectedColumnNames(arrayList);
            }
        }
        this.refreshTable();
        this.refreshDataFunctions();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
        this.dataToolTab.varPopup = null;
        return dataset;
    }

    protected HashMap<String, double[]> insertCells(int[] nArray, HashMap<String, double[]> hashMap) {
        int n = this.getRowCount();
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = n + n2;
            ++n2;
        }
        int[] nArray3 = new int[hashMap.keySet().size()];
        int n3 = 0;
        HashMap<String, double[]> hashMap2 = new HashMap<String, double[]>();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            String string = dataset.getYColumnName();
            if (hashMap.keySet().contains(string)) {
                double[] dArray = hashMap.get(string);
                dArray = this.insertPoints(dataset, nArray, dArray);
                hashMap2.put(string, dArray);
                int n4 = this.dataManager.getDatasetIndex(string);
                nArray3[n3++] = this.convertColumnIndexToView(n4 + 1);
                continue;
            }
            this.insertPoints(dataset, nArray2, null);
        }
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedModelRows(nArray);
        this.setSelectedColumnNames(hashMap.keySet());
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return hashMap2;
    }

    protected HashMap<String, double[]> deleteCells(int[] nArray, HashMap<String, double[]> hashMap) {
        int n = this.getRowCount() - nArray.length;
        HashMap<String, double[]> hashMap2 = new HashMap<String, double[]>();
        for (String string : hashMap.keySet()) {
            int n2 = this.dataManager.getDatasetIndex(string);
            Dataset dataset = this.dataManager.getDataset(n2);
            double[] dArray = this.deletePoints(dataset, nArray);
            hashMap2.put(string, dArray);
            int[] nArray2 = new int[nArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray2[n3] = n + n3;
                ++n3;
            }
            this.insertPoints(dataset, nArray2, null);
        }
        this.trimEmptyRows(n - 1);
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedColumnNames(hashMap.keySet());
        this.setSelectedModelRows(nArray);
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return hashMap2;
    }

    protected HashMap<String, double[]> replaceCells(int[] nArray, HashMap<String, double[]> hashMap) {
        int[] nArray2 = new int[hashMap.keySet().size()];
        HashMap<String, double[]> hashMap2 = new HashMap<String, double[]>();
        Iterator<String> iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            double[] dArray = hashMap.get(string);
            int n2 = this.dataManager.getDatasetIndex(string);
            Dataset dataset = this.dataManager.getDataset(n2);
            double[] dArray2 = this.replacePoints(dataset, nArray, dArray);
            hashMap2.put(string, dArray2);
            nArray2[n++] = this.convertColumnIndexToView(n2 + 1);
        }
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedModelRows(nArray);
        this.setSelectedColumnNames(hashMap.keySet());
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return hashMap2;
    }

    protected HashMap<String, double[]> insertRows(int[] nArray, HashMap<String, double[]> hashMap) {
        Object object;
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        int n = 0;
        while (n < arrayList.size()) {
            Dataset dataset = arrayList.get(n);
            object = dataset.getYColumnName();
            if (!hashMap.keySet().contains(object)) {
                hashMap.put((String)object, null);
            }
            ++n;
        }
        hashMap = this.insertCells(nArray, hashMap);
        n = this.getModelRow(this.getRowCount() - 1);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                object = this.getVisibleRect();
                ((Rectangle)object).y = this.getSize().height - ((Rectangle)object).height + this.getRowHeight();
                this.scrollRectToVisible((Rectangle)object);
                break;
            }
            ++n2;
        }
        return hashMap;
    }

    protected HashMap<String, double[]> deleteRows(int[] nArray) {
        HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray = this.deletePoints(dataset, nArray);
            hashMap.put(dataset.getYColumnName(), dArray);
        }
        this.refreshTable();
        this.refreshDataFunctions();
        this.clearSelection();
        this.setSelectedColumnNames(hashMap.keySet());
        this.setSelectedModelRows(nArray);
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return hashMap;
    }

    protected boolean isEmptyRow(int n) {
        boolean bl = true;
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (dataset instanceof DataFunction) continue;
            double[] dArray = dataset.getYPoints();
            if (n >= dArray.length) {
                return false;
            }
            boolean bl2 = bl = bl && Double.isNaN(dArray[n]);
        }
        return bl;
    }

    protected boolean isEmptyCells(int n, ArrayList<String> arrayList) {
        boolean bl = true;
        for (Dataset dataset : this.dataManager.getDatasets()) {
            String string = dataset.getYColumnName();
            if (dataset instanceof DataFunction || !arrayList.contains(string)) continue;
            double[] dArray = dataset.getYPoints();
            if (n >= dArray.length) {
                return false;
            }
            boolean bl2 = bl = bl && Double.isNaN(dArray[n]);
        }
        return bl;
    }

    protected int getXColumn() {
        if (this.getColumnCount() < 2) {
            return -1;
        }
        int n = this.convertColumnIndexToView(0);
        return n == 0 ? 1 : 0;
    }

    protected int getYColumn() {
        if (this.getColumnCount() < 3) {
            return -1;
        }
        int n = this.convertColumnIndexToView(0);
        return n < 2 ? 2 : 1;
    }

    protected double[] replacePoints(Dataset dataset, int[] nArray, double[] dArray) {
        double[] dArray2 = new double[nArray.length];
        double[] dArray3 = dataset.getXPoints();
        int n = dArray3.length;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = Math.max(n, nArray[n2] + 1);
            ++n2;
        }
        while (n > dArray3.length) {
            int[] nArray2 = new int[]{dArray3.length};
            this.insertRows(nArray2, null);
            dArray3 = dataset.getXPoints();
        }
        double[] dArray4 = dataset.getYPoints();
        int n3 = 0;
        while (n3 < nArray.length) {
            dArray2[n3] = dArray4[nArray[n3]];
            dArray4[nArray[n3]] = dArray == null ? Double.NaN : dArray[n3];
            ++n3;
        }
        dataset.clear();
        dataset.append(dArray3, dArray4);
        this.dataToolTab.tabChanged(true);
        return dArray2;
    }

    protected double[] insertPoints(Dataset dataset, int[] nArray, double[] dArray) {
        if (dArray == null) {
            dArray = new double[nArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = Double.NaN;
                ++n;
            }
        }
        if (dataset instanceof DataFunction) {
            return dArray;
        }
        double[] dArray2 = dataset.getYPoints();
        int n = 0;
        while (n < nArray.length) {
            int n2 = dArray2.length;
            double[] dArray3 = new double[n2 + 1];
            System.arraycopy(dArray2, 0, dArray3, 0, nArray[n]);
            System.arraycopy(dArray2, nArray[n], dArray3, nArray[n] + 1, n2 - nArray[n]);
            dArray3[nArray[n]] = dArray[n];
            dArray2 = dArray3;
            ++n;
        }
        double[] dArray4 = DataTool.getRowArray(dArray2.length);
        dataset.clear();
        dataset.append(dArray4, dArray2);
        this.dataToolTab.tabChanged(true);
        return dArray;
    }

    protected double[] deletePoints(Dataset dataset, int[] nArray) {
        double[] dArray = new double[nArray.length];
        if (dataset instanceof DataFunction) {
            return dArray;
        }
        double[] dArray2 = dataset.getYPoints();
        int n = nArray.length - 1;
        while (n > -1) {
            int n2 = dArray2.length;
            double[] dArray3 = new double[n2 - 1];
            System.arraycopy(dArray2, nArray[n], dArray, n, 1);
            if (nArray[n] > 0) {
                System.arraycopy(dArray2, 0, dArray3, 0, nArray[n]);
            }
            if (nArray[n] < n2 - 1) {
                System.arraycopy(dArray2, nArray[n] + 1, dArray3, nArray[n], n2 - nArray[n] - 1);
            }
            dArray2 = dArray3;
            --n;
        }
        double[] dArray4 = DataTool.getRowArray(dArray2.length);
        dataset.clear();
        dataset.append(dArray4, dArray2);
        this.dataToolTab.tabChanged(true);
        return dArray;
    }

    protected void trimEmptyRows(int n) {
        this.clearSelection();
        int n2 = this.getRowCount() - 1;
        boolean bl = true;
        int[] nArray = new int[1];
        while (bl && n2 > n) {
            bl = this.isEmptyRow(n2);
            if (!bl) continue;
            nArray[0] = n2--;
            this.deleteRows(nArray);
        }
        if (this.getSelectedRows().length == 0) {
            this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    protected void clearSelectionIfEmptyEndRow() {
        if (this.getRowCount() < 2) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        int n = this.getRowCount() - 1;
        if (nArray.length == 1 && nArray[0] == n && this.isEmptyRow(n)) {
            this.clearSelection();
        }
    }

    protected void showDataBuilder() {
        FunctionTool functionTool = this.dataToolTab.getDataBuilder();
        functionTool.setSelectedPanel(this.dataToolTab.getName());
        functionTool.setVisible(true);
    }

    protected void renameColumn(String string, String string2) {
        int n = this.dataManager.getDatasetIndex(string);
        Dataset dataset = this.dataManager.getDataset(n);
        dataset.setXYColumnNames(dataset.getXColumnName(), string2);
        this.refreshDataFunctions();
        this.dataToolTab.columnNameChanged(string, string2);
        this.refreshTable();
        this.refreshUndoItems();
    }

    protected void refreshUndoItems() {
        if (this.dataToolTab.dataTool != null) {
            this.dataToolTab.dataTool.undoItem.setEnabled(this.dataToolTab.undoManager.canUndo());
            this.dataToolTab.dataTool.redoItem.setEnabled(this.dataToolTab.undoManager.canRedo());
        }
    }

    public void refreshDataFunctions() {
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (!(dataset instanceof DataFunction)) continue;
            ((DataFunction)dataset).refreshFunctionData();
        }
    }

    @Override
    public void clearSelection() {
        if (this.workingData != null) {
            this.workingData.clearHighlights();
            this.selectedData.clearHighlights();
        }
        if (this.focusRow > -1 && this.focusRow < this.getRowCount() && this.focusCol > 0 && this.focusCol < this.getColumnCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
        }
        this.leadCol = 0;
        this.leadRow = 0;
        super.clearSelection();
    }

    @Override
    public void refreshTable() {
        int[] nArray = this.getModelColumnOrder();
        int[] nArray2 = this.getSelectedModelRows();
        ArrayList<String> arrayList = this.getSelectedColumnNames();
        boolean bl = this.convertColumnIndexToView(0) == -1;
        super.refreshTable();
        if (bl) {
            return;
        }
        boolean bl2 = this.dataToolTab.tabChanged;
        this.setModelColumnOrder(nArray);
        this.dataToolTab.tabChanged(bl2);
        this.sort(this.getSortedColumn());
        if (nArray2.length > 0) {
            this.setSelectedModelRows(nArray2);
        }
        if (!arrayList.isEmpty()) {
            this.setSelectedColumnNames(arrayList);
        }
    }

    public int[] getModelColumnOrder() {
        int[] nArray = new int[this.getModel().getColumnCount()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.convertColumnIndexToModel(n);
            ++n;
        }
        return nArray;
    }

    public void setModelColumnOrder(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n;
            while (n2 < nArray.length) {
                if (this.convertColumnIndexToModel(n2) == nArray[n]) {
                    if (n2 == n) break;
                    this.moveColumn(n2, n);
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    public String[] getHiddenMarkers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getColumnCount()) {
            String string = this.getColumnName(n);
            WorkingDataset workingDataset = this.getWorkingData(string);
            if (workingDataset != null && !workingDataset.isMarkersVisible()) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void hideMarkers(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            WorkingDataset workingDataset = this.getWorkingData(string);
            if (workingDataset != null) {
                workingDataset.setMarkersVisible(false);
            }
            ++n;
        }
    }

    public void setWorkingColumns(String string, String string2) {
        int n = this.convertColumnIndexToView(0);
        this.getColumnModel().moveColumn(n, 0);
        TableModel tableModel = this.getModel();
        int n2 = 1;
        while (n2 < tableModel.getColumnCount()) {
            if (string.equals(this.getColumnName(n2))) {
                this.getColumnModel().moveColumn(n2, 1);
                break;
            }
            ++n2;
        }
        n2 = 2;
        while (n2 < tableModel.getColumnCount()) {
            if (string2.equals(this.getColumnName(n2))) {
                this.getColumnModel().moveColumn(n2, 2);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.labelRenderer != null) {
            Font font2 = this.labelRenderer.getFont();
            font2 = font2.deriveFont(font.getSize2D());
            this.labelRenderer.setFont(font2);
            this.headerRenderer.headerFont = font2;
            this.rowNumberRenderer.setFont(font2);
        }
        this.setRowHeight(font.getSize() + 4);
    }

    protected void setLabelColumnWidth(int n) {
        this.labelColumnWidth = n;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        if (tableCellRenderer == this.rowNumberRenderer) {
            return this.labelRenderer;
        }
        this.dataRenderer.renderer = tableCellRenderer;
        return this.dataRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        this.editor.setColumn(n2);
        return this.editor;
    }

    protected int getMinimumTableWidth() {
        int n = this.getColumnCount() - 1;
        return this.labelColumnWidth + n * this.minimumDataColumnWidth;
    }

    class DataCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        boolean showFocus = false;
        Color unlockedBG = Color.WHITE;
        Color lockedBG = new Color(255, 220, 0, 30);

        DataCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Component component;
            int n3 = DataToolTable.this.convertColumnIndexToModel(n2);
            if ((bl2 || bl) && n3 > 0) {
                DataToolTable.this.focusRow = n;
                DataToolTable.this.focusCol = n2;
            }
            if (DataToolTable.this.selectedBG == null) {
                component = this.renderer.getTableCellRendererComponent(jTable, object, true, false, n, n2);
                DataToolTable.this.selectedBG = component.getBackground();
                DataToolTable.this.selectedFG = component.getForeground();
                DataToolTable.this.selectedHeaderFG = DataToolTable.this.selectedFG.darker();
                Object object3 = object2 = (Object)Color.RGBtoHSB(DataToolTable.this.selectedBG.getRed(), DataToolTable.this.selectedBG.getGreen(), DataToolTable.this.selectedBG.getBlue(), null);
                object3[2] = object3[2] * 0.85f;
                int n4 = Color.HSBtoRGB((float)object2[0], (float)object2[1], (float)object2[2]);
                DataToolTable.this.selectedHeaderBG = new Color(n4);
            }
            if (!this.showFocus) {
                bl2 = n2 == DataToolTable.this.mouseCol && n == DataToolTable.this.mouseRow;
            }
            component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            object2 = DataToolTable.this.dataManager.getDataset(n3 - 1);
            if (!bl) {
                component.setBackground(DataToolTable.this.dataToolTab.isDeletable((Dataset)object2) ? this.unlockedBG : this.lockedBG);
            }
            return component;
        }
    }

    class DataEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField field = new JTextField();
        int column;
        boolean isFunction;

        DataEditor() {
            this.field.setHorizontalAlignment(4);
            this.field.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.field.setSelectionColor(new Color(204, 255, 255));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(final KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        DataEditor.this.stopCellEditing();
                        Runnable runnable = new Runnable(){

                            @Override
                            public synchronized void run() {
                                int n = DataToolTable.this.getModelRow(((DataEditor)(this).DataEditor.this).DataToolTable.this.focusRow) + 1;
                                if (n == DataToolTable.this.getRowCount()) {
                                    DataToolTable.this.insertRows(new int[]{n}, null);
                                }
                                n = DataToolTable.this.getViewRow(n);
                                DataToolTable.this.changeSelection(n, (this).DataEditor.this.column, false, false);
                                DataToolTable.this.editCellAt(n, (this).DataEditor.this.column, keyEvent);
                                (this).DataEditor.this.field.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    } else if (DataEditor.this.field.isEnabled()) {
                        DataEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (DataEditor.this.field.getBackground() != Color.white) {
                        DataEditor.this.stopCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DataEditor.this.field.selectAll();
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                        DataEditor.this.stopCellEditing();
                        ((DataEditor)DataEditor.this).DataToolTable.this.tableMouseListener.mousePressed(mouseEvent);
                    }
                }
            });
        }

        void setColumn(int n) {
            this.column = n;
            int n2 = DataToolTable.this.convertColumnIndexToModel(n);
            Dataset dataset = DataToolTable.this.dataManager.getDataset(n2 - 1);
            this.isFunction = dataset instanceof DataFunction;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (this.isFunction) {
                DataToolTable.this.showDataBuilder();
                return null;
            }
            this.field.setText(object == null ? "" : String.valueOf(object));
            this.field.setFont(DataToolTable.this.getFont());
            return this.field;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 2) {
                return true;
            }
            if (eventObject instanceof ActionEvent) {
                return true;
            }
            return eventObject instanceof KeyEvent;
        }

        @Override
        public Object getCellEditorValue() {
            DataToolTable.this.requestFocusInWindow();
            this.field.setBackground(Color.white);
            return this.field.getText();
        }
    }

    protected static class DataToolTableModel
    extends DataTable.DefaultDataTableModel {
        DataToolTab tab;

        DataToolTableModel(DataToolTab dataToolTab) {
            this.tab = dataToolTab;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return rowName;
            }
            String string = this.tab.dataManager.getColumnName(n - 1);
            return string;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            double d;
            Dataset dataset;
            block4: {
                if (object == null) {
                    return;
                }
                dataset = this.tab.dataTable.dataManager.getDataset(n2 - 1);
                double[] dArray = dataset.getYPoints();
                d = Double.NaN;
                try {
                    d = Double.parseDouble(object.toString());
                    if (dArray[n] == d) {
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!Double.isNaN(dArray[n])) break block4;
                    return;
                }
            }
            String string = dataset.getYColumnName();
            int[] nArray = new int[]{n};
            HashMap<String, double[]> hashMap = new HashMap<String, double[]>();
            hashMap.put(string, new double[]{d});
            HashMap<String, double[]> hashMap2 = this.tab.dataTable.replaceCells(nArray, hashMap);
            DataToolTable dataToolTable = this.tab.dataTable;
            dataToolTable.getClass();
            TableEdit tableEdit = dataToolTable.new TableEdit(5, string, nArray, new HashMap[]{hashMap2, hashMap});
            this.tab.undoSupport.postEdit(tableEdit);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0 && this.tab.userEditable;
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        Font headerFont;
        DrawingPanel panel = new DrawingPanel();
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -6.0);

        public HeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
            this.textLine.setJustification(0);
            this.panel.addDrawable(this.textLine);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            int n3;
            int n4;
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.headerFont == null) {
                this.headerFont = component.getFont();
            }
            int n5 = (n4 = DataToolTable.this.convertColumnIndexToView(0)) == 0 ? 1 : 0;
            int n6 = n3 = n4 < 2 ? 2 : 1;
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = component.getBackground();
            }
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = UIManager.getColor("Panel.background");
            }
            DataToolTable.this.rowBG = DataToolTable.this.dataToolTab.plot.getBackground();
            Color color2 = n2 == n5 ? xAxisColor : (color = n2 == n3 ? yAxisColor : DataToolTable.this.rowBG);
            if (!(component instanceof JComponent)) {
                return component;
            }
            String string = object == null ? "" : object.toString();
            this.textLine.setText(string);
            JComponent jComponent = (JComponent)component;
            Dimension dimension = jComponent.getPreferredSize();
            ++dimension.height;
            this.panel.setPreferredSize(dimension);
            Border border = jComponent.getBorder();
            if (border instanceof EmptyBorder) {
                border = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            }
            this.panel.setBorder(border);
            Dataset dataset = DataToolTable.this.getDataset(string);
            if (!DataToolTable.this.dataToolTab.isDeletable(dataset)) {
                this.textLine.setFont(DataToolTable.this.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(n2) ? this.headerFont.deriveFont(2) : this.headerFont.deriveFont(3));
            } else {
                this.textLine.setFont(DataToolTable.this.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(n2) ? this.headerFont.deriveFont(0) : this.headerFont.deriveFont(1));
            }
            int[] nArray = DataToolTable.this.getSelectedColumns();
            boolean bl3 = false;
            int n7 = 0;
            while (n7 < nArray.length) {
                bl3 = bl3 || nArray[n7] == n2;
                ++n7;
            }
            bl3 = bl3 && DataToolTable.this.convertColumnIndexToModel(n2) > 0;
            this.textLine.setColor(bl3 ? DataToolTable.this.selectedHeaderFG : jComponent.getForeground());
            color = bl3 ? DataToolTable.this.selectedHeaderBG : color;
            this.textLine.setBackground(color);
            this.panel.setBackground(color);
            return this.panel;
        }
    }

    class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object == null ? null : object.toString());
            this.setEnabled(true);
            boolean bl3 = false;
            if (jTable == DataToolTable.this) {
                this.setEnabled(n < DataToolTable.this.getRowCount() - 1 || !DataToolTable.this.isEmptyRow(n));
                int[] nArray = DataToolTable.this.getSelectedRows();
                int n3 = 0;
                while (n3 < nArray.length) {
                    bl3 = bl3 || nArray[n3] == n;
                    ++n3;
                }
            }
            this.setForeground(bl3 ? DataToolTable.this.selectedHeaderFG : Color.black);
            this.setBackground(bl3 ? DataToolTable.this.selectedHeaderBG : DataToolTable.this.unselectedBG);
            return this;
        }
    }

    protected class TableEdit
    extends AbstractUndoableEdit {
        Object target;
        Object value;
        int editType;
        String columnName;
        HashMap<String, double[]> map;

        public TableEdit(int n, String string, Object object, Object object2) {
            this.editType = n;
            this.columnName = string;
            this.target = object;
            this.value = object2;
            String string2 = string == null ? null : ": column \"" + string + "\"";
            OSPLog.finer(String.valueOf(editTypes[n]) + string2);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            OSPLog.finer("undoing " + editTypes[this.editType]);
            switch (this.editType) {
                case 0: {
                    DataToolTable.this.renameColumn(this.columnName, this.value.toString());
                    break;
                }
                case 1: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 2: {
                    Dataset dataset = (Dataset)this.value;
                    int n = (Integer)this.target;
                    DataToolTable.this.insertColumn(dataset, n);
                    break;
                }
                case 3: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.deleteCells(nArray, hashMap);
                    break;
                }
                case 4: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.insertCells(nArray, hashMap);
                    break;
                }
                case 6: {
                    int[] nArray = (int[])this.target;
                    DataToolTable.this.deleteRows(nArray);
                    break;
                }
                case 7: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.insertRows(nArray, hashMap);
                    break;
                }
                case 5: {
                    int[] nArray = (int[])this.target;
                    HashMap[] hashMapArray = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(nArray, hashMapArray[0]);
                }
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            OSPLog.finer("redoing " + editTypes[this.editType]);
            switch (this.editType) {
                case 0: {
                    DataToolTable.this.renameColumn(this.value.toString(), this.columnName);
                    break;
                }
                case 1: {
                    Dataset dataset = (Dataset)this.value;
                    int n = (Integer)this.target;
                    DataToolTable.this.insertColumn(dataset, n);
                    break;
                }
                case 2: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 3: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.insertCells(nArray, hashMap);
                    break;
                }
                case 4: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.deleteCells(nArray, hashMap);
                    break;
                }
                case 6: {
                    int[] nArray = (int[])this.target;
                    HashMap hashMap = (HashMap)this.value;
                    DataToolTable.this.insertRows(nArray, hashMap);
                    break;
                }
                case 7: {
                    int[] nArray = (int[])this.target;
                    DataToolTable.this.deleteRows(nArray);
                    break;
                }
                case 5: {
                    int[] nArray = (int[])this.target;
                    HashMap[] hashMapArray = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(nArray, hashMapArray[1]);
                }
            }
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }
    }

    class WorkingDataset
    extends HighlightableDataset {
        private final Dataset yData;
        private Dataset xData;
        boolean markersVisible;
        int markerType;
        boolean isWorkingYColumn;

        public WorkingDataset(Dataset dataset) {
            this.yData = dataset;
            this.setColor(this.yData.getFillColor(), this.yData.getLineColor());
            this.markerType = this.yData.getMarkerShape();
            this.setMarkerShape(this.markerType);
            boolean bl = this.markersVisible = this.markerType != 0;
            if (this.markerType == 0) {
                this.markerType = 1;
            }
            this.setMarkerSize(this.yData.getMarkerSize());
            this.setConnected(this.yData.isConnected());
        }

        @Override
        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            boolean bl = this.markersVisible;
            if (this.isWorkingYColumn && !bl) {
                this.setMarkersVisible(true);
            }
            super.draw(drawingPanel, graphics);
            if (this.isWorkingYColumn && !bl) {
                this.setMarkersVisible(false);
            }
        }

        public boolean isMarkersVisible() {
            return this.markersVisible || this.isWorkingYColumn;
        }

        public void setMarkersVisible(boolean bl) {
            if (!bl && this.markersVisible) {
                this.markerType = this.getMarkerShape();
                this.setMarkerShape(0);
            } else if (bl) {
                this.setMarkerShape(this.markerType);
            }
            this.markersVisible = bl;
        }

        public void setColor(Color color, Color color2) {
            Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
            this.setMarkerColor(color3, color);
            this.setLineColor(color2);
            this.yData.setMarkerColor(color3, color);
            this.yData.setLineColor(color2);
        }

        @Override
        public void setConnected(boolean bl) {
            super.setConnected(bl);
            this.yData.setConnected(bl);
        }

        @Override
        public void setMarkerSize(int n) {
            super.setMarkerSize(n);
            this.yData.setMarkerSize(n);
        }

        @Override
        public void setMarkerShape(int n) {
            super.setMarkerShape(n);
            if (n != 0) {
                this.yData.setMarkerShape(n);
                this.markerType = n;
            }
        }

        Dataset getYSource() {
            return this.yData;
        }

        Dataset getXSource() {
            return this.xData;
        }

        void setXSource(Dataset dataset) {
            this.xData = dataset;
            this.clear();
            double[] dArray = this.xData.getYPoints();
            double[] dArray2 = this.yData.getYPoints();
            if (dArray.length != dArray2.length) {
                int n = Math.min(dArray.length, dArray2.length);
                double[] dArray3 = new double[n];
                System.arraycopy(dArray, 0, dArray3, 0, n);
                double[] dArray4 = new double[n];
                System.arraycopy(dArray2, 0, dArray4, 0, n);
                this.append(dArray3, dArray4);
            } else {
                this.append(dArray, dArray2);
            }
            this.setXYColumnNames(this.xData.getYColumnName(), this.yData.getYColumnName());
        }
    }
}

