/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers.rk;

import org.opensourcephysics.numerics.ode_interpolation.EulerRichardsonIntervalData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTime;

public class EulerRichardson
extends SolverEngineDiscreteTime {
    private double[] mRate2;

    @Override
    protected int getNumberOfEvaluations() {
        return 2;
    }

    @Override
    protected void allocateOtherArrays() {
        this.mRate2 = new double[this.mDimension];
    }

    @Override
    protected void computeIntermediateStep(double step, double[] state) {
        double halfStep = step / 2.0;
        double timeRate = this.mInitialRate[this.mTimeIndex];
        int i = 0;
        while (i < this.mDimension) {
            state[i] = this.mInitialState[i] + halfStep * this.mInitialRate[i];
            ++i;
        }
        this.mODE.getRate(state, this.mRate2);
        i = 0;
        while (i < this.mTimeIndex) {
            state[i] = this.mInitialState[i] + step * this.mRate2[i];
            ++i;
        }
        state[this.mTimeIndex] = this.mInitialTime + step * timeRate;
    }

    @Override
    protected InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver eventSolver, double step, double[] state) {
        double halfStep = step / 2.0;
        double timeRate = this.mInitialRate[this.mTimeIndex];
        int i = 0;
        while (i < this.mDimension) {
            state[i] = this.mInitialState[i] + halfStep * this.mInitialRate[i];
            ++i;
        }
        switch (eventSolver.checkDiscontinuity(state, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(state, this.mRate2);
        i = 0;
        while (i < this.mTimeIndex) {
            state[i] = this.mInitialState[i] + step * this.mRate2[i];
            ++i;
        }
        state[this.mTimeIndex] = this.mInitialTime + step * timeRate;
        return eventSolver.checkDiscontinuity(state, true);
    }

    @Override
    protected IntervalData computeFinalRateAndCreateIntervalData() {
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        return new EulerRichardsonIntervalData(this.mInitialState, this.mInitialRate, this.mFinalState[this.mTimeIndex], this.mRate2);
    }
}

