/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;

public class EulerRichardsonIntervalData
extends IntervalData {
    private int mTimeIndex;
    private double mStepSize;
    private double[] mLeftState;
    private double[] mLeftRate;
    private double[] mK2;

    public EulerRichardsonIntervalData(double[] aState, double[] aRate, double right, double[] K2) {
        super(aState[aState.length - 1], right);
        int dimension = aState.length;
        this.mLeftState = new double[dimension];
        this.mLeftRate = new double[dimension];
        this.mK2 = new double[dimension];
        System.arraycopy(aState, 0, this.mLeftState, 0, dimension);
        System.arraycopy(aRate, 0, this.mLeftRate, 0, dimension);
        System.arraycopy(K2, 0, this.mK2, 0, dimension);
        this.mTimeIndex = aState.length - 1;
        this.mStepSize = right - aState[this.mTimeIndex];
    }

    @Override
    public double interpolate(double time, int index) {
        double theta = (time - this.getLeft()) / this.mStepSize;
        double b2 = theta * theta * this.mStepSize;
        double b1 = this.mStepSize * theta - b2;
        return this.mLeftState[index] + b1 * this.mLeftRate[index] + b2 * this.mK2[index];
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        double theta = (time - this.getLeft()) / this.mStepSize;
        double b2 = theta * theta * this.mStepSize;
        double b1 = this.mStepSize * theta - b2;
        int index = beginIndex;
        int i = 0;
        while (i < length) {
            state[i] = this.mLeftState[index] + b1 * this.mLeftRate[index] + b2 * this.mK2[index];
            ++index;
            ++i;
        }
        return state;
    }
}

