/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MatrixTransformation;

public class Matrix2DTransformation
implements MatrixTransformation {
    private double[] origin = new double[]{0.0, 0.0};
    private AffineTransform originTransform = new AffineTransform();
    private AffineTransform internalTransform = new AffineTransform();
    private AffineTransform originInverseTransform = new AffineTransform();
    private AffineTransform totalTransform = new AffineTransform();

    public Matrix2DTransformation(double[][] dArray) {
        if (dArray != null) {
            this.internalTransform.setTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]);
        }
        this.update();
    }

    public Matrix2DTransformation(AffineTransform affineTransform) {
        this.internalTransform.setTransform(affineTransform);
        this.update();
    }

    public static Matrix2DTransformation rotation(double d) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(d));
    }

    public static Matrix2DTransformation rotation(double d, double d2, double d3) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public AffineTransform getTotalTransform() {
        return this.totalTransform;
    }

    @Override
    public Object clone() {
        return new Matrix2DTransformation(this.internalTransform);
    }

    @Override
    public final double[] getFlatMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[6];
        }
        this.internalTransform.getMatrix(dArray);
        return dArray;
    }

    public static Matrix2DTransformation createAlignmentTransformation(double[] dArray, double[] dArray2) {
        return new Matrix2DTransformation(AffineTransform.getRotateInstance(Math.atan2(dArray2[1], dArray2[0]) - Math.atan2(dArray[1], dArray[0])));
    }

    private void update() {
        this.totalTransform.setTransform(this.originTransform);
        this.totalTransform.concatenate(this.internalTransform);
        this.totalTransform.concatenate(this.originInverseTransform);
    }

    public void setOrigin(double d, double d2) {
        this.origin[0] = d;
        this.origin[1] = d2;
        this.originTransform = AffineTransform.getTranslateInstance(d, d2);
        this.originInverseTransform = AffineTransform.getTranslateInstance(-d, -d2);
        this.update();
    }

    public double[] setOrigin(double[] dArray) {
        this.setOrigin(dArray[0], dArray[1]);
        return dArray;
    }

    public final void multiply(Matrix2DTransformation matrix2DTransformation) {
        this.internalTransform.concatenate(matrix2DTransformation.internalTransform);
        this.update();
    }

    public final void multiply(double[][] dArray) {
        this.internalTransform.concatenate(new Matrix2DTransformation((double[][])dArray).internalTransform);
        this.update();
    }

    @Override
    public double[] direct(double[] dArray) {
        this.totalTransform.transform(dArray, 0, dArray, 0, 1);
        return dArray;
    }

    @Override
    public double[] inverse(double[] dArray) throws UnsupportedOperationException {
        try {
            this.totalTransform.inverseTransform(dArray, 0, dArray, 0, 1);
            return dArray;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new UnsupportedOperationException("The inverse matrix does not exist.");
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Matrix2DTransformationLoader();
    }

    protected static class Matrix2DTransformationLoader
    extends XMLLoader {
        protected Matrix2DTransformationLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Matrix2DTransformation matrix2DTransformation = (Matrix2DTransformation)object;
            xMLControl.setValue("matrix", matrix2DTransformation.getFlatMatrix(null));
            xMLControl.setValue("origin x", matrix2DTransformation.origin);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Matrix2DTransformation(new AffineTransform());
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Matrix2DTransformation matrix2DTransformation = (Matrix2DTransformation)object;
            matrix2DTransformation.internalTransform.setTransform(new AffineTransform((double[])xMLControl.getObject("matrix")));
            matrix2DTransformation.setOrigin((double[])xMLControl.getObject("origin"));
            return object;
        }
    }
}

