/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementBox;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementBox
extends SimpleAbstractTile {
    public SimpleElementBox(ElementBox _element) {
        super(_element);
    }

    @Override
    protected double[][][] computeTile() {
        ElementBox box = (ElementBox)this.element;
        int nx = 1;
        int ny = 1;
        int nz = 1;
        Resolution res = this.style.getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    nx = Math.max(res.getN1(), 1);
                    ny = Math.max(res.getN2(), 1);
                    nz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    nx = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeX()) / res.getMaxLength()), 1);
                    ny = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeY()) / res.getMaxLength()), 1);
                    nz = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / res.getMaxLength()), 1);
                }
            }
        }
        return ElementBox.createStandardBox(nx, ny, nz, box.isClosedTop(), box.isClosedBottom(), box.getSizeZReduction());
    }
}

