/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.geometry.Triangulator;
import java.awt.Color;
import java.awt.Paint;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementPolygon
extends Java3dElement {
    private GeometryArray tsa1 = null;
    private TexCoord2f[] texCoord = null;
    private Point3d[] coords = null;
    private BranchGroup bg = null;

    public Java3dElementPolygon(ElementPolygon _element) {
        super(_element);
        this.getAppearance().getPolygonAttributes().setCullFace(0);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 8) != 0 || (_change & 2) != 0) {
            this.computePolygon();
        }
    }

    @Override
    public void styleChanged(int _change) {
        if (_change == 3) {
            this.getAppearance().getPolygonAttributes().setPolygonMode(2);
            Paint fill = this.element.getStyle().getFillColor();
            if (fill instanceof Color) {
                this.getAppearance().getMaterial().setDiffuseColor(new Color3f((Color)fill));
            }
            this.getAppearance().getMaterial().setSpecularColor(new Color3f(Color.white));
            super.styleChanged(4);
        } else {
            super.styleChanged(_change);
        }
    }

    private void computePolygon() {
        int points = ((ElementPolygon)this.element).getData().length;
        if (points <= 1) {
            return;
        }
        if (this.element.getStyle().isDrawingFill()) {
            this.coords = new Point3d[points + 1];
            this.texCoord = new TexCoord2f[points + 1];
            int n = 0;
            while (n < points) {
                this.coords[n] = new Point3d(((ElementPolygon)this.element).getData()[n][0], ((ElementPolygon)this.element).getData()[n][1], ((ElementPolygon)this.element).getData()[n][2]);
                this.texCoord[n] = n == 0 || n % 3 == 0 ? new TexCoord2f(0.0f, 0.0f) : (n % 2 == 0 ? new TexCoord2f(1.0f, 0.0f) : new TexCoord2f(0.5f, 0.5f));
                ++n;
            }
            this.coords[points] = new Point3d(((ElementPolygon)this.element).getData()[0][0], ((ElementPolygon)this.element).getData()[0][1], ((ElementPolygon)this.element).getData()[0][2]);
            this.texCoord[points] = new TexCoord2f(0.0f, 0.0f);
        } else {
            this.coords = new Point3d[points * 2 + 1];
            this.texCoord = new TexCoord2f[points * 2 + 1];
            int n = 0;
            while (n < points) {
                this.coords[n] = new Point3d(((ElementPolygon)this.element).getData()[n][0], ((ElementPolygon)this.element).getData()[n][1], ((ElementPolygon)this.element).getData()[n][2]);
                this.coords[points * 2 - n] = new Point3d(((ElementPolygon)this.element).getData()[n][0], ((ElementPolygon)this.element).getData()[n][1], ((ElementPolygon)this.element).getData()[n][2]);
                if (n == 0 || n % 3 == 0) {
                    this.texCoord[n] = new TexCoord2f(0.0f, 0.0f);
                    this.texCoord[points * 2 - n] = new TexCoord2f(0.0f, 0.0f);
                } else if (n % 2 == 0) {
                    this.texCoord[n] = new TexCoord2f(1.0f, 0.0f);
                    this.texCoord[points * 2 - n] = new TexCoord2f(1.0f, 0.0f);
                } else {
                    this.texCoord[n] = new TexCoord2f(0.5f, 0.5f);
                    this.texCoord[points * 2 - n] = new TexCoord2f(0.5f, 0.5f);
                }
                ++n;
            }
            this.coords[points] = new Point3d(((ElementPolygon)this.element).getData()[0][0], ((ElementPolygon)this.element).getData()[0][1], ((ElementPolygon)this.element).getData()[0][2]);
            this.texCoord[points] = new TexCoord2f(0.0f, 0.0f);
        }
        this.addShape();
    }

    private void addShape() {
        if (this.coords == null) {
            return;
        }
        int points = ((ElementPolygon)this.element).getData().length;
        if (((ElementPolygon)this.element).isClosed() && points > 2) {
            int pGeometry = 0;
            pGeometry = this.element.getStyle().isDrawingFill() ? points + 1 : points * 2 + 1;
            GeometryInfo gi = new GeometryInfo(5);
            gi.setTextureCoordinateParams(1, 2);
            gi.setTextureCoordinates(0, this.texCoord);
            gi.setCoordinates(this.coords);
            gi.setStripCounts(new int[]{pGeometry});
            gi.recomputeIndices();
            Triangulator tr = new Triangulator();
            tr.triangulate(gi);
            gi.recomputeIndices();
            Stripifier st = new Stripifier();
            st.stripify(gi);
            gi.recomputeIndices();
            NormalGenerator ng = new NormalGenerator();
            ng.setCreaseAngle((float)Math.toRadians(30.0));
            ng.generateNormals(gi);
            gi.recomputeIndices();
            this.tsa1 = gi.getGeometryArray();
        } else {
            LineStripArray line = new LineStripArray(((ElementPolygon)this.element).getDataArray().length, 37, new int[]{((ElementPolygon)this.element).getData().length});
            int i = 0;
            while (i < ((ElementPolygon)this.element).getData().length) {
                line.setCoordinate(i, this.coords[i]);
                line.setTextureCoordinate(0, i, this.texCoord[i]);
                ++i;
            }
            this.tsa1 = line;
        }
        Shape3D shape = new Shape3D();
        shape = new Shape3D((Geometry)this.tsa1, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)shape);
        this.addNode((Node)this.bg);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

