/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.opensourcephysics.drawing3d.ElementObject;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class Java3dElementObject
extends Java3dElement {
    protected static final double MAX_SIZE = 1.0;
    protected static final double ROTATION = 1.5707963267948966;
    private static String OBJ = ".obj";
    protected BranchGroup bg = null;
    protected TransformGroup tg = null;
    private boolean noTriangulate = true;
    private boolean noStripify = false;
    private double creaseAngle = 60.0;
    protected Transform3D rX = new Transform3D();

    public Java3dElementObject(ElementObject _element) {
        super(_element);
        this.tg = new TransformGroup();
        this.tg.setCapability(13);
        this.tg.setCapability(12);
        this.tg.setCapability(14);
        this.tg.setCapability(18);
        this.rX.rotX(1.5707963267948966);
        this.tg.setTransform(this.rX);
        if (((ElementObject)this.element).getObjectFile() != null) {
            this.element.addChange(8);
        }
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        String file;
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 8) != 0 && (file = ((ElementObject)this.element).getObjectFile().toLowerCase()).substring(file.length() - 5).contains(OBJ)) {
            Resource resource = ResourceLoader.getResource(((ElementObject)this.element).getObjectFile());
            int flags = 64;
            if (!this.noTriangulate) {
                flags |= 0x80;
            }
            if (!this.noStripify) {
                flags |= 0x200;
            }
            ObjectFile f = new ObjectFile(flags, (float)(this.creaseAngle * Math.PI / 180.0));
            Scene s = null;
            try {
                s = f.load(resource.getURL());
                Hashtable namedObjects = s.getNamedObjects();
                Enumeration e = namedObjects.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Shape3D shape = (Shape3D)namedObjects.get(name);
                    shape.setAppearance(this.getAppearance());
                }
                if (this.bg != null) {
                    this.tg.removeChild((Node)this.bg);
                }
                this.bg = new BranchGroup();
                this.bg.setCapability(17);
                this.bg.addChild((Node)s.getSceneGroup());
                this.tg.addChild((Node)this.bg);
                this.addNode((Node)this.tg);
            }
            catch (Exception exc) {
                System.out.println("Incorrect OBJ file:" + ((ElementObject)this.element).getObjectFile());
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

