/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import javax.swing.JFrame;
import org.opensourcephysics.display2d.VectorColorMapper;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.utils.Style;

public class VectorField
extends Group {
    protected double minimumX = Double.NaN;
    protected double maximumX = Double.NaN;
    protected double minimumY = Double.NaN;
    protected double maximumY = Double.NaN;
    protected double minimumZ = Double.NaN;
    protected double maximumZ = Double.NaN;
    protected double vectorSizeX = 1.0;
    protected double vectorSizeY = 1.0;
    protected double vectorSizeZ = 1.0;
    protected double vectorAlpha = Double.NaN;
    protected double vectorBeta = Double.NaN;
    protected double vectorMagnitude = Double.NaN;
    protected double[][][] vectorSizeXData;
    protected double[][][] vectorSizeYData;
    protected double[][][] vectorSizeZData;
    protected double[][][] vectorAlphaData;
    protected double[][][] vectorBetaData;
    protected double[][][] vectorMagnitudeData;
    protected boolean autoscaleMagnitude = false;
    protected boolean useColorMapper = false;
    protected double constantLength = Double.NaN;
    protected int levels = -1;
    protected int invisibleLevel = -1;
    protected Color maxColor = Color.RED;
    protected Color minColor = Color.BLUE;
    private boolean positionChanged = true;
    private boolean sizeChanged = true;
    private boolean magChanged = true;
    protected double magConstant = 0.0;
    protected double minMagnitude = 0.0;
    protected double maxMagnitude = 1.0;
    protected double useMinX;
    protected double useMaxX;
    protected double useMinY;
    protected double useMaxY;
    protected double useMinZ;
    protected double useMaxZ;
    protected Color[] colors;
    protected VectorColorMapper mapper = new VectorColorMapper(16, 1.0);
    protected double[][][] vectorLength;
    protected int nX = -1;
    protected int nY = -1;
    protected int nZ = -1;
    private ElementArrow invisibleElement = new ElementArrow();
    private boolean showLegend;
    private int arrowType = 0;

    public VectorField() {
        this.addElement(this.invisibleElement);
        this.setNumberOfLevels(16);
    }

    @Override
    public void processChanges(int _cummulativeChange) {
        this.prepareField();
        super.processChanges(_cummulativeChange);
    }

    public void setMinimumX(double min) {
        if (min != this.minimumX) {
            this.minimumX = min;
            this.positionChanged = true;
        }
    }

    public void setMaximumX(double max) {
        if (max != this.maximumX) {
            this.maximumX = max;
            this.positionChanged = true;
        }
    }

    public void setMinimumY(double min) {
        if (min != this.minimumY) {
            this.minimumY = min;
            this.positionChanged = true;
        }
    }

    public void setMaximumY(double max) {
        if (max != this.maximumY) {
            this.maximumY = max;
            this.positionChanged = true;
        }
    }

    public void setMinimumZ(double min) {
        if (min != this.minimumZ) {
            this.minimumZ = min;
            this.positionChanged = true;
        }
    }

    public void setMaximumZ(double max) {
        if (max != this.maximumZ) {
            this.maximumZ = max;
            this.positionChanged = true;
        }
    }

    public void setVectorSizeXData(double[][][] data) {
        this.vectorSizeXData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeX(double size) {
        if (this.vectorSizeX != size) {
            this.vectorSizeX = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeYData(double[][][] data) {
        this.vectorSizeYData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeY(double size) {
        if (this.vectorSizeY != size) {
            this.vectorSizeY = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeZData(double[][][] data) {
        this.vectorSizeZData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeZ(double size) {
        if (this.vectorSizeZ != size) {
            this.vectorSizeZ = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorAlphaData(double[][][] data) {
        this.vectorAlphaData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAlpha(double size) {
        if (this.vectorAlpha != size) {
            this.vectorAlpha = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorBetaData(double[][][] data) {
        this.vectorBetaData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAlphaAndBetaData(double[][][] adata, double[][][] bdata) {
        this.vectorAlphaData = adata;
        this.vectorBetaData = bdata;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorBeta(double size) {
        if (this.vectorBeta != size) {
            this.vectorBeta = size;
            this.sizeChanged = true;
        }
    }

    public void setConstantLength(double length) {
        if (this.constantLength != length) {
            this.constantLength = length;
            this.sizeChanged = true;
        }
    }

    public void setAutoscaleMagnitude(boolean scale) {
        if (this.autoscaleMagnitude != scale) {
            this.autoscaleMagnitude = scale;
            this.magChanged = true;
        }
    }

    public void setMagnitudeExtrema(double min, double max) {
        if (this.autoscaleMagnitude) {
            this.autoscaleMagnitude = false;
            this.magChanged = true;
        }
        if (this.minMagnitude == min && this.maxMagnitude == max) {
            return;
        }
        this.minMagnitude = min;
        this.maxMagnitude = max;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public double getMagnitudeMinimum() {
        return this.minMagnitude;
    }

    public double getMagnitudeMaximum() {
        return this.maxMagnitude;
    }

    public void setMagnitudeData(double[][][] data) {
        this.vectorMagnitudeData = data;
        this.magChanged = true;
        this.checkArrays();
    }

    public void setMagnitude(double magnitude) {
        if (this.vectorMagnitude != magnitude) {
            this.vectorMagnitude = magnitude;
            this.magChanged = true;
        }
    }

    public void setNumberOfLevels(int _lev) {
        if (_lev == this.levels) {
            return;
        }
        this.magChanged = true;
        if (_lev <= 0) {
            this.levels = 0;
            return;
        }
        this.levels = _lev;
        this.colors = new Color[this.levels];
        this.initColors();
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setNumberOfColors(_lev);
        this.mapper.updateLegend();
    }

    public void setMinColor(Color _aColor) {
        if (_aColor.equals(this.minColor)) {
            return;
        }
        this.minColor = _aColor;
        this.initColors();
        this.magChanged = true;
    }

    public void setMaxColor(Color _aColor) {
        if (_aColor.equals(this.maxColor)) {
            return;
        }
        this.maxColor = _aColor;
        this.initColors();
        this.magChanged = true;
    }

    public void setInvisibleLevel(int level) {
        if (this.invisibleLevel != level) {
            this.invisibleLevel = level;
            this.magChanged = true;
        }
    }

    public void setArrowType(int type) {
        this.arrowType = type;
        for (Element element : this.getElements()) {
            ((ElementArrow)element).setArrowType(type);
        }
    }

    public void setRelativePosition(int position) {
        for (Element element : this.getElements()) {
            element.getStyle().setRelativePosition(position);
        }
    }

    public void setOffset(int type) {
        this.setRelativePosition(type);
    }

    public void setUseColorMapper(boolean _do) {
        this.useColorMapper = _do;
        this.setShowLegend(this.showLegend);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public VectorColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setShowLegend(boolean _visible) {
        this.showLegend = _visible;
        JFrame legendFrame = this.mapper.getLegendFrame();
        if (legendFrame == null) {
            legendFrame = this.mapper.showLegend();
        }
        legendFrame.setVisible(this.useColorMapper && _visible);
    }

    public double indexToX(int i) {
        if (i < 0 || i >= this.nX) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nX == 1) {
            return (this.useMinX + this.useMaxX) / 2.0;
        }
        return this.useMinX + (double)i * (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
    }

    public double indexToY(int i) {
        if (i < 0 || i >= this.nY) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nY == 1) {
            return (this.useMinY + this.useMaxY) / 2.0;
        }
        return this.useMinY + (double)i * (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
    }

    public double indexToZ(int i) {
        if (i < 0 || i >= this.nZ) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nZ == 1) {
            return (this.useMinZ + this.useMaxZ) / 2.0;
        }
        return this.useMinZ + (double)i * (this.useMaxZ - this.useMinZ) / (double)(this.nZ - 1);
    }

    private void checkExtrema() {
        DrawingPanel3D panel = this.getPanel();
        this.useMinX = Double.isNaN(this.minimumX) ? panel.getPreferredMinX() : this.minimumX;
        this.useMaxX = Double.isNaN(this.maximumX) ? panel.getPreferredMaxX() : this.maximumX;
        this.useMinY = Double.isNaN(this.minimumY) ? panel.getPreferredMinY() : this.minimumY;
        this.useMaxY = Double.isNaN(this.maximumY) ? panel.getPreferredMaxY() : this.maximumY;
        this.useMinZ = Double.isNaN(this.minimumZ) ? panel.getPreferredMinZ() : this.minimumZ;
        this.useMaxZ = Double.isNaN(this.maximumZ) ? panel.getPreferredMaxZ() : this.maximumZ;
    }

    private void checkArraySize(double[][][] data) {
        if (data != null) {
            this.nX = Math.min(this.nX, data.length);
            this.nY = Math.min(this.nY, data[0].length);
            this.nZ = Math.min(this.nZ, data[0][0].length);
        }
    }

    private boolean checkArrays() {
        int total;
        this.nZ = Integer.MAX_VALUE;
        this.nY = Integer.MAX_VALUE;
        this.nX = Integer.MAX_VALUE;
        this.checkArraySize(this.vectorSizeXData);
        this.checkArraySize(this.vectorSizeYData);
        this.checkArraySize(this.vectorSizeZData);
        this.checkArraySize(this.vectorAlphaData);
        this.checkArraySize(this.vectorBetaData);
        this.checkArraySize(this.vectorMagnitudeData);
        if (this.nX == Integer.MAX_VALUE) {
            this.nX = 0;
        }
        if (this.nY == Integer.MAX_VALUE) {
            this.nY = 0;
        }
        if (this.nZ == Integer.MAX_VALUE) {
            this.nZ = 0;
        }
        if (this.nX <= 0 || this.nY <= 0 || this.nZ <= 0) {
            return false;
        }
        if (this.vectorLength == null || this.vectorLength.length != this.nX || this.vectorLength[0].length != this.nY || this.vectorLength[0][0].length != this.nZ) {
            this.vectorLength = new double[this.nX][this.nY][this.nZ];
        }
        if ((total = this.nX * this.nY * this.nZ) != this.getNumberOfElements() - 1) {
            this.setNumberOfElements(total);
        }
        return true;
    }

    private boolean isAngleSet() {
        if (this.vectorAlphaData == null && Double.isNaN(this.vectorAlpha)) {
            return false;
        }
        return this.vectorBetaData != null || !Double.isNaN(this.vectorBeta);
    }

    private boolean isMagnitudeSet() {
        return this.vectorMagnitudeData != null || !Double.isNaN(this.vectorMagnitude);
    }

    private void setNumberOfElements(int newNumber) {
        Style oldStyle = this.invisibleElement.getStyle();
        this.removeAllElements();
        this.addElement(this.invisibleElement);
        int i = 1;
        while (i <= newNumber) {
            ElementArrow arrow = new ElementArrow();
            arrow.setHeadSize(3.5);
            oldStyle.copyTo(arrow.getStyle());
            arrow.setArrowType(this.arrowType);
            this.addElementAtIndex(i, arrow);
            ++i;
        }
        this.magChanged = true;
        this.sizeChanged = true;
        this.positionChanged = true;
    }

    private boolean prepareField() {
        if (this.nX <= 0 || this.nY <= 0 || this.nZ <= 0) {
            return false;
        }
        if (this.sizeChanged) {
            if (this.vectorSizeXData != null || this.vectorSizeYData != null || this.vectorSizeZData != null || !this.isAngleSet()) {
                if (Double.isNaN(this.constantLength)) {
                    double dx = this.vectorSizeX;
                    double dy = this.vectorSizeY;
                    double dz = this.vectorSizeZ;
                    int i = 0;
                    int el = 0;
                    while (i < this.nX) {
                        int j = 0;
                        while (j < this.nY) {
                            int k = 0;
                            while (k < this.nZ) {
                                if (this.vectorSizeXData != null) {
                                    dx = this.vectorSizeXData[i][j][k];
                                }
                                if (this.vectorSizeYData != null) {
                                    dy = this.vectorSizeYData[i][j][k];
                                }
                                if (this.vectorSizeZData != null) {
                                    dz = this.vectorSizeZData[i][j][k];
                                }
                                this.vectorLength[i][j][k] = Math.sqrt(dx * dx + dy * dy + dz * dz);
                                this.getElement(el).setSizeXYZ(dx, dy, dz);
                                ++k;
                                ++el;
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    int el = 0;
                    while (i < this.nX) {
                        int j = 0;
                        while (j < this.nY) {
                            int k = 0;
                            while (k < this.nZ) {
                                double length;
                                double dx = this.vectorSizeX;
                                double dy = this.vectorSizeY;
                                double dz = this.vectorSizeZ;
                                if (this.vectorSizeXData != null) {
                                    dx = this.vectorSizeXData[i][j][k];
                                }
                                if (this.vectorSizeYData != null) {
                                    dy = this.vectorSizeYData[i][j][k];
                                }
                                if (this.vectorSizeZData != null) {
                                    dz = this.vectorSizeZData[i][j][k];
                                }
                                if ((length = (this.vectorLength[i][j][k] = Math.sqrt(dx * dx + dy * dy + dz * dz))) == 0.0) {
                                    dz = 0.0;
                                    dy = 0.0;
                                    dx = 0.0;
                                } else {
                                    length = this.constantLength / length;
                                    dx *= length;
                                    dy *= length;
                                    dz *= length;
                                }
                                this.getElement(el).setSizeXYZ(dx, dy, dz);
                                ++k;
                                ++el;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else {
                double alpha = this.vectorAlpha;
                double beta = this.vectorBeta;
                int i = 0;
                int el = 0;
                while (i < this.nX) {
                    int j = 0;
                    while (j < this.nY) {
                        int k = 0;
                        while (k < this.nZ) {
                            if (this.vectorAlphaData != null) {
                                alpha = this.vectorAlphaData[i][j][k];
                            }
                            if (this.vectorBetaData != null) {
                                beta = this.vectorBetaData[i][j][k];
                            }
                            this.vectorLength[i][j][k] = this.constantLength;
                            double csb = Math.cos(beta);
                            this.getElement(el).setSizeXYZ(this.constantLength * Math.cos(alpha) * csb, this.constantLength * Math.sin(alpha) * csb, this.constantLength * Math.sin(beta));
                            ++k;
                            ++el;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (!this.isMagnitudeSet()) {
                this.magChanged = true;
            }
        }
        double oldUseMinX = this.useMinX;
        double oldUseMaxX = this.useMaxX;
        double oldUseMinY = this.useMinY;
        double oldUseMaxY = this.useMaxY;
        double oldUseMinZ = this.useMinZ;
        double oldUseMaxZ = this.useMaxZ;
        this.checkExtrema();
        if (this.positionChanged || oldUseMinX != this.useMinX || oldUseMaxX != this.useMaxX || oldUseMinY != this.useMinY || oldUseMaxY != this.useMaxY || oldUseMinZ != this.useMinZ || oldUseMaxZ != this.useMaxZ) {
            double dz;
            double startZ;
            double dy;
            double startY;
            double dx;
            double startX;
            if (this.nX <= 1) {
                startX = (this.useMinX + this.useMaxX) / 2.0;
                dx = 0.0;
            } else {
                startX = this.useMinX;
                dx = (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
            }
            if (this.nY <= 1) {
                startY = (this.useMinY + this.useMaxY) / 2.0;
                dy = 0.0;
            } else {
                startY = this.useMinY;
                dy = (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
            }
            if (this.nZ <= 1) {
                startZ = (this.useMinZ + this.useMaxZ) / 2.0;
                dz = 0.0;
            } else {
                startZ = this.useMinZ;
                dz = (this.useMaxZ - this.useMinZ) / (double)(this.nZ - 1);
            }
            int i = 0;
            int el = 0;
            while (i < this.nX) {
                double x = startX + (double)i * dx;
                int j = 0;
                while (j < this.nY) {
                    double y = startY + (double)j * dy;
                    int k = 0;
                    while (k < this.nZ) {
                        double z = startZ + (double)k * dz;
                        this.getElement(el).setXYZ(x, y, z);
                        ++k;
                        ++el;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.magChanged) {
            this.processMagnitude();
        }
        this.magChanged = false;
        this.sizeChanged = false;
        this.positionChanged = false;
        this.invisibleElement.setVisible(false);
        return true;
    }

    private void processMagnitude() {
        this.mapper.checkPallet(this.getPanel().getVisualizationHints().getBackgroundColor());
        if (this.levels > 0) {
            double[][][] magArray;
            double[][][] dArray = magArray = this.isMagnitudeSet() ? this.vectorMagnitudeData : this.vectorLength;
            if (magArray != null) {
                if (this.autoscaleMagnitude) {
                    this.computeMagnitudeExtrema(magArray);
                }
                int i = 0;
                int el = 0;
                while (i < this.nX) {
                    int j = 0;
                    while (j < this.nY) {
                        int k = 0;
                        while (k < this.nZ) {
                            Element element = this.getElement(el);
                            double mag = magArray[i][j][k];
                            Color color = this.magToColor(mag);
                            if (color == null) {
                                element.setVisible(false);
                            } else {
                                element.setVisible(true);
                                element.getStyle().setLineColor(color);
                                element.getStyle().setFillColor(color);
                                element.getStyle().setExtraColor(this.magToCompColor(mag));
                            }
                            ++k;
                            ++el;
                        }
                        ++j;
                    }
                    ++i;
                }
                return;
            }
        }
        Color color = Double.isNaN(this.vectorMagnitude) ? this.minColor : this.magToColor(this.vectorMagnitude);
        Color extraColor = Double.isNaN(this.vectorMagnitude) ? this.maxColor : this.magToCompColor(this.vectorMagnitude);
        int i = 0;
        int el = 0;
        while (i < this.nX) {
            int j = 0;
            while (j < this.nY) {
                int k = 0;
                while (k < this.nZ) {
                    Element element = this.getElement(el);
                    element.setVisible(true);
                    element.getStyle().setLineColor(color);
                    element.getStyle().setFillColor(color);
                    element.getStyle().setExtraColor(extraColor);
                    ++k;
                    ++el;
                }
                ++j;
            }
            ++i;
        }
    }

    private void computeMagnitudeExtrema(double[][][] temp) {
        if (temp == null) {
            return;
        }
        this.minMagnitude = Double.POSITIVE_INFINITY;
        this.maxMagnitude = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < temp.length) {
            double[][] v = temp[i];
            int j = 0;
            while (j < v.length) {
                double[] vij = v[j];
                int k = 0;
                while (k < vij.length) {
                    this.minMagnitude = Math.min(this.minMagnitude, vij[k]);
                    this.maxMagnitude = Math.max(this.minMagnitude, vij[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
    }

    private void initColors() {
        int redStart = this.minColor.getRed();
        int greenStart = this.minColor.getGreen();
        int blueStart = this.minColor.getBlue();
        int alphaStart = this.minColor.getAlpha();
        int redEnd = this.maxColor.getRed();
        int greenEnd = this.maxColor.getGreen();
        int blueEnd = this.maxColor.getBlue();
        int alphaEnd = this.maxColor.getAlpha();
        int i = 0;
        while (i < this.levels) {
            int r = (int)((float)redStart + (float)((redEnd - redStart) * i) * 1.0f / (float)(this.levels - 1));
            int g = (int)((float)greenStart + (float)((greenEnd - greenStart) * i) * 1.0f / (float)(this.levels - 1));
            int b = (int)((float)blueStart + (float)((blueEnd - blueStart) * i) * 1.0f / (float)(this.levels - 1));
            int a = (int)((float)alphaStart + (float)((alphaEnd - alphaStart) * i) * 1.0f / (float)(this.levels - 1));
            this.colors[i] = new Color(r, g, b, a);
            ++i;
        }
    }

    private Color magToColor(double mag) {
        if (this.useColorMapper) {
            return this.mapper.doubleToColor(mag);
        }
        if (this.colors == null || this.levels == 0) {
            return this.minColor;
        }
        int index = (int)(this.magConstant * (mag - this.minMagnitude));
        if (this.invisibleLevel >= 0 && index <= this.invisibleLevel) {
            return null;
        }
        if (index <= 0) {
            return this.colors[0];
        }
        if (index >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[index];
    }

    private Color magToCompColor(double mag) {
        if (this.useColorMapper) {
            return this.mapper.doubleToCompColor(mag);
        }
        if (this.colors == null || this.levels == 0) {
            return this.maxColor;
        }
        int index = (int)(this.magConstant * (this.maxMagnitude - mag));
        if (this.invisibleLevel >= 0 && index <= this.invisibleLevel) {
            return null;
        }
        if (index <= 0) {
            return this.colors[0];
        }
        if (index >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[index];
    }
}

