/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.event.ActionListener;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSurface;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSurface;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementSurface
extends Element {
    protected double[][][] data;
    private ActionListener listener = null;
    protected int nu = -1;
    protected int nv = -1;

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementSurface(this);
            }
            case 1: 
        }
        return new Java3dElementSurface(this);
    }

    public void setData(double[][][] data) {
        this.data = data;
        this.addChange(8);
    }

    public double[][][] getData() {
        return this.data;
    }

    public void setActionListener(ActionListener _listener) {
        this.listener = _listener;
    }

    @Override
    public void processChanges(int _cummulativeChange) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        super.processChanges(_cummulativeChange);
    }

    @Override
    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        int i = 0;
        int n1 = this.data.length;
        while (i < n1) {
            int j = 0;
            int n2 = this.data[0].length;
            while (j < n2) {
                System.arraycopy(this.data[i][j], 0, aPoint, 0, 3);
                this.sizeAndToSpaceFrame(aPoint);
                minX = Math.min(minX, aPoint[0]);
                maxX = Math.max(maxX, aPoint[0]);
                minY = Math.min(minY, aPoint[1]);
                maxY = Math.max(maxY, aPoint[1]);
                minZ = Math.min(minZ, aPoint[2]);
                maxZ = Math.max(maxZ, aPoint[2]);
                ++j;
            }
            ++i;
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }
}

