/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementPolygon;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementPolygon;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementPolygon
extends Element
implements Data {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private ActionListener listener = null;
    protected int datasetID = this.hashCode();

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementPolygon(this);
            }
            case 1: 
        }
        return new Java3dElementPolygon(this);
    }

    public void setClosed(boolean _closed) {
        if (this.closed == _closed) {
            return;
        }
        this.closed = _closed;
        this.addChange(64);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setActionListener(ActionListener _listener) {
        this.listener = _listener;
    }

    public void setData(double[][] data) {
        if (data == null) {
            return;
        }
        int n = data.length;
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][3];
        }
        int i = 0;
        while (i < n) {
            System.arraycopy(data[i], 0, this.coordinates[i], 0, 3);
            ++i;
        }
        this.addChange(2);
    }

    public void setData(double[] xArray, double[] yArray, double[] zArray) {
        if (xArray == null || yArray == null || zArray == null) {
            return;
        }
        int n = Math.max(xArray.length, Math.max(yArray.length, zArray.length));
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][3];
        }
        if (xArray.length == yArray.length && xArray.length == zArray.length) {
            int i = 0;
            while (i < n) {
                this.coordinates[i][0] = xArray[i];
                this.coordinates[i][1] = yArray[i];
                this.coordinates[i][2] = zArray[i];
                ++i;
            }
        } else {
            double lastX = xArray[xArray.length - 1];
            double lastY = yArray[yArray.length - 1];
            double lastZ = zArray[zArray.length - 1];
            int i = 0;
            while (i < n) {
                this.coordinates[i][0] = i < xArray.length ? xArray[i] : lastX;
                this.coordinates[i][1] = i < yArray.length ? yArray[i] : lastY;
                this.coordinates[i][2] = i < zArray.length ? zArray[i] : lastZ;
                ++i;
            }
        }
        this.addChange(2);
    }

    public double[][] getData() {
        return this.coordinates;
    }

    public double[][] getDataArray() {
        return this.coordinates;
    }

    @Override
    public void processChanges(int _cummulativeChange) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        super.processChanges(_cummulativeChange);
    }

    @Override
    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        int i = 0;
        int n = this.coordinates.length;
        while (i < n) {
            System.arraycopy(this.coordinates[i], 0, aPoint, 0, 3);
            this.sizeAndToSpaceFrame(aPoint);
            minX = Math.min(minX, aPoint[0]);
            maxX = Math.max(maxX, aPoint[0]);
            minY = Math.min(minY, aPoint[1]);
            maxY = Math.max(maxY, aPoint[1]);
            minZ = Math.min(minZ, aPoint[2]);
            maxZ = Math.max(maxZ, aPoint[2]);
            ++i;
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] data = new double[3][this.coordinates.length];
        int i = 0;
        int n = this.coordinates.length;
        while (i < n) {
            data[0][i] = this.coordinates[i][0];
            data[1][i] = this.coordinates[i][1];
            data[2][i] = this.coordinates[i][2];
            ++i;
        }
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"x", "y", "z"};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, Color.BLUE, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{Color.BLACK, Color.BLUE, (Color)fill};
        }
        return new Color[]{Color.BLACK, Color.BLUE, Color.RED};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

