/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Component;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Element;

public class PlottingPanel2D
extends PlottingPanel
implements DrawingPanel {
    private static final long serialVersionUID = 1L;

    public PlottingPanel2D(String xLabel, String yLabel, String title) {
        super(xLabel, yLabel, title);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public double[] projectPosition(double[] p, double[] pixel) {
        pixel[0] = super.xToPix(p[0]);
        pixel[1] = super.yToPix(p[1]);
        return pixel;
    }

    @Override
    public double[] projectSize(double[] p, double[] size, double[] pixelSize) {
        pixelSize[0] = this.xPixPerUnit * size[0];
        pixelSize[1] = this.yPixPerUnit * size[1];
        return pixelSize;
    }

    @Override
    public void addDrawable(Drawable drawable) {
        if (drawable instanceof Element) {
            ((Element)drawable).setPanel(this);
        }
        super.addDrawable(drawable);
    }

    @Override
    public void addDrawableAtIndex(int _index, Drawable drawable) {
        if (drawable instanceof Element) {
            ((Element)drawable).setPanel(this);
        }
        super.addDrawableAtIndex(_index, drawable);
    }

    @Override
    public void invalidateImage() {
        super.invalidateImage();
        for (Drawable drawable : super.getDrawables()) {
            if (!(drawable instanceof Element)) continue;
            ((Element)drawable).setNeedToProject(true);
        }
    }

    @Override
    protected boolean isValidImage() {
        if (!super.isValidImage()) {
            return false;
        }
        for (Drawable drawable : super.getDrawables()) {
            if (!(drawable instanceof Element) || !((Element)drawable).hasChanged()) continue;
            return false;
        }
        return true;
    }
}

