/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing2d.Element;

public class ElementText
extends Element {
    private String text = "";
    private Font font;
    private boolean trueSize = false;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private TextLine textLine = new TextLine();
    private AffineTransform translation = new AffineTransform();

    public ElementText() {
        this.setSizeXY(0.4, 0.4);
        this.setFont(new Font("dialog", 0, 12));
        this.getStyle().setRelativePosition(0);
        this.getStyle().setFillColor(this.getStyle().getLineColor());
    }

    public void setText(String _text) {
        this.text = _text;
        this.textLine.setText(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font _font) {
        this.font = _font;
        this.textLine.setFont(_font);
    }

    public Font getFont() {
        return this.font;
    }

    public void setTrueSize(boolean _s) {
        this.trueSize = _s;
        this.setNeedToProject(true);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    @Override
    protected void styleChanged(int styleThatChanged) {
        if (styleThatChanged == 5) {
            double y1;
            double x1;
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    this.textLine.setJustification(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    this.textLine.setJustification(2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    this.textLine.setJustification(1);
                }
            }
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    x1 = -0.5;
                    y1 = -0.5;
                    break;
                }
                case 1: {
                    x1 = -0.5;
                    y1 = -1.0;
                    break;
                }
                case 2: {
                    x1 = -0.5;
                    y1 = 0.0;
                    break;
                }
                case 3: {
                    x1 = -1.0;
                    y1 = -0.5;
                    break;
                }
                case 4: {
                    x1 = 0.0;
                    y1 = -0.5;
                    break;
                }
                case 5: {
                    x1 = -1.0;
                    y1 = -1.0;
                    break;
                }
                case 6: {
                    x1 = 0.0;
                    y1 = -1.0;
                    break;
                }
                case 7: {
                    x1 = -1.0;
                    y1 = 0.0;
                    break;
                }
                case 8: {
                    x1 = 0.0;
                    y1 = 0.0;
                }
            }
            this.translation = AffineTransform.getTranslateInstance(x1, y1);
        }
    }

    @Override
    protected int getCorners(double[] _corners) {
        if (this.trueSize) {
            _corners[1] = 0.0;
            _corners[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                _corners[0] = -0.5;
                _corners[1] = -0.5;
                break;
            }
            case 1: {
                _corners[0] = -0.5;
                _corners[1] = -1.0;
                break;
            }
            case 2: {
                _corners[0] = -0.5;
                _corners[1] = 0.0;
                break;
            }
            case 3: {
                _corners[0] = -1.0;
                _corners[1] = -0.5;
                break;
            }
            case 4: {
                _corners[0] = 0.0;
                _corners[1] = -0.5;
                break;
            }
            case 5: {
                _corners[0] = -1.0;
                _corners[1] = -1.0;
                break;
            }
            case 6: {
                _corners[0] = 0.0;
                _corners[1] = -1.0;
                break;
            }
            case 7: {
                _corners[0] = -1.0;
                _corners[1] = 0.0;
                break;
            }
            case 8: {
                _corners[0] = 0.0;
                _corners[1] = 0.0;
            }
        }
        _corners[4] = _corners[2] = _corners[0] + 1.0;
        _corners[6] = _corners[0];
        _corners[3] = _corners[1];
        _corners[5] = _corners[7] = _corners[1] + 1.0;
        return 4;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.isReallyVisible() || this.text == null || this.text.length() <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        Color color = this.getStyle().getLineColor();
        Paint fill = this.getStyle().getFillColor();
        g2.setStroke(this.getStyle().getLineStroke());
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            this.textLine.setColor(color);
            AffineTransform originalTransform = g2.getTransform();
            try {
                AffineTransform tr = new AffineTransform(originalTransform);
                tr.concatenate(AffineTransform.getTranslateInstance(this.pixel[0], this.pixel[1]));
                tr.concatenate(((AffineTransform)this.getTransformation()).createInverse());
                tr.concatenate(AffineTransform.getTranslateInstance(-this.pixel[0], -this.pixel[1]));
                g2.setTransform(tr);
            }
            catch (Exception tr) {
                // empty catch block
            }
            int a1 = (int)this.pixel[0];
            int b1 = (int)this.pixel[1];
            int leny = this.textLine.getHeight(_g) / 2;
            switch (this.getStyle().getRelativePosition()) {
                case 0: 
                case 3: 
                case 4: {
                    b1 = (int)((double)b1 + (double)leny / 2.0);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    b1 += leny;
                    break;
                }
            }
            this.textLine.drawText(g2, a1, b1);
            g2.setTransform(originalTransform);
        } else {
            TextLayout tl = new TextLayout(this.text, this.font, g2.getFontRenderContext());
            Rectangle2D rect = tl.getBounds();
            AffineTransform tr = new AffineTransform(this.translation);
            tr.scale(1.0 / rect.getWidth(), -1.0 / rect.getHeight());
            tr.translate(-rect.getX(), -rect.getMaxY());
            Shape shape = this.getPixelTransform(_panel).createTransformedShape(tl.getOutline(tr));
            if (fill != null && this.getStyle().isDrawingFill()) {
                g2.setPaint(fill);
                g2.fill(shape);
            }
            if (color != null && this.getStyle().isDrawingLines()) {
                g2.setColor(color);
                g2.draw(shape);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        int sensitivity = this.getStyle().getSensitivity();
        if (Math.abs(this.pixel[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixel[1] - (double)_ypix) < (double)sensitivity) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        this.setNeedToProject(false);
    }
}

