/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.VectorPlot;

public class VectorColorMapper {
    public static final int SPECTRUM = 0;
    public static final int RED = 1;
    public static final int BLUE = 2;
    public static final int GREEN = 3;
    public static final int GRAY = 4;
    public static final int BLACK = 5;
    private static final Color RED_COMP;
    private static final Color GREEN_COMP;
    private static final Color BLUE_COMP;
    private Color background = Color.WHITE;
    private Color[] colors;
    private Color[] compColors;
    private double ceil;
    private double floor;
    private int numColors;
    private int paletteType;
    private JFrame legendFrame;
    private VectorPlot legendPlot;
    private InteractivePanel legendPanel;

    static {
        float[] fArray = Color.RGBtoHSB(255, 0, 0, null);
        RED_COMP = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
        fArray = Color.RGBtoHSB(0, 255, 0, null);
        GREEN_COMP = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
        fArray = Color.RGBtoHSB(0, 255, 0, null);
        BLUE_COMP = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
    }

    public VectorColorMapper(int n, double d) {
        this.ceil = d;
        this.numColors = n;
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
        this.paletteType = 0;
        this.createSpectrumPalette();
    }

    public void setNumberOfColors(int n) {
        if (n == this.numColors) {
            return;
        }
        this.numColors = n;
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
        this.setPaletteType(this.paletteType);
    }

    public double getFloor() {
        return this.floor;
    }

    public double getCeiling() {
        return this.ceil;
    }

    public void setPaletteType(int n) {
        if (this.paletteType == n && this.numColors == this.colors.length) {
            return;
        }
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
        this.paletteType = n;
        switch (this.paletteType) {
            case 1: {
                this.createRedSpectrumPalette();
                return;
            }
            case 2: {
                this.createBlueSpectrumPalette();
                return;
            }
            case 3: {
                this.createGreenSpectrumPalette();
                return;
            }
            case 5: {
                return;
            }
            case 4: {
                this.createGraySpectrumPalette();
                return;
            }
        }
        this.createSpectrumPalette();
    }

    public void checkPallet(Color color) {
        if (this.background == color) {
            return;
        }
        this.background = color;
        switch (this.paletteType) {
            case 1: {
                this.createRedSpectrumPalette();
                return;
            }
            case 2: {
                this.createBlueSpectrumPalette();
                return;
            }
            case 3: {
                this.createGreenSpectrumPalette();
                return;
            }
            case 5: {
                return;
            }
            case 4: {
                this.createGraySpectrumPalette();
                return;
            }
        }
        this.createSpectrumPalette();
    }

    public void setScale(double d) {
        this.ceil = d;
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
    }

    public Color doubleToCompColor(double d) {
        if (d <= this.floor) {
            return this.background;
        }
        switch (this.paletteType) {
            case 1: {
                if (d >= this.ceil) {
                    return RED_COMP;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.compColors[n];
            }
            case 2: {
                if (d >= this.ceil) {
                    return BLUE_COMP;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.compColors[n];
            }
            case 3: {
                if (d >= this.ceil) {
                    return GREEN_COMP;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.compColors[n];
            }
            case 5: {
                return Color.WHITE;
            }
            case 4: {
                if (d >= this.ceil) {
                    return Color.black;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.colors[n];
            }
        }
        Color color = this.getSpectrumColor(d);
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(this.background.getRed(), this.background.getGreen(), this.background.getBlue(), null);
        return Color.getHSBColor((2.0f * fArray2[0] - fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
    }

    public Color doubleToColor(double d) {
        if (d <= this.floor) {
            return this.background;
        }
        switch (this.paletteType) {
            case 1: {
                if (d >= this.ceil) {
                    return Color.RED;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.colors[n];
            }
            case 2: {
                if (d >= this.ceil) {
                    return Color.BLUE;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.colors[n];
            }
            case 3: {
                if (d >= this.ceil) {
                    return Color.GREEN;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.colors[n];
            }
            case 5: {
                return Color.black;
            }
            case 4: {
                if (d >= this.ceil) {
                    return Color.black;
                }
                int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
                return this.colors[n];
            }
        }
        return this.getSpectrumColor(d);
    }

    private Color getSpectrumColor(double d) {
        if (this.background == Color.BLACK && d >= this.ceil) {
            int n = (int)(255.0 * (1.0 - this.ceil / d));
            return new Color(255, n, n);
        }
        if (d >= this.ceil) {
            return new Color((int)(255.0 * this.ceil / d), 0, 0);
        }
        int n = (int)((double)(this.numColors - 1) * (d / this.ceil));
        return this.colors[n];
    }

    private void createRedSpectrumPalette() {
        this.colors = new Color[this.numColors];
        this.compColors = new Color[this.numColors];
        int n = this.background.getRed();
        int n2 = this.background.getGreen();
        int n3 = this.background.getBlue();
        int n4 = 0;
        while (n4 < this.numColors) {
            int n5 = n + (255 - n) * n4 / this.numColors;
            int n6 = n2 - n2 * n4 / this.numColors;
            int n7 = n3 - n3 * n4 / this.numColors;
            this.colors[n4] = new Color(n5, n6, n7);
            float[] fArray = Color.RGBtoHSB(n5, n6, n7, null);
            Color color = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
            n5 = n + (color.getRed() - n) * n4 / this.numColors;
            n6 = n2 + (color.getGreen() - n2) * n4 / this.numColors;
            n7 = n3 + (color.getBlue() - n3) * n4 / this.numColors;
            this.compColors[n4] = new Color(n5, n6, n7);
            ++n4;
        }
    }

    private void createGreenSpectrumPalette() {
        this.colors = new Color[this.numColors];
        this.compColors = new Color[this.numColors];
        int n = this.background.getRed();
        int n2 = this.background.getGreen();
        int n3 = this.background.getBlue();
        int n4 = 0;
        while (n4 < this.numColors) {
            int n5 = n - n * n4 / this.numColors;
            int n6 = n2 + (255 - n2) * n4 / this.numColors;
            int n7 = n3 - n3 * n4 / this.numColors;
            this.colors[n4] = new Color(n5, n6, n7);
            float[] fArray = Color.RGBtoHSB(n5, n6, n7, null);
            Color color = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
            n5 = n + (color.getRed() - n) * n4 / this.numColors;
            n6 = n2 + (color.getGreen() - n2) * n4 / this.numColors;
            n7 = n3 + (color.getBlue() - n3) * n4 / this.numColors;
            this.compColors[n4] = new Color(n5, n6, n7);
            ++n4;
        }
    }

    private void createBlueSpectrumPalette() {
        this.colors = new Color[this.numColors];
        this.compColors = new Color[this.numColors];
        int n = this.background.getRed();
        int n2 = this.background.getGreen();
        int n3 = this.background.getBlue();
        int n4 = 0;
        while (n4 < this.numColors) {
            int n5 = n - n * n4 / this.numColors;
            int n6 = n2 - n2 * n4 / this.numColors;
            int n7 = n3 + (255 - n3) * n4 / this.numColors;
            this.colors[n4] = new Color(n5, n6, n7);
            float[] fArray = Color.RGBtoHSB(n5, n6, n7, null);
            Color color = Color.getHSBColor((fArray[0] + 0.5f) % 1.0f, fArray[1], fArray[2]);
            n5 = n + (color.getRed() - n) * n4 / this.numColors;
            n6 = n2 + (color.getGreen() - n2) * n4 / this.numColors;
            n7 = n3 + (color.getBlue() - n3) * n4 / this.numColors;
            this.compColors[n4] = new Color(n5, n6, n7);
            ++n4;
        }
    }

    private void createGraySpectrumPalette() {
        this.colors = new Color[this.numColors];
        this.compColors = this.colors;
        if (this.background == Color.BLACK) {
            int n = 0;
            while (n < this.numColors) {
                int n2 = 255 * n / this.numColors;
                this.colors[n] = new Color(n2, n2, n2);
                ++n;
            }
            return;
        }
        int n = this.background.getRed();
        int n3 = this.background.getGreen();
        int n4 = this.background.getBlue();
        int n5 = 0;
        while (n5 < this.numColors) {
            int n6 = n - n * n5 / this.numColors;
            int n7 = n3 - n3 * n5 / this.numColors;
            int n8 = n4 - n4 * n5 / this.numColors;
            this.colors[n5] = new Color(n6, n7, n8);
            ++n5;
        }
    }

    private void createSpectrumPalette() {
        this.colors = new Color[this.numColors];
        this.compColors = this.colors;
        int n = this.numColors / 3;
        n = Math.max(1, n);
        int n2 = this.background.getRed();
        int n3 = this.background.getGreen();
        int n4 = this.background.getBlue();
        int n5 = 0;
        while (n5 < n) {
            int n6 = n2 - n2 * n5 / n;
            int n7 = n3 - n3 * n5 / n;
            int n8 = Math.min(255, n3 + (255 - n4) * n5 / n);
            this.colors[n5] = new Color(n6, n7, n8);
            ++n5;
        }
        n5 = n;
        while (n5 < this.numColors) {
            double d = (double)n / 1.2;
            double d2 = (double)(n5 - n) / d;
            double d3 = (double)(n5 - 2 * n) / d;
            double d4 = (double)(n5 - this.numColors) / d;
            int n9 = (int)(255.0 * Math.exp(-d2 * d2));
            int n10 = (int)(255.0 * Math.exp(-d3 * d3));
            int n11 = (int)(255.0 * Math.exp(-d4 * d4));
            n11 = Math.min(255, n11);
            n9 = Math.min(255, n9);
            n10 = Math.min(255, n10);
            this.colors[n5] = new Color(n11, n10, n9);
            ++n5;
        }
    }

    public JFrame showLegend() {
        double d = 0.0;
        double d2 = this.ceil * 2.0;
        this.legendPanel = new InteractivePanel();
        this.legendPanel.setPreferredSize(new Dimension(300, 120));
        this.legendPanel.setPreferredGutters(0, 0, 0, 35);
        this.legendPanel.setClipAtGutter(false);
        this.legendPanel.setSquareAspect(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(this.legendPanel);
        int n = 30;
        GridPointData gridPointData = new GridPointData(n, 2, 3);
        double[][][] dArray = gridPointData.getData();
        double d3 = 1.5 * d2 / (double)n;
        double d4 = d - d3 / 2.0;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            dArray[n2][1][2] = d4;
            dArray[n2][1][3] = 0.0;
            dArray[n2][1][4] = 4.0;
            d4 += d3;
            ++n2;
        }
        gridPointData.setScale(0.0, 1.5 * d2 + d3, 0.0, 1.0);
        this.legendPlot = new VectorPlot(gridPointData);
        this.legendPlot.setPaletteType(this.paletteType);
        this.legendPlot.setAutoscaleZ(false, 0.5 * d2, d2);
        this.legendPlot.update();
        this.legendPanel.addDrawable(this.legendPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.0);
        xAxis.setEnabled(true);
        this.legendPanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public JFrame getLegendFrame() {
        return this.legendFrame;
    }

    public void updateLegend() {
        if (this.legendPlot == null) {
            return;
        }
        this.legendPlot.setPaletteType(this.paletteType);
        this.legendPlot.setAutoscaleZ(false, 0.5 * this.ceil, this.ceil);
        this.legendPlot.update();
        this.legendPanel.repaint();
    }
}

