/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlSet3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;

public class ControlShapeSet3D
extends ControlSet3D {
    private static final int SHAPESET_PROPERTIES_ADDED = 3;
    private static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 3;
    }

    @Override
    protected Element createAnElement() {
        return new ElementShape();
    }

    @Override
    protected void copyAnElement(Element oldElement, Element newElement) {
        super.copyAnElement(oldElement, newElement);
        ((ElementShape)newElement).setRotationAngle(((ElementShape)oldElement).getRotationAngle());
        ((ElementShape)newElement).setShapeType(((ElementShape)oldElement).getShapeType());
        ((ElementShape)newElement).setPixelSize(((ElementShape)oldElement).isPixelSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (_property.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("rotationAngle")) {
            return "int|double|int[]|double[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setShapeType(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setShapeType(val);
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setPixelSize(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setPixelSize(val);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setRotationAngle(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setRotationAngle((double)val[i] * (Math.PI / 180));
                        ++i;
                    }
                } else if (_value instanceof IntegerValue) {
                    double angle = (double)_value.getInteger() * (Math.PI / 180);
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setRotationAngle(angle);
                        ++i;
                    }
                } else {
                    double angle = _value.getDouble();
                    int i = 0;
                    while (i < this.numElements) {
                        ((ElementShape)this.elements[i]).setRotationAngle(angle);
                        ++i;
                    }
                }
                break;
            }
            default: {
                super.setValue(_index - 3, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                int i = 0;
                while (i < this.numElements) {
                    ((ElementShape)this.elements[i]).setShapeType(1);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.numElements) {
                    ((ElementShape)this.elements[i]).setPixelSize(false);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.numElements) {
                    ((ElementShape)this.elements[i]).setRotationAngle(0.0);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index - 3);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "0.0";
            }
        }
        return super.getDefaultValueString(_index - 3);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

