/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementPolygon;

public class ControlAnalyticCurve3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int CURVE_PROPERTIES_ADDED = 10;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected String functionZ;
    protected boolean useJavaSyntax = true;
    protected ElementPolygon polygon;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX;
    protected int indexY;
    protected int indexZ;
    private double minAbcise = Double.NaN;
    private double maxAbcise = Double.NaN;
    private static List<String> infoList = null;

    @Override
    protected Element createElement() {
        this.polygon = new ElementPolygon();
        this.polygon.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _event) {
                ControlAnalyticCurve3D.this.checkExtremes();
            }
        });
        this.polygon.setClosed(false);
        this.polygon.setCanBeMeasured(false);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.polygon;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementPolygon";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 10;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String";
        }
        if (_property.equals("min")) {
            return "int|double";
        }
        if (_property.equals("max")) {
            return "int|double";
        }
        if (_property.equals("points")) {
            return "int";
        }
        if (_property.equals("functionx")) {
            return "String";
        }
        if (_property.equals("functiony")) {
            return "String";
        }
        if (_property.equals("functionz")) {
            return "String";
        }
        if (_property.equals("javaSyntax")) {
            return "boolean";
        }
        if (_property.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.variable != null && this.variable.equals(_value.getString())) break;
                this.variable = _value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = _value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = _value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 3: {
                this.numPoints = _value.getInteger();
                break;
            }
            case 4: {
                if (this.functionX != null && this.functionX.equals(_value.getString())) break;
                this.functionX = _value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (this.functionY != null && this.functionY.equals(_value.getString())) break;
                this.functionY = _value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (this.functionZ != null && this.functionZ.equals(_value.getString())) break;
                this.functionZ = _value.getString();
                this.changedZfunction = true;
                break;
            }
            case 7: {
                if (_value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = _value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, _value.getString());
                break;
            }
            case 9: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, _value.getString());
                break;
            }
            default: {
                super.setValue(_index - 10, _value);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 7: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                break;
            }
            case 9: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                break;
            }
            default: {
                super.setDefaultValue(_index - 10);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<none>";
            }
            case 7: {
                return "true";
            }
            case 8: 
            case 9: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(_index - 10);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(_index - 10);
    }

    private boolean isVariableDefined(String varName) {
        if (this.variable.equals(varName)) {
            return true;
        }
        Value value = this.myGroup.getValue(varName);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            if (this.myParent == null) {
                return;
            }
            DrawingPanel3D panel = this.myParent.getDrawingPanel3D();
            if (Double.isNaN(this.min) && panel.getPreferredMinX() != this.minAbcise) {
                this.preupdate();
            } else if (Double.isNaN(this.max) && panel.getPreferredMaxX() != this.maxAbcise) {
                this.preupdate();
            }
        }
    }

    @Override
    public void preupdate() {
        int n;
        int i;
        int n2;
        int i2;
        ParserAndVariables pav;
        boolean parsedOk = false;
        boolean errorX = false;
        boolean errorY = false;
        boolean errorZ = false;
        if (this.changedXfunction && this.functionX != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = pav.getVariables();
            this.parserX = pav.getParser();
            i2 = 0;
            n2 = this.varsX.length;
            while (i2 < n2) {
                if (!this.isVariableDefined(this.varsX[i2])) {
                    errorX = true;
                    break;
                }
                this.parserX.defineVariable(i2, this.varsX[i2]);
                ++i2;
            }
            if (!errorX) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    errorX = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = pav.getVariables();
            this.parserY = pav.getParser();
            i2 = 0;
            n2 = this.varsY.length;
            while (i2 < n2) {
                if (!this.isVariableDefined(this.varsY[i2])) {
                    errorY = true;
                    break;
                }
                this.parserY.defineVariable(i2, this.varsY[i2]);
                ++i2;
            }
            if (!errorY) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    errorY = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = pav.getVariables();
            this.parserZ = pav.getParser();
            i2 = 0;
            n2 = this.varsZ.length;
            while (i2 < n2) {
                if (!this.isVariableDefined(this.varsZ[i2])) {
                    errorZ = true;
                    break;
                }
                this.parserZ.defineVariable(i2, this.varsZ[i2]);
                ++i2;
            }
            if (!errorZ) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    errorZ = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (errorX || errorY || errorZ) {
            this.invokeActions(1001);
        } else if (parsedOk) {
            this.invokeActions(1002);
        }
        if (this.myEjsPropertyEditor != null) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", errorX);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", errorY);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", errorZ);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve3D.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve3D.indexOf(this.variable, this.varsY);
            this.indexZ = ControlAnalyticCurve3D.indexOf(this.variable, this.varsZ);
            this.updateIndexes = false;
        }
        int nPoints = this.numPoints;
        this.minAbcise = this.min;
        this.maxAbcise = this.max;
        if (this.myParent != null) {
            DrawingPanel3D panel = this.myParent.getDrawingPanel3D();
            if (nPoints <= 0) {
                nPoints = panel != null ? Math.max(100, panel.getComponent().getWidth() / 2) : 100;
            }
            if (Double.isNaN(this.minAbcise)) {
                this.minAbcise = panel.getPreferredMinX();
            }
            if (Double.isNaN(this.maxAbcise)) {
                this.maxAbcise = panel.getPreferredMaxX();
            }
        } else if (nPoints <= 0) {
            nPoints = 100;
        }
        if (this.polygon.getDataArray().length != nPoints) {
            this.polygon.setData(new double[nPoints][3]);
        }
        double[][] data = this.polygon.getDataArray();
        if (this.isUnderEjs) {
            try {
                i = 0;
                n = this.varsX.length;
                while (i < n) {
                    if (i != this.indexX) {
                        this.parserX.setVariable(i, this.myGroup.getDouble(this.varsX[i]));
                    }
                    ++i;
                }
                i = 0;
                n = this.varsY.length;
                while (i < n) {
                    if (i != this.indexY) {
                        this.parserY.setVariable(i, this.myGroup.getDouble(this.varsY[i]));
                    }
                    ++i;
                }
                i = 0;
                n = this.varsZ.length;
                while (i < n) {
                    if (i != this.indexZ) {
                        this.parserZ.setVariable(i, this.myGroup.getDouble(this.varsZ[i]));
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                System.err.println("ControlAnalyticCurve3D: Null String?\n");
                exc.printStackTrace();
            }
        } else {
            i = 0;
            n = this.varsX.length;
            while (i < n) {
                if (i != this.indexX) {
                    this.parserX.setVariable(i, this.myGroup.getDouble(this.varsX[i]));
                }
                ++i;
            }
            i = 0;
            n = this.varsY.length;
            while (i < n) {
                if (i != this.indexY) {
                    this.parserY.setVariable(i, this.myGroup.getDouble(this.varsY[i]));
                }
                ++i;
            }
            i = 0;
            n = this.varsZ.length;
            while (i < n) {
                if (i != this.indexZ) {
                    this.parserZ.setVariable(i, this.myGroup.getDouble(this.varsZ[i]));
                }
                ++i;
            }
        }
        int i3 = 0;
        n = nPoints - 1;
        while (i3 <= n) {
            double t = ((double)(n - i3) * this.minAbcise + (double)i3 * this.maxAbcise) / (double)n;
            if (this.functionX == null || errorX) {
                data[i3][0] = 0.0;
            } else {
                if (this.indexX >= 0) {
                    this.parserX.setVariable(this.indexX, t);
                }
                data[i3][0] = this.parserX.evaluate();
            }
            if (this.functionY == null || errorY) {
                data[i3][1] = 0.0;
            } else {
                if (this.indexY >= 0) {
                    this.parserY.setVariable(this.indexY, t);
                }
                data[i3][1] = this.parserY.evaluate();
            }
            if (this.functionZ == null || errorZ) {
                data[i3][2] = 0.0;
            } else {
                if (this.indexZ >= 0) {
                    this.parserZ.setVariable(this.indexZ, t);
                }
                data[i3][2] = this.parserZ.evaluate();
            }
            ++i3;
        }
        this.polygon.addChange(2);
    }
}

