/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Quadrics;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;

public class Cone
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int CAP = 1;

    public Cone() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cone(float f, float f2) {
        this(f, f2, 1, 15, 1, null);
    }

    public Cone(float f, float f2, Appearance appearance) {
        this(f, f2, 1, 15, 1, appearance);
    }

    public Cone(float f, float f2, int n, Appearance appearance) {
        this(f, f2, n, 15, 1, appearance);
    }

    public Shape3D getShape(int n) {
        if (n > 1 || n < 0) {
            return null;
        }
        return (Shape3D)this.getChild(n);
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
        ((Shape3D)this.getChild(1)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n) {
        if (n > 1 || n < 0) {
            return null;
        }
        return this.getShape(n).getAppearance();
    }

    public Cone(float f, float f2, int n, int n2, int n3, Appearance appearance) {
        Shape3D[] shape3DArray = new Shape3D[2];
        this.radius = f;
        this.height = f2;
        this.xdivisions = n2;
        this.ydivisions = n3;
        this.flags = n;
        boolean bl = (this.flags & 4) == 0;
        Quadrics quadrics = new Quadrics();
        GeomBuffer geomBuffer = null;
        GeomBuffer geomBuffer2 = this.getCachedGeometry(4, f, 0.0f, f2, n2, n3, n);
        if (geomBuffer2 != null) {
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.coneTop((double)f2 / 2.0 - (double)(f2 / (float)this.ydivisions), f / (float)this.ydivisions, f2 / (float)this.ydivisions, this.xdivisions, 1.0 - 1.0 / (double)this.ydivisions, bl);
            shape3DArray[0] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(4, f, 0.0f, f2, n2, n3, n, geomBuffer);
            }
        }
        if (this.ydivisions > 1) {
            geomBuffer2 = this.getCachedGeometry(64, f, 0.0f, f2, n2, n3, n);
            if (geomBuffer2 != null) {
                shape3DArray[0].addGeometry((Geometry)geomBuffer2.getComputedGeometry());
                this.numVerts += geomBuffer2.getNumVerts();
                this.numTris += geomBuffer2.getNumTris();
            } else {
                geomBuffer = quadrics.coneBody(-((double)f2 / 2.0), (double)f2 / 2.0 - (double)(f2 / (float)this.ydivisions), f, f / (float)this.ydivisions, this.xdivisions, this.ydivisions - 1, 1.0 / (double)this.ydivisions, bl);
                shape3DArray[0].addGeometry((Geometry)geomBuffer.getGeom(this.flags));
                this.numVerts += geomBuffer.getNumVerts();
                this.numTris += geomBuffer.getNumTris();
                if ((n & 0x10) == 0) {
                    this.cacheGeometry(64, f, 0.0f, f2, n2, n3, n, geomBuffer);
                }
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[0].setCapability(14);
            shape3DArray[0].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[0].setCapability(12);
        }
        this.addChild((Node)shape3DArray[0]);
        geomBuffer2 = this.getCachedGeometry(32, f, f, -f2 / 2.0f, n2, n2, n);
        if (geomBuffer2 != null) {
            shape3DArray[1] = new Shape3D((Geometry)geomBuffer2.getComputedGeometry());
            this.numVerts += geomBuffer2.getNumVerts();
            this.numTris += geomBuffer2.getNumTris();
        } else {
            geomBuffer = quadrics.disk(f, n2, -((double)f2) / 2.0, !bl);
            shape3DArray[1] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(32, f, f, -f2 / 2.0f, n2, n2, n, geomBuffer);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3DArray[1].setCapability(14);
            shape3DArray[1].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3DArray[1].setCapability(12);
        }
        this.addChild((Node)shape3DArray[1]);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Node cloneNode(boolean bl) {
        Cone cone = new Cone(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        cone.duplicateNode((Node)this, bl);
        return cone;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getXdivisions() {
        return this.xdivisions;
    }

    public int getYdivisions() {
        return this.ydivisions;
    }
}

