/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.EigenvalueDecomposition;
import org.opensourcephysics.numerics.Function;

public class Polynomial
implements Function {
    protected double[] coefficients;

    public Polynomial(double[] dArray) {
        this.coefficients = dArray;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public Polynomial(String[] stringArray) {
        this.coefficients = new double[stringArray.length];
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            try {
                this.coefficients[n] = Double.parseDouble(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                this.coefficients[n] = 0.0;
            }
            ++n;
        }
    }

    public static double evalPolynomial(double d, double[] dArray) {
        int n = dArray.length - 1;
        double d2 = dArray[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            d2 = dArray[n2] + d2 * d;
            --n2;
        }
        return d2;
    }

    public Polynomial add(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        dArray[0] = this.coefficients[0] + d;
        int n2 = 1;
        while (n2 < n) {
            dArray[n2] = this.coefficients[n2];
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public Polynomial add(Polynomial polynomial) {
        int n = Math.max(polynomial.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.coefficient(n2) + polynomial.coefficient(n2);
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public double coefficient(int n) {
        return n < this.coefficients.length ? this.coefficients[n] : 0.0;
    }

    public Polynomial deflate(double d) {
        int n = this.degree();
        double d2 = this.coefficients[n];
        double[] dArray = new double[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            dArray[n2] = d2;
            d2 = d2 * d + this.coefficients[n2];
            --n2;
        }
        return new Polynomial(dArray);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public Polynomial derivative() {
        int n = this.degree();
        if (n == 0) {
            double[] dArray = new double[]{0.0};
            return new Polynomial(dArray);
        }
        double[] dArray = new double[n];
        int n2 = 1;
        while (n2 <= n) {
            dArray[n2 - 1] = this.coefficients[n2] * (double)n2;
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public Polynomial divide(double d) {
        return this.multiply(1.0 / d);
    }

    public Polynomial divide(Polynomial polynomial) {
        return this.divideWithRemainder(polynomial)[0];
    }

    public Polynomial[] divideWithRemainder(Polynomial polynomial) {
        int n;
        int n2;
        Polynomial[] polynomialArray = new Polynomial[2];
        int n3 = this.degree();
        if (n3 < (n2 = polynomial.degree())) {
            double[] dArray = new double[]{0.0};
            polynomialArray[0] = new Polynomial(dArray);
            polynomialArray[1] = polynomial;
            return polynomialArray;
        }
        double[] dArray = new double[n3 - n2 + 1];
        double[] dArray2 = new double[n3 + 1];
        int n4 = 0;
        while (n4 <= n3) {
            dArray2[n4] = this.coefficients[n4];
            ++n4;
        }
        double d = 1.0 / polynomial.coefficient(n2);
        int n5 = n3 - n2;
        while (n5 >= 0) {
            dArray[n5] = dArray2[n2 + n5] * d;
            n = n2 + n5 - 1;
            while (n >= n5) {
                int n6 = n;
                dArray2[n6] = dArray2[n6] - dArray[n5] * polynomial.coefficient(n - n5);
                --n;
            }
            --n5;
        }
        double[] dArray3 = new double[n2];
        n = 0;
        while (n < n2) {
            dArray3[n] = dArray2[n];
            ++n;
        }
        polynomialArray[0] = new Polynomial(dArray);
        polynomialArray[1] = new Polynomial(dArray3);
        return polynomialArray;
    }

    public Polynomial integral() {
        return this.integral(0.0);
    }

    public Polynomial integral(double d) {
        int n = this.coefficients.length + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        int n2 = 1;
        while (n2 < n) {
            dArray[n2] = this.coefficients[n2 - 1] / (double)n2;
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public Polynomial multiply(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.coefficients[n2] * d;
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public Polynomial multiply(Polynomial polynomial) {
        int n = polynomial.degree() + this.degree();
        double[] dArray = new double[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            dArray[n2] = 0.0;
            int n3 = 0;
            while (n3 <= n2) {
                int n4 = n2;
                dArray[n4] = dArray[n4] + polynomial.coefficient(n3) * this.coefficient(n2 - n3);
                ++n3;
            }
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public double[][] roots() {
        int n;
        int n2 = n = this.coefficients.length - 1;
        while (n2 > 0) {
            if (this.coefficients[n] != 0.0) break;
            n = n2--;
        }
        if (n == 0) {
            return new double[2][0];
        }
        double d = this.coefficients[n];
        double[][] dArray = new double[n][n];
        dArray[0][n - 1] = -this.coefficients[0] / d;
        int n3 = 0;
        while (n3 < n - 1) {
            dArray[0][n3] = -this.coefficients[n - n3 - 1] / d;
            dArray[n3 + 1][n3] = 1.0;
            ++n3;
        }
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(dArray);
        double[][] dArrayArray = new double[][]{eigenvalueDecomposition.getRealEigenvalues(), eigenvalueDecomposition.getImagEigenvalues()};
        return dArrayArray;
    }

    public double[] rootsReal() {
        double[][] dArray = this.roots();
        int n = dArray[0].length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d = dArray[0][n3] * dArray[0][n3] + dArray[1][n3] * dArray[1][n3];
            if (dArray[1][n3] * dArray[1][n3] / d < 1.0E-12) {
                dArray2[n2] = dArray[0][n3];
                ++n2;
            }
            ++n3;
        }
        double[] dArray3 = new double[n2];
        System.arraycopy(dArray2, 0, dArray3, 0, n2);
        return dArray3;
    }

    public Polynomial subtract(double d) {
        return this.add(-d);
    }

    public Polynomial subtract(Polynomial polynomial) {
        int n = Math.max(polynomial.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.coefficient(n2) - polynomial.coefficient(n2);
            ++n2;
        }
        return new Polynomial(dArray);
    }

    public String toString() {
        if (this.coefficients == null || this.coefficients.length < 1) {
            return "Polynomial coefficients are undefined.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = this.coefficients.length;
        while (n < n2) {
            if (this.coefficients[n] != 0.0) {
                if (bl) {
                    stringBuffer.append(this.coefficients[n] > 0.0 ? " + " : " ");
                } else {
                    bl = true;
                }
                if (n == 0 || this.coefficients[n] != 1.0) {
                    stringBuffer.append(Double.toString(this.coefficients[n]));
                }
                if (n > 0) {
                    stringBuffer.append(" x^" + n);
                }
            }
            ++n;
        }
        String string = stringBuffer.toString();
        if (string.equals("")) {
            return "0";
        }
        return string;
    }

    public double evaluate(double d) {
        int n = this.coefficients.length;
        double d2 = this.coefficients[--n];
        while (n > 0) {
            d2 = d2 * d + this.coefficients[--n];
        }
        return d2;
    }

    public double[] valueAndDerivative(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[]{this.coefficients[--n], 0.0};
        while (n > 0) {
            dArray[1] = dArray[1] * d + dArray[0];
            dArray[0] = dArray[0] * d + this.coefficients[--n];
        }
        return dArray;
    }
}

