/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.opensourcephysics.drawing3d.ElementObject;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class Java3dElementObject
extends Java3dElement {
    protected static final double MAX_SIZE = 1.0;
    protected static final double ROTATION = 1.5707963267948966;
    private static String OBJ = ".obj";
    protected BranchGroup bg = null;
    protected TransformGroup tg = null;
    private boolean noTriangulate = true;
    private boolean noStripify = false;
    private double creaseAngle = 60.0;
    protected Transform3D rX = new Transform3D();

    public Java3dElementObject(ElementObject elementObject) {
        super(elementObject);
        this.tg = new TransformGroup();
        this.tg.setCapability(13);
        this.tg.setCapability(12);
        this.tg.setCapability(14);
        this.tg.setCapability(18);
        this.rX.rotX(1.5707963267948966);
        this.tg.setTransform(this.rX);
        if (((ElementObject)this.element).getObjectFile() != null) {
            this.element.addChange(8);
        }
    }

    public void processChanges(int n, int n2) {
        String string;
        super.processChanges(n, n2);
        if ((n & 8) != 0 && (string = ((ElementObject)this.element).getObjectFile().toLowerCase()).substring(string.length() - 5).contains(OBJ)) {
            Resource resource = ResourceLoader.getResource(((ElementObject)this.element).getObjectFile());
            int n3 = 64;
            if (!this.noTriangulate) {
                n3 |= 0x80;
            }
            if (!this.noStripify) {
                n3 |= 0x200;
            }
            ObjectFile objectFile = new ObjectFile(n3, (float)(this.creaseAngle * Math.PI / 180.0));
            Scene scene = null;
            try {
                scene = objectFile.load(resource.getURL());
                Hashtable hashtable = scene.getNamedObjects();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Shape3D shape3D = (Shape3D)hashtable.get(string2);
                    shape3D.setAppearance(this.getAppearance());
                }
                if (this.bg != null) {
                    this.tg.removeChild((Node)this.bg);
                }
                this.bg = new BranchGroup();
                this.bg.setCapability(17);
                this.bg.addChild((Node)scene.getSceneGroup());
                this.tg.addChild((Node)this.bg);
                this.addNode((Node)this.tg);
            }
            catch (Exception exception) {
                System.out.println("Incorrect OBJ file:" + ((ElementObject)this.element).getObjectFile());
            }
        }
    }

    public boolean isPrimitive() {
        return false;
    }
}

