/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.utils.Style;

public class MultiTrail
extends Group {
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    private ElementTrail currentSegment;
    private ElementTrail.TrailPoint flushPoint = new ElementTrail.TrailPoint(0.0, 0.0, 0.0, 1);
    private int counter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;

    public MultiTrail() {
        this.createNewTrail();
    }

    public Style getStyle() {
        return this.currentSegment.getStyle();
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean bl) {
        this.noRepeat = bl;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int n) {
        if (this.skip != n) {
            this.skip = n;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void setXLabel(String string) {
        this.inputLabels[0] = string;
        this.currentSegment.setXLabel(this.inputLabels[0]);
    }

    public void setYLabel(String string) {
        this.inputLabels[1] = string;
        this.currentSegment.setYLabel(this.inputLabels[1]);
    }

    public void setZLabel(String string) {
        this.inputLabels[2] = string;
        this.currentSegment.setZLabel(this.inputLabels[2]);
    }

    public void addPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, d3, this.connectionType);
    }

    public void addPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], dArray[2], this.connectionType);
    }

    public void moveToPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, d3, 0);
    }

    public void moveToPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], dArray[2], 0);
    }

    public void addPoints(double[][] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(dArray[n][0], dArray[n][1], dArray[n][2], this.connectionType);
            ++n;
        }
    }

    public void addPoints(double d, double d2, double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(d, d2, dArray[n], this.connectionType);
            ++n;
        }
    }

    public void addPoints(double d, double[] dArray, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(d, dArray[n], d2, this.connectionType);
            ++n;
        }
    }

    public void addPoints(double[] dArray, double d, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(dArray[n], d, d2, this.connectionType);
            ++n;
        }
    }

    public void addPoints(double d, double[] dArray, double[] dArray2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(d, dArray[n2], dArray2[n2], this.connectionType);
            ++n2;
        }
    }

    public void addPoints(double[] dArray, double d, double[] dArray2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], d, dArray2[n2], this.connectionType);
            ++n2;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, double d) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2], d, this.connectionType);
            ++n2;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, Math.min(dArray2.length, dArray3.length));
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2], dArray3[n2], this.connectionType);
            ++n2;
        }
    }

    public void setMaximumPoints(int n) {
        this.maximum = Math.max(n, 2);
        this.currentSegment.setMaximumPoints(n);
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void clear() {
        for (Element element : this.getElements()) {
            ((ElementTrail)element).clear();
        }
        this.removeAllElements();
        this.addElement(this.currentSegment);
        this.initialize();
    }

    public void initialize() {
        this.currentSegment.clear();
        this.currentSegment.setGhostPoint(null);
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    public void newSegment() {
        this.currentSegment.closeTrail(Double.isNaN(this.lastX) ? 0 : this.flushPoint.getType());
        this.createNewTrail();
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    private void createNewTrail() {
        ElementTrail elementTrail = this.currentSegment;
        this.currentSegment = new ElementTrail();
        this.currentSegment.setMaximumPoints(this.maximum);
        this.currentSegment.setLabels(this.inputLabels);
        if (elementTrail != null) {
            elementTrail.getStyle().copyTo(this.currentSegment.getStyle());
        }
        this.addElement(this.currentSegment);
    }

    private void addPoint(double d, double d2, double d3, int n) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            this.lastZ = Double.NaN;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            return;
        }
        if (this.noRepeat && this.lastX == d && this.lastY == d2 && this.lastZ == d3) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint.setCoordinates(d, d2, d3, n);
                this.currentSegment.setGhostPoint(this.flushPoint);
                this.lastX = d;
                this.lastY = d2;
                this.lastZ = d3;
                return;
            }
            ++this.counter;
        }
        this.currentSegment.setGhostPoint(null);
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
        this.currentSegment.addPoint(d, d2, d3, Double.isNaN(this.lastX) ? 0 : n);
    }
}

