/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementTrail;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementTrail;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements Data {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private int maximum = 0;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    private TrailPoint ghostPoint = null;
    private List<TrailPoint> list = new ArrayList<TrailPoint>();
    private List<TrailPoint> displayPoints = new ArrayList<TrailPoint>();
    protected int datasetID = this.hashCode();

    @Override
    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementTrail(this);
            }
            case 1: 
        }
        return new Java3dElementTrail(this);
    }

    public void setMaximumPoints(int n) {
        this.maximum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        List<TrailPoint> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
        list = this.displayPoints;
        synchronized (list) {
            this.displayPoints.clear();
        }
        this.ghostPoint = null;
        this.addChange(8);
    }

    public void setLabels(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.inputLabels[n] = stringArray[n];
            ++n;
        }
    }

    public void setXLabel(String string) {
        this.inputLabels[0] = string;
    }

    public void setYLabel(String string) {
        this.inputLabels[1] = string;
    }

    public void setZLabel(String string) {
        this.inputLabels[2] = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(double d, double d2, double d3, int n) {
        TrailPoint trailPoint = new TrailPoint(d, d2, d3, n);
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.maximum > 0 && this.list.size() >= this.maximum) {
                this.list.remove(0);
            }
            this.list.add(trailPoint);
        }
        this.addChange(8);
    }

    public void addPoint(double d, double d2, double d3) {
        this.addPoint(d, d2, d3, 1);
    }

    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2], 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(TrailPoint trailPoint) {
        TrailPoint trailPoint2 = new TrailPoint(trailPoint);
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.maximum > 0 && this.list.size() >= this.maximum) {
                this.list.remove(0);
            }
            this.list.add(trailPoint2);
        }
        this.addChange(8);
    }

    public void setGhostPoint(TrailPoint trailPoint) {
        this.ghostPoint = trailPoint;
        this.addChange(8);
    }

    public void closeTrail(int n) {
        if (this.ghostPoint != null) {
            this.ghostPoint.type = n;
            this.addPoint(this.ghostPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChanges(int n) {
        if ((this.getChange() & 8) != 0) {
            this.displayPoints.clear();
            Object object = this.list;
            synchronized (object) {
                this.displayPoints.addAll(this.list);
            }
            if (this.ghostPoint != null) {
                object = this.ghostPoint;
                synchronized (object) {
                    this.displayPoints.add(new TrailPoint(this.ghostPoint));
                }
            }
        }
        super.processChanges(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.list.isEmpty()) {
                return;
            }
        }
        list = this.displayPoints;
        synchronized (list) {
            for (TrailPoint trailPoint : this.displayPoints) {
                System.arraycopy(trailPoint.coordinates, 0, dArray3, 0, 3);
                this.sizeAndToSpaceFrame(dArray3);
                d = Math.min(d, dArray3[0]);
                d2 = Math.max(d2, dArray3[0]);
                d3 = Math.min(d3, dArray3[1]);
                d4 = Math.max(d4, dArray3[1]);
                d5 = Math.min(d5, dArray3[2]);
                d6 = Math.max(d6, dArray3[2]);
            }
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    public List<TrailPoint> getDisplayPoints() {
        return this.displayPoints;
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        List<TrailPoint> list = this.displayPoints;
        synchronized (list) {
            int n = this.displayPoints.size();
            double[][] dArray = new double[3][n];
            int n2 = 0;
            while (n2 < n) {
                TrailPoint trailPoint = this.displayPoints.get(n2);
                dArray[0][n2] = trailPoint.coordinates[0];
                dArray[1][n2] = trailPoint.coordinates[1];
                dArray[2][n2] = trailPoint.coordinates[2];
                ++n2;
            }
            return dArray;
        }
    }

    public double[] getData1D() {
        int n = this.getData2D()[0].length;
        double[] dArray = new double[3 * n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.getData2D()[0][n2];
            dArray[n2 + 1] = this.getData2D()[1][n2];
            dArray[n2 + 2] = this.getData2D()[2][n2];
            ++n2;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        Paint paint = this.getStyle().getFillColor();
        if (paint instanceof Color) {
            return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), (Color)paint};
        }
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public static class TrailPoint {
        private int type;
        private double[] coordinates;

        public TrailPoint(double d, double d2, double d3, int n) {
            this.coordinates = new double[]{d, d2, d3};
            this.type = n;
        }

        public TrailPoint(TrailPoint trailPoint) {
            this.coordinates = (double[])trailPoint.coordinates.clone();
            this.type = trailPoint.type;
        }

        public void setCoordinates(double d, double d2, double d3, int n) {
            this.coordinates[0] = d;
            this.coordinates[1] = d2;
            this.coordinates[2] = d3;
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public double[] getPoint() {
            return this.coordinates;
        }
    }
}

