/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDialog
extends ControlWindow {
    private static final int DIALOG_ADDED = 4;
    protected JDialog dialog;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        return this.createDialog(null);
    }

    @Override
    public String getObjectClassname() {
        return "javax.swing.JDialog";
    }

    @Override
    public Object getObject() {
        return this.dialog;
    }

    @Override
    protected JRootPane getRootPane() {
        return this.dialog.getRootPane();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.dialog.getJMenuBar();
    }

    @Override
    public void replaceVisual(Frame frame) {
        this.dialog.dispose();
        this.myVisual = this.createDialog(frame);
        this.adjustBorder();
        this.dialog.repaint();
    }

    private Component createDialog(Frame frame) {
        this.startingup = true;
        this.dialog = new JDialog(frame, "", false, EjsControl.getDefaultGraphicsConfiguration());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlDialog.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlDialog.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlDialog.this.printScreen();
                    }
                }
            }
        });
        this.dialog.getContentPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlDialog.this.getSimulation() != null && OSPRuntime.isPopupTrigger(mouseEvent)) {
                    ControlDialog.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.internalValue = new BooleanValue(true);
        this.setListeners();
        if (this.menubar != null) {
            this.dialog.setJMenuBar(this.menubar);
        }
        return this.dialog.getContentPane();
    }

    @Override
    protected int getVisibleIndex() {
        return 14;
    }

    @Override
    protected int getLocationIndex() {
        return 5;
    }

    @Override
    protected int getSizeIndex() {
        return 15;
    }

    @Override
    public Component getComponent() {
        return this.dialog;
    }

    @Override
    public Container getContainer() {
        return this.dialog.getContentPane();
    }

    @Override
    public void add(final ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlDialog.this.menubar = (JMenuBar)controlElement.getVisual();
                ControlDialog.this.dialog.setJMenuBar(ControlDialog.this.menubar);
                ControlDialog.this.adjustSize();
            }
        });
        ((ControlSwingElement)controlElement).setControlWindow(this);
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement controlElement) {
        if (!(controlElement.getVisual() instanceof JMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        ((ControlSwingElement)controlElement).setControlWindow(null);
        this.menubar = null;
        this.dialog.setJMenuBar(null);
        this.adjustSize();
        this.dialog.validate();
        this.dialog.repaint();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("closable");
            infoList.add("modal");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("resizable")) {
            return "boolean";
        }
        if (string.equals("closable")) {
            return "boolean";
        }
        if (string.equals("modal")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.dialog.setTitle(String.valueOf(TeXParser.parseTeX(value.getString())) + " " + string);
                    break;
                }
                this.dialog.setTitle(TeXParser.parseTeX(value.getString()));
                break;
            }
            case 1: {
                this.dialog.setResizable(value.getBoolean());
                break;
            }
            case 2: {
                if (value.getBoolean()) {
                    this.dialog.setDefaultCloseOperation(1);
                    break;
                }
                this.dialog.setDefaultCloseOperation(0);
                break;
            }
            case 3: {
                if (this.isUnderEjs) break;
                this.dialog.setModal(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.dialog.setTitle(string);
                    break;
                }
                this.dialog.setTitle("");
                break;
            }
            case 1: {
                this.dialog.setResizable(true);
                break;
            }
            case 2: {
                this.dialog.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.dialog.setModal(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 4);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

