/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LevenbergMarquardt;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCurveFitter
extends JPanel {
    static ArrayList<KnownFunction> defaultFits = new ArrayList();
    static JFileChooser chooser;
    static NumberFormat SEFormat;
    Map<String, KnownFunction> allFitsMap = new TreeMap<String, KnownFunction>();
    ArrayList<KnownFunction> definedFits = new ArrayList();
    ArrayList<KnownFunction> addedFits = new ArrayList();
    PropertyChangeListener fitListener;
    Dataset dataset;
    KnownFunction fit;
    HessianMinimize hessian = new HessianMinimize();
    LevenbergMarquardt levmar = new LevenbergMarquardt();
    FunctionDrawer drawer;
    Color color = Color.MAGENTA;
    JButton colorButton;
    JButton closeButton;
    JCheckBox autofitCheckBox;
    String[] fitNames;
    JLabel fitLabel;
    JLabel eqnLabel;
    JLabel rmsLabel;
    JToolBar fitBar;
    JToolBar eqnBar;
    JToolBar rmsBar;
    JComboBox fitDropDown;
    JTextField eqnField;
    NumberField rmsField;
    ParamTableModel paramModel;
    JTable paramTable;
    ParamCellRenderer cellRenderer;
    SpinCellEditor spinCellEditor;
    int fitNumber = 1;
    JButton fitBuilderButton;
    boolean refreshing = false;
    boolean isActive;
    JSplitPane splitPane;
    JDialog colorDialog;
    int fontLevel;
    FitBuilder fitBuilder;
    double correlation = Double.NaN;
    double[] uncertainties = new double[2];
    DataToolTab tab;

    static {
        SEFormat = NumberFormat.getInstance();
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0}));
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0, 0.0}));
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0}));
        UserFunction userFunction = new UserFunction("Gaussian");
        userFunction.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 0.0, 1.0});
        userFunction.setExpression("A*exp(-(x-B)^2/C)", new String[]{"x"});
        defaultFits.add(userFunction);
        userFunction = new UserFunction("Exponential");
        userFunction.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 1.0, 0.0});
        userFunction.setExpression("A*exp(-B*(x-C))", new String[]{"x"});
        defaultFits.add(userFunction);
        userFunction = new UserFunction("Sinusoid");
        userFunction.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 1.0, 0.0});
        userFunction.setExpression("A*sin(B*x+C)", new String[]{"x"});
        defaultFits.add(userFunction);
    }

    public DatasetCurveFitter(Dataset dataset, FitBuilder fitBuilder) {
        this.dataset = dataset;
        this.fitBuilder = fitBuilder;
        this.createGUI();
        this.fit(this.fit);
    }

    public FunctionDrawer getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset dataset) {
        this.dataset = dataset;
        if (this.isActive) {
            this.fit(this.fit);
        }
        if (this.dataset != null) {
            String string = this.dataset.getXColumnName();
            string = TeXParser.removeSubscripting(string);
            this.fitBuilder.setDefaultVariables(new String[]{string});
            if (!this.isActive) {
                double[] dArray = this.dataset.getValidXPoints();
                double[] dArray2 = this.dataset.getValidYPoints();
                this.doLinearRegression(dArray, dArray2, false);
                this.refreshStatusBar();
            }
        }
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.drawer != null) {
            boolean bl;
            this.drawer.setColor(color);
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            boolean bl2 = bl = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1;
            if (bl) {
                this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
            } else {
                this.colorButton.setBackground(this.color);
            }
            this.firePropertyChange("changed", null, null);
        }
    }

    public void setAutofit(boolean bl) {
        if (bl && !this.autofitCheckBox.isSelected()) {
            this.autofitCheckBox.doClick(0);
        } else if (!bl && this.autofitCheckBox.isSelected()) {
            this.autofitCheckBox.doClick(0);
        }
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        if (bl) {
            this.fit(this.fit);
        }
    }

    public double fit(KnownFunction knownFunction) {
        if (this.drawer == null) {
            this.selectFit((String)this.fitDropDown.getSelectedItem());
        }
        if (knownFunction == null || this.dataset == null) {
            if (knownFunction instanceof UserFunction) {
                this.eqnField.setText("y = " + ((UserFunction)knownFunction).getFullExpression(new String[]{"x"}));
            } else {
                this.eqnField.setText("y = " + knownFunction.getExpression("x"));
            }
            this.autofitCheckBox.setEnabled(false);
            this.spinCellEditor.stopCellEditing();
            this.paramTable.setEnabled(false);
            this.rmsField.setText("");
            return Double.NaN;
        }
        this.autofitCheckBox.setEnabled(true);
        this.paramTable.setEnabled(true);
        double[] dArray = this.dataset.getValidXPoints();
        double[] dArray2 = this.dataset.getValidYPoints();
        double d = 0.0;
        double[] dArray3 = null;
        double d2 = this.getDevSquared(knownFunction, dArray, dArray2);
        boolean bl = false;
        if (this.autofitCheckBox.isSelected()) {
            double[] dArray4;
            KnownFunction knownFunction2;
            if (knownFunction instanceof KnownPolynomial) {
                knownFunction2 = (KnownPolynomial)knownFunction;
                ((PolynomialLeastSquareFit)((Object)knownFunction2)).fitData(dArray, dArray2);
                bl = ((Polynomial)((Object)knownFunction2)).degree() == 1;
            } else if (knownFunction instanceof UserFunction && (dArray4 = new double[((UserFunction)(knownFunction2 = (UserFunction)knownFunction)).getParameterCount()]).length > 0) {
                int n;
                MinimizeUserFunction minimizeUserFunction = new MinimizeUserFunction((UserFunction)knownFunction2, dArray, dArray2);
                dArray3 = new double[dArray4.length];
                int n2 = 0;
                while (n2 < dArray4.length) {
                    dArray4[n2] = dArray3[n2] = ((UserFunction)knownFunction2).getParameterValue(n2);
                    ++n2;
                }
                double d3 = 1.0E-6;
                int n3 = 20;
                this.hessian.minimize(minimizeUserFunction, dArray4, n3, d3);
                d = this.getDevSquared(knownFunction, dArray, dArray2);
                if (d > d2) {
                    n = 0;
                    while (n < dArray3.length) {
                        ((UserFunction)knownFunction2).setParameterValue(n, dArray3[n]);
                        ++n;
                    }
                    this.levmar.minimize(minimizeUserFunction, dArray4, n3, d3);
                    d = this.getDevSquared(knownFunction, dArray, dArray2);
                }
                if (d > d2) {
                    n = 0;
                    while (n < dArray3.length) {
                        ((UserFunction)knownFunction2).setParameterValue(n, dArray3[n]);
                        ++n;
                    }
                    d = d2;
                    this.autofitCheckBox.setSelected(false);
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        }
        this.doLinearRegression(dArray, dArray2, bl);
        if (d == 0.0) {
            d = this.getDevSquared(knownFunction, dArray, dArray2);
        }
        double d4 = Math.sqrt(d / (double)dArray.length);
        this.rmsField.setForeground(this.eqnField.getForeground());
        if (dArray.length == 0 || dArray2.length == 0) {
            this.rmsField.setText(ToolsRes.getString("DatasetCurveFitter.RMSField.NoData"));
            this.rmsField.setForeground(Color.RED);
        } else {
            this.rmsField.applyPattern("0.000E0");
            this.rmsField.setValue(d4);
        }
        this.refreshStatusBar();
        this.firePropertyChange("fit", null, null);
        return d4;
    }

    public void addFitFunction(KnownFunction knownFunction, boolean bl) {
        KnownFunction knownFunction2 = this.allFitsMap.get(knownFunction.getName());
        if (knownFunction2 != null) {
            if (knownFunction2.getExpression("x").equals(knownFunction.getExpression("x"))) {
                return;
            }
            if (knownFunction instanceof UserFunction) {
                ((UserFunction)knownFunction).setName(this.fitBuilder.getUniqueName(knownFunction.getName()));
            } else {
                return;
            }
        }
        if (bl) {
            UserFunction userFunction = (UserFunction)knownFunction;
            UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
            userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
            FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
            if (this.dataset != null) {
                String string = this.dataset.getXColumnName();
                String[] stringArray = new String[]{TeXParser.removeSubscripting(string)};
                userFunctionEditor.setDefaultVariables(stringArray);
            }
            this.fitBuilder.addPanel(userFunction.getName(), fitFunctionPanel);
        } else {
            this.addedFits.add(knownFunction);
            this.refreshFits();
        }
    }

    public String getSelectedFitName() {
        Iterator<String> iterator = this.allFitsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (this.allFitsMap.get(string) != this.fit) continue;
            return string;
        }
        return null;
    }

    public void refreshStatusBar() {
        if (this.tab != null && this.tab.statsCheckbox.isSelected()) {
            this.tab.refreshStatusBar();
        }
    }

    public double getUncertainty(int n) {
        if (n < this.uncertainties.length && this.autofitCheckBox.isSelected()) {
            return this.uncertainties[n];
        }
        return Double.NaN;
    }

    public String getUncertaintyString(int n) {
        double d = this.getUncertainty(n);
        if (Double.isNaN(d)) {
            return null;
        }
        if (SEFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)SEFormat;
            if (d < 0.1) {
                decimalFormat.applyPattern("0.0E0");
            } else if (d < 1.0) {
                decimalFormat.applyPattern("0.00");
            } else if (d < 10.0) {
                decimalFormat.applyPattern("0.0");
            } else if (d < 100.0) {
                decimalFormat.applyPattern("0");
            } else {
                decimalFormat.applyPattern("0.0E0");
            }
        }
        return "\u00b1 " + SEFormat.format(d);
    }

    public Map<String, Double> getSelectedFitParameters() {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.fitBar.getPreferredSize();
        dimension.height += this.eqnBar.getPreferredSize().height;
        dimension.height += this.rmsBar.getPreferredSize().height + 1;
        return dimension;
    }

    protected void createGUI() {
        JPanel jPanel;
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(4);
        this.autofitCheckBox = new JCheckBox("", true);
        this.autofitCheckBox.setSelected(true);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetCurveFitter.this.spinCellEditor.stopCellEditing();
                DatasetCurveFitter.this.paramTable.clearSelection();
                DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit);
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
            }
        });
        this.refreshFits();
        this.fitBuilder.addForbiddenNames(this.fitNames);
        this.fitLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.fitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.eqnLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        this.eqnLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.rmsLabel = new JLabel();
        this.rmsLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.fitDropDown = new JComboBox(this.fitNames){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.fitDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DatasetCurveFitter.this.fitDropDown.getSelectedItem().equals(DatasetCurveFitter.this.getFitName())) {
                    DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                }
                DatasetCurveFitter.this.selectFit((String)DatasetCurveFitter.this.fitDropDown.getSelectedItem());
            }
        });
        this.eqnField = new JTextField(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.eqnField.setEditable(false);
        this.eqnField.setEnabled(true);
        this.eqnField.setBackground(Color.white);
        this.eqnField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    String string = DatasetCurveFitter.this.fitDropDown.getSelectedItem().toString();
                    if (DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(string)) {
                        DatasetCurveFitter.this.fitBuilder.setSelectedPanel(string);
                    } else {
                        UserFunction userFunction = DatasetCurveFitter.this.createClone(DatasetCurveFitter.this.fit, string);
                        UserFunctionEditor userFunctionEditor = new UserFunctionEditor();
                        userFunctionEditor.setMainFunctions(new UserFunction[]{userFunction});
                        FitFunctionPanel fitFunctionPanel = new FitFunctionPanel(userFunctionEditor);
                        DatasetCurveFitter.this.fitBuilder.addPanel(userFunction.getName(), fitFunctionPanel);
                        DatasetCurveFitter.this.fitDropDown.setSelectedItem(userFunction.getName());
                    }
                    DatasetCurveFitter.this.fitBuilder.setVisible(true);
                }
            }
        });
        this.colorButton = DataTool.createButton("");
        this.colorButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Color.Tooltip"));
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = DatasetCurveFitter.this.getColorDialog();
                DatasetCurveFitter.this.closeButton.setText(ToolsRes.getString("Button.OK"));
                jDialog.setTitle(ToolsRes.getString("DatasetCurveFitter.Dialog.Color.Title"));
                jDialog.setVisible(true);
            }
        });
        this.rmsField = new NumberField(6){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = DataTool.buttonHeight - 2;
                return dimension;
            }
        };
        this.rmsField.setEditable(false);
        this.rmsField.setEnabled(true);
        this.rmsField.setBackground(Color.white);
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramModel = new ParamTableModel();
        this.paramTable = new ParamTable(this.paramModel);
        this.paramTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.paramTable){

            public Dimension getMinimumSize() {
                Dimension dimension = DatasetCurveFitter.this.spinCellEditor.spinner.getPreferredSize();
                dimension.width += DatasetCurveFitter.this.cellRenderer.fieldFont.getSize() * 7;
                return dimension;
            }
        };
        this.splitPane.setRightComponent(jScrollPane);
        this.add((Component)this.splitPane, "Center");
        this.fitBuilderButton = DataTool.createButton(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string2;
                for (String string2 : DatasetCurveFitter.this.fitBuilder.getPanelNames()) {
                    FitFunctionPanel fitFunctionPanel = (FitFunctionPanel)DatasetCurveFitter.this.fitBuilder.getPanel(string2);
                    UserFunction userFunction = DatasetCurveFitter.this.getFitFunction(fitFunctionPanel);
                    DatasetCurveFitter.this.allFitsMap.put(string2, userFunction);
                    DatasetCurveFitter.this.fitDropDown.addItem(string2);
                }
                DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                string2 = DatasetCurveFitter.this.getFitName();
                if (DatasetCurveFitter.this.fit instanceof UserFunction && string2 != null && DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(string2)) {
                    DatasetCurveFitter.this.fitBuilder.setSelectedPanel(DatasetCurveFitter.this.getFitName());
                } else if (DatasetCurveFitter.this.fitBuilder.getSelectedName() != null) {
                    DatasetCurveFitter.this.fitDropDown.setSelectedItem(DatasetCurveFitter.this.fitBuilder.getSelectedName());
                }
                DatasetCurveFitter.this.fitBuilder.setVisible(true);
            }
        });
        this.fitListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                Object object2;
                if (DatasetCurveFitter.this.refreshing) {
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("function") && !string.equals("panel")) {
                    return;
                }
                if (string.equals("panel")) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        object2 = DatasetCurveFitter.this.getFitFunction((FitFunctionPanel)propertyChangeEvent.getNewValue());
                        object = ((UserFunction)object2).getName();
                        if (!DatasetCurveFitter.this.allFitsMap.keySet().contains(object)) {
                            DatasetCurveFitter.this.allFitsMap.put((String)object, (KnownFunction)object2);
                            DatasetCurveFitter.this.fitDropDown.addItem(object);
                        }
                        if (DatasetCurveFitter.this.fitBuilder.isVisible()) {
                            DatasetCurveFitter.this.fitDropDown.setSelectedItem(object);
                        }
                    }
                    if (propertyChangeEvent.getOldValue() != null) {
                        object2 = DatasetCurveFitter.this.getFitFunction((FitFunctionPanel)propertyChangeEvent.getOldValue());
                        object = ((UserFunction)object2).getName();
                        if (!DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(object)) {
                            DatasetCurveFitter.this.allFitsMap.remove(object);
                            DatasetCurveFitter.this.fitDropDown.removeItem(object);
                        }
                    }
                }
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                object2 = DatasetCurveFitter.this.fitBuilder.getSelectedName();
                object = (FitFunctionPanel)DatasetCurveFitter.this.fitBuilder.getPanel((String)object2);
                KnownFunction knownFunction = DatasetCurveFitter.this.fit;
                if (object != null) {
                    knownFunction = DatasetCurveFitter.this.getFitFunction((FitFunctionPanel)object);
                    DatasetCurveFitter.this.allFitsMap.put((String)object2, knownFunction);
                }
                if (string.equals("function")) {
                    String string2 = (String)propertyChangeEvent.getOldValue();
                    if (string2 != null) {
                        DatasetCurveFitter.this.allFitsMap.remove(string2);
                        DatasetCurveFitter.this.allFitsMap.put((String)object2, knownFunction);
                        int n = 0;
                        while (n < DatasetCurveFitter.this.fitDropDown.getItemCount()) {
                            Object e = DatasetCurveFitter.this.fitDropDown.getItemAt(n);
                            if (e.equals(string2)) {
                                DatasetCurveFitter.this.fitDropDown.insertItemAt(object2, n);
                                DatasetCurveFitter.this.fitDropDown.removeItem(string2);
                                break;
                            }
                            ++n;
                        }
                    }
                    if (object != null && !DatasetCurveFitter.this.fitDropDown.getSelectedItem().equals(object2)) {
                        DatasetCurveFitter.this.fitDropDown.setSelectedItem(object2);
                    }
                }
                DatasetCurveFitter.this.refreshGUI();
            }
        };
        for (String object2 : this.fitBuilder.getPanelNames()) {
            jPanel = (FitFunctionPanel)this.fitBuilder.getPanel(object2);
            UserFunction userFunction = this.getFitFunction((FitFunctionPanel)jPanel);
            this.allFitsMap.put(object2, userFunction);
            this.fitDropDown.addItem(object2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.splitPane.setLeftComponent(jPanel2);
        this.fitBar = new JToolBar();
        this.fitBar.setFloatable(false);
        this.fitBar.setBorder(BorderFactory.createEtchedBorder());
        this.fitBar.add(this.fitLabel);
        this.fitBar.add(this.fitDropDown);
        this.fitBar.addSeparator();
        this.fitBar.add(this.fitBuilderButton);
        jPanel2.add((Component)this.fitBar, "North");
        JPanel jPanel22 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel22, "Center");
        this.eqnBar = new JToolBar();
        this.eqnBar.setFloatable(false);
        this.eqnBar.setBorder(BorderFactory.createEtchedBorder());
        this.eqnBar.add(this.eqnLabel);
        this.eqnBar.add(this.eqnField);
        this.eqnBar.add(this.colorButton);
        jPanel22.add((Component)this.eqnBar, "North");
        jPanel = new JPanel(new BorderLayout());
        jPanel22.add((Component)jPanel, "Center");
        this.rmsBar = new JToolBar();
        this.rmsBar.setFloatable(false);
        this.rmsBar.setBorder(BorderFactory.createEtchedBorder());
        this.rmsBar.add(this.autofitCheckBox);
        this.rmsBar.addSeparator();
        this.rmsBar.add(this.rmsLabel);
        this.rmsBar.add(this.rmsField);
        jPanel.add((Component)this.rmsBar, "North");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        boolean bl;
        this.autofitCheckBox.setText(ToolsRes.getString("Checkbox.Autofit.Label"));
        this.rmsLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.RMSDeviation"));
        this.fitBuilderButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Tooltip"));
        int n = this.fitDropDown.getItemCount();
        int n2 = n - this.fitNames.length;
        this.refreshFits();
        Object[] objectArray = new Object[this.fitNames.length + n2];
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3] = n3 < this.fitNames.length ? this.fitNames[n3] : this.fitDropDown.getItemAt(n3 + n - this.fitNames.length - n2);
            ++n3;
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        int n4 = this.fitDropDown.getSelectedIndex();
        this.fitDropDown.setModel(defaultComboBoxModel);
        this.fitDropDown.setSelectedIndex(n4);
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl2 = bl = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1;
        if (bl) {
            this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
        } else {
            this.colorButton.setBackground(this.color);
        }
    }

    protected void refreshFits() {
        this.definedFits.clear();
        for (KnownFunction knownFunction : defaultFits) {
            this.definedFits.add(knownFunction);
        }
        for (KnownFunction knownFunction : this.addedFits) {
            this.definedFits.add(knownFunction);
        }
        this.fitNames = new String[this.definedFits.size()];
        int n = 0;
        while (n < this.fitNames.length) {
            this.fitNames[n] = this.definedFits.get(n).getName();
            String string = ToolsRes.getString("Function." + this.fitNames[n] + ".Name");
            if (!string.startsWith("!")) {
                this.fitNames[n] = string;
            }
            this.allFitsMap.put(this.fitNames[n], this.definedFits.get(n));
            ++n;
        }
    }

    protected void setDataToolTab(DataToolTab dataToolTab) {
        this.tab = dataToolTab;
    }

    protected void setFontLevel(int n) {
        this.fontLevel = n;
        FontSizer.setFonts(this, this.fontLevel);
        this.fitBuilder.setFontLevel(n);
        this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation());
    }

    protected void setParameterValue(int n, double d) {
        if (n < this.fit.getParameterCount()) {
            this.fit.setParameterValue(n, d);
        }
    }

    protected void selectFit(String string) {
        this.fit = this.allFitsMap.get(string);
        if (this.fit != null) {
            String string2;
            FunctionDrawer functionDrawer = this.drawer;
            this.drawer = new FunctionDrawer(this.fit);
            this.drawer.setColor(this.color);
            this.paramTable.tableChanged(null);
            String string3 = this.dataset == null ? "y" : TeXParser.removeSubscripting(this.dataset.getColumnName(1));
            String string4 = string2 = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
            if (this.fit instanceof UserFunction) {
                this.eqnField.setText(String.valueOf(string3) + " = " + ((UserFunction)this.fit).getFullExpression(new String[]{string2}));
            } else {
                this.eqnField.setText(String.valueOf(string3) + " = " + this.fit.getExpression(string2));
            }
            this.firePropertyChange("drawer", functionDrawer, this.drawer);
            if (this.isActive) {
                this.fit(this.fit);
            }
            if (this.fit instanceof UserFunction && this.fitBuilder.isVisible()) {
                UserFunction userFunction = (UserFunction)this.fit;
                this.fitBuilder.setSelectedPanel(userFunction.getName());
            }
            this.revalidate();
        }
    }

    protected UserFunction createClone(KnownFunction knownFunction, String string) {
        int n;
        Object object;
        String string2 = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
        knownFunction.getExpression(string2);
        UserFunction userFunction = null;
        if (knownFunction instanceof UserFunction) {
            userFunction = ((UserFunction)knownFunction).clone();
        } else {
            userFunction = new UserFunction(knownFunction.getName());
            String[] stringArray = new String[knownFunction.getParameterCount()];
            object = new double[knownFunction.getParameterCount()];
            n = 0;
            while (n < stringArray.length) {
                stringArray[n] = knownFunction.getParameterName(n);
                object[n] = knownFunction.getParameterValue(n);
                ++n;
            }
            userFunction.setParameters(stringArray, (double[])object);
            userFunction.setExpression(knownFunction.getExpression(string2), new String[]{string2});
        }
        int n2 = 1;
        try {
            object = string.substring(string.length() - 1);
            n2 = Integer.parseInt((String)object) + 1;
            string = string.substring(0, string.length() - 1);
        }
        catch (Exception exception) {}
        object = new HashSet();
        n = 0;
        while (n < this.fitDropDown.getItemCount()) {
            object.add(this.fitDropDown.getItemAt(n).toString());
            ++n;
        }
        try {
            while (object.contains(String.valueOf(string) + n2)) {
                ++n2;
            }
        }
        catch (Exception exception) {}
        userFunction.setName(String.valueOf(string) + n2);
        return userFunction;
    }

    private double getDevSquared(Function function, double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            double d2 = function.evaluate(dArray[n]);
            double d3 = d2 - dArray2[n];
            d += d3 * d3;
            ++n;
        }
        return d;
    }

    public void doLinearRegression(double[] dArray, double[] dArray2, boolean bl) {
        int n = dArray.length;
        this.correlation = Double.NaN;
        int n2 = 0;
        while (n2 < this.uncertainties.length) {
            this.uncertainties[n2] = Double.NaN;
            ++n2;
        }
        if (n < 3) {
            return;
        }
        double d = dArray[0];
        double d2 = dArray2[0];
        int n3 = 1;
        while (n3 < n) {
            d += dArray[n3];
            d2 += dArray2[n3];
            ++n3;
        }
        d /= (double)n;
        d2 /= (double)n;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            double d6 = dArray[n4] - d;
            double d7 = dArray2[n4] - d2;
            d3 += d6 * d6;
            d4 += d7 * d7;
            d5 += d6 * d7;
            ++n4;
        }
        if (d3 == 0.0 || d4 == 0.0) {
            this.correlation = Double.NaN;
            n4 = 0;
            while (n4 < this.uncertainties.length) {
                this.uncertainties[n4] = Double.NaN;
                ++n4;
            }
            return;
        }
        double d8 = d3 / (double)n;
        double d9 = d4 / (double)n;
        double d10 = d5 / (double)n;
        this.correlation = d10 * d10 / (d8 * d9);
        if (bl) {
            double d11 = Math.max(0.0, d4 - d5 * d5 / d3);
            double d12 = d11 / (double)(n - 2);
            this.uncertainties[0] = Math.sqrt(d12 / d3);
            this.uncertainties[1] = Math.sqrt(d12 * (1.0 / (double)n + d * d / d3));
        }
    }

    private UserFunction getFitFunction(FitFunctionPanel fitFunctionPanel) {
        return fitFunctionPanel.getFitFunction().clone();
    }

    private String getFitName() {
        for (String string : this.allFitsMap.keySet()) {
            if (this.fit != this.allFitsMap.get(string)) continue;
            return string.toString();
        }
        return null;
    }

    protected JDialog getColorDialog() {
        if (this.colorDialog == null) {
            final Frame frame = JOptionPane.getFrameForComponent(this);
            final JColorChooser jColorChooser = new JColorChooser();
            jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    DatasetCurveFitter.this.color = jColorChooser.getColor();
                    DatasetCurveFitter.this.setColor(DatasetCurveFitter.this.color);
                    frame.repaint();
                }
            });
            this.colorDialog = new JDialog(frame, false);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DatasetCurveFitter.this.colorDialog.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.closeButton);
            AbstractColorChooserPanel abstractColorChooserPanel = jColorChooser.getChooserPanels()[0];
            abstractColorChooserPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 12, 2));
            jPanel.add((Component)abstractColorChooserPanel, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.colorDialog.setContentPane(jPanel);
            this.colorDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.colorDialog.getWidth()) / 2;
            Point point = this.getLocationOnScreen();
            int n2 = Math.max(0, point.y - this.colorDialog.getHeight());
            this.colorDialog.setLocation(n, n2);
        }
        return this.colorDialog;
    }

    public static void setDefaultFitFunctions(ArrayList<KnownFunction> arrayList) {
        if (arrayList != null) {
            defaultFits = arrayList;
        }
    }

    public class MinimizeMultiVarFunction
    implements MultiVarFunction {
        MultiVarFunction f;
        double[] x;
        double[] y;
        double[] vars = new double[5];

        MinimizeMultiVarFunction(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2) {
            this.f = multiVarFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            System.arraycopy(dArray, 0, this.vars, 1, 4);
            double d = 0.0;
            int n = 0;
            int n2 = this.x.length;
            while (n < n2) {
                this.vars[0] = this.x[n];
                double d2 = this.y[n] - this.f.evaluate(this.vars);
                d += d2 * d2;
                ++n;
            }
            return d;
        }
    }

    public class MinimizeUserFunction
    implements MultiVarFunction {
        UserFunction f;
        double[] x;
        double[] y;

        MinimizeUserFunction(UserFunction userFunction, double[] dArray, double[] dArray2) {
            this.f = userFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            int n = 0;
            while (n < dArray.length) {
                this.f.setParameterValue(n, dArray[n]);
                ++n;
            }
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.x.length) {
                double d2 = this.y[n2] - this.f.evaluate(this.x[n2]);
                d += d2 * d2;
                ++n2;
            }
            return d;
        }
    }

    class NumberField
    extends JTextField {
        protected NumberFormat format;
        protected double prevValue;

        public NumberField(int n) {
            super(n);
            this.format = NumberFormat.getInstance();
            this.setForeground(Color.black);
        }

        public double getValue() {
            double d;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                d = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return d;
        }

        public void setValue(double d) {
            if (!this.isVisible()) {
                return;
            }
            this.setText(this.format.format(d));
            this.prevValue = d;
        }

        public void applyPattern(String string) {
            if (this.format instanceof DecimalFormat) {
                ((DecimalFormat)this.format).applyPattern(string);
            }
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font fieldFont = new JTextField().getFont();
        Font labelFont = this.getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            this.setHorizontalAlignment(2);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            String string2 = string = n2 == 1 ? ToolsRes.getString("DatasetCurveFitter.SE.Description") : null;
            if (object instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(bl ? Color.LIGHT_GRAY : this.lightGray);
                this.setForeground(Color.black);
                this.setText(object.toString());
            } else {
                this.setFont(this.fieldFont);
                this.setBackground(bl ? this.lightBlue : Color.white);
                this.setForeground(bl ? Color.red : (jTable.isEnabled() ? Color.black : Color.gray));
                NumberFormat numberFormat = DatasetCurveFitter.this.spinCellEditor.field.format;
                this.setText(numberFormat.format(object));
                if (!DatasetCurveFitter.this.autofitCheckBox.isSelected()) {
                    string = String.valueOf(string) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Autofit");
                } else if (DatasetCurveFitter.this.fit instanceof KnownPolynomial) {
                    String string3;
                    string = String.valueOf(string) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Unknown");
                    KnownPolynomial knownPolynomial = (KnownPolynomial)DatasetCurveFitter.this.fit;
                    if (knownPolynomial.degree() == 1 && (string3 = DatasetCurveFitter.this.getUncertaintyString(n)) != null) {
                        string = String.valueOf(string3) + " (" + ToolsRes.getString("DatasetCurveFitter.SE.Name") + ")";
                    }
                } else {
                    string = String.valueOf(string) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Unknown");
                }
            }
            this.setToolTipText(string);
            return this;
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel paramTableModel) {
            super(paramTableModel);
            this.setGridColor(Color.blue);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setForeground(Color.blue);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return DatasetCurveFitter.this.cellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            DatasetCurveFitter.this.spinCellEditor.rowNumber = n;
            return DatasetCurveFitter.this.spinCellEditor;
        }

        public void setFont(Font font) {
            super.setFont(font);
            if (DatasetCurveFitter.this.cellRenderer != null) {
                Font font2 = DatasetCurveFitter.this.cellRenderer.labelFont;
                DatasetCurveFitter.this.cellRenderer.labelFont = font2 = font2.deriveFont(font.getSize2D());
                DatasetCurveFitter.this.spinCellEditor.stepSizeLabel.setFont(font2);
                font2 = DatasetCurveFitter.this.cellRenderer.fieldFont;
                DatasetCurveFitter.this.cellRenderer.fieldFont = font2 = font2.deriveFont(font.getSize2D());
                DatasetCurveFitter.this.spinCellEditor.field.setFont(font2);
            }
            this.setRowHeight(font.getSize() + 4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("Table.Heading.Parameter") : ToolsRes.getString("Table.Heading.Value");
        }

        @Override
        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(n);
            }
            return new Double(DatasetCurveFitter.this.fit.getParameterValue(n));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel;
        JSpinner spinner;
        NumberField field;
        int rowNumber;
        JLabel stepSizeLabel;

        SpinCellEditor() {
            this.crawlerModel = new SpinnerNumberCrawlerModel(1.0);
            this.stepSizeLabel = new JLabel("10%");
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    UserFunction userFunction;
                    String string;
                    FitFunctionPanel fitFunctionPanel;
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                    double d = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(d);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.rowNumber, d);
                    if (((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit instanceof UserFunction && (fitFunctionPanel = (FitFunctionPanel)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fitBuilder.getPanel(string = (userFunction = (UserFunction)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit).getName())) != null) {
                        string = userFunction.getParameterName(SpinCellEditor.this.rowNumber);
                        Parameter parameter = new Parameter(string, SpinCellEditor.this.field.getText());
                        block0: for (Parameter parameter2 : fitFunctionPanel.getParamEditor().evaluateDependents(parameter)) {
                            int n = 0;
                            while (n < userFunction.getParameterCount()) {
                                if (userFunction.getParameterName(n).equals(parameter2.getName())) {
                                    userFunction.setParameterValue(n, parameter2.getValue());
                                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.paramModel.fireTableCellUpdated(n, 1);
                                    continue block0;
                                }
                                ++n;
                            }
                        }
                        fitFunctionPanel.getFitFunctionEditor().parametersValid = false;
                        userFunction.updateReferenceParameters();
                    }
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.drawer.functionChanged = true;
                    DatasetCurveFitter.this.fit(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                    DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                }
            });
            this.field = new NumberField(10);
            this.field.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
            this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.spinner.setEditor(this.field);
            this.stepSizeLabel.addMouseListener(new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            double d = Double.parseDouble(actionEvent.getActionCommand());
                            (this).SpinCellEditor.this.crawlerModel.setPercentDelta(d);
                            (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            (this).SpinCellEditor.this.stepSizeLabel.setText(String.valueOf(actionEvent.getActionCommand()) + "%");
                        }
                    };
                    int n = 0;
                    while (n < 3) {
                        String string = n == 0 ? "10" : (n == 1 ? "1.0" : "0.1");
                        JMenuItem jMenuItem = new JMenuItem(String.valueOf(string) + "%");
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                        ++n;
                    }
                    jPopupMenu.show(SpinCellEditor.this.stepSizeLabel, 0, SpinCellEditor.this.stepSizeLabel.getHeight());
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    JComponent jComponent = (JComponent)keyEvent.getSource();
                    if (keyEvent.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(new Double(SpinCellEditor.this.field.getValue()));
                        jComponent.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        jComponent.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
            this.panel.add((Component)this.stepSizeLabel, "East");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.spinner.setValue(object);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return true;
            }
            return eventObject instanceof ActionEvent;
        }

        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.rowNumber, this.field.getValue());
                DatasetCurveFitter.this.drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                this.field.setBackground(Color.white);
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
            }
            return null;
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double d) {
            this.delta = d;
        }

        public Object getValue() {
            return new Double(this.val);
        }

        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        public void setValue(Object object) {
            if (object != null) {
                this.val = (Double)object;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double d) {
            this.percentDelta = d;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }
}

