/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSpring;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementSpring;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementSpring
extends ElementSegment {
    public static final double DEF_RADIUS = 0.05;
    public static final int DEF_LOOPS = 8;
    public static final int DEF_PPL = 15;
    private double radius = 0.05;
    private double solenoid = 0.0;
    private boolean thinExtremes = true;
    private int loops;
    private int pointsPerLoop;

    public ElementSpring() {
        this.setSize(new double[]{0.1, 0.1, 0.1});
        this.setResolution(8, 15);
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementSpring(this);
            }
            case 1: 
        }
        return new Java3dElementSpring(this);
    }

    public void setRadius(double d) {
        if (this.radius == d) {
            return;
        }
        this.radius = d;
        this.addChange(8);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setSolenoid(double d) {
        if (this.solenoid == d) {
            return;
        }
        this.solenoid = d;
        this.addChange(8);
    }

    public double getSolenoid() {
        return this.solenoid;
    }

    public void setThinExtremes(boolean bl) {
        if (this.thinExtremes == bl) {
            return;
        }
        this.thinExtremes = bl;
        this.addChange(8);
    }

    public boolean isThinExtremes() {
        return this.thinExtremes;
    }

    public void setResolution(int n, int n2) {
        if (n == this.loops && n2 == this.pointsPerLoop) {
            return;
        }
        this.loops = n;
        this.pointsPerLoop = n2;
        this.getStyle().setResolution(new Resolution(this.loops, this.pointsPerLoop, 1));
        this.addChange(8);
    }

    public int getLoops() {
        return this.loops;
    }

    public int getPointsPerLoop() {
        return this.pointsPerLoop;
    }
}

