/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementPolygon;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementPolygon;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPolygon
extends Element
implements Data {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private ActionListener listener = null;
    protected int datasetID = this.hashCode();

    @Override
    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementPolygon(this);
            }
            case 1: 
        }
        return new Java3dElementPolygon(this);
    }

    public void setClosed(boolean bl) {
        if (this.closed == bl) {
            return;
        }
        this.closed = bl;
        this.addChange(64);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void setData(double[][] dArray) {
        if (dArray == null) {
            return;
        }
        int n = dArray.length;
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][3];
        }
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, this.coordinates[n2], 0, 3);
            ++n2;
        }
        this.addChange(2);
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        int n = Math.max(dArray.length, Math.max(dArray2.length, dArray3.length));
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][3];
        }
        if (dArray.length == dArray2.length && dArray.length == dArray3.length) {
            int n2 = 0;
            while (n2 < n) {
                this.coordinates[n2][0] = dArray[n2];
                this.coordinates[n2][1] = dArray2[n2];
                this.coordinates[n2][2] = dArray3[n2];
                ++n2;
            }
        } else {
            double d = dArray[dArray.length - 1];
            double d2 = dArray2[dArray2.length - 1];
            double d3 = dArray3[dArray3.length - 1];
            int n3 = 0;
            while (n3 < n) {
                this.coordinates[n3][0] = n3 < dArray.length ? dArray[n3] : d;
                this.coordinates[n3][1] = n3 < dArray2.length ? dArray2[n3] : d2;
                this.coordinates[n3][2] = n3 < dArray3.length ? dArray3[n3] : d3;
                ++n3;
            }
        }
        this.addChange(2);
    }

    public double[][] getData() {
        return this.coordinates;
    }

    public double[][] getDataArray() {
        return this.coordinates;
    }

    @Override
    public void processChanges(int n) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        super.processChanges(n);
    }

    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray3, 0, 3);
            this.sizeAndToSpaceFrame(dArray3);
            d = Math.min(d, dArray3[0]);
            d2 = Math.max(d2, dArray3[0]);
            d3 = Math.min(d3, dArray3[1]);
            d4 = Math.max(d4, dArray3[1]);
            d5 = Math.min(d5, dArray3[2]);
            d6 = Math.max(d6, dArray3[2]);
            ++n;
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[3][this.coordinates.length];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            dArray[0][n] = this.coordinates[n][0];
            dArray[1][n] = this.coordinates[n][1];
            dArray[2][n] = this.coordinates[n][2];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"x", "y", "z"};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, Color.BLUE, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint paint = this.getStyle().getFillColor();
        if (paint instanceof Color) {
            return new Color[]{Color.BLACK, Color.BLUE, (Color)paint};
        }
        return new Color[]{Color.BLACK, Color.BLUE, Color.RED};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

