/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPolygon3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int POLYGON_PROPERTIES_ADDED = 6;
    private static final int INDEX_SELECTED = 2;
    private ElementPolygon polygon;
    protected IntegerValue pointValue = new IntegerValue(-1);
    private double[] xArray = null;
    private double[] yArray = null;
    private double[] zArray = null;
    private double[] xFixed = new double[]{0.0};
    private double[] yFixed = new double[]{0.0};
    private double[] zFixed = new double[]{0.0};
    private boolean dataSet = false;
    static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementPolygon";
    }

    @Override
    protected Element createElement() {
        this.polygon = new ElementPolygon();
        this.polygon.setData(new double[][]{{0.0, 0.0, 0.0}, {0.1, 0.0, 0.0}, {0.1, 0.1, 0.0}});
        return this.polygon;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 6;
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlPolygon3D.getDataInformationMenuEntries(this.getTopWindow(), this.polygon));
    }

    @Override
    public void preupdate() {
        if (this.dataSet) {
            return;
        }
        if (this.xArray == null) {
            if (this.yArray == null) {
                if (this.zArray == null) {
                    this.polygon.setData(this.xFixed, this.yFixed, this.zFixed);
                } else {
                    this.polygon.setData(this.xFixed, this.yFixed, this.zArray);
                }
            } else if (this.zArray == null) {
                this.polygon.setData(this.xFixed, this.yArray, this.zFixed);
            } else {
                this.polygon.setData(this.xFixed, this.yArray, this.zArray);
            }
        } else if (this.yArray == null) {
            if (this.zArray == null) {
                this.polygon.setData(this.xArray, this.yFixed, this.zFixed);
            } else {
                this.polygon.setData(this.xArray, this.yFixed, this.zArray);
            }
        } else if (this.zArray == null) {
            this.polygon.setData(this.xArray, this.yArray, this.zFixed);
        } else {
            this.polygon.setData(this.xArray, this.yArray, this.zArray);
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("closed");
            infoList.add("data");
            infoList.add("indexSelected");
            infoList.add("xData");
            infoList.add("yData");
            infoList.add("zData");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("closed")) {
            return "boolean";
        }
        if (string.equals("data")) {
            return "double[][]";
        }
        if (string.equals("indexSelected")) {
            return "int";
        }
        if (string.equals("xData")) {
            return "int|double|double[]|Object";
        }
        if (string.equals("yData")) {
            return "int|double|double[]|Object";
        }
        if (string.equals("zData")) {
            return "int|double|double[]|Object";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.polygon.setClosed(value.getBoolean());
                break;
            }
            case 1: {
                this.polygon.setData((double[][])value.getObject());
                this.dataSet = true;
                break;
            }
            case 2: {
                this.pointValue.value = value.getInteger();
                break;
            }
            case 3: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                    break;
                }
                this.xArray = null;
                this.xFixed[0] = value.getDouble();
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[]) {
                    this.yArray = (double[])value.getObject();
                    break;
                }
                this.yArray = null;
                this.yFixed[0] = value.getDouble();
                break;
            }
            case 5: {
                if (value.getObject() instanceof double[]) {
                    this.zArray = (double[])value.getObject();
                    break;
                }
                this.zArray = null;
                this.zFixed[0] = value.getDouble();
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.polygon.setClosed(true);
                break;
            }
            case 1: {
                this.dataSet = false;
                break;
            }
            case 2: {
                this.pointValue.value = -1;
                break;
            }
            case 3: {
                this.xArray = null;
                this.xFixed[0] = 0.0;
                break;
            }
            case 4: {
                this.yArray = null;
                this.yFixed[0] = 0.0;
                break;
            }
            case 5: {
                this.zArray = null;
                this.zFixed[0] = 0.0;
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "true";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "-1";
            }
            case 3: 
            case 4: 
            case 5: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 6);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

