/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticCurve3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int CURVE_PROPERTIES_ADDED = 10;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected String functionZ;
    protected boolean useJavaSyntax = true;
    protected ElementPolygon polygon;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX;
    protected int indexY;
    protected int indexZ;
    private double minAbcise = Double.NaN;
    private double maxAbcise = Double.NaN;
    private static List<String> infoList = null;

    @Override
    protected Element createElement() {
        this.polygon = new ElementPolygon();
        this.polygon.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlAnalyticCurve3D.this.checkExtremes();
            }
        });
        this.polygon.setClosed(false);
        this.polygon.setCanBeMeasured(false);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.polygon;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementPolygon";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 10;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String";
        }
        if (string.equals("min")) {
            return "int|double";
        }
        if (string.equals("max")) {
            return "int|double";
        }
        if (string.equals("points")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("functionz")) {
            return "String";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.variable != null && this.variable.equals(value.getString())) break;
                this.variable = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 3: {
                this.numPoints = value.getInteger();
                break;
            }
            case 4: {
                if (this.functionX != null && this.functionX.equals(value.getString())) break;
                this.functionX = value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (this.functionY != null && this.functionY.equals(value.getString())) break;
                this.functionY = value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (this.functionZ != null && this.functionZ.equals(value.getString())) break;
                this.functionZ = value.getString();
                this.changedZfunction = true;
                break;
            }
            case 7: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                break;
            }
            case 9: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 7: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                break;
            }
            case 9: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<none>";
            }
            case 7: {
                return "true";
            }
            case 8: 
            case 9: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(n - 10);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 10);
    }

    private boolean isVariableDefined(String string) {
        if (this.variable.equals(string)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            if (this.myParent == null) {
                return;
            }
            DrawingPanel3D drawingPanel3D = this.myParent.getDrawingPanel3D();
            if (Double.isNaN(this.min) && drawingPanel3D.getPreferredMinX() != this.minAbcise) {
                this.preupdate();
            } else if (Double.isNaN(this.max) && drawingPanel3D.getPreferredMaxX() != this.maxAbcise) {
                this.preupdate();
            }
        }
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        int n3;
        ParserAndVariables parserAndVariables;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.changedXfunction && this.functionX != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = parserAndVariables.getVariables();
            this.parserX = parserAndVariables.getParser();
            n3 = 0;
            n2 = this.varsX.length;
            while (n3 < n2) {
                if (!this.isVariableDefined(this.varsX[n3])) {
                    bl2 = true;
                    break;
                }
                this.parserX.defineVariable(n3, this.varsX[n3]);
                ++n3;
            }
            if (!bl2) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = parserAndVariables.getVariables();
            this.parserY = parserAndVariables.getParser();
            n3 = 0;
            n2 = this.varsY.length;
            while (n3 < n2) {
                if (!this.isVariableDefined(this.varsY[n3])) {
                    bl3 = true;
                    break;
                }
                this.parserY.defineVariable(n3, this.varsY[n3]);
                ++n3;
            }
            if (!bl3) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    bl3 = true;
                } else {
                    bl = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = parserAndVariables.getVariables();
            this.parserZ = parserAndVariables.getParser();
            n3 = 0;
            n2 = this.varsZ.length;
            while (n3 < n2) {
                if (!this.isVariableDefined(this.varsZ[n3])) {
                    bl4 = true;
                    break;
                }
                this.parserZ.defineVariable(n3, this.varsZ[n3]);
                ++n3;
            }
            if (!bl4) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    bl4 = true;
                } else {
                    bl = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (bl2 || bl3 || bl4) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.myEjsPropertyEditor != null) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", bl2);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", bl3);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", bl4);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve3D.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve3D.indexOf(this.variable, this.varsY);
            this.indexZ = ControlAnalyticCurve3D.indexOf(this.variable, this.varsZ);
            this.updateIndexes = false;
        }
        int n4 = this.numPoints;
        this.minAbcise = this.min;
        this.maxAbcise = this.max;
        if (this.myParent != null) {
            DrawingPanel3D drawingPanel3D = this.myParent.getDrawingPanel3D();
            if (n4 <= 0) {
                n4 = drawingPanel3D != null ? Math.max(100, drawingPanel3D.getComponent().getWidth() / 2) : 100;
            }
            if (Double.isNaN(this.minAbcise)) {
                this.minAbcise = drawingPanel3D.getPreferredMinX();
            }
            if (Double.isNaN(this.maxAbcise)) {
                this.maxAbcise = drawingPanel3D.getPreferredMaxX();
            }
        } else if (n4 <= 0) {
            n4 = 100;
        }
        if (this.polygon.getDataArray().length != n4) {
            this.polygon.setData(new double[n4][3]);
        }
        double[][] dArray = this.polygon.getDataArray();
        if (this.isUnderEjs) {
            try {
                n2 = 0;
                n = this.varsX.length;
                while (n2 < n) {
                    if (n2 != this.indexX) {
                        this.parserX.setVariable(n2, this.myGroup.getDouble(this.varsX[n2]));
                    }
                    ++n2;
                }
                n2 = 0;
                n = this.varsY.length;
                while (n2 < n) {
                    if (n2 != this.indexY) {
                        this.parserY.setVariable(n2, this.myGroup.getDouble(this.varsY[n2]));
                    }
                    ++n2;
                }
                n2 = 0;
                n = this.varsZ.length;
                while (n2 < n) {
                    if (n2 != this.indexZ) {
                        this.parserZ.setVariable(n2, this.myGroup.getDouble(this.varsZ[n2]));
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                System.err.println("ControlAnalyticCurve3D: Null String?\n");
                exception.printStackTrace();
            }
        } else {
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (n2 != this.indexX) {
                    this.parserX.setVariable(n2, this.myGroup.getDouble(this.varsX[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (n2 != this.indexY) {
                    this.parserY.setVariable(n2, this.myGroup.getDouble(this.varsY[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (n2 != this.indexZ) {
                    this.parserZ.setVariable(n2, this.myGroup.getDouble(this.varsZ[n2]));
                }
                ++n2;
            }
        }
        int n5 = 0;
        n = n4 - 1;
        while (n5 <= n) {
            double d = ((double)(n - n5) * this.minAbcise + (double)n5 * this.maxAbcise) / (double)n;
            if (this.functionX == null || bl2) {
                dArray[n5][0] = 0.0;
            } else {
                if (this.indexX >= 0) {
                    this.parserX.setVariable(this.indexX, d);
                }
                dArray[n5][0] = this.parserX.evaluate();
            }
            if (this.functionY == null || bl3) {
                dArray[n5][1] = 0.0;
            } else {
                if (this.indexY >= 0) {
                    this.parserY.setVariable(this.indexY, d);
                }
                dArray[n5][1] = this.parserY.evaluate();
            }
            if (this.functionZ == null || bl4) {
                dArray[n5][2] = 0.0;
            } else {
                if (this.indexZ >= 0) {
                    this.parserZ.setVariable(this.indexZ, d);
                }
                dArray[n5][2] = this.parserZ.evaluate();
            }
            ++n5;
        }
        this.polygon.addChange(2);
    }
}

