/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigContainer;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

class ConfigSexpression {
    private ArrayList elements = new ArrayList();

    ConfigSexpression() {
    }

    private void syntaxError(StreamTokenizer streamTokenizer, String string, String string2) {
        System.out.println(string2 + ":\nat line " + streamTokenizer.lineno() + " in " + string);
        this.print();
        System.out.print("\n\n");
    }

    private int myNextToken(StreamTokenizer streamTokenizer, String string) {
        int n = 0;
        try {
            n = streamTokenizer.nextToken();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException + "\nwhile reading " + string);
        }
        return n;
    }

    Object parseAndEval(ConfigContainer configContainer, StreamTokenizer streamTokenizer, int n) {
        int n2;
        String string = configContainer.currentFileName;
        this.elements.clear();
        do {
            if ((n2 = this.myNextToken(streamTokenizer, string)) == -1) {
                return Boolean.FALSE;
            }
            if (n2 != 41) continue;
            this.syntaxError(streamTokenizer, string, "Premature closing parenthesis");
        } while (n2 != 40);
        int n3 = 0;
        while (true) {
            Object object;
            if ((n2 = this.myNextToken(streamTokenizer, string)) == -1) {
                this.syntaxError(streamTokenizer, string, "Missing closing parenthesis");
                break;
            }
            if (n2 == 40) {
                streamTokenizer.pushBack();
                object = new ConfigSexpression();
                this.elements.add(((ConfigSexpression)object).parseAndEval(configContainer, streamTokenizer, n + 1));
            } else {
                if (n2 == 41) break;
                if (n3 >= 20) {
                    this.syntaxError(streamTokenizer, string, "Too many arguments");
                }
                if (n2 == -2) {
                    this.elements.add(new Double(streamTokenizer.nval));
                } else if (n2 != -3 && n2 != 34 && n2 != 39) {
                    object = String.valueOf((char)n2);
                    this.elements.add(object);
                    this.syntaxError(streamTokenizer, string, "Invalid token \"" + (String)object + "\" must be enclosed in quotes");
                } else {
                    String string2 = this.scanJavaProperties(streamTokenizer, string, streamTokenizer.sval);
                    if (string2 != null) {
                        if (string2.equalsIgnoreCase("true")) {
                            this.elements.add(new Boolean(true));
                        } else if (string2.equalsIgnoreCase("false")) {
                            this.elements.add(new Boolean(false));
                        } else {
                            this.elements.add(string2);
                        }
                    }
                }
            }
            ++n3;
        }
        if (this.elements.size() == 0) {
            this.syntaxError(streamTokenizer, string, "Null command");
        }
        if (this.elements.get(0) instanceof String) {
            try {
                if (n == 0) {
                    configContainer.evaluateCommand(this.elements, streamTokenizer.lineno());
                    return Boolean.TRUE;
                }
                return this.evaluateBuiltIn(configContainer, this.elements, streamTokenizer.lineno());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.syntaxError(streamTokenizer, string, illegalArgumentException.getMessage());
                if (n == 0) {
                    return Boolean.TRUE;
                }
                return this;
            }
        }
        if (n == 0) {
            this.syntaxError(streamTokenizer, string, "Malformed top-level command name");
        }
        if (this.elements.get(0) instanceof Double) {
            if (this.elements.size() == 1) {
                this.syntaxError(streamTokenizer, string, "Can't have single-element vector");
            }
            if (this.elements.size() == 2) {
                if (!(this.elements.get(1) instanceof Double)) {
                    this.syntaxError(streamTokenizer, string, "Both elements must be numbers");
                }
                return new Point2d((Double)this.elements.get(0), (Double)this.elements.get(1));
            }
            if (this.elements.size() == 3) {
                if (!(this.elements.get(1) instanceof Double) || !(this.elements.get(2) instanceof Double)) {
                    this.syntaxError(streamTokenizer, string, "All elements must be numbers");
                }
                return new Point3d((Double)this.elements.get(0), (Double)this.elements.get(1), (Double)this.elements.get(2));
            }
            if (this.elements.size() == 4) {
                if (!(this.elements.get(1) instanceof Double && this.elements.get(2) instanceof Double && this.elements.get(3) instanceof Double)) {
                    this.syntaxError(streamTokenizer, string, "All elements must be numbers");
                }
                return new Point4d((Double)this.elements.get(0), (Double)this.elements.get(1), (Double)this.elements.get(2), (Double)this.elements.get(3));
            }
            this.syntaxError(streamTokenizer, string, "Too many vector elements");
        }
        if (this.elements.get(0) instanceof Point3d) {
            if (this.elements.size() != 3) {
                this.syntaxError(streamTokenizer, string, "Matrix must have three rows");
            }
            if (!(this.elements.get(1) instanceof Point3d) || !(this.elements.get(2) instanceof Point3d)) {
                this.syntaxError(streamTokenizer, string, "All rows must have three elements");
            }
            return new Matrix3d(((Point3d)this.elements.get((int)0)).x, ((Point3d)this.elements.get((int)0)).y, ((Point3d)this.elements.get((int)0)).z, ((Point3d)this.elements.get((int)1)).x, ((Point3d)this.elements.get((int)1)).y, ((Point3d)this.elements.get((int)1)).z, ((Point3d)this.elements.get((int)2)).x, ((Point3d)this.elements.get((int)2)).y, ((Point3d)this.elements.get((int)2)).z);
        }
        if (this.elements.get(0) instanceof Point4d) {
            if (this.elements.size() == 3) {
                if (!(this.elements.get(1) instanceof Point4d) || !(this.elements.get(2) instanceof Point4d)) {
                    this.syntaxError(streamTokenizer, string, "All rows must have four elements");
                }
                return new Matrix4d(((Point4d)this.elements.get((int)0)).x, ((Point4d)this.elements.get((int)0)).y, ((Point4d)this.elements.get((int)0)).z, ((Point4d)this.elements.get((int)0)).w, ((Point4d)this.elements.get((int)1)).x, ((Point4d)this.elements.get((int)1)).y, ((Point4d)this.elements.get((int)1)).z, ((Point4d)this.elements.get((int)1)).w, ((Point4d)this.elements.get((int)2)).x, ((Point4d)this.elements.get((int)2)).y, ((Point4d)this.elements.get((int)2)).z, ((Point4d)this.elements.get((int)2)).w, 0.0, 0.0, 0.0, 1.0);
            }
            if (this.elements.size() != 4) {
                this.syntaxError(streamTokenizer, string, "Matrix must have three or four rows");
            }
            if (!(this.elements.get(1) instanceof Point4d && this.elements.get(2) instanceof Point4d && this.elements.get(3) instanceof Point4d)) {
                this.syntaxError(streamTokenizer, string, "All rows must have four elements");
            }
            return new Matrix4d(((Point4d)this.elements.get((int)0)).x, ((Point4d)this.elements.get((int)0)).y, ((Point4d)this.elements.get((int)0)).z, ((Point4d)this.elements.get((int)0)).w, ((Point4d)this.elements.get((int)1)).x, ((Point4d)this.elements.get((int)1)).y, ((Point4d)this.elements.get((int)1)).z, ((Point4d)this.elements.get((int)1)).w, ((Point4d)this.elements.get((int)2)).x, ((Point4d)this.elements.get((int)2)).y, ((Point4d)this.elements.get((int)2)).z, ((Point4d)this.elements.get((int)2)).w, ((Point4d)this.elements.get((int)3)).x, ((Point4d)this.elements.get((int)3)).y, ((Point4d)this.elements.get((int)3)).z, ((Point4d)this.elements.get((int)3)).w);
        }
        this.syntaxError(streamTokenizer, string, "Syntax error");
        return null;
    }

    private String scanJavaProperties(StreamTokenizer streamTokenizer, String string, String string2) {
        int n = string2.indexOf("${");
        if (n == -1) {
            return string2;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append(string2.substring(n2, n));
            n2 = string2.indexOf(125, n);
            if (n2 == -1) {
                this.elements.add(string2);
                this.syntaxError(streamTokenizer, string, "Java property substitution syntax error");
                return null;
            }
            String string3 = string2.substring(n + 2, n2);
            String string4 = ConfigCommand.evaluateJavaProperty(string3);
            if (string4 == null) {
                this.elements.add(string2);
                this.syntaxError(streamTokenizer, string, "Java property \"" + string3 + "\" has a null value");
                return null;
            }
            stringBuffer.append(string4);
            n = string2.indexOf("${", n2);
            ++n2;
        }
        stringBuffer.append(string2.substring(n2));
        return stringBuffer.toString();
    }

    private Object evaluateBuiltIn(ConfigContainer configContainer, ArrayList arrayList, int n) {
        int n2 = arrayList.size();
        String string = (String)arrayList.get(0);
        if (string.equals("Rotate")) {
            return this.makeRotate(arrayList);
        }
        if (string.equals("Translate")) {
            return this.makeTranslate(arrayList);
        }
        if (string.equals("RotateTranslate") || string.equals("TranslateRotate") || string.equals("Concatenate")) {
            return this.concatenate(arrayList);
        }
        if (string.equals("BoundingSphere")) {
            return this.makeBoundingSphere(arrayList);
        }
        return new ConfigCommand(arrayList, configContainer.currentFileName, n);
    }

    private Matrix4d makeTranslate(ArrayList arrayList) {
        if (arrayList.size() != 4) {
            throw new IllegalArgumentException("Incorrect number of arguments to Translate");
        }
        if (!(arrayList.get(1) instanceof Double && arrayList.get(2) instanceof Double && arrayList.get(3) instanceof Double)) {
            throw new IllegalArgumentException("All arguments to Translate must be numbers");
        }
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(new Vector3d((Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3)));
        return matrix4d;
    }

    private Matrix4d makeRotate(ArrayList arrayList) {
        if (arrayList.size() != 4) {
            throw new IllegalArgumentException("Incorrect number of arguments to Rotate");
        }
        if (!(arrayList.get(1) instanceof Double && arrayList.get(2) instanceof Double && arrayList.get(3) instanceof Double)) {
            throw new IllegalArgumentException("All arguments to Rotate must be numbers");
        }
        double d = Math.toRadians((Double)arrayList.get(1));
        double d2 = Math.toRadians((Double)arrayList.get(2));
        double d3 = Math.toRadians((Double)arrayList.get(3));
        Transform3D transform3D = new Transform3D();
        transform3D.setEuler(new Vector3d(d, d2, d3));
        Matrix4d matrix4d = new Matrix4d();
        transform3D.get(matrix4d);
        return matrix4d;
    }

    private Matrix4d concatenate(ArrayList arrayList) {
        String string = (String)arrayList.get(0);
        if (arrayList.size() != 3) {
            throw new IllegalArgumentException("Incorrect number of arguments to " + string);
        }
        if (!(arrayList.get(1) instanceof Matrix4d) || !(arrayList.get(2) instanceof Matrix4d)) {
            throw new IllegalArgumentException("Both arguments to " + string + " must be Matrix4d");
        }
        Matrix4d matrix4d = new Matrix4d((Matrix4d)arrayList.get(2));
        matrix4d.mul((Matrix4d)arrayList.get(1));
        return matrix4d;
    }

    private BoundingSphere makeBoundingSphere(ArrayList arrayList) {
        if (arrayList.size() != 3) {
            throw new IllegalArgumentException("Incorrect number of arguments to BoundingSphere");
        }
        if (!(arrayList.get(1) instanceof Point3d) || !(arrayList.get(2) instanceof Double) && !(arrayList.get(2) instanceof String)) {
            throw new IllegalArgumentException("BoundingSphere needs a Point3d center followed by a Double radius or the String \"infinite\"");
        }
        double d = arrayList.get(2) instanceof Double ? (Double)arrayList.get(2) : Double.POSITIVE_INFINITY;
        return new BoundingSphere((Point3d)arrayList.get(1), d);
    }

    void print() {
        System.out.print("(");
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            if (this.elements.get(i) instanceof Matrix3d) {
                stringArray = ConfigCommand.formatMatrixRows((Matrix3d)this.elements.get(i));
                System.out.println("\n ((" + stringArray[0] + ")");
                System.out.println("  (" + stringArray[1] + ")");
                System.out.print("  (" + stringArray[2] + "))");
                if (i == n - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof Matrix4d) {
                stringArray = ConfigCommand.formatMatrixRows((Matrix4d)this.elements.get(i));
                System.out.println("\n ((" + stringArray[0] + ")");
                System.out.println("  (" + stringArray[1] + ")");
                System.out.println("  (" + stringArray[2] + ")");
                System.out.print("  (" + stringArray[3] + "))");
                if (i == n - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof ConfigSexpression) {
                if (i > 0) {
                    System.out.print(" ");
                }
                ((ConfigSexpression)this.elements.get(i)).print();
                if (i == n - 1) continue;
                System.out.println();
                continue;
            }
            if (this.elements.get(i) instanceof ConfigCommand) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(this.elements.get(i).toString());
                if (i == n - 1) continue;
                System.out.println();
                continue;
            }
            if (i > 0) {
                System.out.print(" ");
            }
            System.out.print(this.elements.get(i).toString());
        }
        System.out.print(")");
    }
}

