/*
 * Decompiled with CFR 0.152.
 */
package webcam;

import java.awt.Image;
import webcam.CircularObjectBuffer;
import webcam.Receiver;

public class VideoReceiver {
    private Receiver webcam;
    private CircularObjectBuffer cob = null;
    private boolean connected = false;
    private Image imagen;
    private String cam;
    private String m_appName;
    private boolean isMJPEG;
    private int delayImage;
    private String connStyle;

    public VideoReceiver(String camera, String app, boolean format, String method, int delaymsec) {
        this.cam = camera;
        this.m_appName = app;
        this.isMJPEG = format;
        this.connStyle = method;
        this.delayImage = delaymsec;
    }

    public void connect() {
        if (!this.connected) {
            this.cob = new CircularObjectBuffer();
            this.webcam = new Receiver(this.cam, this.m_appName, this.isMJPEG, this.connStyle, this.delayImage, this.cob);
            this.webcam.setPriority(2);
            this.webcam.start();
            this.connected = true;
        }
    }

    public Image getImage() {
        if (this.connected) {
            try {
                if (this.getAvailableBuffer() > 0) {
                    this.imagen = (Image)this.cob.read();
                    this.cob.clear();
                }
            }
            catch (InterruptedException ie) {
                System.out.println(ie);
            }
        }
        return this.imagen;
    }

    public int getAvailableBuffer() {
        return this.cob.getAvailable();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        if (this.connected) {
            this.webcam.closeStream();
            try {
                this.webcam.join();
                this.connected = false;
            }
            catch (InterruptedException ie) {
                System.out.println("Problem disconnecting video..." + ie.getMessage());
            }
        }
    }

    private synchronized void cleanInputBuffer(boolean _remove) {
        if (this.connected) {
            if (_remove) {
                try {
                    int buffsizein = this.cob.getAvailable();
                    while (buffsizein > 1) {
                        this.cob.skip(buffsizein);
                        buffsizein = this.cob.getAvailable();
                    }
                }
                catch (Exception e) {
                    System.out.println("cleanInputBuffer() method message: Exception = " + e.getMessage());
                }
            }
        } else {
            System.out.println("cleanInputBuffer() method message: You are not connected yet.");
        }
    }
}

