/*
 * Decompiled with CFR 0.152.
 */
package webcam;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import webcam.Base64;
import webcam.CircularObjectBuffer;
import webcam.ExceptionReporter;
import webcam.ImageChangeEvent;
import webcam.ImageChangeListener;
import webcam.StreamSplit;

public class Receiver
extends Thread {
    private Object m_lock = new Object();
    private String stringURL;
    private URL u;
    private Socket websock;
    private DataInputStream dis;
    private DataOutputStream dos;
    private Image image = null;
    private HttpURLConnection huc = null;
    private boolean connectedVideo = false;
    private boolean m_collecting = false;
    private String m_imageType = "image/jpeg";
    private byte[] m_rawImage;
    private int m_imgidx = 0;
    private int m_retryCount = 1;
    private int m_retryDelay = 1000;
    private static final int IMG_FLUFF_FACTOR = 1;
    private long m_startTime = 0L;
    private ExceptionReporter m_reporter = null;
    private URL m_docBase = null;
    private String m_appName = "";
    private Vector m_listeners = new Vector();
    private StreamSplit ssplit = null;
    private String encpasswd = null;
    private Object headers = null;
    private String connectionError = null;
    private String ctype = null;
    private int bidx = 0;
    private String boundary = null;
    private int delayImage;
    private boolean isMJPEG;
    private String connStyle = null;
    private CircularObjectBuffer cob;

    public Receiver(String camera, String app, boolean format, String method, int delaymsec, CircularObjectBuffer buffer) {
        this.stringURL = camera;
        this.m_appName = app;
        this.isMJPEG = format;
        this.delayImage = delaymsec;
        this.connStyle = method;
        this.cob = buffer;
    }

    public synchronized void run() {
        this.openStream();
        System.out.println("Running Video Receiver ...");
        while (this.connectedVideo) {
            if (this.isMJPEG) {
                this.readStream();
            } else {
                this.readJPG();
            }
            this.delay(this.delayImage);
        }
        this.cob.clear();
        System.out.println("Stopping Video Receiver ...");
    }

    private void openStream() {
        try {
            this.u = new URL(this.stringURL);
            int port = this.u.getPort();
            if (port == -1) {
                port = 80;
            }
            int tryIndex = 0;
            int retryCount = this.m_retryCount;
            int retryDelay = this.m_retryDelay;
            String userPass = this.u.getUserInfo();
            if (userPass != null && userPass.length() > 0) {
                this.encpasswd = Base64.encode(userPass.getBytes());
            }
            do {
                ++tryIndex;
                if (this.connStyle.equals("SOCKET")) {
                    this.websock = new Socket();
                    this.websock.connect(new InetSocketAddress(this.u.getHost(), port), 10000);
                    this.websock.setSoTimeout(10000);
                    this.dos = new DataOutputStream(this.websock.getOutputStream());
                    this.dis = new DataInputStream(new BufferedInputStream(this.websock.getInputStream()));
                    StringBuffer request = new StringBuffer();
                    request.append("GET " + this.u.getFile() + " HTTP/1.0\r\n");
                    if (this.m_docBase != null) {
                        request.append("Referer: " + this.m_docBase + "\r\n");
                    }
                    request.append("User-Agent: " + this.m_appName + "\r\n");
                    if (this.encpasswd != null) {
                        request.append("Authorization: Basic " + this.encpasswd + "\r\n");
                    }
                    request.append("Host: " + this.u.getHost() + "\r\n");
                    request.append("\r\n");
                    this.dos.writeBytes(request.toString());
                    this.ssplit = new StreamSplit(this.dis);
                    this.headers = this.ssplit.readHeaders();
                } else if (this.connStyle.equals("HTTP")) {
                    URLConnection conn = this.u.openConnection();
                    if (this.m_docBase != null) {
                        conn.setRequestProperty("Referer", this.m_docBase.toString());
                    }
                    conn.setRequestProperty("User-Agent", this.m_appName);
                    if (this.encpasswd != null) {
                        conn.setRequestProperty("Authorization", "Basic " + this.encpasswd);
                    }
                    conn.setRequestProperty("Host", this.u.getHost());
                    this.dis = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
                    this.ssplit = new StreamSplit(this.dis);
                    this.headers = this.ssplit.readHeaders(conn);
                }
                this.m_collecting = true;
                this.connectionError = null;
                this.ctype = (String)((Hashtable)this.headers).get("content-type");
                if (this.ctype == null) {
                    this.connectionError = "No main content type";
                } else if (this.ctype.indexOf("text") != -1) {
                    String response = null;
                    while ((response = this.dis.readLine()) != null) {
                        System.out.println(response);
                    }
                    this.connectionError = "Failed to connect to server (denied?)";
                }
                if (this.connectionError == null) break;
                if (!this.connectedVideo) {
                    return;
                }
                this.m_reporter.reportFailure(this.connectionError);
                this.delay(retryDelay);
            } while (tryIndex < retryCount);
            if (this.connectionError != null) {
                return;
            }
            this.connectedVideo = true;
            this.bidx = this.ctype.indexOf("boundary=");
            if (this.bidx != -1) {
                this.boundary = this.ctype.substring(this.bidx + 9);
                this.ctype = this.ctype.substring(0, this.bidx);
                if (!this.boundary.startsWith("--")) {
                    this.boundary = "--" + this.boundary;
                }
            }
            if (this.ctype.startsWith("multipart/x-mixed-replace")) {
                this.ssplit.skipToBoundary(this.boundary);
            }
            System.out.println("The connection to the camera is opened.");
        }
        catch (UnknownHostException e) {
            System.out.println("UnknownHostException in openStream method: " + e.getMessage());
        }
        catch (SocketTimeoutException e2) {
            System.out.println("SocketTimeoutException in openStream method: " + e2);
        }
        catch (IOException e) {
            System.out.println("IOException in openStream method: " + e);
        }
        catch (Exception e2) {
            System.out.println("Exception in openStream method: " + e2.getMessage());
        }
    }

    public void closeStream() {
        if (this.connectedVideo && this.dis != null) {
            try {
                this.dis.close();
                this.dis = null;
                if (this.connStyle.equals("SOCKET")) {
                    this.dos.close();
                    this.websock.close();
                    this.dos = null;
                    this.websock = null;
                }
                this.m_collecting = false;
                this.connectedVideo = false;
                this.stop();
                System.out.println("The connection to the camera is closed.");
            }
            catch (IOException e) {
                System.out.println("IOException in closeStream method: " + e.getMessage());
            }
        }
    }

    private void readStream() {
        try {
            if (this.m_collecting) {
                if (this.boundary != null) {
                    this.headers = this.ssplit.readHeaders();
                    if (this.ssplit.isAtStreamEnd()) {
                        // empty if block
                    }
                    this.ctype = (String)((Hashtable)this.headers).get("content-type");
                    if (this.ctype == null) {
                        throw new Exception("No part content type");
                    }
                }
                if (this.ctype.startsWith("multipart/x-mixed-replace")) {
                    this.bidx = this.ctype.indexOf("boundary=");
                    this.boundary = this.ctype.substring(this.bidx + 9);
                    this.ssplit.skipToBoundary(this.boundary);
                } else {
                    byte[] img = this.ssplit.readToBoundary(this.boundary);
                    if (img.length == 0) {
                        // empty if block
                    }
                    if (this.m_imgidx > 1 && this.m_startTime == 0L) {
                        this.m_startTime = System.currentTimeMillis();
                    }
                    this.updateImage(this.ctype, img);
                }
            }
        }
        catch (IOException io) {
            System.out.println("IOException in readStream method: " + io);
        }
        catch (Exception e) {
            System.out.println("Exception in readStream method: " + e);
        }
    }

    private void fireImageChange() {
        ImageChangeEvent ce = new ImageChangeEvent(this);
        Vector m_listeners = new Vector();
        Enumeration e = m_listeners.elements();
        while (e.hasMoreElements()) {
            ((ImageChangeListener)e.nextElement()).imageChanged(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(String ctype, byte[] img) {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                BufferedImage imagen = ImageIO.read(new ByteArrayInputStream(img));
                this.image = imagen;
                this.cob.write(this.image);
            }
            catch (IOException ex) {
                System.out.println("IOException in updateImage method: " + ex);
            }
            catch (Exception e) {
                System.out.println("Exception in updateImage method: " + e);
            }
            this.m_imageType = ctype;
            this.m_rawImage = img;
            ++this.m_imgidx;
            this.image.getWidth(new ImageObserver(){

                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    boolean fully;
                    boolean bl = fully = (infoflags & 0x24) != 0;
                    if (fully) {
                        Receiver.this.fireImageChange();
                    }
                    return !fully;
                }
            });
        }
    }

    private void readJPG() {
        try {
            this.u = new URL(this.stringURL);
            this.huc = (HttpURLConnection)this.u.openConnection();
            InputStream is = this.huc.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            DataInputStream dis = new DataInputStream(bis);
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)dis);
            this.image = decoder.decodeAsBufferedImage();
            this.cob.write(this.image);
        }
        catch (IOException e) {
            this.huc.disconnect();
            System.out.println("IOException in readJPG method: " + e);
        }
        catch (Exception e) {
            System.out.println("Exception in readJPG method: " + e);
        }
    }

    public boolean isConnectedVideo() {
        return this.connectedVideo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRawImage() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_rawImage;
        }
    }

    public double getFPS() {
        if (this.m_startTime == 0L) {
            return 0.0;
        }
        long currTime = System.currentTimeMillis();
        return 1000.0 * (double)(this.m_imgidx - 1) / (double)(currTime - this.m_startTime);
    }

    private void delay(int mseconds) {
        try {
            Thread.sleep(mseconds);
        }
        catch (InterruptedException e) {
            System.out.println("Delay interrupted!");
        }
    }
}

