/*
 * Decompiled with CFR 0.152.
 */
package webcam;

import java.nio.BufferOverflowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularObjectBuffer<ElementType> {
    private static final int DEFAULT_SIZE = 1024;
    public static final int INFINITE_SIZE = -1;
    protected ElementType[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected volatile boolean infinite = false;
    protected boolean blockingWrite = true;
    protected boolean inputDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularObjectBuffer circularObjectBuffer = this;
        synchronized (circularObjectBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.inputDone = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        CircularObjectBuffer circularObjectBuffer = this;
        synchronized (circularObjectBuffer) {
            return this.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceLeft() {
        CircularObjectBuffer circularObjectBuffer = this;
        synchronized (circularObjectBuffer) {
            return this.spaceLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        CircularObjectBuffer circularObjectBuffer = this;
        synchronized (circularObjectBuffer) {
            return this.buffer.length;
        }
    }

    private ElementType[] createArray(int size) {
        return new Object[size];
    }

    private void resize() {
        ElementType[] newBuffer = this.createArray(this.buffer.length * 2);
        int available = this.available();
        if (this.readPosition <= this.writePosition) {
            int length = this.writePosition - this.readPosition;
            System.arraycopy(this.buffer, this.readPosition, newBuffer, 0, length);
        } else {
            int length1 = this.buffer.length - this.readPosition;
            System.arraycopy(this.buffer, this.readPosition, newBuffer, 0, length1);
            int length2 = this.writePosition;
            System.arraycopy(this.buffer, 0, newBuffer, length1, length2);
        }
        this.buffer = newBuffer;
        this.readPosition = 0;
        this.writePosition = available;
    }

    private int spaceLeft() {
        if (this.writePosition < this.readPosition) {
            return this.readPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.readPosition);
    }

    private int available() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    public CircularObjectBuffer() {
        this(1024, true);
    }

    public CircularObjectBuffer(int size) {
        this(size, true);
    }

    public CircularObjectBuffer(boolean blockingWrite) {
        this(1024, blockingWrite);
    }

    public CircularObjectBuffer(int size, boolean blockingWrite) {
        if (size == -1) {
            this.buffer = this.createArray(1024);
            this.infinite = true;
        } else {
            this.buffer = this.createArray(size);
            this.infinite = false;
        }
        this.blockingWrite = blockingWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementType read() throws InterruptedException {
        while (true) {
            CircularObjectBuffer circularObjectBuffer = this;
            synchronized (circularObjectBuffer) {
                int available = this.available();
                if (available > 0) {
                    ElementType result = this.buffer[this.readPosition];
                    ++this.readPosition;
                    if (this.readPosition == this.buffer.length) {
                        this.readPosition = 0;
                    }
                    return result;
                }
                if (this.inputDone) {
                    return null;
                }
            }
            Thread.sleep(100L);
        }
    }

    public int read(ElementType[] buf) throws InterruptedException {
        return this.read(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ElementType[] buf, int off, int len) throws InterruptedException {
        while (true) {
            CircularObjectBuffer circularObjectBuffer = this;
            synchronized (circularObjectBuffer) {
                int available = this.available();
                if (available > 0) {
                    int length = Math.min(len, available);
                    int firstLen = Math.min(length, this.buffer.length - this.readPosition);
                    int secondLen = length - firstLen;
                    System.arraycopy(this.buffer, this.readPosition, buf, off, firstLen);
                    if (secondLen > 0) {
                        System.arraycopy(this.buffer, 0, buf, off + firstLen, secondLen);
                        this.readPosition = secondLen;
                    } else {
                        this.readPosition += length;
                    }
                    if (this.readPosition == this.buffer.length) {
                        this.readPosition = 0;
                    }
                    return length;
                }
                if (this.inputDone) {
                    return -1;
                }
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws InterruptedException, IllegalArgumentException {
        while (true) {
            CircularObjectBuffer circularObjectBuffer = this;
            synchronized (circularObjectBuffer) {
                int available = this.available();
                if (available > 0) {
                    int firstLen;
                    int length = Math.min((int)n, available);
                    int secondLen = length - (firstLen = Math.min(length, this.buffer.length - this.readPosition));
                    this.readPosition = secondLen > 0 ? secondLen : (this.readPosition += length);
                    if (this.readPosition == this.buffer.length) {
                        this.readPosition = 0;
                    }
                    return length;
                }
                if (this.inputDone) {
                    return 0L;
                }
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        CircularObjectBuffer circularObjectBuffer = this;
        synchronized (circularObjectBuffer) {
            this.inputDone = true;
        }
    }

    public void write(ElementType[] buf) throws BufferOverflowException, IllegalStateException, InterruptedException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ElementType[] buf, int off, int len) throws BufferOverflowException, IllegalStateException, InterruptedException {
        while (len > 0) {
            int written;
            CircularObjectBuffer circularObjectBuffer = this;
            synchronized (circularObjectBuffer) {
                if (this.inputDone) {
                    throw new IllegalStateException("CircularObjectBuffer.done() has been called, CircularObjectBuffer.write() failed.");
                }
                int spaceLeft = this.spaceLeft();
                while (this.infinite && spaceLeft < len) {
                    this.resize();
                    spaceLeft = this.spaceLeft();
                }
                if (!this.blockingWrite && spaceLeft < len) {
                    throw new BufferOverflowException();
                }
                int realLen = Math.min(len, spaceLeft);
                int firstLen = Math.min(realLen, this.buffer.length - this.writePosition);
                int secondLen = Math.min(realLen - firstLen, this.buffer.length - this.readPosition - 1);
                written = firstLen + secondLen;
                if (firstLen > 0) {
                    System.arraycopy(buf, off, this.buffer, this.writePosition, firstLen);
                }
                if (secondLen > 0) {
                    System.arraycopy(buf, off + firstLen, this.buffer, 0, secondLen);
                    this.writePosition = secondLen;
                } else {
                    this.writePosition += written;
                }
                if (this.writePosition == this.buffer.length) {
                    this.writePosition = 0;
                }
                off += written;
            }
            if ((len -= written) <= 0) continue;
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ElementType o) throws BufferOverflowException, IllegalStateException, InterruptedException {
        boolean written = false;
        while (!written) {
            CircularObjectBuffer circularObjectBuffer = this;
            synchronized (circularObjectBuffer) {
                if (this.inputDone) {
                    throw new IllegalStateException("CircularObjectBuffer.done() has been called, CircularObjectBuffer.write() failed.");
                }
                int spaceLeft = this.spaceLeft();
                while (this.infinite && spaceLeft < 1) {
                    this.resize();
                    spaceLeft = this.spaceLeft();
                }
                if (!this.blockingWrite && spaceLeft < 1) {
                    throw new BufferOverflowException();
                }
                if (spaceLeft > 0) {
                    this.buffer[this.writePosition] = o;
                    ++this.writePosition;
                    if (this.writePosition == this.buffer.length) {
                        this.writePosition = 0;
                    }
                    written = true;
                }
            }
            if (written) continue;
            Thread.sleep(100L);
        }
    }
}

